/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.type;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.EnumTypeNode;
import de.unika.ipd.grgen.ast.model.type.ExternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalTransientObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.type.container.ContainerTypeNode;
import de.unika.ipd.grgen.ast.type.container.DequeTypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ir.type.Type;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class TypeNode
extends BaseNode {
    private static final Map<TypeNode, HashSet<TypeNode>> compatibleMap = new HashMap<TypeNode, HashSet<TypeNode>>();
    private static final Map<TypeNode, HashSet<TypeNode>> castableMap = new HashMap<TypeNode, HashSet<TypeNode>>();
    private Set<TypeNode> compatibleToTypes;
    private Set<TypeNode> castableToTypes;

    public static String getKindStr() {
        return "type";
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    public int compatibilityDistance(TypeNode typeNode) {
        if (this.isEqual(typeNode)) {
            return 0;
        }
        if (this.isCompatibleTo(typeNode)) {
            return 1;
        }
        for (TypeNode typeNode2 : this.getCompatibleToTypes()) {
            if (!typeNode2.isCompatibleTo(typeNode)) continue;
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    public boolean isCompatibleTo(TypeNode typeNode) {
        if (this.isEqual(typeNode)) {
            return true;
        }
        return this.getCompatibleToTypes().contains(typeNode);
    }

    public boolean isCastableTo(TypeNode typeNode) {
        return this.getCastableToTypes().contains(typeNode);
    }

    @Override
    public Color getNodeColor() {
        return Color.MAGENTA;
    }

    public Type getType() {
        return this.checkIR(Type.class);
    }

    public boolean isEqual(TypeNode typeNode) {
        if (typeNode == this) {
            return true;
        }
        if (typeNode instanceof SetTypeNode && this instanceof SetTypeNode) {
            return ((SetTypeNode)typeNode).valueType == ((SetTypeNode)this).valueType;
        }
        if (typeNode instanceof MapTypeNode && this instanceof MapTypeNode) {
            return ((MapTypeNode)typeNode).keyType == ((MapTypeNode)this).keyType && ((MapTypeNode)typeNode).valueType == ((MapTypeNode)this).valueType;
        }
        if (typeNode instanceof ArrayTypeNode && this instanceof ArrayTypeNode) {
            return ((ArrayTypeNode)typeNode).valueType == ((ArrayTypeNode)this).valueType;
        }
        if (typeNode instanceof DequeTypeNode && this instanceof DequeTypeNode) {
            return ((DequeTypeNode)typeNode).valueType == ((DequeTypeNode)this).valueType;
        }
        return false;
    }

    public boolean isBasic() {
        return false;
    }

    public final Collection<TypeNode> getCompatibleToTypes() {
        if (this.compatibleToTypes == null) {
            this.compatibleToTypes = new HashSet<TypeNode>();
            this.doGetCompatibleToTypes(this.compatibleToTypes);
            this.compatibleToTypes.add(this);
            this.compatibleToTypes = Collections.unmodifiableSet(this.compatibleToTypes);
        }
        return this.compatibleToTypes;
    }

    public static void addCompatibility(TypeNode typeNode, TypeNode typeNode2) {
        if (compatibleMap.get(typeNode) == null) {
            compatibleMap.put(typeNode, new HashSet());
        }
        compatibleMap.get(typeNode).add(typeNode2);
    }

    public static void addCastability(TypeNode typeNode, TypeNode typeNode2) {
        if (castableMap.get(typeNode) == null) {
            castableMap.put(typeNode, new HashSet());
        }
        castableMap.get(typeNode).add(typeNode2);
    }

    public void doGetCompatibleToTypes(Collection<TypeNode> collection) {
        debug.report(4, "compatible types to " + this.getName() + ":");
        Collection collection2 = compatibleMap.get(this);
        if (collection2 == null) {
            return;
        }
        if (debug.willReport(4)) {
            for (BaseNode baseNode : collection2) {
                debug.report(4, "" + baseNode.getName());
            }
        }
        collection.addAll(collection2);
    }

    protected final Collection<TypeNode> getCastableToTypes() {
        if (this.castableToTypes == null) {
            this.castableToTypes = new HashSet<TypeNode>();
            this.doGetCastableToTypes(this.castableToTypes);
            this.castableToTypes.addAll(this.getCompatibleToTypes());
            this.castableToTypes = Collections.unmodifiableSet(this.castableToTypes);
        }
        return this.castableToTypes;
    }

    private void doGetCastableToTypes(Collection<TypeNode> collection) {
        Collection collection2 = castableMap.get(this);
        if (collection2 != null) {
            collection.addAll(collection2);
        }
    }

    public boolean isFilterableType() {
        if (this.isOrderableType()) {
            return true;
        }
        if (this instanceof NodeTypeNode) {
            return true;
        }
        return this instanceof EdgeTypeNode;
    }

    public boolean isOrderableType() {
        if (this.isAccumulatableType()) {
            return true;
        }
        if (this.isEqual(BasicTypeNode.stringType)) {
            return true;
        }
        if (this.isEqual(BasicTypeNode.booleanType)) {
            return true;
        }
        return this instanceof EnumTypeNode;
    }

    public boolean isAccumulatableType() {
        return this.isNumericType();
    }

    public boolean isAccumulationTargetType() {
        if (this.isEqual(BasicTypeNode.intType)) {
            return true;
        }
        if (this.isEqual(BasicTypeNode.longType)) {
            return true;
        }
        if (this.isEqual(BasicTypeNode.floatType)) {
            return true;
        }
        return this.isEqual(BasicTypeNode.doubleType);
    }

    public boolean isNumericType() {
        if (this.isEqual(BasicTypeNode.byteType)) {
            return true;
        }
        if (this.isEqual(BasicTypeNode.shortType)) {
            return true;
        }
        if (this.isEqual(BasicTypeNode.intType)) {
            return true;
        }
        if (this.isEqual(BasicTypeNode.longType)) {
            return true;
        }
        if (this.isEqual(BasicTypeNode.floatType)) {
            return true;
        }
        return this.isEqual(BasicTypeNode.doubleType);
    }

    public static String getFilterableTypesAsString() {
        return TypeNode.getOrderableTypesAsString() + " or a node or edge class";
    }

    public static String getOrderableTypesAsString() {
        return TypeNode.getAccumulatableTypesAsString() + ", string, boolean";
    }

    public static String getAccumulatableTypesAsString() {
        return TypeNode.getNumericTypesAsString();
    }

    public static String getAccumulationTargetTypesAsString() {
        return "int, long, float, double";
    }

    public static String getNumericTypesAsString() {
        return "byte, short, int, long, float, double";
    }

    public boolean isValueType() {
        return this instanceof BasicTypeNode || this instanceof EnumTypeNode || this instanceof ExternalObjectTypeNode;
    }

    public boolean isReferenceType() {
        return this instanceof ContainerTypeNode || this instanceof MatchTypeNode || this instanceof InternalObjectTypeNode || this instanceof InternalTransientObjectTypeNode;
    }

    public boolean isLockableType() {
        return !this.isOrderableType();
    }

    public String getTypeName() {
        return this.toString();
    }
}

