/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.type.basic;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.NullConstNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BooleanTypeNode;
import de.unika.ipd.grgen.ast.type.basic.ByteTypeNode;
import de.unika.ipd.grgen.ast.type.basic.DoubleTypeNode;
import de.unika.ipd.grgen.ast.type.basic.EnumItemTypeNode;
import de.unika.ipd.grgen.ast.type.basic.ErrorTypeNode;
import de.unika.ipd.grgen.ast.type.basic.FloatTypeNode;
import de.unika.ipd.grgen.ast.type.basic.GraphTypeNode;
import de.unika.ipd.grgen.ast.type.basic.IntTypeNode;
import de.unika.ipd.grgen.ast.type.basic.LongTypeNode;
import de.unika.ipd.grgen.ast.type.basic.NullTypeNode;
import de.unika.ipd.grgen.ast.type.basic.ObjectTypeNode;
import de.unika.ipd.grgen.ast.type.basic.ShortTypeNode;
import de.unika.ipd.grgen.ast.type.basic.StringTypeNode;
import de.unika.ipd.grgen.ast.type.basic.TypeTypeNode;
import de.unika.ipd.grgen.ast.type.basic.UntypedExecVarTypeNode;
import de.unika.ipd.grgen.ast.type.basic.VoidTypeNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class BasicTypeNode
extends DeclaredTypeNode {
    public static final BasicTypeNode stringType = new StringTypeNode();
    public static final BasicTypeNode typeType = new TypeTypeNode();
    public static final BasicTypeNode byteType = new ByteTypeNode();
    public static final BasicTypeNode shortType = new ShortTypeNode();
    public static final BasicTypeNode intType = new IntTypeNode();
    public static final BasicTypeNode longType = new LongTypeNode();
    public static final BasicTypeNode doubleType = new DoubleTypeNode();
    public static final BasicTypeNode floatType = new FloatTypeNode();
    public static final BasicTypeNode booleanType = new BooleanTypeNode();
    public static final BasicTypeNode objectType = new ObjectTypeNode();
    public static final BasicTypeNode enumItemType = new EnumItemTypeNode();
    public static final BasicTypeNode voidType = new VoidTypeNode();
    public static final BasicTypeNode nullType = new NullTypeNode();
    public static final BasicTypeNode graphType = new GraphTypeNode();
    public static final BasicTypeNode untypedType = new UntypedExecVarTypeNode();
    public static final TypeNode errorType = new ErrorTypeNode(IdentNode.getInvalid());
    private static Object invalidValueType = new Object(){

        public String toString() {
            return "invalid value";
        }
    };
    protected static Map<BasicTypeNode, Class<?>> valueMap = new HashMap();

    public static TypeNode getErrorType(IdentNode identNode) {
        return new ErrorTypeNode(identNode);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        return vector;
    }

    @Override
    public final boolean isBasic() {
        return true;
    }

    public final Class<?> getValueType() {
        if (!valueMap.containsKey(this)) {
            return invalidValueType.getClass();
        }
        return valueMap.get(this);
    }

    public static String getKindStr() {
        return "basic type";
    }

    public static TypeNode getArrayAccumulationResultType(TypeNode typeNode) {
        if (typeNode == byteType) {
            return intType;
        }
        if (typeNode == shortType) {
            return intType;
        }
        if (typeNode == intType) {
            return intType;
        }
        if (typeNode == longType) {
            return longType;
        }
        if (typeNode == floatType) {
            return doubleType;
        }
        if (typeNode == doubleType) {
            return doubleType;
        }
        return errorType;
    }

    static {
        BasicTypeNode.setName(BasicTypeNode.class, "basic type");
        valueMap.put(byteType, Byte.class);
        valueMap.put(shortType, Short.class);
        valueMap.put(intType, Integer.class);
        valueMap.put(longType, Long.class);
        valueMap.put(floatType, Float.class);
        valueMap.put(doubleType, Double.class);
        valueMap.put(booleanType, Boolean.class);
        valueMap.put(stringType, String.class);
        valueMap.put(enumItemType, Integer.class);
        valueMap.put(objectType, ObjectTypeNode.Value.class);
        valueMap.put(nullType, NullConstNode.Value.class);
        valueMap.put(untypedType, UntypedExecVarTypeNode.Value.class);
        BasicTypeNode.addCompatibility(enumItemType, byteType);
        BasicTypeNode.addCompatibility(enumItemType, shortType);
        BasicTypeNode.addCompatibility(enumItemType, intType);
        BasicTypeNode.addCompatibility(enumItemType, longType);
        BasicTypeNode.addCompatibility(enumItemType, floatType);
        BasicTypeNode.addCompatibility(enumItemType, doubleType);
        BasicTypeNode.addCompatibility(byteType, shortType);
        BasicTypeNode.addCompatibility(byteType, intType);
        BasicTypeNode.addCompatibility(byteType, longType);
        BasicTypeNode.addCompatibility(byteType, floatType);
        BasicTypeNode.addCompatibility(byteType, doubleType);
        BasicTypeNode.addCompatibility(shortType, intType);
        BasicTypeNode.addCompatibility(shortType, longType);
        BasicTypeNode.addCompatibility(shortType, floatType);
        BasicTypeNode.addCompatibility(shortType, doubleType);
        BasicTypeNode.addCompatibility(intType, longType);
        BasicTypeNode.addCompatibility(intType, floatType);
        BasicTypeNode.addCompatibility(intType, doubleType);
        BasicTypeNode.addCompatibility(longType, floatType);
        BasicTypeNode.addCompatibility(longType, doubleType);
        BasicTypeNode.addCompatibility(floatType, doubleType);
        BasicTypeNode.addCompatibility(enumItemType, stringType);
        BasicTypeNode.addCompatibility(byteType, stringType);
        BasicTypeNode.addCompatibility(shortType, stringType);
        BasicTypeNode.addCompatibility(intType, stringType);
        BasicTypeNode.addCompatibility(longType, stringType);
        BasicTypeNode.addCompatibility(floatType, stringType);
        BasicTypeNode.addCompatibility(doubleType, stringType);
        BasicTypeNode.addCompatibility(booleanType, stringType);
        BasicTypeNode.addCompatibility(objectType, stringType);
        BasicTypeNode.addCompatibility(voidType, stringType);
        BasicTypeNode.addCompatibility(enumItemType, untypedType);
        BasicTypeNode.addCompatibility(byteType, untypedType);
        BasicTypeNode.addCompatibility(shortType, untypedType);
        BasicTypeNode.addCompatibility(intType, untypedType);
        BasicTypeNode.addCompatibility(longType, untypedType);
        BasicTypeNode.addCompatibility(floatType, untypedType);
        BasicTypeNode.addCompatibility(doubleType, untypedType);
        BasicTypeNode.addCompatibility(booleanType, untypedType);
        BasicTypeNode.addCompatibility(objectType, untypedType);
        BasicTypeNode.addCompatibility(voidType, untypedType);
        BasicTypeNode.addCompatibility(stringType, untypedType);
        BasicTypeNode.addCompatibility(nullType, untypedType);
        BasicTypeNode.addCompatibility(graphType, untypedType);
        BasicTypeNode.addCastability(shortType, byteType);
        BasicTypeNode.addCastability(intType, byteType);
        BasicTypeNode.addCastability(intType, shortType);
        BasicTypeNode.addCastability(longType, byteType);
        BasicTypeNode.addCastability(longType, shortType);
        BasicTypeNode.addCastability(longType, intType);
        BasicTypeNode.addCastability(floatType, byteType);
        BasicTypeNode.addCastability(floatType, shortType);
        BasicTypeNode.addCastability(floatType, intType);
        BasicTypeNode.addCastability(floatType, longType);
        BasicTypeNode.addCastability(doubleType, byteType);
        BasicTypeNode.addCastability(doubleType, shortType);
        BasicTypeNode.addCastability(doubleType, intType);
        BasicTypeNode.addCastability(doubleType, longType);
        BasicTypeNode.addCastability(doubleType, floatType);
        BasicTypeNode.addCastability(enumItemType, objectType);
        BasicTypeNode.addCastability(byteType, objectType);
        BasicTypeNode.addCastability(shortType, objectType);
        BasicTypeNode.addCastability(intType, objectType);
        BasicTypeNode.addCastability(longType, objectType);
        BasicTypeNode.addCastability(floatType, objectType);
        BasicTypeNode.addCastability(doubleType, objectType);
        BasicTypeNode.addCastability(booleanType, objectType);
        BasicTypeNode.addCastability(stringType, objectType);
    }
}

