/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.type.container;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorEvaluator;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ContainerTypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.ir.type.container.MapType;
import java.util.Collection;
import java.util.Vector;

public class MapTypeNode
extends ContainerTypeNode {
    public IdentNode keyTypeUnresolved;
    public TypeNode keyType;
    public IdentNode valueTypeUnresolved;
    public TypeNode valueType;
    private SetTypeNode exceptCompatibleSetTyp;
    private static DeclarationTypeResolver<TypeNode> typeResolver;

    @Override
    public String getTypeName() {
        return "map<" + this.keyTypeUnresolved.toString() + "," + this.valueTypeUnresolved.toString() + ">";
    }

    public MapTypeNode(IdentNode identNode, IdentNode identNode2) {
        this.keyTypeUnresolved = this.becomeParent(identNode);
        this.valueTypeUnresolved = this.becomeParent(identNode2);
        this.exceptCompatibleSetTyp = new SetTypeNode(identNode);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.keyTypeUnresolved instanceof PackageIdentNode) {
            Resolver.resolveOwner((PackageIdentNode)this.keyTypeUnresolved);
        } else {
            MapTypeNode.fixupDefinition(this.keyTypeUnresolved, this.keyTypeUnresolved.getScope());
        }
        if (this.valueTypeUnresolved instanceof PackageIdentNode) {
            Resolver.resolveOwner((PackageIdentNode)this.valueTypeUnresolved);
        } else {
            MapTypeNode.fixupDefinition(this.valueTypeUnresolved, this.valueTypeUnresolved.getScope());
        }
        this.keyType = (TypeNode)typeResolver.resolve(this.keyTypeUnresolved, this);
        this.valueType = (TypeNode)typeResolver.resolve(this.valueTypeUnresolved, this);
        this.exceptCompatibleSetTyp.resolve();
        if (this.keyType == null || this.valueType == null) {
            return false;
        }
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.IN, BasicTypeNode.booleanType, this.keyType, this, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.INDEX, this.valueType, this, this.keyType, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.EQ, BasicTypeNode.booleanType, this, this, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.NE, BasicTypeNode.booleanType, this, this, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.SE, BasicTypeNode.booleanType, this, this, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.GT, BasicTypeNode.booleanType, this, this, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.GE, BasicTypeNode.booleanType, this, this, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.LT, BasicTypeNode.booleanType, this, this, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.LE, BasicTypeNode.booleanType, this, this, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.BIT_OR, this, this, this, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.BIT_AND, this, this, this, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.EXCEPT, this, this, this, OperatorEvaluator.mapEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.EXCEPT, this, this, this.exceptCompatibleSetTyp, OperatorEvaluator.mapEvaluator);
        TypeNode.addCompatibility(this, BasicTypeNode.stringType);
        return true;
    }

    @Override
    public TypeNode getElementType() {
        return this.keyType;
    }

    @Override
    protected MapType constructIR() {
        Type type = this.keyType.getType();
        Type type2 = this.valueType.getType();
        return new MapType(type, type2);
    }

    static {
        MapTypeNode.setName(MapTypeNode.class, "map type");
        typeResolver = new DeclarationTypeResolver<TypeNode>(TypeNode.class);
    }
}

