/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.util;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.util.Pair;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.util.Util;

public class DeclarationPairResolver<R extends BaseNode, S extends BaseNode>
extends Resolver<Pair<R, S>> {
    private Class<R> clsR;
    private Class<S> clsS;
    private Class<?>[] classes;

    public DeclarationPairResolver(Class<R> clazz, Class<S> clazz2) {
        this.clsR = clazz;
        this.clsS = clazz2;
        this.classes = new Class[]{this.clsR, this.clsS};
    }

    @Override
    public Pair<R, S> resolve(BaseNode baseNode, BaseNode baseNode2) {
        if (baseNode instanceof IdentNode) {
            Pair<R, S> pair = this.resolve((IdentNode)baseNode);
            if (pair != null) {
                assert (pair.fst == null || pair.snd == null);
                baseNode2.becomeParent(pair.fst);
                baseNode2.becomeParent(pair.snd);
            }
            return pair;
        }
        Pair pair = new Pair();
        if (this.clsR.isInstance(baseNode)) {
            pair.fst = (BaseNode)this.clsR.cast(baseNode);
        }
        if (this.clsS.isInstance(baseNode)) {
            pair.snd = (BaseNode)this.clsS.cast(baseNode);
        }
        if (pair.fst != null || pair.snd != null) {
            assert (pair.fst == null || pair.snd == null);
            return pair;
        }
        baseNode.reportError(baseNode + " is a " + baseNode.getKind() + " but a " + Util.getStrListWithOr(this.classes, BaseNode.class, "getKindStr") + " is expected.");
        return null;
    }

    private Pair<R, S> resolve(IdentNode identNode) {
        if (identNode instanceof PackageIdentNode && !DeclarationPairResolver.resolveOwner((PackageIdentNode)identNode)) {
            return null;
        }
        Pair pair = new Pair();
        DeclNode declNode = identNode.getDecl();
        if (this.clsR.isInstance(declNode)) {
            pair.fst = (BaseNode)this.clsR.cast(declNode);
        }
        if (this.clsS.isInstance(declNode)) {
            pair.snd = (BaseNode)this.clsS.cast(declNode);
        }
        if (pair.fst != null || pair.snd != null) {
            return pair;
        }
        identNode.reportError(identNode + " is a " + declNode.getKind() + " but a " + Util.getStrListWithOr(this.classes, BaseNode.class, "getKindStr") + " is expected.");
        return null;
    }
}

