/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.util;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.util.Util;

public class DeclarationResolver<R extends BaseNode>
extends Resolver<R> {
    private Class<R> cls;
    private Class<? extends R>[] classes;

    public DeclarationResolver(Class<R> clazz) {
        this.cls = clazz;
    }

    @SafeVarargs
    public DeclarationResolver(Class<? extends R> ... classArray) {
        this.classes = classArray;
    }

    @Override
    public R resolve(BaseNode baseNode, BaseNode baseNode2) {
        if (baseNode instanceof IdentNode) {
            R r = this.resolve((IdentNode)baseNode);
            baseNode2.becomeParent(r);
            return r;
        }
        R r = this.tryCast(baseNode);
        if (r != null) {
            return r;
        }
        baseNode.reportError(baseNode + " is a " + baseNode.getKind() + " but a " + this.getAllowedNames() + " is expected.");
        return null;
    }

    public R resolve(IdentNode identNode) {
        if (identNode instanceof PackageIdentNode && !DeclarationResolver.resolveOwner((PackageIdentNode)identNode)) {
            return null;
        }
        DeclNode declNode = identNode.getDecl();
        R r = this.tryCast(declNode);
        if (r != null) {
            return r;
        }
        identNode.reportError(identNode + " is a " + declNode.getKind() + " but a " + this.getAllowedNames() + " is expected.");
        return null;
    }

    private R tryCast(BaseNode baseNode) {
        if (this.cls == null) {
            for (Class<R> clazz : this.classes) {
                if (!clazz.isInstance(baseNode)) continue;
                return (R)((BaseNode)clazz.cast(baseNode));
            }
        } else if (this.cls.isInstance(baseNode)) {
            return (R)((BaseNode)this.cls.cast(baseNode));
        }
        return null;
    }

    private String getAllowedNames() {
        if (this.cls != null) {
            return Util.getStr(this.cls, BaseNode.class, "getKindStr");
        }
        return Util.getStrListWithOr(this.classes, BaseNode.class, "getKindStr");
    }
}

