/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.util;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.util.Util;

public class DeclarationTypeResolver<T extends BaseNode>
extends Resolver<T> {
    private Class<T> cls;

    public DeclarationTypeResolver(Class<T> clazz) {
        this.cls = clazz;
    }

    @Override
    public T resolve(BaseNode baseNode, BaseNode baseNode2) {
        if (baseNode instanceof IdentNode) {
            T t = this.resolve((IdentNode)baseNode);
            baseNode2.becomeParent(t);
            return t;
        }
        if (this.cls.isInstance(baseNode)) {
            return (T)((BaseNode)this.cls.cast(baseNode));
        }
        baseNode.reportError(baseNode + " is a " + baseNode.getKind() + " but a " + Util.getStr(this.cls, BaseNode.class, "getKindStr") + " is expected.");
        return null;
    }

    public T resolve(IdentNode identNode) {
        DeclarationResolver<DeclNode> declarationResolver = new DeclarationResolver<DeclNode>(DeclNode.class);
        DeclNode declNode = declarationResolver.resolve(identNode);
        if (declNode != null) {
            declNode.resolve();
            TypeNode typeNode = declNode.getDeclType();
            if (this.cls.isInstance(typeNode)) {
                return (T)((BaseNode)this.cls.cast(typeNode));
            }
            identNode.reportError(identNode + " is a " + typeNode.getKind() + " but a " + Util.getStr(this.cls, BaseNode.class, "getKindStr") + " is expected.");
        }
        return null;
    }
}

