/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.util;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.util.Checker;
import de.unika.ipd.grgen.util.report.ErrorReporter;

public class SimpleChecker
implements Checker {
    private Class<?>[] validTypes;

    public SimpleChecker(Class<?> clazz) {
        this.validTypes = new Class[]{clazz};
    }

    public SimpleChecker(Class<?>[] classArray) {
        this.validTypes = classArray;
    }

    @Override
    public boolean check(BaseNode baseNode, ErrorReporter errorReporter) {
        boolean bl = false;
        for (int i = 0; i < this.validTypes.length; ++i) {
            if (!this.validTypes[i].isInstance(baseNode)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            if (this.validTypes.length == 1) {
                baseNode.reportError("AST node " + baseNode.getName() + " must be an instance of type " + SimpleChecker.shortClassName(this.validTypes[0]));
            } else {
                baseNode.reportError("AST node " + baseNode.getName() + " - Unknown type");
            }
        }
        return bl;
    }

    protected static String shortClassName(Class<?> clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }
}

