/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.util;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.Checker;
import de.unika.ipd.grgen.util.report.ErrorReporter;

public class TypeChecker
implements Checker {
    private Class<?>[] validTypes;

    public TypeChecker(Class<?>[] classArray) {
        this.validTypes = classArray;
    }

    public TypeChecker(Class<?> clazz) {
        this(new Class[]{clazz});
    }

    @Override
    public boolean check(BaseNode baseNode, ErrorReporter errorReporter) {
        boolean bl = baseNode instanceof DeclNode;
        if (!bl) {
            baseNode.reportError("Not a " + BaseNode.getName(DeclNode.class));
        } else {
            TypeNode typeNode = ((DeclNode)baseNode).getDeclType();
            bl = false;
            for (Class<?> clazz : this.validTypes) {
                if (!clazz.isInstance(typeNode)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                ((DeclNode)baseNode).getIdentNode().reportError(TypeChecker.getErrorMsg(this.validTypes, baseNode));
            }
        }
        return bl;
    }

    protected static String getExpection(Class<?> clazz) {
        String string = "";
        try {
            string = (String)clazz.getMethod("getKindStr", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            string = "<invalid>";
        }
        return string;
    }

    protected static String getExpectionList(Class<?>[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(TypeChecker.getExpection(classArray[i]));
            if (i < classArray.length - 2) {
                stringBuffer.append(", ");
                continue;
            }
            if (i != classArray.length - 2) continue;
            stringBuffer.append(" or ");
        }
        return stringBuffer.toString();
    }

    protected static String getErrorMsg(Class<?>[] classArray, BaseNode baseNode) {
        return "expected a " + TypeChecker.getExpectionList(classArray);
    }
}

