/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.be.C;

import de.unika.ipd.grgen.Sys;
import de.unika.ipd.grgen.be.Backend;
import de.unika.ipd.grgen.be.IDBase;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.Identifiable;
import de.unika.ipd.grgen.ir.Unit;
import de.unika.ipd.grgen.ir.executable.Action;
import de.unika.ipd.grgen.ir.executable.MatchingAction;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.model.ConnAssert;
import de.unika.ipd.grgen.ir.model.EnumItem;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import de.unika.ipd.grgen.ir.model.type.EnumType;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.util.Util;
import de.unika.ipd.grgen.util.report.ErrorReporter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;

public abstract class CBackend
extends IDBase
implements Backend {
    protected Unit unit;
    private File path;
    public final String incExtension = ".inc";
    protected ErrorReporter error;

    protected Unit getUnit() {
        return this.unit;
    }

    protected static String mangle(Identifiable identifiable) {
        String string = identifiable.getIdent().toString();
        string = string.replaceAll("_", "__");
        string = string.replace('$', '_');
        return string;
    }

    protected final void writeFile(String string, CharSequence charSequence) {
        Util.writeFile(new File(this.path, string), charSequence, this.error);
    }

    protected final PrintStream openFile(String string) {
        return Util.openFile(new File(this.path, string), this.error);
    }

    protected static final void closeFile(PrintStream printStream) {
        Util.closeFile(printStream);
    }

    protected static void makeTypeDefines(PrintStream printStream, Map<? extends InheritanceType, Integer> map, String string) {
        printStream.print("/** Use this macro to check, if an id is a valid type */\n");
        printStream.print("#define GR_" + string + "_TYPE_VALID(t) ((t) >= 0 && (t) < " + map.size() + ")\n\n");
        printStream.print("/** The number of types defined */\n");
        printStream.print("#define GR_" + string + "_TYPES " + map.size() + "\n\n");
        for (InheritanceType inheritanceType : map.keySet()) {
            Ident ident = inheritanceType.getIdent();
            printStream.print("/** type " + ident + " defined at line " + ident.getCoords().getLine() + " */\n");
            printStream.print("#define GR_DEF_" + string + "_TYPE_" + CBackend.mangle(inheritanceType) + " " + map.get(inheritanceType) + "\n\n");
        }
    }

    protected static void makeAttrDefines(PrintStream printStream, Map<Entity, Integer> map, String string) {
        printStream.print("/** Number of attributes macro for " + string + " */\n");
        printStream.print("#define GR_" + string + "_ATTRS " + map.size() + "\n\n");
        printStream.print("/** Attribute valid macro for " + string + " */\n");
        printStream.print("#define GR_" + string + "_ATTR_VALID(a) ((a) >= 0 && (a) < " + map.size() + ")\n\n");
        for (Entity entity : map.keySet()) {
            Ident ident = entity.getIdent();
            printStream.print("/** Attribute " + ident + " of " + entity.getOwner().getIdent() + " in line " + ident.getCoords().getLine() + " */\n");
            printStream.print("#define GR_DEF_" + string + "_ATTR_" + CBackend.mangle(entity.getOwner()) + "_" + CBackend.mangle(entity) + " " + map.get(entity) + "\n\n");
        }
    }

    protected static void makeEnumDefines(PrintStream printStream, Map<EnumType, Integer> map) {
        printStream.print("/** Number of enum types. */\n");
        printStream.print("#define GR_DEF_ENUMS " + map.size() + "\n\n");
        printStream.print("/** Use this macro to check, if an id is a valid enum type */\n");
        printStream.print("#define GR_ENUM_TYPE_VALID(t) ((t) >= 0 && (t) < " + map.size() + ")\n\n");
    }

    protected static void makeTypeMap(PrintStream printStream, Map<? extends InheritanceType, Integer> map, String string) {
        String[] stringArray = new String[map.size()];
        for (Identifiable identifiable : map.keySet()) {
            int n = CBackend.getTypeId(map, identifiable);
            stringArray[n] = identifiable.getIdent().toString();
        }
        printStream.print("static const char *" + string + "_type_map[] = {\n");
        for (int i = 0; i < stringArray.length; ++i) {
            printStream.print("  \"" + stringArray[i] + "\",\n");
        }
        printStream.print("  NULL\n};\n\n");
    }

    protected static void makeAttrMap(PrintStream printStream, Map<Entity, Integer> map, Map<? extends InheritanceType, Integer> map2, Map<EnumType, Integer> map3, String string) {
        String[] stringArray = new String[map.size()];
        Type[] typeArray = new Type[map.size()];
        Integer[] integerArray = new Integer[map.size()];
        for (Entity entity : map.keySet()) {
            int n = map.get(entity);
            stringArray[n] = entity.getIdent().toString();
            integerArray[n] = new Integer(CBackend.getTypeId(map2, entity.getOwner()));
            typeArray[n] = entity.getType();
        }
        printStream.print("/** The attribute map for " + string + " attributes. */\n");
        printStream.print("static const attr_t " + string + "_attr_map[] = {\n");
        for (int i = 0; i < stringArray.length; ++i) {
            printStream.print("  { " + integerArray[i] + ", " + CBackend.formatString(stringArray[i]) + ", " + (Object)((Object)typeArray[i].classify()) + ", ");
            if (typeArray[i] instanceof EnumType) {
                int n = CBackend.getTypeId(map3, typeArray[i]);
                printStream.print(n + " },\n");
                continue;
            }
            printStream.print("-1 },\n");
        }
        printStream.print("  { 0, NULL, 0 }\n};\n\n");
    }

    protected void makeIsAMatrix(PrintStream printStream, boolean bl, String string) {
        short[][] sArray = this.getIsAMatrix(bl);
        int n = sArray.length;
        String string2 = string + "_type_is_a_matrix";
        printStream.print("/** The matrix showing valid type attributes for " + string + ". */\n");
        printStream.print("static const char " + string2 + "[" + n + "][" + n + "] = {\n");
        for (int i = 0; i < n; ++i) {
            printStream.print("  { ");
            for (int j = 0; j < n; ++j) {
                printStream.print(j != 0 ? ", " : "");
                printStream.print(sArray[i][j]);
            }
            printStream.print(" }, /* ");
            printStream.print(i);
            printStream.print(' ');
            printStream.print(this.getTypeName(bl, i));
            printStream.print(" */\n");
        }
        printStream.print("};\n\n");
        printStream.print("/** Function to test for type compatibility. */\n");
        printStream.print("static inline int ");
        printStream.print(string);
        printStream.print("_type_is_a(int t1, int t2) {\n");
        printStream.print("  return t1 == t2 || " + string2 + "[t1][t2] != 0;\n}\n\n");
    }

    protected void makeSuperSubTypes(PrintStream printStream, boolean bl, String string) {
        int n;
        int[] nArray;
        int n2;
        int[] nArray2 = this.getIDs(bl);
        int n3 = nArray2.length;
        printStream.print("static const char " + string + "_super_types[" + (n3 + 1) + "][" + n3 + "] = {\n");
        for (n2 = 0; n2 < n3; ++n2) {
            nArray = this.getSuperTypes(bl, n2);
            printStream.print("  /* super types of ");
            printStream.print(this.getTypeName(bl, n2));
            printStream.print(": ");
            for (n = 0; n < nArray.length; ++n) {
                printStream.print(this.getTypeName(bl, nArray[n]));
                printStream.print(" ");
            }
            printStream.print(" */\n");
            printStream.print("  { ");
            for (n = 0; n < nArray.length; ++n) {
                printStream.print(nArray[n]);
                printStream.print(", ");
            }
            printStream.print("-1 },\n\n");
        }
        printStream.print("};\n\n");
        printStream.print("static const char " + string + "_sub_types[" + (n3 + 1) + "][" + n3 + "] = {\n");
        for (n2 = 0; n2 < n3; ++n2) {
            nArray = this.getSubTypes(bl, n2);
            printStream.print("  /* sub types of ");
            printStream.print(this.getTypeName(bl, n2));
            printStream.print(": ");
            for (n = 0; n < nArray.length; ++n) {
                printStream.print(this.getTypeName(bl, nArray[n]));
                printStream.print(" ");
            }
            printStream.print(" */\n  {");
            for (n = 0; n < nArray.length; ++n) {
                printStream.print(nArray[n]);
                printStream.print(", ");
            }
            printStream.print("-1 },\n\n");
        }
        printStream.print("};\n\n");
    }

    protected static void makeAttrMatrix(PrintStream printStream, String string, Map<Entity, Integer> map, Map<? extends InheritanceType, Integer> map2) {
        int n = map2.size();
        int n2 = map.size();
        int[][] nArray = new int[n][n2];
        for (Entity entity : map.keySet()) {
            int n3 = map.get(entity);
            int n4 = CBackend.getTypeId(map2, entity.getOwner());
            nArray[n4][n3] = 1;
        }
        printStream.print("static const char " + string + "_attr_matrix[" + n + "][" + n2 + "] = {\n");
        for (int i = 0; i < n; ++i) {
            printStream.print("  { ");
            for (int j = 0; j < n2; ++j) {
                printStream.print((j != 0 ? ", " : "") + nArray[i][j]);
            }
            printStream.print(" },\n");
        }
        printStream.print("};\n");
    }

    protected static void makeActionMap(PrintStream printStream, Map<Rule, Integer> map) {
        Action[] actionArray = new Action[map.size()];
        for (Rule action : map.keySet()) {
            int n = map.get(action);
            actionArray[n] = action;
        }
        printStream.print("#define GR_ACTION_VALID(x) ((x) >= 0 && (x) < " + actionArray.length + ")\n\n");
        printStream.print("#define GR_ACTIONS " + actionArray.length + "\n\n");
        printStream.print("static const action_t action_map[] = {\n");
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            String string = "gr_action_kind_test";
            if (action instanceof Rule && ((Rule)action).getRight() != null) {
                string = "gr_action_kind_rule";
            }
            printStream.print("  { " + CBackend.formatString(action.getIdent().toString()) + ", " + string + ", 0, 0, NULL, NULL },\n");
        }
        printStream.print("  { NULL, -1, 0, 0, NULL, NULL }\n};\n\n");
    }

    protected void makeActions(PrintStream printStream) {
        for (Rule rule : this.actionRuleMap.keySet()) {
            int n = (Integer)this.actionRuleMap.get(rule);
            this.genMatch(printStream, rule, n);
            this.genFinish(printStream, rule, n);
        }
    }

    protected static void dumpXMLTag(int n, PrintStream printStream, String string, Type type) {
        for (int i = 0; i < n; ++i) {
            printStream.print("  ");
        }
        printStream.print("<" + type.getName().replace(' ', '_') + " name=\"" + type.getIdent() + "\"" + string);
    }

    protected static void dumpXMLEndTag(int n, PrintStream printStream, Type type) {
        for (int i = 0; i < n; ++i) {
            printStream.print("  ");
        }
        printStream.print("</" + type.getName().replace(' ', '_') + ">\n");
    }

    protected static void dumpXMLTag(int n, PrintStream printStream, String string, Entity entity) {
        for (int i = 0; i < n; ++i) {
            printStream.print("  ");
        }
        printStream.print("<" + entity.getName().replace(' ', '_') + " name=\"" + entity.getIdent() + "\" type=\"" + entity.getType().getIdent() + "\"" + string);
    }

    protected static void dumpXMLEndTag(int n, PrintStream printStream, Entity entity) {
        for (int i = 0; i < n; ++i) {
            printStream.print("  ");
        }
        printStream.print("</" + entity.getName().replace(' ', '_') + ">\n");
    }

    protected static void dumpXMLTag(int n, PrintStream printStream, String string, EnumItem enumItem) {
        for (int i = 0; i < n; ++i) {
            printStream.print("  ");
        }
        printStream.print("<" + enumItem.getName().replace(' ', '_') + " name=\"" + enumItem + "\" value=\"" + enumItem.getValue().getValue() + "\"" + string);
    }

    protected void writeOverview(PrintStream printStream) {
        LinkedHashSet<Map> linkedHashSet = new LinkedHashSet<Map>();
        linkedHashSet.add(this.nodeTypeMap);
        linkedHashSet.add(this.edgeTypeMap);
        printStream.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        printStream.print("<unit>\n");
        for (Map object : linkedHashSet) {
            for (Identifiable identifiable : object.keySet()) {
                Object object2;
                CBackend.dumpXMLTag(1, printStream, ">\n", identifiable);
                Iterator<InheritanceType> iterator = identifiable.getDirectSuperTypes().iterator();
                if (iterator.hasNext()) {
                    printStream.print("    <inherits>\n");
                    while (iterator.hasNext()) {
                        object2 = iterator.next();
                        CBackend.dumpXMLTag(3, printStream, "/>\n", (Type)object2);
                    }
                    printStream.print("    </inherits>\n");
                }
                if ((object2 = identifiable.getMembers().iterator()).hasNext()) {
                    printStream.print("    <attributes>\n");
                    while (object2.hasNext()) {
                        Entity entity = (Entity)object2.next();
                        CBackend.dumpXMLTag(3, printStream, "/>\n", entity);
                    }
                    printStream.print("    </attributes>\n");
                }
                CBackend.dumpXMLEndTag(1, printStream, identifiable);
            }
        }
        for (EnumType enumType : this.enumMap.keySet()) {
            CBackend.dumpXMLTag(1, printStream, ">\n", enumType);
            Iterator<Object> iterator = enumType.getItems().iterator();
            if (iterator.hasNext()) {
                printStream.print("    <items>\n");
                while (iterator.hasNext()) {
                    Identifiable identifiable;
                    identifiable = (EnumItem)iterator.next();
                    CBackend.dumpXMLTag(3, printStream, "/>\n", (EnumItem)identifiable);
                }
                printStream.print("    </items>\n");
            }
            CBackend.dumpXMLEndTag(1, printStream, enumType);
        }
        printStream.print("</unit>\n");
    }

    protected static void makeCTypes(PrintStream printStream) {
        printStream.print("/** The attribute type classification. */\n");
        printStream.print("typedef enum _attribute_type {\n");
        printStream.print("  AT_TYPE_INTEGER = " + (Object)((Object)Type.TypeClass.IS_INTEGER) + ", /**< an integer */\n");
        printStream.print("  AT_TYPE_BOOLEAN = " + (Object)((Object)Type.TypeClass.IS_BOOLEAN) + ", /**< a boolean */\n");
        printStream.print("  AT_TYPE_STRING  = " + (Object)((Object)Type.TypeClass.IS_STRING) + ", /**< a string */\n");
        printStream.print("} attribute_type;\n\n");
        printStream.print("/** The attribute type. */\n");
        printStream.print("typedef struct {\n  int type_id;       /**< the ID of attributes type */\n  const char *name;  /**< the name of the attribute */\n  attribute_type at; /**< the attribute type kind */\n  int enum_id;       /**< the Id of the enum type or -1 */\n} attr_t;\n\n");
        printStream.print("/** The type of an action. */\n");
        printStream.print("typedef struct {\n  const char *name;\n  gr_action_kind_t kind;\n  int ins;\n  int outs;\n  const gr_value_kind_t *in_types;\n  const gr_value_kind_t *out_types;\n} action_t;\n\n");
        printStream.print("/** The type of an enum item declaration. */\n");
        printStream.print("typedef struct {\n  const char *name;    /**< the name of the enum item */\n  int value;           /**< the value of the enum item */\n} enum_item_decl_t;\n\n");
        printStream.print("/** The type of an enum declaration. */\n");
        printStream.print("typedef struct {\n  const char *name;    /**< the name of the enum type */\n  int num_items;       /**< the number of items in this enum type */\n  const enum_item_decl_t *items;  /**< the items of this enum type */\n} enum_type_decl_t;\n\n");
        printStream.print("/** The type of the enum table. */\n");
        printStream.print("typedef struct {\n  const enum_type_decl_t *type; /**< declaration of the type */\n  int type_id;                  /**< the Id of this enum type */\n} enum_types_t;\n\n");
    }

    /*
     * WARNING - void declaration
     */
    protected static void makeEnumDeclarations(PrintStream printStream, Map<EnumType, Integer> map) {
        void var3_6;
        for (EnumType object : map.keySet()) {
            Ident ident = object.getIdent();
            printStream.print("/** The items for the " + ident + " enum type. */\n");
            printStream.print("static const enum_item_decl_t _" + ident + "_items[] = {\n");
            for (EnumItem enumItem : object.getItems()) {
                printStream.print(" { \"" + enumItem + "\", " + enumItem.getValue().getValue() + " },\n");
            }
            printStream.print("};\n\n");
            printStream.print("/** The declaration of the " + ident + " enum type. */\n");
            printStream.print("static const enum_type_decl_t " + ident + "_decl = {\n  \"" + ident + "\",\n  sizeof(_" + ident + "_items)/sizeof(_" + ident + "_items[0]),\n  _" + ident + "_items,\n};\n\n");
        }
        printStream.print("/** All enum types. */\n");
        printStream.print("static const enum_types_t enum_types[] = {\n");
        String[] stringArray = new String[map.size()];
        for (EnumType enumType : map.keySet()) {
            int n = CBackend.getTypeId(map, enumType);
            stringArray[n] = enumType.getIdent().toString();
        }
        boolean bl = false;
        while (var3_6 < map.size()) {
            printStream.print("  { &" + stringArray[var3_6] + "_decl, " + (int)var3_6 + " },\n");
            ++var3_6;
        }
        printStream.print("};\n\n");
    }

    @Override
    public void init(Unit unit, Sys sys, File file) {
        this.unit = unit;
        this.error = sys.getErrorReporter();
        this.path = file;
        this.path.mkdirs();
        this.makeTypes(unit);
    }

    @Override
    public void generate() {
        String string = CBackend.formatString(this.unit.getUnitName());
        PrintStream printStream = this.openFile("types.inc");
        CBackend.makeCTypes(printStream);
        CBackend.closeFile(printStream);
        printStream = this.openFile("graph.inc");
        printStream.println("/** name of the unit */\n");
        printStream.println("#define UNIT_NAME " + string + "\n\n");
        printStream.println("/** type model digest */\n");
        printStream.println("#define TYPE_MODEL_DIGEST \"" + this.unit.getTypeDigest() + "\"\n\n");
        CBackend.makeTypeDefines(printStream, this.nodeTypeMap, "NODE");
        CBackend.makeTypeDefines(printStream, this.edgeTypeMap, "EDGE");
        CBackend.makeAttrDefines(printStream, this.nodeAttrMap, "NODE");
        CBackend.makeAttrDefines(printStream, this.edgeAttrMap, "EDGE");
        CBackend.makeEnumDefines(printStream, this.enumMap);
        CBackend.closeFile(printStream);
        printStream = this.openFile("enums.inc");
        CBackend.makeEnumDeclarations(printStream, this.enumMap);
        CBackend.closeFile(printStream);
        printStream = this.openFile("is_a.inc");
        this.makeIsAMatrix(printStream, true, "node");
        this.makeIsAMatrix(printStream, false, "edge");
        CBackend.closeFile(printStream);
        printStream = this.openFile("super_sub_types.inc");
        this.makeSuperSubTypes(printStream, true, "node");
        this.makeSuperSubTypes(printStream, false, "edge");
        CBackend.closeFile(printStream);
        printStream = this.openFile("attr.inc");
        CBackend.makeAttrMatrix(printStream, "node", this.nodeAttrMap, this.nodeTypeMap);
        CBackend.makeAttrMatrix(printStream, "edge", this.edgeAttrMap, this.edgeTypeMap);
        CBackend.closeFile(printStream);
        printStream = this.openFile("names.inc");
        CBackend.makeTypeMap(printStream, this.nodeTypeMap, "node");
        CBackend.makeTypeMap(printStream, this.edgeTypeMap, "edge");
        CBackend.makeAttrMap(printStream, this.nodeAttrMap, this.nodeTypeMap, this.enumMap, "node");
        CBackend.makeAttrMap(printStream, this.edgeAttrMap, this.edgeTypeMap, this.enumMap, "edge");
        CBackend.closeFile(printStream);
        printStream = this.openFile("actions.inc");
        CBackend.makeActionMap(printStream, this.actionRuleMap);
        CBackend.closeFile(printStream);
        printStream = this.openFile("action_impl.inc");
        this.makeActions(printStream);
        CBackend.closeFile(printStream);
        printStream = this.openFile("overview.xml");
        this.writeOverview(printStream);
        CBackend.closeFile(printStream);
        this.genValidateStatements();
        this.genExtra();
    }

    protected abstract void genMatch(PrintStream var1, MatchingAction var2, int var3);

    protected abstract void genFinish(PrintStream var1, MatchingAction var2, int var3);

    protected abstract void genExtra();

    @Override
    public void done() {
    }

    public static String formatId(String string) {
        return string;
    }

    public static String formatString(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() * 2);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        CBackend.formatString(printStream, string);
        printStream.flush();
        printStream.close();
        return byteArrayOutputStream.toString();
    }

    public static void formatString(PrintStream printStream, String string) {
        printStream.print('\"');
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    printStream.print("\\\"");
                    continue block5;
                }
                case '\'': {
                    printStream.print("\\'");
                    continue block5;
                }
                case '\t': 
                case '\n': {
                    continue block5;
                }
                default: {
                    printStream.print(c);
                }
            }
        }
        printStream.print('\"');
    }

    protected void genValidateStatements() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n/** The Validate Info */\n\n");
        stringBuffer.append("static gr_validate_info_t valid_info[] = {\n");
        for (EdgeType edgeType : this.edgeTypeMap.keySet()) {
            for (ConnAssert connAssert : edgeType.getConnAsserts()) {
                stringBuffer.append("\n{\n");
                stringBuffer.append("  " + this.getId(edgeType) + ",\n");
                stringBuffer.append("  " + this.getId(connAssert.getSrcType()) + ",\n");
                stringBuffer.append("  " + this.getId(connAssert.getTgtType()) + ",\n");
                stringBuffer.append("  " + connAssert.getSrcLower() + ",\n");
                stringBuffer.append("  " + connAssert.getSrcUpper() + ",\n");
                stringBuffer.append("  " + connAssert.getTgtLower() + ",\n");
                stringBuffer.append("  " + connAssert.getTgtUpper() + ",\n");
                stringBuffer.append("},\n");
            }
        }
        stringBuffer.append("\n{-1, -1, -1, -1, -1, -1, -1}\n\n};\n\n");
        this.writeFile("valid_info.inc", stringBuffer);
    }
}

