/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.be.C;

import de.unika.ipd.grgen.be.C.InformationCollector;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Action;
import de.unika.ipd.grgen.ir.executable.MatchingAction;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Operator;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.PatternGraphBase;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.PatternGraphRhs;
import de.unika.ipd.grgen.ir.stmt.Assignment;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.EvalStatements;
import de.unika.ipd.grgen.ir.type.basic.PrimitiveType;
import de.unika.ipd.grgen.util.Annotations;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class MoreInformationCollector
extends InformationCollector {
    protected Map<Collection<Assignment>, Integer> evalListMap = new HashMap<Collection<Assignment>, Integer>();
    protected Map<Collection<Assignment>, Collection<Node>> evalInvolvedNodes = new HashMap<Collection<Assignment>, Collection<Node>>();
    protected Map<Collection<Assignment>, Collection<Edge>> evalInvolvedEdges = new HashMap<Collection<Assignment>, Collection<Edge>>();
    protected Map<Collection<Assignment>, Action> evalActions = new HashMap<Collection<Assignment>, Action>();
    protected Vector<Map<Node, Collection<Integer>>> involvedEvalNodeAttrIds;
    protected Vector<Map<Edge, Collection<Integer>>> involvedEvalEdgeAttrIds;
    protected int[][] replacementEdgeIsPreservedEdge;
    protected int[][] patternEdgeIsToBeKept;
    private static final int min_subgraph_size = 4;
    protected int max_n_negative_nodes = 0;
    protected int max_n_negative_edges = 0;
    protected int max_n_negative_patterns = 0;
    protected int[] n_negative_patterns;
    protected Vector<Vector<Map<Node, Integer>>> negative_node_num;
    protected Vector<Vector<Map<Edge, Integer>>> negative_edge_num;
    protected Vector<Map<PatternGraphLhs, Integer>> negMap;
    protected int[][][] patternNodeIsNegativeNode;
    protected int[][][] patternEdgeIsNegativeEdge;
    protected Map<Collection<InheritanceType>, Integer> typeConditionsPatternNum = new HashMap<Collection<InheritanceType>, Integer>();
    protected Map<Expression, Integer> conditionsPatternNum = new HashMap<Expression, Integer>();
    protected int[] n_subgraphs;
    protected int[] first_subgraph;
    protected int max_n_subgraphs;
    protected Vector<LinkedList<Collection<Node>>> nodesOfSubgraph;
    protected Vector<LinkedList<Collection<Edge>>> edgesOfSubgraph;
    protected Map<Node, Integer> subgraphOfNode;
    protected Map<Edge, Integer> subgraphOfEdge;

    protected void collectEvalInfo() {
        this.involvedEvalNodeAttrIds = new Vector(this.actionRuleMap.size());
        this.involvedEvalEdgeAttrIds = new Vector(this.actionRuleMap.size());
        for (Rule rule : this.actionRuleMap.keySet()) {
            if (rule.getRight() == null) continue;
            Integer n = (Integer)this.actionRuleMap.get(rule);
            LinkedList<Assignment> linkedList = new LinkedList<Assignment>();
            for (EvalStatements evalStatements : rule.getEvals()) {
                for (EvalStatement evalStatement : evalStatements.evalStatements) {
                    if (!(evalStatement instanceof Assignment)) continue;
                    linkedList.add((Assignment)evalStatement);
                }
            }
            this.evalListMap.put(linkedList, n);
            this.evalActions.put(linkedList, rule);
            HashSet hashSet = new HashSet();
            HashSet<Edge> object2 = new HashSet<Edge>();
            this.involvedEvalNodeAttrIds.set(n, new HashMap());
            this.involvedEvalEdgeAttrIds.set(n, new HashMap());
            for (Assignment assignment : linkedList) {
                Qualification qualification = assignment.getTarget();
                if (!(qualification instanceof Qualification)) {
                    throw new UnsupportedOperationException("The C backend only supports assignments to qualified expressions, yet!");
                }
                Qualification qualification2 = qualification;
                Expression expression = assignment.getExpression();
                Operator operator = new Operator((PrimitiveType)qualification2.getType(), Operator.OperatorCode.EQ);
                operator.addOperand(qualification2);
                operator.addOperand(expression);
                hashSet.addAll(this.collectInvolvedNodes(operator));
                object2.addAll(this.collectInvolvedEdges(operator));
                this.__recursive_qual_collect(n, this.involvedEvalNodeAttrIds.get(n), this.involvedEvalEdgeAttrIds.get(n), operator);
            }
            this.evalInvolvedNodes.put(linkedList, hashSet);
            this.evalInvolvedEdges.put(linkedList, object2);
        }
    }

    private void collectReplacementEdgeIsPreservedEdgeInfo() {
        this.replacementEdgeIsPreservedEdge = new int[this.n_graph_actions][this.max_n_replacement_edges];
        for (int i = 0; i < this.n_graph_actions; ++i) {
            for (int j = 0; j < this.max_n_replacement_edges; ++j) {
                this.replacementEdgeIsPreservedEdge[i][j] = -1;
            }
        }
        for (Rule rule : this.actionRuleMap.keySet()) {
            int n = (Integer)this.actionRuleMap.get(rule);
            if (rule.getRight() == null) continue;
            HashSet<Edge> hashSet = new HashSet<Edge>();
            hashSet.addAll(rule.getRight().getEdges());
            hashSet.retainAll(rule.getPattern().getEdges());
            for (Edge edge : hashSet) {
                int n2 = (Integer)((Map)this.replacement_edge_num.get(n)).get(edge);
                this.replacementEdgeIsPreservedEdge[n][n2] = (Integer)((Map)this.pattern_edge_num.get(n)).get(edge);
            }
        }
    }

    private void collectPatternEdgesToBeKeptInfo() {
        this.patternEdgeIsToBeKept = new int[this.n_graph_actions][this.max_n_pattern_edges];
        for (int i = 0; i < this.n_graph_actions; ++i) {
            for (int j = 0; j < this.max_n_pattern_edges; ++j) {
                this.patternEdgeIsToBeKept[i][j] = -1;
            }
        }
        for (Rule rule : this.actionRuleMap.keySet()) {
            int n = (Integer)this.actionRuleMap.get(rule);
            HashSet<Edge> hashSet = new HashSet<Edge>();
            hashSet.addAll(rule.getPattern().getEdges());
            if (rule.getRight() == null) continue;
            PatternGraphRhs patternGraphRhs = rule.getRight();
            hashSet.retainAll(patternGraphRhs.getEdges());
            for (Edge edge : hashSet) {
                int n2 = (Integer)((Map)this.pattern_edge_num.get(n)).get(edge);
                this.patternEdgeIsToBeKept[n][n2] = (Integer)((Map)this.replacement_edge_num.get(n)).get(edge);
            }
        }
    }

    private void collectNegativeInfo() {
        int n;
        this.max_n_negative_nodes = 0;
        this.max_n_negative_edges = 0;
        this.max_n_negative_patterns = 0;
        this.n_negative_patterns = new int[this.n_graph_actions];
        this.negMap = new Vector(this.n_graph_actions);
        for (Rule rule : this.actionRuleMap.keySet()) {
            n = (Integer)this.actionRuleMap.get(rule);
            int n2 = 0;
            this.negMap.set(n, new HashMap());
            for (PatternGraphLhs patternGraphLhs : rule.getPattern().getNegs()) {
                this.negMap.get(n).put(patternGraphLhs, new Integer(n2++));
                int n3 = patternGraphLhs.getNodes().size();
                if (n3 > this.max_n_negative_nodes) {
                    this.max_n_negative_nodes = n3;
                }
                if ((n3 = patternGraphLhs.getEdges().size()) <= this.max_n_negative_edges) continue;
                this.max_n_negative_edges = n3;
            }
            this.n_negative_patterns[n] = n2;
            if (n2 <= this.max_n_negative_patterns) continue;
            this.max_n_negative_patterns = n2;
        }
        this.negative_node_num = new Vector(this.n_graph_actions);
        this.negative_edge_num = new Vector(this.n_graph_actions);
        for (Rule rule : this.actionRuleMap.keySet()) {
            n = (Integer)this.actionRuleMap.get(rule);
            this.negative_node_num.set(n, new Vector(this.max_n_negative_patterns));
            for (PatternGraphLhs patternGraphLhs : this.negMap.get(n).keySet()) {
                int n4 = this.negMap.get(n).get(patternGraphLhs);
                this.negative_node_num.get(n).set(n4, new HashMap());
                this.negative_edge_num.get(n).set(n4, new HashMap());
                int n5 = 0;
                for (Node node : patternGraphLhs.getNodes()) {
                    this.negative_node_num.get(n).get(n4).put(node, new Integer(n5++));
                }
                assert (n5 == patternGraphLhs.getNodes().size()) : "Wrong number of node_nums was created";
                int n6 = 0;
                for (Edge edge : patternGraphLhs.getEdges()) {
                    this.negative_edge_num.get(n).get(n4).put(edge, new Integer(n6++));
                }
                assert (n6 == patternGraphLhs.getEdges().size()) : "Wrong number of edge_nums was created";
            }
        }
    }

    protected void collectPatternNodeIsNegativeNodeInfo() {
        int n;
        this.patternNodeIsNegativeNode = new int[this.n_graph_actions][this.max_n_negative_patterns][this.max_n_pattern_nodes];
        for (int i = 0; i < this.n_graph_actions; ++i) {
            for (int j = 0; j < this.max_n_negative_patterns; ++j) {
                for (n = 0; n < this.max_n_pattern_nodes; ++n) {
                    this.patternNodeIsNegativeNode[i][j][n] = -1;
                }
            }
        }
        for (Rule rule : this.actionRuleMap.keySet()) {
            n = (Integer)this.actionRuleMap.get(rule);
            for (PatternGraphLhs patternGraphLhs : this.negMap.get(n).keySet()) {
                int n2 = this.negMap.get(n).get(patternGraphLhs);
                HashSet<Node> hashSet = new HashSet<Node>();
                hashSet.addAll(patternGraphLhs.getNodes());
                hashSet.retainAll(rule.getPattern().getNodes());
                for (Node node : hashSet) {
                    int n3 = (Integer)((Map)this.pattern_node_num.get(n)).get(node);
                    this.patternNodeIsNegativeNode[n][n2][n3] = this.negative_node_num.get(n).get(n2).get(node);
                }
            }
        }
    }

    protected void collectPatternEdgeIsNegativeEdgeInfo() {
        int n;
        this.patternEdgeIsNegativeEdge = new int[this.n_graph_actions][this.max_n_negative_patterns][this.max_n_pattern_edges];
        for (int i = 0; i < this.n_graph_actions; ++i) {
            for (int j = 0; j < this.max_n_negative_patterns; ++j) {
                for (n = 0; n < this.max_n_pattern_edges; ++n) {
                    this.patternEdgeIsNegativeEdge[i][j][n] = -1;
                }
            }
        }
        for (Rule rule : this.actionRuleMap.keySet()) {
            n = (Integer)this.actionRuleMap.get(rule);
            for (PatternGraphLhs patternGraphLhs : this.negMap.get(n).keySet()) {
                int n2 = this.negMap.get(n).get(patternGraphLhs);
                HashSet<Edge> hashSet = new HashSet<Edge>();
                hashSet.addAll(patternGraphLhs.getEdges());
                hashSet.retainAll(rule.getPattern().getEdges());
                for (Edge edge : hashSet) {
                    int n3 = (Integer)((Map)this.pattern_edge_num.get(n)).get(edge);
                    this.patternEdgeIsNegativeEdge[n][n2][n3] = this.negative_edge_num.get(n).get(n2).get(edge);
                }
            }
        }
    }

    protected void collectNegativePatternConditionsInfo() {
        int n;
        int n2 = this.n_conditions;
        for (Rule rule : this.actionRuleMap.keySet()) {
            n = (Integer)this.actionRuleMap.get(rule);
            for (IR iR : this.negMap.get(n).keySet()) {
                int n3 = this.negMap.get(n).get(iR);
                for (Expression expression : iR.getConditions()) {
                    Collection<Expression> collection = this.decomposeAndParts(expression);
                    for (Expression expression2 : collection) {
                        assert (this.conditionNumbers.get(expression2) == null);
                        this.conditionNumbers.put(expression2, new Integer(n2++));
                        Collection<Node> collection2 = this.collectInvolvedNodes(expression2);
                        Collection<Edge> collection3 = this.collectInvolvedEdges(expression2);
                        this.conditionsInvolvedNodes.put(expression2, collection2);
                        this.conditionsInvolvedEdges.put(expression2, collection3);
                        this.conditionsPatternNum.put(expression2, new Integer(n3 + 1));
                        ((Collection)this.conditions.get(n)).add(expression2);
                    }
                }
            }
        }
        this.n_conditions = n2;
        this.involvedPatternNodeAttrIds = new HashMap();
        this.involvedPatternEdgeAttrIds = new HashMap();
        for (Rule rule : this.actionRuleMap.keySet()) {
            n = (Integer)this.actionRuleMap.get(rule);
            for (IR iR : (Collection)this.conditions.get(n)) {
                HashMap<Node, Collection<Integer>> hashMap = new HashMap<Node, Collection<Integer>>();
                HashMap hashMap2 = new HashMap();
                this.__recursive_qual_collect(n, hashMap, hashMap2, (Expression)iR);
                this.involvedPatternNodeAttrIds.put(iR, hashMap);
                this.involvedPatternEdgeAttrIds.put(iR, hashMap2);
            }
        }
    }

    protected void collectNegativePatternTypeConditionsInfo() {
        int n = this.n_conditions;
        for (Rule rule : this.actionRuleMap.keySet()) {
            int n2 = (Integer)this.actionRuleMap.get(rule);
            for (PatternGraphLhs patternGraphLhs : this.negMap.get(n2).keySet()) {
                Set set;
                HashSet<GraphEntity> hashSet;
                Collection<InheritanceType> collection;
                int n3 = this.negMap.get(n2).get(patternGraphLhs);
                for (Node node : patternGraphLhs.getNodes()) {
                    if (node.getConstraints().isEmpty()) continue;
                    collection = node.getConstraints();
                    this.typeConditionNumbers.put(collection, new Integer(n++));
                    hashSet = new HashSet<GraphEntity>();
                    hashSet.add(node);
                    this.typeConditionsInvolvedNodes.put(collection, hashSet);
                    set = Collections.emptySet();
                    this.typeConditionsInvolvedEdges.put(collection, set);
                    this.typeConditionsPatternNum.put(collection, new Integer(n3 + 1));
                    ((Collection)this.typeConditions.get(n2)).add(collection);
                }
                for (Edge edge : patternGraphLhs.getEdges()) {
                    if (edge.getConstraints().isEmpty()) continue;
                    collection = edge.getConstraints();
                    this.typeConditionNumbers.put(collection, new Integer(n++));
                    hashSet = new HashSet();
                    hashSet.add(edge);
                    set = Collections.emptySet();
                    this.typeConditionsInvolvedNodes.put(collection, set);
                    this.typeConditionsInvolvedEdges.put(collection, hashSet);
                    this.typeConditionsPatternNum.put(collection, new Integer(n3 + 1));
                    ((Collection)this.typeConditions.get(n2)).add(collection);
                }
            }
        }
        this.n_conditions = n;
    }

    /*
     * WARNING - void declaration
     */
    private void collectSubGraphInfo() {
        this.n_subgraphs = new int[this.actionRuleMap.size()];
        this.first_subgraph = new int[this.actionRuleMap.size()];
        this.nodesOfSubgraph = new Vector(this.actionRuleMap.size());
        this.edgesOfSubgraph = new Vector(this.actionRuleMap.size());
        this.subgraphOfNode = new HashMap<Node, Integer>();
        this.subgraphOfEdge = new HashMap<Edge, Integer>();
        this.max_n_subgraphs = 0;
        for (Rule rule : this.actionRuleMap.keySet()) {
            Collection<GraphEntity> collection;
            Collection<Edge> collection2;
            PatternGraphLhs patternGraphLhs = rule.getPattern();
            int n = (Integer)this.actionRuleMap.get(rule);
            int n2 = 0;
            HashSet<IR> hashSet = new HashSet<IR>();
            HashSet<IR> hashSet2 = new HashSet<IR>();
            hashSet.addAll(patternGraphLhs.getNodes());
            hashSet2.addAll(patternGraphLhs.getEdges());
            this.nodesOfSubgraph.set(n, new LinkedList());
            this.edgesOfSubgraph.set(n, new LinkedList());
            this.n_subgraphs[n] = 0;
            while (!hashSet.isEmpty()) {
                collection2 = new HashSet();
                HashSet<Edge> hashSet3 = new HashSet<Edge>();
                this.nodesOfSubgraph.get(n).addLast(collection2);
                this.edgesOfSubgraph.get(n).addLast(hashSet3);
                collection = (Node)hashSet.iterator().next();
                hashSet.remove(collection);
                this.subgraphOfNode.put((Node)((Object)collection), new Integer(n2));
                collection2.add((Edge)((Object)collection));
                this.__deep_first_collect_subgraph_info((Collection<IR>)hashSet, (Collection<IR>)hashSet2, (Collection<Node>)collection2, (Collection<Edge>)hashSet3, n2, (Node)((Object)collection), rule, patternGraphLhs);
                ++n2;
            }
            if (this.nodesOfSubgraph.get(n).size() > 1) {
                void var10_15;
                do {
                    void var11_21;
                    int edge;
                    collection = this.nodesOfSubgraph.get(n).getFirst();
                    collection2 = this.edgesOfSubgraph.get(n).getFirst();
                    assert (this.nodesOfSubgraph.get(n).size() == this.edgesOfSubgraph.get(n).size());
                    boolean n3 = false;
                    while (edge < this.nodesOfSubgraph.get(n).size()) {
                        if (this.nodesOfSubgraph.get(n).get(edge).size() < collection.size()) {
                            collection = this.nodesOfSubgraph.get(n).get(edge);
                            collection2 = this.edgesOfSubgraph.get(n).get(edge);
                        }
                        ++edge;
                    }
                    if (collection.size() >= 4) break;
                    edge = this.nodesOfSubgraph.get(n).remove(collection);
                    assert (edge != 0);
                    edge = this.edgesOfSubgraph.get(n).remove(collection2) ? 1 : 0;
                    assert (edge != 0);
                    Collection<Node> collection3 = this.nodesOfSubgraph.get(n).getFirst();
                    Collection<Edge> collection4 = this.edgesOfSubgraph.get(n).getFirst();
                    assert (this.nodesOfSubgraph.get(n).size() == this.edgesOfSubgraph.get(n).size());
                    for (int i = 0; i < this.nodesOfSubgraph.get(n).size(); ++i) {
                        if (this.nodesOfSubgraph.get(n).get(i).size() >= var11_21.size()) continue;
                        Collection<Node> collection5 = this.nodesOfSubgraph.get(n).get(i);
                        collection4 = this.edgesOfSubgraph.get(n).get(i);
                    }
                    var11_21.addAll(collection);
                    collection4.addAll(collection2);
                } while (this.nodesOfSubgraph.get(n).size() > 1);
                collection = this.nodesOfSubgraph.get(n).getFirst();
                collection2 = this.edgesOfSubgraph.get(n).getFirst();
                boolean node = false;
                while (var10_15 < this.nodesOfSubgraph.get(n).size()) {
                    if (this.nodesOfSubgraph.get(n).get((int)var10_15).size() < collection.size()) {
                        collection = this.nodesOfSubgraph.get(n).get((int)var10_15);
                        collection2 = this.edgesOfSubgraph.get(n).get((int)var10_15);
                    }
                    ++var10_15;
                }
                this.nodesOfSubgraph.get(n).remove(collection);
                this.edgesOfSubgraph.get(n).remove(collection2);
                this.nodesOfSubgraph.get(n).addFirst(collection);
                this.edgesOfSubgraph.get(n).addFirst(collection2);
            }
            this.n_subgraphs[n] = this.nodesOfSubgraph.get(n).size();
            if (this.max_n_subgraphs < this.n_subgraphs[n]) {
                this.max_n_subgraphs = this.n_subgraphs[n];
            }
            for (n2 = 0; n2 < this.edgesOfSubgraph.get(n).size(); ++n2) {
                collection = this.edgesOfSubgraph.get(n).get(n2);
                for (Edge edge : collection) {
                    this.subgraphOfEdge.put(edge, new Integer(n2));
                }
            }
            for (n2 = 0; n2 < this.nodesOfSubgraph.get(n).size(); ++n2) {
                collection = this.nodesOfSubgraph.get(n).get(n2);
                for (Node node : collection) {
                    this.subgraphOfNode.put(node, new Integer(n2));
                }
            }
            int n4 = 0;
            if (patternGraphLhs.getNodes().size() > 0) {
                collection2 = patternGraphLhs.getNodes().iterator().next();
                for (Node node : patternGraphLhs.getNodes()) {
                    int n3 = 0;
                    Annotations annotations = node.getAnnotations();
                    if (annotations != null && annotations.containsKey("prio") && annotations.isInteger("prio")) {
                        n3 = (Integer)annotations.get("prio");
                    }
                    if (n3 <= n4) continue;
                    n4 = n3;
                    collection2 = node;
                }
                this.first_subgraph[n] = this.subgraphOfNode.get(collection2);
                continue;
            }
            this.first_subgraph[n] = 0;
        }
    }

    private void __deep_first_collect_subgraph_info(Collection<IR> collection, Collection<IR> collection2, Collection<Node> collection3, Collection<Edge> collection4, int n, Node node, MatchingAction matchingAction, PatternGraphLhs patternGraphLhs) {
        HashSet<Edge> hashSet = new HashSet<Edge>();
        patternGraphLhs.getOutgoing(node, hashSet);
        patternGraphLhs.getIncoming(node, hashSet);
        for (Edge edge : hashSet) {
            if (!collection2.contains(edge)) continue;
            collection4.add(edge);
            collection2.remove(edge);
            if (!collection.contains(MoreInformationCollector.getFarEndNode(edge, node, patternGraphLhs))) continue;
            collection3.add(MoreInformationCollector.getFarEndNode(edge, node, patternGraphLhs));
            collection.remove(MoreInformationCollector.getFarEndNode(edge, node, patternGraphLhs));
            this.__deep_first_collect_subgraph_info(collection, collection2, collection3, collection4, n, MoreInformationCollector.getFarEndNode(edge, node, patternGraphLhs), matchingAction, patternGraphLhs);
        }
    }

    private static Node getFarEndNode(Edge edge, Node node, PatternGraphBase patternGraphBase) {
        Node node2 = null;
        if (patternGraphBase.getTarget(edge) == node) {
            node2 = patternGraphBase.getSource(edge);
        }
        if (patternGraphBase.getSource(edge) == node) {
            node2 = patternGraphBase.getTarget(edge);
        }
        return node2;
    }

    @Override
    protected void collectActionInfo() {
        super.collectActionInfo();
        this.collectPatternEdgesToBeKeptInfo();
        this.collectReplacementEdgeIsPreservedEdgeInfo();
        this.collectNegativeInfo();
        this.collectPatternNodeIsNegativeNodeInfo();
        this.collectPatternEdgeIsNegativeEdgeInfo();
        this.collectNegativePatternConditionsInfo();
        this.collectNegativePatternTypeConditionsInfo();
        this.collectSubGraphInfo();
    }
}

