/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.be.Csharp;

import de.unika.ipd.grgen.be.Csharp.CSharpBase;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.ir.pattern.Alternative;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.PatternGraphBase;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.SubpatternUsage;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.type.container.ContainerType;
import de.unika.ipd.grgen.util.SourceBuilder;
import java.util.HashSet;

public class ActionsMatchGen
extends CSharpBase {
    final int MATCH_PART_NODES = 0;
    final int MATCH_PART_EDGES = 1;
    final int MATCH_PART_VARIABLES = 2;
    final int MATCH_PART_EMBEDDED_GRAPHS = 3;
    final int MATCH_PART_ALTERNATIVES = 4;
    final int MATCH_PART_ITERATEDS = 5;
    final int MATCH_PART_INDEPENDENTS = 6;
    final int MATCH_PART_END = 7;

    public ActionsMatchGen(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    public void genPatternMatchInterface(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, HashSet<String> hashSet) {
        Object object;
        this.genMatchInterface(sourceBuilder, patternGraphLhs, string, string2, string3, bl, bl2, bl3, hashSet);
        for (PatternGraphLhs iR : patternGraphLhs.getNegs()) {
            object = iR.getNameOfGraph();
            this.genPatternMatchInterface(sourceBuilder, iR, string3 + (String)object, "GRGEN_LIBGR.IMatch", string3 + (String)object + "_", false, false, false, hashSet);
        }
        for (PatternGraphLhs patternGraphLhs2 : patternGraphLhs.getIdpts()) {
            object = patternGraphLhs2.getNameOfGraph();
            this.genPatternMatchInterface(sourceBuilder, patternGraphLhs2, string3 + (String)object, "GRGEN_LIBGR.IMatch", string3 + (String)object + "_", false, false, false, hashSet);
        }
        for (Alternative alternative : patternGraphLhs.getAlts()) {
            object = alternative.getNameOfGraph();
            ActionsMatchGen.genAlternativeMatchInterface(sourceBuilder, string3 + (String)object);
            for (Rule rule : alternative.getAlternativeCases()) {
                PatternGraphLhs patternGraphLhs3 = rule.getLeft();
                String string4 = string3 + (String)object + "_" + patternGraphLhs3.getNameOfGraph();
                this.genPatternMatchInterface(sourceBuilder, patternGraphLhs3, string4, "IMatch_" + string3 + (String)object, string3 + (String)object + "_" + patternGraphLhs3.getNameOfGraph() + "_", false, true, false, hashSet);
            }
        }
        for (Rule rule : patternGraphLhs.getIters()) {
            object = rule.getLeft();
            String string5 = ((PatternGraphBase)object).getNameOfGraph();
            this.genPatternMatchInterface(sourceBuilder, (PatternGraphLhs)object, string3 + (String)string5, "GRGEN_LIBGR.IMatch", string3 + (String)string5 + "_", true, false, false, hashSet);
        }
    }

    public void genPatternMatchImplementation(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        this.genMatchImplementation(sourceBuilder, patternGraphLhs, string, string2, string3, string4, bl, bl2, bl3);
        for (PatternGraphLhs iR : patternGraphLhs.getNegs()) {
            object = iR.getNameOfGraph();
            this.genPatternMatchImplementation(sourceBuilder, iR, string4 + (String)object, string4 + (String)object, string3, string4 + (String)object + "_", false, false, false, false);
        }
        for (PatternGraphLhs patternGraphLhs2 : patternGraphLhs.getIdpts()) {
            object = patternGraphLhs2.getNameOfGraph();
            this.genPatternMatchImplementation(sourceBuilder, patternGraphLhs2, string4 + (String)object, string4 + (String)object, string3, string4 + (String)object + "_", false, true, false, false);
        }
        for (Alternative alternative : patternGraphLhs.getAlts()) {
            object = alternative.getNameOfGraph();
            for (Rule rule : alternative.getAlternativeCases()) {
                PatternGraphLhs patternGraphLhs3 = rule.getLeft();
                String string5 = string4 + (String)object + "_" + patternGraphLhs3.getNameOfGraph();
                this.genPatternMatchImplementation(sourceBuilder, patternGraphLhs3, string5, string5, string3, string4 + (String)object + "_" + patternGraphLhs3.getNameOfGraph() + "_", false, false, false, false);
            }
        }
        for (Rule rule : patternGraphLhs.getIters()) {
            object = rule.getLeft();
            String string6 = ((PatternGraphBase)object).getNameOfGraph();
            this.genPatternMatchImplementation(sourceBuilder, (PatternGraphLhs)object, string4 + (String)string6, string4 + (String)string6, string3, string4 + (String)string6 + "_", true, false, false, false);
        }
    }

    private void genMatchInterface(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, HashSet<String> hashSet) {
        String string4 = "IMatch_" + string;
        sourceBuilder.appendFront("public interface " + string4 + " : " + string2 + "\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.indent();
        for (int i = 0; i < 7; ++i) {
            this.genMatchedEntitiesInterface(sourceBuilder, patternGraphLhs, hashSet, string, i, string3);
        }
        sourceBuilder.appendFront("// further match object stuff\n");
        if (bl) {
            sourceBuilder.appendFront("bool IsNullMatch { get; }\n");
        }
        if (bl2) {
            sourceBuilder.appendFront("new void SetMatchOfEnclosingPattern(GRGEN_LIBGR.IMatch matchOfEnclosingPattern);\n");
        } else if (!bl3) {
            sourceBuilder.appendFront("void SetMatchOfEnclosingPattern(GRGEN_LIBGR.IMatch matchOfEnclosingPattern);\n");
        }
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        sourceBuilder.append("\n");
    }

    private static void genAlternativeMatchInterface(SourceBuilder sourceBuilder, String string) {
        String string2 = "IMatch_" + string;
        sourceBuilder.appendFront("public interface " + string2 + " : GRGEN_LIBGR.IMatch\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.appendFrontIndented("void SetMatchOfEnclosingPattern(GRGEN_LIBGR.IMatch matchOfEnclosingPattern);\n");
        sourceBuilder.appendFront("}\n");
        sourceBuilder.append("\n");
    }

    public void genMatchClassImplementation(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, String string, String string2) {
        String string3 = "IMatch_" + string;
        String string4 = "Match_" + string;
        sourceBuilder.appendFront("public class " + string4 + " : GRGEN_LGSP.MatchListElement<" + string4 + ">, " + string3 + "\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.indent();
        for (int i = 0; i < 7; ++i) {
            this.genMatchedEntitiesImplementation(sourceBuilder, patternGraphLhs, string, i, string2);
            this.genMatchEnum(sourceBuilder, patternGraphLhs, string, i, string2);
            this.genIMatchImplementation(sourceBuilder, patternGraphLhs, string, i, string2);
            sourceBuilder.append("\n");
        }
        sourceBuilder.appendFront("public override GRGEN_LIBGR.IPatternGraph Pattern { get { return null; } }\n");
        sourceBuilder.appendFront("public override GRGEN_LIBGR.IMatchClass MatchClass { get { return MatchClassInfo_" + string + ".Instance; } }\n");
        sourceBuilder.appendFront("public override GRGEN_LIBGR.IMatch Clone() { return new " + string4 + "(this); }\n");
        sourceBuilder.appendFront("public override GRGEN_LIBGR.IMatch Clone(IDictionary<GRGEN_LIBGR.IGraphElement, GRGEN_LIBGR.IGraphElement> oldToNewMap) { return new " + string4 + "(this, oldToNewMap); }\n");
        sourceBuilder.appendFront("public void SetMatchOfEnclosingPattern(GRGEN_LIBGR.IMatch matchOfEnclosingPattern) { _matchOfEnclosingPattern = matchOfEnclosingPattern; }\n");
        this.genCopyConstructorAndContentAssignment(sourceBuilder, patternGraphLhs, false, string, string2, string4);
        this.genCopyConstructorAndContentAssignment(sourceBuilder, patternGraphLhs, true, string, string2, string4);
        sourceBuilder.appendFront("public " + string4 + "()\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.appendFront("}\n");
        sourceBuilder.append("\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        sourceBuilder.append("\n");
    }

    private void genMatchImplementation(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3) {
        String string5 = "IMatch_" + string;
        String string6 = "Match_" + string;
        sourceBuilder.appendFront("public class " + string6 + " : GRGEN_LGSP.MatchListElement<" + string6 + ">, " + string5 + "\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.indent();
        for (int i = 0; i < 7; ++i) {
            this.genMatchedEntitiesImplementation(sourceBuilder, patternGraphLhs, string, i, string4);
            this.genMatchEnum(sourceBuilder, patternGraphLhs, string, i, string4);
            this.genIMatchImplementation(sourceBuilder, patternGraphLhs, string, i, string4);
            sourceBuilder.append("\n");
        }
        sourceBuilder.appendFront("public override GRGEN_LIBGR.IPatternGraph Pattern { get { return " + string3 + ".instance." + string2 + "; } }\n");
        sourceBuilder.appendFront("public override GRGEN_LIBGR.IMatchClass MatchClass { get { return null; } }\n");
        if (bl) {
            sourceBuilder.appendFront("public bool IsNullMatch { get { return _isNullMatch; } }\n");
            sourceBuilder.appendFront("public bool _isNullMatch;\n");
        }
        sourceBuilder.appendFront("public override GRGEN_LIBGR.IMatch Clone() { return new " + string6 + "(this); }\n");
        sourceBuilder.appendFront("public override GRGEN_LIBGR.IMatch Clone(IDictionary<GRGEN_LIBGR.IGraphElement, GRGEN_LIBGR.IGraphElement> oldToNewMap) { return new " + string6 + "(this, oldToNewMap); }\n");
        sourceBuilder.appendFront("public void SetMatchOfEnclosingPattern(GRGEN_LIBGR.IMatch matchOfEnclosingPattern) { _matchOfEnclosingPattern = matchOfEnclosingPattern; }\n");
        sourceBuilder.appendFront("public " + string6 + " nextWithSameHash;\n");
        ActionsMatchGen.genCleanNextWithSameHash(sourceBuilder, string6);
        if (bl3) {
            sourceBuilder.appendFront("public int duplicateMatchHash;\n");
        }
        this.genCopyConstructorAndContentAssignment(sourceBuilder, patternGraphLhs, false, string, string4, string6);
        this.genCopyConstructorAndContentAssignment(sourceBuilder, patternGraphLhs, true, string, string4, string6);
        sourceBuilder.appendFront("public " + string6 + "()\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.appendFront("}\n");
        sourceBuilder.append("\n");
        this.genIsEqualMethod(sourceBuilder, patternGraphLhs, string, string4, string6);
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        sourceBuilder.append("\n");
    }

    private static void genCleanNextWithSameHash(SourceBuilder sourceBuilder, String string) {
        sourceBuilder.appendFront("public void CleanNextWithSameHash() {\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront(string + " cur = this;\n");
        sourceBuilder.appendFront("while(cur != null) {\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront(string + " next = cur.nextWithSameHash;\n");
        sourceBuilder.appendFront("cur.nextWithSameHash = null;\n");
        sourceBuilder.appendFront("cur = next;\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        sourceBuilder.append("\n");
    }

    private void genCopyConstructorAndContentAssignment(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, boolean bl, String string, String string2, String string3) {
        String string4 = bl ? ", IDictionary<GRGEN_LIBGR.IGraphElement, GRGEN_LIBGR.IGraphElement> oldToNewMap" : "";
        String string5 = bl ? ", oldToNewMap" : "";
        sourceBuilder.appendFront("public void AssignContent(" + string3 + " that" + string4 + ")\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.indent();
        for (int i = 0; i < 7; ++i) {
            this.genCopyMatchedEntities(sourceBuilder, patternGraphLhs, bl, string, i, string2);
        }
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        sourceBuilder.append("\n");
        sourceBuilder.appendFront("public " + string3 + "(" + string3 + " that" + string4 + ")\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.appendFrontIndented("AssignContent(that" + string5 + ");\n");
        sourceBuilder.appendFront("}\n");
    }

    private void genIsEqualMethod(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, String string, String string2, String string3) {
        sourceBuilder.appendFront("public bool IsEqual(" + string3 + " that)\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("if(that==null) return false;\n");
        for (int i = 0; i < 7; ++i) {
            this.genEqualMatch(sourceBuilder, patternGraphLhs, string, i, string2);
        }
        sourceBuilder.appendFront("return true;\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
    }

    private void genMatchedEntitiesInterface(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, HashSet<String> hashSet, String string, int n, String string2) {
        sourceBuilder.appendFront("//" + this.matchedEntitiesNamePlural(n) + "\n");
        switch (n) {
            case 0: {
                for (Node node : patternGraphLhs.getNodes()) {
                    String string3 = hashSet.contains(ActionsMatchGen.formatEntity(node)) ? "new " : "";
                    sourceBuilder.appendFront(string3 + this.formatElementInterfaceRef(node.getType()) + " " + ActionsMatchGen.formatEntity(node) + " { get; set; }\n");
                }
                break;
            }
            case 1: {
                for (Edge edge : patternGraphLhs.getEdges()) {
                    String string4 = hashSet.contains(ActionsMatchGen.formatEntity(edge)) ? "new " : "";
                    sourceBuilder.appendFront(string4 + this.formatElementInterfaceRef(edge.getType()) + " " + ActionsMatchGen.formatEntity(edge) + " { get; set; }\n");
                }
                break;
            }
            case 2: {
                for (Variable variable : patternGraphLhs.getVars()) {
                    String string5 = hashSet.contains(ActionsMatchGen.formatEntity(variable)) ? "new " : "";
                    sourceBuilder.appendFront(string5 + this.formatAttributeType(variable.getType()) + " @" + ActionsMatchGen.formatEntity(variable) + " { get; set; }\n");
                }
                break;
            }
            case 3: {
                for (SubpatternUsage subpatternUsage : patternGraphLhs.getSubpatternUsages()) {
                    sourceBuilder.appendFront("@" + ActionsMatchGen.matchType(subpatternUsage.getSubpatternAction().getPattern(), subpatternUsage.getSubpatternAction(), true, "") + " @" + ActionsMatchGen.formatIdentifiable(subpatternUsage) + " { get; }\n");
                }
                break;
            }
            case 4: {
                for (Alternative alternative : patternGraphLhs.getAlts()) {
                    String string6 = alternative.getNameOfGraph();
                    sourceBuilder.appendFront("IMatch_" + string2 + string6 + " " + string6 + " { get; }\n");
                }
                break;
            }
            case 5: {
                for (Rule rule : patternGraphLhs.getIters()) {
                    String string7 = rule.getLeft().getNameOfGraph();
                    sourceBuilder.appendFront("GRGEN_LIBGR.IMatchesExact<IMatch_" + string2 + string7 + "> " + string7 + " { get; }\n");
                }
                break;
            }
            case 6: {
                for (PatternGraphLhs patternGraphLhs2 : patternGraphLhs.getIdpts()) {
                    String string8 = patternGraphLhs2.getNameOfGraph();
                    sourceBuilder.appendFront("IMatch_" + string2 + string8 + " " + string8 + " { get; }\n");
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void genMatchedEntitiesImplementation(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, String string, int n, String string2) {
        switch (n) {
            case 0: {
                for (Node node : patternGraphLhs.getNodes()) {
                    sourceBuilder.appendFront("public " + this.formatElementInterfaceRef(node.getType()) + " " + ActionsMatchGen.formatEntity(node) + " { get { return (" + this.formatElementInterfaceRef(node.getType()) + ")" + ActionsMatchGen.formatEntity(node, "_") + "; } set { " + ActionsMatchGen.formatEntity(node, "_") + " = (GRGEN_LGSP.LGSPNode)value; } }\n");
                }
                for (Node node : patternGraphLhs.getNodes()) {
                    sourceBuilder.appendFront("public GRGEN_LGSP.LGSPNode " + ActionsMatchGen.formatEntity(node, "_") + ";\n");
                }
                break;
            }
            case 1: {
                for (Edge edge : patternGraphLhs.getEdges()) {
                    sourceBuilder.appendFront("public " + this.formatElementInterfaceRef(edge.getType()) + " " + ActionsMatchGen.formatEntity(edge) + " { get { return (" + this.formatElementInterfaceRef(edge.getType()) + ")" + ActionsMatchGen.formatEntity(edge, "_") + "; } set { " + ActionsMatchGen.formatEntity(edge, "_") + " = (GRGEN_LGSP.LGSPEdge)value; } }\n");
                }
                for (Edge edge : patternGraphLhs.getEdges()) {
                    sourceBuilder.appendFront("public GRGEN_LGSP.LGSPEdge " + ActionsMatchGen.formatEntity(edge, "_") + ";\n");
                }
                break;
            }
            case 2: {
                for (Variable variable : patternGraphLhs.getVars()) {
                    sourceBuilder.appendFront("public " + this.formatAttributeType(variable.getType()) + " " + ActionsMatchGen.formatEntity(variable) + " { get { return " + ActionsMatchGen.formatEntity(variable, "_") + "; } set { " + ActionsMatchGen.formatEntity(variable, "_") + " = value; } }\n");
                }
                for (Variable variable : patternGraphLhs.getVars()) {
                    sourceBuilder.appendFront("public " + this.formatAttributeType(variable.getType()) + " " + ActionsMatchGen.formatEntity(variable, "_") + ";\n");
                }
                break;
            }
            case 3: {
                for (SubpatternUsage subpatternUsage : patternGraphLhs.getSubpatternUsages()) {
                    sourceBuilder.appendFront("public @" + ActionsMatchGen.matchType(subpatternUsage.getSubpatternAction().getPattern(), subpatternUsage.getSubpatternAction(), true, "") + " @" + ActionsMatchGen.formatIdentifiable(subpatternUsage) + " { get { return @" + ActionsMatchGen.formatIdentifiable(subpatternUsage, "_") + "; } }\n");
                }
                for (SubpatternUsage subpatternUsage : patternGraphLhs.getSubpatternUsages()) {
                    sourceBuilder.appendFront("public @" + ActionsMatchGen.matchType(subpatternUsage.getSubpatternAction().getPattern(), subpatternUsage.getSubpatternAction(), true, "") + " @" + ActionsMatchGen.formatIdentifiable(subpatternUsage, "_") + ";\n");
                }
                break;
            }
            case 4: {
                String string3;
                for (Alternative alternative : patternGraphLhs.getAlts()) {
                    string3 = alternative.getNameOfGraph();
                    sourceBuilder.appendFront("public IMatch_" + string2 + string3 + " " + string3 + " { get { return _" + string3 + "; } }\n");
                }
                for (Alternative alternative : patternGraphLhs.getAlts()) {
                    string3 = alternative.getNameOfGraph();
                    sourceBuilder.appendFront("public IMatch_" + string2 + string3 + " _" + string3 + ";\n");
                }
                break;
            }
            case 5: {
                String string4;
                for (Rule rule : patternGraphLhs.getIters()) {
                    string4 = rule.getLeft().getNameOfGraph();
                    sourceBuilder.appendFront("public GRGEN_LIBGR.IMatchesExact<IMatch_" + string2 + string4 + "> " + string4 + " { get { return _" + string4 + "; } }\n");
                }
                for (Rule rule : patternGraphLhs.getIters()) {
                    string4 = rule.getLeft().getNameOfGraph();
                    sourceBuilder.appendFront("public GRGEN_LGSP.LGSPMatchesList<Match_" + string2 + string4 + ", IMatch_" + string2 + string4 + "> _" + string4 + ";\n");
                }
                break;
            }
            case 6: {
                String string5;
                for (PatternGraphLhs patternGraphLhs2 : patternGraphLhs.getIdpts()) {
                    string5 = patternGraphLhs2.getNameOfGraph();
                    sourceBuilder.appendFront("public IMatch_" + string2 + string5 + " " + string5 + " { get { return _" + string5 + "; } }\n");
                }
                for (PatternGraphLhs patternGraphLhs2 : patternGraphLhs.getIdpts()) {
                    string5 = patternGraphLhs2.getNameOfGraph();
                    sourceBuilder.appendFront("public IMatch_" + string2 + string5 + " _" + string5 + ";\n");
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void genCopyMatchedEntities(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, boolean bl, String string, int n, String string2) {
        switch (n) {
            case 0: {
                for (Node node : patternGraphLhs.getNodes()) {
                    String string3 = ActionsMatchGen.formatEntity(node, "_");
                    if (bl) {
                        sourceBuilder.appendFront(string3 + " = (GRGEN_LGSP.LGSPNode)oldToNewMap[that." + string3 + "];\n");
                        continue;
                    }
                    sourceBuilder.appendFront(string3 + " = that." + string3 + ";\n");
                }
                break;
            }
            case 1: {
                for (Edge edge : patternGraphLhs.getEdges()) {
                    String string4 = ActionsMatchGen.formatEntity(edge, "_");
                    if (bl) {
                        sourceBuilder.appendFront(string4 + " = (GRGEN_LGSP.LGSPEdge)oldToNewMap[that." + string4 + "];\n");
                        continue;
                    }
                    sourceBuilder.appendFront(string4 + " = that." + string4 + ";\n");
                }
                break;
            }
            case 2: {
                for (Variable variable : patternGraphLhs.getVars()) {
                    String string5 = ActionsMatchGen.formatEntity(variable, "_");
                    if (bl) {
                        if (variable.getType() instanceof ContainerType) {
                            sourceBuilder.appendFront(string5 + " = (" + this.formatType(variable.getType()) + ")GRGEN_LIBGR.ContainerHelper.MappingClone(that." + string5 + ", oldToNewMap);\n");
                            continue;
                        }
                        if (variable.getType() instanceof NodeType || variable.getType() instanceof EdgeType) {
                            sourceBuilder.appendFront(string5 + " = (" + this.formatType(variable.getType()) + ")oldToNewMap[that." + string5 + "];\n");
                            continue;
                        }
                        sourceBuilder.appendFront(string5 + " = that." + string5 + ";\n");
                        continue;
                    }
                    sourceBuilder.appendFront(string5 + " = that." + string5 + ";\n");
                }
                break;
            }
            case 3: {
                for (SubpatternUsage subpatternUsage : patternGraphLhs.getSubpatternUsages()) {
                    String string6 = "@" + ActionsMatchGen.formatIdentifiable(subpatternUsage, "_");
                    String string7 = ActionsMatchGen.matchType(subpatternUsage.getSubpatternAction().getPattern(), subpatternUsage.getSubpatternAction(), true, "");
                    if (bl) {
                        sourceBuilder.appendFront(string6 + " = new " + string7 + "(that." + string6 + ", oldToNewMap);\n");
                        continue;
                    }
                    sourceBuilder.appendFront(string6 + " = that." + string6 + ";\n");
                }
                break;
            }
            case 4: {
                for (Alternative alternative : patternGraphLhs.getAlts()) {
                    String string8 = "_" + alternative.getNameOfGraph();
                    if (bl) {
                        boolean bl2 = true;
                        for (Rule rule : alternative.getAlternativeCases()) {
                            String string9 = "Match_" + string2 + alternative.getNameOfGraph() + "_" + rule.getPattern().getNameOfGraph();
                            if (bl2) {
                                bl2 = false;
                                sourceBuilder.appendFront("if(that." + string8 + " is " + string9 + ")\n");
                            } else {
                                sourceBuilder.appendFront("else if(that." + string8 + " is " + string9 + ")\n");
                            }
                            sourceBuilder.appendFrontIndented(string8 + " = new " + string9 + "((" + string9 + ")that." + string8 + ", oldToNewMap);\n");
                        }
                        continue;
                    }
                    sourceBuilder.appendFront(string8 + " = that." + string8 + ";\n");
                }
                break;
            }
            case 5: {
                for (Rule rule : patternGraphLhs.getIters()) {
                    String string10 = "_" + rule.getLeft().getNameOfGraph();
                    String string11 = "Match_" + string2 + rule.getLeft().getNameOfGraph();
                    String string12 = "GRGEN_LGSP.LGSPMatchesList<" + string11 + ", I" + string11 + ">";
                    if (bl) {
                        sourceBuilder.appendFront(string10 + " = new " + string12 + "(that." + string10 + ", oldToNewMap);\n");
                        continue;
                    }
                    sourceBuilder.appendFront(string10 + " = that." + string10 + ";\n");
                }
                break;
            }
            case 6: {
                for (PatternGraphLhs patternGraphLhs2 : patternGraphLhs.getIdpts()) {
                    String string13 = "_" + patternGraphLhs2.getNameOfGraph();
                    String string14 = "Match_" + string2 + patternGraphLhs2.getNameOfGraph();
                    if (bl) {
                        sourceBuilder.appendFront(string13 + " = new " + string14 + "((" + string14 + ")that." + string13 + ", oldToNewMap);\n");
                        continue;
                    }
                    sourceBuilder.appendFront(string13 + " = that." + string13 + ";\n");
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void genEqualMatch(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, String string, int n, String string2) {
        switch (n) {
            case 0: {
                for (Node node : patternGraphLhs.getNodes()) {
                    if (node.isDefToBeYieldedTo()) continue;
                    String string3 = ActionsMatchGen.formatEntity(node, "_");
                    sourceBuilder.appendFront("if(" + string3 + " != that." + string3 + ") return false;\n");
                }
                break;
            }
            case 1: {
                for (Edge edge : patternGraphLhs.getEdges()) {
                    if (edge.isDefToBeYieldedTo()) continue;
                    String string4 = ActionsMatchGen.formatEntity(edge, "_");
                    sourceBuilder.appendFront("if(" + string4 + " != that." + string4 + ") return false;\n");
                }
                break;
            }
            case 2: {
                for (Variable variable : patternGraphLhs.getVars()) {
                    if (variable.isDefToBeYieldedTo()) continue;
                    String string5 = ActionsMatchGen.formatEntity(variable, "_");
                    sourceBuilder.appendFront("if(" + string5 + " != that." + string5 + ") return false;\n");
                }
                break;
            }
            case 3: {
                for (SubpatternUsage subpatternUsage : patternGraphLhs.getSubpatternUsages()) {
                    String string6 = "@" + ActionsMatchGen.formatIdentifiable(subpatternUsage, "_");
                    sourceBuilder.appendFront("if(!" + string6 + ".IsEqual(that." + string6 + ")) return false;\n");
                }
                break;
            }
            case 4: {
                for (Alternative alternative : patternGraphLhs.getAlts()) {
                    String string7 = "_" + alternative.getNameOfGraph();
                    for (Rule rule : alternative.getAlternativeCases()) {
                        PatternGraphLhs patternGraphLhs2 = rule.getLeft();
                        sourceBuilder.appendFront("if(" + string7 + " is Match_" + string + string7 + "_" + patternGraphLhs2.getNameOfGraph() + " && !(" + string7 + " as Match_" + string + string7 + "_" + patternGraphLhs2.getNameOfGraph() + ").IsEqual(that." + string7 + " as Match_" + string + string7 + "_" + patternGraphLhs2.getNameOfGraph() + ")) return false;\n");
                    }
                }
                break;
            }
            case 5: {
                for (Rule rule : patternGraphLhs.getIters()) {
                    String string8 = "_" + rule.getLeft().getNameOfGraph();
                    sourceBuilder.appendFront("if(" + string8 + ".Count != that." + string8 + ".Count) return false;\n");
                    sourceBuilder.appendFront("IEnumerator<GRGEN_LIBGR.IMatch> " + string8 + "_thisEnumerator = " + string8 + ".GetEnumerator();\n");
                    sourceBuilder.appendFront("IEnumerator<GRGEN_LIBGR.IMatch> " + string8 + "_thatEnumerator = that." + string8 + ".GetEnumerator();\n");
                    sourceBuilder.appendFront("while(" + string8 + "_thisEnumerator.MoveNext())\n");
                    sourceBuilder.appendFront("{\n");
                    sourceBuilder.indent();
                    sourceBuilder.appendFront(string8 + "_thatEnumerator.MoveNext();\n");
                    sourceBuilder.appendFront("if(!(" + string8 + "_thisEnumerator.Current as Match_" + string + string8 + ").IsEqual(" + string8 + "_thatEnumerator.Current as Match_" + string + string8 + ")) return false;\n");
                    sourceBuilder.unindent();
                    sourceBuilder.appendFront("}\n");
                }
                break;
            }
            case 6: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void genIMatchImplementation(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, String string, int n, String string2) {
        String string3 = "GRGEN_LGSP." + this.matchedEntitiesNamePlural(n) + "_Enumerable";
        String string4 = "GRGEN_LGSP." + this.matchedEntitiesNamePlural(n) + "_Enumerator";
        String string5 = this.typeOfMatchedEntities(n);
        int n2 = this.numOfMatchedEntities(n, patternGraphLhs);
        String string6 = this.matchedEntitiesNameSingular(n);
        String string7 = this.matchedEntitiesNamePlural(n);
        sourceBuilder.appendFront("public override IEnumerable<" + string5 + "> " + string7 + " { get { return new " + string3 + "(this); } }\n");
        sourceBuilder.appendFront("public override IEnumerator<" + string5 + "> " + string7 + "Enumerator { get { return new " + string4 + "(this); } }\n");
        sourceBuilder.appendFront("public override int NumberOf" + string7 + " { get { return " + n2 + "; } }\n");
        sourceBuilder.appendFront("public override " + string5 + " get" + string6 + "At(int index)\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("switch(index) {\n");
        switch (n) {
            case 0: {
                for (Node iterator : patternGraphLhs.getNodes()) {
                    sourceBuilder.appendFront("case (int)" + this.entitiesEnumName(n, string2) + ".@" + ActionsMatchGen.formatIdentifiable(iterator) + ": return " + ActionsMatchGen.formatEntity(iterator, "_") + ";\n");
                }
                break;
            }
            case 1: {
                for (Edge edge : patternGraphLhs.getEdges()) {
                    sourceBuilder.appendFront("case (int)" + this.entitiesEnumName(n, string2) + ".@" + ActionsMatchGen.formatIdentifiable(edge) + ": return " + ActionsMatchGen.formatEntity(edge, "_") + ";\n");
                }
                break;
            }
            case 2: {
                for (Variable variable : patternGraphLhs.getVars()) {
                    sourceBuilder.appendFront("case (int)" + this.entitiesEnumName(n, string2) + ".@" + ActionsMatchGen.formatIdentifiable(variable) + ": return " + ActionsMatchGen.formatEntity(variable, "_") + ";\n");
                }
                break;
            }
            case 3: {
                for (SubpatternUsage subpatternUsage : patternGraphLhs.getSubpatternUsages()) {
                    sourceBuilder.appendFront("case (int)" + this.entitiesEnumName(n, string2) + ".@" + ActionsMatchGen.formatIdentifiable(subpatternUsage) + ": return " + ActionsMatchGen.formatIdentifiable(subpatternUsage, "_") + ";\n");
                }
                break;
            }
            case 4: {
                for (Alternative alternative : patternGraphLhs.getAlts()) {
                    String string8 = alternative.getNameOfGraph();
                    sourceBuilder.appendFront("case (int)" + this.entitiesEnumName(n, string2) + ".@" + string8 + ": return _" + string8 + ";\n");
                }
                break;
            }
            case 5: {
                for (Rule rule : patternGraphLhs.getIters()) {
                    String string9 = rule.getLeft().getNameOfGraph();
                    sourceBuilder.appendFront("case (int)" + this.entitiesEnumName(n, string2) + ".@" + string9 + ": return _" + string9 + ";\n");
                }
                break;
            }
            case 6: {
                for (PatternGraphLhs patternGraphLhs2 : patternGraphLhs.getIdpts()) {
                    String string10 = patternGraphLhs2.getNameOfGraph();
                    sourceBuilder.appendFront("case (int)" + this.entitiesEnumName(n, string2) + ".@" + string10 + ": return _" + string10 + ";\n");
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        sourceBuilder.appendFront("default: return null;\n");
        sourceBuilder.appendFront("}\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        sourceBuilder.appendFront("public override " + string5 + " get" + string6 + "(string name)\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("switch(name) {\n");
        switch (n) {
            case 0: {
                for (Node node : patternGraphLhs.getNodes()) {
                    sourceBuilder.appendFront("case \"" + ActionsMatchGen.formatIdentifiable(node) + "\": return " + ActionsMatchGen.formatEntity(node, "_") + ";\n");
                }
                break;
            }
            case 1: {
                for (Edge edge : patternGraphLhs.getEdges()) {
                    sourceBuilder.appendFront("case \"" + ActionsMatchGen.formatIdentifiable(edge) + "\": return " + ActionsMatchGen.formatEntity(edge, "_") + ";\n");
                }
                break;
            }
            case 2: {
                for (Variable variable : patternGraphLhs.getVars()) {
                    sourceBuilder.appendFront("case \"" + ActionsMatchGen.formatIdentifiable(variable) + "\": return " + ActionsMatchGen.formatEntity(variable, "_") + ";\n");
                }
                break;
            }
            case 3: {
                for (SubpatternUsage subpatternUsage : patternGraphLhs.getSubpatternUsages()) {
                    sourceBuilder.appendFront("case \"" + ActionsMatchGen.formatIdentifiable(subpatternUsage) + "\": return " + ActionsMatchGen.formatIdentifiable(subpatternUsage, "_") + ";\n");
                }
                break;
            }
            case 4: {
                for (Alternative alternative : patternGraphLhs.getAlts()) {
                    String string11 = alternative.getNameOfGraph();
                    sourceBuilder.appendFront("case \"" + string11 + "\": return _" + string11 + ";\n");
                }
                break;
            }
            case 5: {
                for (Rule rule : patternGraphLhs.getIters()) {
                    String string12 = rule.getLeft().getNameOfGraph();
                    sourceBuilder.appendFront("case \"" + string12 + "\": return _" + string12 + ";\n");
                }
                break;
            }
            case 6: {
                for (PatternGraphLhs patternGraphLhs3 : patternGraphLhs.getIdpts()) {
                    String string13 = patternGraphLhs3.getNameOfGraph();
                    sourceBuilder.appendFront("case \"" + string13 + "\": return _" + string13 + ";\n");
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        sourceBuilder.appendFront("default: return null;\n");
        sourceBuilder.appendFront("}\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        if (n != 0 && n != 1 && n != 2) {
            return;
        }
        String string8 = n == 0 ? "GRGEN_LIBGR.INode" : (n == 1 ? "GRGEN_LIBGR.IEdge" : "object");
        sourceBuilder.appendFront("public override void Set" + string6 + "(string name, " + (String)string8 + " value)\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("switch(name) {\n");
        switch (n) {
            case 0: {
                for (Node node : patternGraphLhs.getNodes()) {
                    sourceBuilder.appendFront("case \"" + ActionsMatchGen.formatIdentifiable(node) + "\": " + ActionsMatchGen.formatEntity(node, "_") + " = (GRGEN_LGSP.LGSPNode)value; break;\n");
                }
                break;
            }
            case 1: {
                for (Edge edge : patternGraphLhs.getEdges()) {
                    sourceBuilder.appendFront("case \"" + ActionsMatchGen.formatIdentifiable(edge) + "\": " + ActionsMatchGen.formatEntity(edge, "_") + " = (GRGEN_LGSP.LGSPEdge)value; break;\n");
                }
                break;
            }
            case 2: {
                for (Variable variable : patternGraphLhs.getVars()) {
                    sourceBuilder.appendFront("case \"" + ActionsMatchGen.formatIdentifiable(variable) + "\": " + ActionsMatchGen.formatEntity(variable, "_") + " = (" + this.formatType(variable.getType()) + ")value; break;\n");
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        sourceBuilder.appendFront("default: break;\n");
        sourceBuilder.appendFront("}\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
    }

    private void genMatchEnum(SourceBuilder sourceBuilder, PatternGraphLhs patternGraphLhs, String string, int n, String string2) {
        sourceBuilder.appendFront("public enum " + this.entitiesEnumName(n, string2) + " { ");
        switch (n) {
            case 0: {
                for (Node node : patternGraphLhs.getNodes()) {
                    sourceBuilder.append("@" + ActionsMatchGen.formatIdentifiable(node) + ", ");
                }
                break;
            }
            case 1: {
                for (Edge edge : patternGraphLhs.getEdges()) {
                    sourceBuilder.append("@" + ActionsMatchGen.formatIdentifiable(edge) + ", ");
                }
                break;
            }
            case 2: {
                for (Variable variable : patternGraphLhs.getVars()) {
                    sourceBuilder.append("@" + ActionsMatchGen.formatIdentifiable(variable) + ", ");
                }
                break;
            }
            case 3: {
                for (SubpatternUsage subpatternUsage : patternGraphLhs.getSubpatternUsages()) {
                    sourceBuilder.append("@" + ActionsMatchGen.formatIdentifiable(subpatternUsage) + ", ");
                }
                break;
            }
            case 4: {
                for (Alternative alternative : patternGraphLhs.getAlts()) {
                    sourceBuilder.append("@" + alternative.getNameOfGraph() + ", ");
                }
                break;
            }
            case 5: {
                for (Rule rule : patternGraphLhs.getIters()) {
                    sourceBuilder.append("@" + rule.getLeft().getNameOfGraph() + ", ");
                }
                break;
            }
            case 6: {
                for (PatternGraphLhs patternGraphLhs2 : patternGraphLhs.getIdpts()) {
                    sourceBuilder.append("@" + patternGraphLhs2.getNameOfGraph() + ", ");
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        sourceBuilder.append("END_OF_ENUM };\n");
    }

    private String matchedEntitiesNameSingular(int n) {
        switch (n) {
            case 0: {
                return "Node";
            }
            case 1: {
                return "Edge";
            }
            case 2: {
                return "Variable";
            }
            case 3: {
                return "EmbeddedGraph";
            }
            case 4: {
                return "Alternative";
            }
            case 5: {
                return "Iterated";
            }
            case 6: {
                return "Independent";
            }
        }
        assert (false);
        return "";
    }

    private String matchedEntitiesNamePlural(int n) {
        return this.matchedEntitiesNameSingular(n) + "s";
    }

    private String entitiesEnumName(int n, String string) {
        switch (n) {
            case 0: {
                return string + "NodeNums";
            }
            case 1: {
                return string + "EdgeNums";
            }
            case 2: {
                return string + "VariableNums";
            }
            case 3: {
                return string + "SubNums";
            }
            case 4: {
                return string + "AltNums";
            }
            case 5: {
                return string + "IterNums";
            }
            case 6: {
                return string + "IdptNums";
            }
        }
        assert (false);
        return "";
    }

    private String typeOfMatchedEntities(int n) {
        switch (n) {
            case 0: {
                return "GRGEN_LIBGR.INode";
            }
            case 1: {
                return "GRGEN_LIBGR.IEdge";
            }
            case 2: {
                return "object";
            }
            case 3: {
                return "GRGEN_LIBGR.IMatch";
            }
            case 4: {
                return "GRGEN_LIBGR.IMatch";
            }
            case 5: {
                return "GRGEN_LIBGR.IMatches";
            }
            case 6: {
                return "GRGEN_LIBGR.IMatch";
            }
        }
        assert (false);
        return "";
    }

    private int numOfMatchedEntities(int n, PatternGraphLhs patternGraphLhs) {
        switch (n) {
            case 0: {
                return patternGraphLhs.getNodes().size();
            }
            case 1: {
                return patternGraphLhs.getEdges().size();
            }
            case 2: {
                return patternGraphLhs.getVars().size();
            }
            case 3: {
                return patternGraphLhs.getSubpatternUsages().size();
            }
            case 4: {
                return patternGraphLhs.getAlts().size();
            }
            case 5: {
                return patternGraphLhs.getIters().size();
            }
            case 6: {
                return patternGraphLhs.getIdpts().size();
            }
        }
        assert (false);
        return 0;
    }

    @Override
    protected void genQualAccess(SourceBuilder sourceBuilder, Qualification qualification, Object object) {
    }

    @Override
    protected void genMemberAccess(SourceBuilder sourceBuilder, Entity entity) {
    }
}

