/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.be.Csharp;

import de.unika.ipd.grgen.be.Csharp.CSharpBase;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.executable.ExternalFunction;
import de.unika.ipd.grgen.ir.executable.ExternalFunctionMethod;
import de.unika.ipd.grgen.ir.executable.ExternalProcedure;
import de.unika.ipd.grgen.ir.executable.ExternalProcedureMethod;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.model.Model;
import de.unika.ipd.grgen.ir.model.type.ExternalObjectType;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.util.SourceBuilder;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class ModelExternalGen
extends CSharpBase {
    private Model model;
    private SourceBuilder sb = null;

    public ModelExternalGen(Model model, SourceBuilder sourceBuilder, String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.model = model;
        this.sb = sourceBuilder;
    }

    public void genExternalFunctionsFile(String string) {
        this.sb.appendFront("// This file has been generated automatically by GrGen (www.grgen.net)\n// Do not modify this file! Any changes will be lost!\n// Generated from \"" + string + "\" on " + new Date() + "\n\nusing System;\nusing System.Collections.Generic;\nusing System.IO;\nusing GRGEN_LIBGR = de.unika.ipd.grGen.libGr;\nusing GRGEN_LGSP = de.unika.ipd.grGen.lgsp;\nusing GRGEN_MODEL = de.unika.ipd.grGen.Model_" + this.model.getIdent() + ";\n");
        if (!this.model.getExternalObjectTypes().isEmpty() || this.model.isEmitClassDefined() || this.model.isEmitGraphClassDefined()) {
            this.sb.append("\n");
            this.sb.appendFront("namespace de.unika.ipd.grGen.Model_" + this.model.getIdent() + "\n{\n");
            this.sb.indent();
            this.genExternalClasses();
            if (this.model.isEmitClassDefined() || this.model.isEmitGraphClassDefined()) {
                this.genEmitterParserClass();
            }
            if (this.model.isCopyClassDefined() || this.model.isEqualClassDefined() || this.model.isLowerClassDefined()) {
                this.genCopierComparerClass();
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
        if (!this.model.getExternalFunctions().isEmpty()) {
            this.sb.append("\n");
            this.sb.appendFront("namespace de.unika.ipd.grGen.expression\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("public partial class ExternalFunctions\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("// You must implement the following functions in the same partial class in ./" + this.model.getIdent() + "ModelExternalFunctionsImpl.cs:\n");
            this.sb.append("\n");
            this.genExternalFunctionHeaders();
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
        if (!this.model.getExternalProcedures().isEmpty()) {
            this.sb.append("\n");
            this.sb.appendFront("namespace de.unika.ipd.grGen.expression\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("public partial class ExternalProcedures\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("// You must implement the following procedures in the same partial class in ./" + this.model.getIdent() + "ModelExternalFunctionsImpl.cs:\n");
            this.sb.append("\n");
            this.genExternalProcedureHeaders();
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    public void genExternalObjectType(ExternalObjectType externalObjectType) {
        this.sb.append("\n");
        this.sb.appendFront("public sealed class ExternalObjectType_" + externalObjectType.getIdent() + " : GRGEN_LIBGR.ExternalObjectType\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("public ExternalObjectType_" + externalObjectType.getIdent() + "()\n");
        this.sb.appendFrontIndented(": base(\"" + externalObjectType.getIdent() + "\", typeof(" + externalObjectType.getIdent() + "))\n");
        this.sb.appendFront("{\n");
        this.sb.appendFront("}\n");
        this.sb.appendFront("public override int NumFunctionMethods { get { return " + externalObjectType.getAllExternalFunctionMethods().size() + "; } }\n");
        this.genExternalFunctionMethodsEnumerator(externalObjectType);
        this.genGetExternalFunctionMethod(externalObjectType);
        this.sb.appendFront("public override int NumProcedureMethods { get { return " + externalObjectType.getAllExternalProcedureMethods().size() + "; } }\n");
        this.genExternalProcedureMethodsEnumerator(externalObjectType);
        this.genGetExternalProcedureMethod(externalObjectType);
        this.sb.unindent();
        this.sb.append("}\n");
        Collection<ExternalFunctionMethod> collection = externalObjectType.getAllExternalFunctionMethods();
        for (ExternalFunctionMethod object2 : collection) {
            this.genExternalFunctionMethodInfo(object2, externalObjectType, null);
        }
        Collection<ExternalProcedureMethod> collection2 = externalObjectType.getAllExternalProcedureMethods();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            ExternalProcedureMethod externalProcedureMethod = (ExternalProcedureMethod)iterator.next();
            this.genExternalProcedureMethodInfo(externalProcedureMethod, externalObjectType, null);
        }
    }

    private void genExternalFunctionMethodsEnumerator(ExternalObjectType externalObjectType) {
        Collection<ExternalFunctionMethod> collection = externalObjectType.getAllExternalFunctionMethods();
        this.sb.appendFront("public override IEnumerable<GRGEN_LIBGR.IFunctionDefinition> FunctionMethods");
        if (collection.isEmpty()) {
            this.sb.append(" { get { yield break; } }\n");
        } else {
            this.sb.append("\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("get\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (ExternalFunctionMethod externalFunctionMethod : collection) {
                this.sb.appendFront("yield return " + ModelExternalGen.formatExternalFunctionMethodInfoName(externalFunctionMethod, externalObjectType) + ".Instance;\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    private void genGetExternalFunctionMethod(ExternalObjectType externalObjectType) {
        Collection<ExternalFunctionMethod> collection = externalObjectType.getAllExternalFunctionMethods();
        this.sb.appendFront("public override GRGEN_LIBGR.IFunctionDefinition GetFunctionMethod(string name)");
        if (collection.isEmpty()) {
            this.sb.append(" { return null; }\n");
        } else {
            this.sb.append("\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("switch(name)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (ExternalFunctionMethod externalFunctionMethod : collection) {
                this.sb.appendFront("case \"" + ModelExternalGen.formatIdentifiable(externalFunctionMethod) + "\" : return " + ModelExternalGen.formatExternalFunctionMethodInfoName(externalFunctionMethod, externalObjectType) + ".Instance;\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("return null;\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    private void genExternalProcedureMethodsEnumerator(ExternalObjectType externalObjectType) {
        Collection<ExternalProcedureMethod> collection = externalObjectType.getAllExternalProcedureMethods();
        this.sb.appendFront("public override IEnumerable<GRGEN_LIBGR.IProcedureDefinition> ProcedureMethods");
        if (collection.isEmpty()) {
            this.sb.append(" { get { yield break; } }\n");
        } else {
            this.sb.append("\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("get\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (ExternalProcedureMethod externalProcedureMethod : collection) {
                this.sb.appendFront("yield return " + ModelExternalGen.formatExternalProcedureMethodInfoName(externalProcedureMethod, externalObjectType) + ".Instance;\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    private void genGetExternalProcedureMethod(ExternalObjectType externalObjectType) {
        Collection<ExternalProcedureMethod> collection = externalObjectType.getAllExternalProcedureMethods();
        this.sb.appendFront("public override GRGEN_LIBGR.IProcedureDefinition GetProcedureMethod(string name)");
        if (collection.isEmpty()) {
            this.sb.append(" { return null; }\n");
        } else {
            this.sb.append("\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("switch(name)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (ExternalProcedureMethod externalProcedureMethod : collection) {
                this.sb.appendFront("case \"" + ModelExternalGen.formatIdentifiable(externalProcedureMethod) + "\" : return " + ModelExternalGen.formatExternalProcedureMethodInfoName(externalProcedureMethod, externalObjectType) + ".Instance;\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("return null;\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    private void genExternalFunctionMethodInfo(ExternalFunctionMethod externalFunctionMethod, ExternalObjectType externalObjectType, String string) {
        String string2 = ModelExternalGen.formatIdentifiable(externalFunctionMethod);
        String string3 = ModelExternalGen.formatExternalFunctionMethodInfoName(externalFunctionMethod, externalObjectType);
        this.sb.appendFront("public class " + string3 + " : GRGEN_LIBGR.FunctionInfo\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("private static " + string3 + " instance = null;\n");
        this.sb.appendFront("public static " + string3 + " Instance { get { if(instance==null) { instance = new " + string3 + "(); } return instance; } }\n");
        this.sb.append("\n");
        this.sb.appendFront("private " + string3 + "()\n");
        this.sb.indent();
        this.sb.appendFront(": base(\n");
        this.sb.indent();
        this.sb.appendFront("\"" + string2 + "\",\n");
        this.sb.appendFront((string != null ? "\"" + string + "\"" : "null") + ", ");
        this.sb.append("\"" + (string != null ? string + "::" + string2 : string2) + "\",\n");
        this.sb.appendFront("true,\n");
        this.sb.appendFront("new String[] { ");
        int n = 0;
        for (Type type : externalFunctionMethod.getParameterTypes()) {
            this.sb.append("\"in_" + n + "\", ");
            ++n;
        }
        this.sb.append(" },\n");
        this.sb.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Type type : externalFunctionMethod.getParameterTypes()) {
            if (type instanceof InheritanceType && !(type instanceof ExternalObjectType)) {
                this.sb.appendFront(ModelExternalGen.formatTypeClassRef(type) + ".typeVar, ");
                continue;
            }
            this.sb.appendFront("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(type) + ")), ");
        }
        this.sb.append(" },\n");
        Type type = externalFunctionMethod.getReturnType();
        if (type instanceof InheritanceType && !(type instanceof ExternalObjectType)) {
            this.sb.appendFront(ModelExternalGen.formatTypeClassRef(type) + ".typeVar\n");
        } else {
            this.sb.appendFront("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(type) + "))\n");
        }
        this.sb.unindent();
        this.sb.appendFront(")\n");
        this.sb.unindent();
        this.sb.appendFront("{\n");
        this.sb.appendFront("}\n");
        this.sb.appendFront("public override object Apply(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv, GRGEN_LIBGR.IGraph graph, object[] arguments)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("throw new Exception(\"Not implemented, can't call function method without this object!\");\n");
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    private void genExternalProcedureMethodInfo(ExternalProcedureMethod externalProcedureMethod, ExternalObjectType externalObjectType, String string) {
        String string2 = ModelExternalGen.formatIdentifiable(externalProcedureMethod);
        String string3 = ModelExternalGen.formatExternalProcedureMethodInfoName(externalProcedureMethod, externalObjectType);
        this.sb.appendFront("public class " + string3 + " : GRGEN_LIBGR.ProcedureInfo\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("private static " + string3 + " instance = null;\n");
        this.sb.appendFront("public static " + string3 + " Instance { get { if(instance==null) { instance = new " + string3 + "(); } return instance; } }\n");
        this.sb.append("\n");
        this.sb.appendFront("private " + string3 + "()\n");
        this.sb.indent();
        this.sb.appendFront(": base(\n");
        this.sb.indent();
        this.sb.appendFront("\"" + string2 + "\",\n");
        this.sb.appendFront((string != null ? "\"" + string + "\"" : "null") + ", ");
        this.sb.append("\"" + (string != null ? string + "::" + string2 : string2) + "\",\n");
        this.sb.appendFront("true,\n");
        this.sb.appendFront("new String[] { ");
        int n = 0;
        for (Type type : externalProcedureMethod.getParameterTypes()) {
            this.sb.append("\"in_" + n + "\", ");
            ++n;
        }
        this.sb.append(" },\n");
        this.sb.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Type type : externalProcedureMethod.getParameterTypes()) {
            if (type instanceof InheritanceType && !(type instanceof ExternalObjectType)) {
                this.sb.append(ModelExternalGen.formatTypeClassRef(type) + ".typeVar, ");
                continue;
            }
            this.sb.append("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(type) + ")), ");
        }
        this.sb.append(" },\n");
        this.sb.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Type type : externalProcedureMethod.getReturnTypes()) {
            if (type instanceof InheritanceType && !(type instanceof ExternalObjectType)) {
                this.sb.append(ModelExternalGen.formatTypeClassRef(type) + ".typeVar, ");
                continue;
            }
            this.sb.append("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(type) + ")), ");
        }
        this.sb.append(" }\n");
        this.sb.unindent();
        this.sb.appendFront(")\n");
        this.sb.unindent();
        this.sb.appendFront("{\n");
        this.sb.appendFront("}\n");
        this.sb.appendFront("public override object[] Apply(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv, GRGEN_LIBGR.IGraph graph, object[] arguments)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("throw new Exception(\"Not implemented, can't call procedure method without this object!\");\n");
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    public void genExternalObjectTypeObject() {
        this.sb.append("\n");
        this.sb.appendFront("public sealed class ExternalObjectType_object : GRGEN_LIBGR.ExternalObjectType\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("public ExternalObjectType_object()\n");
        this.sb.appendFrontIndented(": base(\"object\", typeof(object))\n");
        this.sb.appendFront("{\n");
        this.sb.appendFront("}\n");
        this.sb.appendFront("public override int NumFunctionMethods { get { return 0; } }\n");
        this.sb.appendFront("public override IEnumerable<GRGEN_LIBGR.IFunctionDefinition> FunctionMethods { get { yield break; } }\n");
        this.sb.appendFront("public override GRGEN_LIBGR.IFunctionDefinition GetFunctionMethod(string name) { return null; }\n");
        this.sb.appendFront("public override int NumProcedureMethods { get { return 0; } }\n");
        this.sb.appendFront("public override IEnumerable<GRGEN_LIBGR.IProcedureDefinition> ProcedureMethods { get { yield break; } }\n");
        this.sb.appendFront("public override GRGEN_LIBGR.IProcedureDefinition GetProcedureMethod(string name) { return null; }\n");
        this.sb.append("\n");
        this.sb.appendFront("public static object ThrowCopyClassMissingException() { throw new Exception(\"Cannot copy/clone external object, copy class specification is missing in the model.\"); }\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genExternalClasses() {
        for (ExternalObjectType externalObjectType : this.model.getExternalObjectTypes()) {
            this.sb.appendFront("public partial class " + externalObjectType.getIdent());
            boolean bl = true;
            for (InheritanceType inheritanceType : externalObjectType.getDirectSuperTypes()) {
                if (bl) {
                    this.sb.append(" : ");
                } else {
                    this.sb.append(", ");
                }
                this.sb.append(inheritanceType.getIdent().toString());
                bl = false;
            }
            this.sb.append("\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("// You must implement this class in the same partial class in ./" + this.model.getIdent() + "ModelExternalFunctionsImpl.cs:\n");
            this.genExternalMethods(externalObjectType);
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.append("\n");
        }
    }

    private void genExternalMethods(ExternalObjectType externalObjectType) {
        if (externalObjectType.getAllExternalFunctionMethods().size() == 0 && externalObjectType.getAllExternalProcedureMethods().size() == 0) {
            return;
        }
        this.sb.append("\n");
        this.sb.appendFront("// You must implement the following methods in the same partial class in ./" + this.model.getIdent() + "ModelExternalFunctionsImpl.cs:\n");
        for (ExternalFunctionMethod identifiable : externalObjectType.getAllExternalFunctionMethods()) {
            this.sb.appendFront("//public " + this.formatType(identifiable.getReturnType()) + " ");
            this.sb.append(identifiable.getIdent().toString() + "(GRGEN_LIBGR.IActionExecutionEnvironment, GRGEN_LIBGR.IGraph");
            for (Type type : identifiable.getParameterTypes()) {
                this.sb.append(", ");
                this.sb.append(this.formatType(type));
            }
            this.sb.append(");\n");
            if (!this.model.areFunctionsParallel()) continue;
            this.sb.appendFront("//public " + this.formatType(identifiable.getReturnType()) + " ");
            this.sb.append(identifiable.getIdent().toString() + "(GRGEN_LIBGR.IActionExecutionEnvironment, GRGEN_LIBGR.IGraph");
            for (Type type : identifiable.getParameterTypes()) {
                this.sb.append(", ");
                this.sb.append(this.formatType(type));
            }
            this.sb.append(", int threadId");
            this.sb.append(");\n");
        }
        for (ExternalProcedureMethod externalProcedureMethod : externalObjectType.getAllExternalProcedureMethods()) {
            this.genParameterPassingReturnArray(externalObjectType, externalProcedureMethod);
        }
        for (ExternalProcedureMethod externalProcedureMethod : externalObjectType.getAllExternalProcedureMethods()) {
            this.sb.appendFront("//public void ");
            this.sb.append(externalProcedureMethod.getIdent().toString() + "(GRGEN_LIBGR.IActionExecutionEnvironment, GRGEN_LIBGR.IGraph, GRGEN_LIBGR.IGraphElement");
            for (Type type : externalProcedureMethod.getParameterTypes()) {
                this.sb.append(", ");
                this.sb.append(this.formatType(type));
            }
            for (Type type : externalProcedureMethod.getReturnTypes()) {
                this.sb.append(", out ");
                this.sb.append(this.formatType(type));
            }
            this.sb.append(");\n");
        }
    }

    private void genParameterPassingReturnArray(ExternalObjectType externalObjectType, ExternalProcedureMethod externalProcedureMethod) {
        this.sb.appendFront("private static object[] ReturnArray_" + externalProcedureMethod.getIdent().toString() + "_" + externalObjectType.getIdent().toString() + " = new object[" + externalProcedureMethod.getReturnTypes().size() + "]; // helper array for multi-value-returns, to allow for contravariant parameter assignment\n");
    }

    private void genEmitterParserClass() {
        this.sb.appendFront("public partial class AttributeTypeObjectEmitterParser");
        this.sb.append("\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// You must implement this class in the same partial class in ./" + this.model.getIdent() + "ModelExternalFunctionsImpl.cs:\n");
        this.sb.appendFront("// You must implement the functions called by the following functions inside that class (same name plus suffix Impl):\n");
        this.sb.append("\n");
        if (this.model.isEmitClassDefined()) {
            this.sb.appendFront("// Called during .grs import, at exactly the position in the text reader where the attribute begins.\n");
            this.sb.appendFront("// For attribute type object or a user defined type, which is treated as object.\n");
            this.sb.appendFront("// The implementation must parse from there on the attribute type requested.\n");
            this.sb.appendFront("// It must not parse beyond the serialized representation of the attribute, \n");
            this.sb.appendFront("// i.e. Peek() must return the first character not belonging to the attribute type any more.\n");
            this.sb.appendFront("// Returns the parsed object.\n");
            this.sb.appendFront("public static object Parse(TextReader reader, GRGEN_LIBGR.AttributeType attrType, GRGEN_LIBGR.IGraph graph)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("return ParseImpl(reader, attrType, graph);\n");
            this.sb.appendFront("//reader.Read(); reader.Read(); reader.Read(); reader.Read(); // eat 'n' 'u' 'l' 'l' // default implementation\n");
            this.sb.appendFront("//return null; // default implementation\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.append("\n");
            this.sb.appendFront("// Called during .grs export, the implementation must return a string representation for the attribute.\n");
            this.sb.appendFront("// For attribute type object or a user defined type, which is treated as object.\n");
            this.sb.appendFront("// The serialized string must be parseable by Parse.\n");
            this.sb.appendFront("public static string Serialize(object attribute, GRGEN_LIBGR.AttributeType attrType, GRGEN_LIBGR.IGraph graph)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("return SerializeImpl(attribute, attrType, graph);\n");
            this.sb.appendFront("//Console.WriteLine(\"Warning: Exporting attribute of object type to null\"); // default implementation\n");
            this.sb.appendFront("//return \"null\"; // default implementation\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.append("\n");
            this.sb.appendFront("// Called during debugging or emit writing, the implementation must return a string representation for the attribute.\n");
            this.sb.appendFront("// For attribute type object or a user defined type, which is treated as object.\n");
            this.sb.appendFront("// The attribute type may be null.\n");
            this.sb.appendFront("// The string is meant for consumption by humans, it does not need to be parseable.\n");
            this.sb.appendFront("public static string Emit(object attribute, GRGEN_LIBGR.AttributeType attrType, GRGEN_LIBGR.IGraph graph)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("return EmitImpl(attribute, attrType, graph);\n");
            this.sb.appendFront("//return \"null\"; // default implementation\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.append("\n");
            this.sb.appendFront("// Called when the shell hits a line starting with \"external\".\n");
            this.sb.appendFront("// The content of that line is handed in.\n");
            this.sb.appendFront("// This is typically used while replaying changes containing a method call of an external type\n");
            this.sb.appendFront("// -- after such a line was recorded, by the method called, by writing to the recorder.\n");
            this.sb.appendFront("// This is meant to replay fine-grain changes of graph attributes of external type,\n");
            this.sb.appendFront("// in contrast to full assignments handled by Parse and Serialize.\n");
            this.sb.appendFront("public static void External(string line, GRGEN_LIBGR.IGraph graph)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("ExternalImpl(line, graph);\n");
            this.sb.appendFront("//Console.Write(\"Ignoring: \"); // default implementation\n");
            this.sb.appendFront("//Console.WriteLine(line); // default implementation\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.append("\n");
        }
        if (this.model.isEmitGraphClassDefined()) {
            this.sb.appendFront("// Called during debugging on user request, the implementation must return a named graph representation for the attribute.\n");
            this.sb.appendFront("// For attribute type object or a user defined type, which is treated as object.\n");
            this.sb.appendFront("// The attribute type may be null. The return graph must be of the same model as the graph handed in.\n");
            this.sb.appendFront("// The named graph is meant for display in the debugger, to visualize the internal structure of some attribute type.\n");
            this.sb.appendFront("// This way you can graphically inspect your own data types which are opaque to GrGen with its debugger.\n");
            this.sb.appendFront("public static GRGEN_LIBGR.INamedGraph AsGraph(object attribute, GRGEN_LIBGR.AttributeType attrType, GRGEN_LIBGR.IGraph graph)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("return AsGraphImpl(attribute, attrType, graph);\n");
            this.sb.appendFront("//return null; // default implementation\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    private void genCopierComparerClass() {
        this.sb.appendFront("public partial class AttributeTypeObjectCopierComparer\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// You must implement the following functions in the same partial class in ./" + this.model.getIdent() + "ModelExternalFunctionsImpl.cs:\n");
        this.sb.append("\n");
        if (this.model.isCopyClassDefined()) {
            this.sb.appendFront("// Called when a graph element or internal (transient) object bearing attributes of external object type is to be copied.\n");
            this.sb.appendFront("// Also called when a top-level external object is to be cloned or copied.\n");
            this.sb.appendFront("// If \"copy class\" is not specified, object attributes are copied by copying the reference, i.e. they are identical afterwards (top-level objects cannot be copied/cloned in this case).\n");
            this.sb.appendFront("// If \"copy class\" is specified:\n");
            this.sb.appendFront("// If the old to new element dictionary is null, objects are to be cloned, i.e. top-level object (of the very call) is to be cloned and others are just assigned by reference.\n");
            this.sb.appendFront("// Otherwise, they are to be copied by-value (so changing one attribute later on has no effect on the other).\n");
            this.sb.appendFront("//public static object Copy(object, IGraph, IDictionary<object, object>);\n");
            this.sb.append("\n");
        }
        if (this.model.isEqualClassDefined()) {
            this.sb.appendFront("// Called during comparison of graph elements from graph isomorphy comparison, or during deeply equal attribute comparisons.\n");
            this.sb.appendFront("// For attribute type object.\n");
            this.sb.appendFront("// If \"~~ class\" is not specified, objects are equal if their references are identical.\n");
            this.sb.appendFront("// The visited objects dictionary contains the already visited objects, insert your object here to detect multiple appearances/cycles (and check against it).\n");
            this.sb.appendFront("//public static bool IsEqual(object, object, IDictionary<object, object>);\n");
            this.sb.append("\n");
        }
        if (this.model.isLowerClassDefined()) {
            this.sb.appendFront("// Called during attribute comparison.\n");
            this.sb.appendFront("// For attribute type object.\n");
            this.sb.appendFront("// If \"< class\" is not specified, objects can't be compared for ordering, only for equality.\n");
            this.sb.appendFront("//public static bool IsLower(object, object, IDictionary<object, object>);\n");
            this.sb.append("\n");
        }
        if (this.model.getExternalObjectTypes().size() > 0) {
            this.sb.append("\n");
            this.sb.appendFront("// The same functions, just for each user defined type.\n");
            this.sb.appendFront("// Those are normally treated as object (if no \"copy class or ~~ class or < class\" is specified),\n");
            this.sb.appendFront("// i.e. equal if identical references, no ordered comparisons available, and copy just copies the reference (making them identical).\n");
            this.sb.appendFront("// Here you can overwrite the default reference semantics with value semantics, fitting better to the other attribute types.\n");
            for (ExternalObjectType externalObjectType : this.model.getExternalObjectTypes()) {
                String string = externalObjectType.getIdent().toString();
                this.sb.append("\n");
                if (this.model.isCopyClassDefined()) {
                    this.sb.appendFront("//public static " + string + " Copy(" + string + ");\n");
                }
                if (this.model.isEqualClassDefined()) {
                    this.sb.appendFront("//public static bool IsEqual(" + string + ", " + string + ", IDictionary<object, object>);\n");
                }
                if (!this.model.isLowerClassDefined()) continue;
                this.sb.appendFront("//public static bool IsLower(" + string + ", " + string + ", IDictionary<object, object>);\n");
            }
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    private void genExternalFunctionHeaders() {
        for (ExternalFunction externalFunction : this.model.getExternalFunctions()) {
            Type type = externalFunction.getReturnType();
            this.sb.appendFront("//public static " + this.formatType(type) + " " + externalFunction.getName() + "(GRGEN_LIBGR.IActionExecutionEnvironment, GRGEN_LIBGR.IGraph");
            for (Type type2 : externalFunction.getParameterTypes()) {
                this.sb.append(", ");
                this.sb.append(this.formatType(type2));
            }
            this.sb.append(");\n");
            if (!this.model.areFunctionsParallel()) continue;
            this.sb.appendFront("//public static " + this.formatType(type) + " " + externalFunction.getName() + "(GRGEN_LIBGR.IActionExecutionEnvironment, GRGEN_LIBGR.IGraph");
            for (Type type2 : externalFunction.getParameterTypes()) {
                this.sb.append(", ");
                this.sb.append(this.formatType(type2));
            }
            this.sb.append(", int threadId");
            this.sb.append(");\n");
        }
    }

    private void genExternalProcedureHeaders() {
        for (ExternalProcedure externalProcedure : this.model.getExternalProcedures()) {
            this.sb.appendFront("//public static void " + externalProcedure.getName() + "(GRGEN_LIBGR.IActionExecutionEnvironment, GRGEN_LIBGR.IGraph");
            for (Type type : externalProcedure.getParameterTypes()) {
                this.sb.append(", ");
                this.sb.append(this.formatType(type));
            }
            for (Type type : externalProcedure.getReturnTypes()) {
                this.sb.append(", ");
                this.sb.append("out ");
                this.sb.append(this.formatType(type));
            }
            this.sb.append(");\n");
        }
    }

    @Override
    protected void genQualAccess(SourceBuilder sourceBuilder, Qualification qualification, Object object) {
    }

    @Override
    protected void genMemberAccess(SourceBuilder sourceBuilder, Entity entity) {
    }
}

