/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.be.Csharp;

import de.unika.ipd.grgen.be.Csharp.CSharpBase;
import de.unika.ipd.grgen.be.Csharp.ModelExternalGen;
import de.unika.ipd.grgen.be.Csharp.ModelIndexGen;
import de.unika.ipd.grgen.be.Csharp.ModifyEvalGen;
import de.unika.ipd.grgen.be.Csharp.ModifyExecGen;
import de.unika.ipd.grgen.be.Csharp.ModifyGenerationState;
import de.unika.ipd.grgen.be.Csharp.ModifyGenerationStateConst;
import de.unika.ipd.grgen.be.Csharp.SearchPlanBackend2;
import de.unika.ipd.grgen.ir.ContainedInPackage;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.executable.FunctionMethod;
import de.unika.ipd.grgen.ir.executable.ProcedureMethod;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.ExpressionPair;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.expr.array.ArrayInit;
import de.unika.ipd.grgen.ir.expr.deque.DequeInit;
import de.unika.ipd.grgen.ir.expr.map.MapInit;
import de.unika.ipd.grgen.ir.expr.set.SetInit;
import de.unika.ipd.grgen.ir.model.AttributeIndex;
import de.unika.ipd.grgen.ir.model.ConnAssert;
import de.unika.ipd.grgen.ir.model.EnumItem;
import de.unika.ipd.grgen.ir.model.IncidenceCountIndex;
import de.unika.ipd.grgen.ir.model.Index;
import de.unika.ipd.grgen.ir.model.MemberInit;
import de.unika.ipd.grgen.ir.model.Model;
import de.unika.ipd.grgen.ir.model.NodeEdgeEnumBearer;
import de.unika.ipd.grgen.ir.model.type.BaseInternalObjectType;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import de.unika.ipd.grgen.ir.model.type.EnumType;
import de.unika.ipd.grgen.ir.model.type.ExternalObjectType;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.model.type.InternalObjectType;
import de.unika.ipd.grgen.ir.model.type.InternalTransientObjectType;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.ir.model.type.PackageType;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.ir.type.basic.BooleanType;
import de.unika.ipd.grgen.ir.type.basic.ByteType;
import de.unika.ipd.grgen.ir.type.basic.DoubleType;
import de.unika.ipd.grgen.ir.type.basic.FloatType;
import de.unika.ipd.grgen.ir.type.basic.GraphType;
import de.unika.ipd.grgen.ir.type.basic.IntType;
import de.unika.ipd.grgen.ir.type.basic.LongType;
import de.unika.ipd.grgen.ir.type.basic.ObjectType;
import de.unika.ipd.grgen.ir.type.basic.ShortType;
import de.unika.ipd.grgen.ir.type.basic.StringType;
import de.unika.ipd.grgen.ir.type.basic.VoidType;
import de.unika.ipd.grgen.ir.type.container.ArrayType;
import de.unika.ipd.grgen.ir.type.container.ContainerType;
import de.unika.ipd.grgen.ir.type.container.DequeType;
import de.unika.ipd.grgen.ir.type.container.MapType;
import de.unika.ipd.grgen.ir.type.container.SetType;
import de.unika.ipd.grgen.util.SourceBuilder;
import java.io.File;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ModelGen
extends CSharpBase {
    private final int MAX_OPERATIONS_FOR_ATTRIBUTE_INITIALIZATION_INLINING = 20;
    private static final String ATTR_IMPL_SUFFIX = "_M0no_suXx_h4rD";
    private SearchPlanBackend2 be;
    private Model model;
    private SourceBuilder sb = null;
    private SourceBuilder stubsb = null;
    private String curMemberOwner = null;
    private HashSet<String> rootTypes;

    public ModelGen(SearchPlanBackend2 searchPlanBackend2, String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.be = searchPlanBackend2;
        this.rootTypes = new HashSet();
        this.rootTypes.add("Node");
        this.rootTypes.add("Edge");
        this.rootTypes.add("AEdge");
        this.rootTypes.add("UEdge");
        this.rootTypes.add("Object");
        this.rootTypes.add("TransientObject");
    }

    public void genModel(Model model) {
        this.model = model;
        this.sb = new SourceBuilder();
        this.stubsb = null;
        String string = model.getIdent() + "Model.cs";
        System.out.println("  generating the " + string + " file...");
        this.sb.appendFront("// This file has been generated automatically by GrGen (www.grgen.net)\n// Do not modify this file! Any changes will be lost!\n// Generated from \"" + this.be.unit.getFilename() + "\" on " + new Date() + "\n\nusing System;\nusing System.Collections.Generic;\nusing System.Collections;\nusing System.IO;\nusing System.Diagnostics;\nusing GRGEN_LIBGR = de.unika.ipd.grGen.libGr;\nusing GRGEN_LGSP = de.unika.ipd.grGen.lgsp;\nusing GRGEN_EXPR = de.unika.ipd.grGen.expression;\nusing GRGEN_MODEL = de.unika.ipd.grGen.Model_" + model.getIdent() + ";\n\nnamespace de.unika.ipd.grGen.Model_" + model.getIdent() + "\n{\n");
        this.sb.indent();
        for (PackageType object2 : model.getPackages()) {
            System.out.println("    generating package " + object2.getIdent() + "...");
            this.sb.append("\n");
            this.sb.appendFront("//-----------------------------------------------------------\n");
            this.sb.appendFront("namespace ");
            this.sb.append(ModelGen.formatIdentifiable(object2));
            this.sb.append("\n");
            this.sb.appendFront("//-----------------------------------------------------------\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.genBearer(model.getAllNodeTypes(), model.getAllEdgeTypes(), model.getAllObjectTypes(), model.getAllTransientObjectTypes(), object2, object2.getIdent().toString());
            this.sb.append("\n");
            this.sb.appendFront("//-----------------------------------------------------------\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("//-----------------------------------------------------------\n");
        }
        this.genBearer(model.getAllNodeTypes(), model.getAllEdgeTypes(), model.getAllObjectTypes(), model.getAllTransientObjectTypes(), model, null);
        Object object3 = new ModelExternalGen(model, this.sb, this.nodeTypePrefix, this.edgeTypePrefix, this.objectTypePrefix, this.transientObjectTypePrefix);
        ((ModelExternalGen)object3).genExternalObjectTypeObject();
        for (ExternalObjectType externalObjectType : model.getExternalObjectTypes()) {
            ((ModelExternalGen)object3).genExternalObjectType(externalObjectType);
        }
        System.out.println("    generating indices...");
        this.sb.append("\n");
        this.sb.appendFront("//\n");
        this.sb.appendFront("// Indices\n");
        this.sb.appendFront("//\n");
        this.sb.append("\n");
        ModelIndexGen modelIndexGen = new ModelIndexGen(model, this.sb, this.nodeTypePrefix, this.edgeTypePrefix, this.objectTypePrefix, this.transientObjectTypePrefix);
        modelIndexGen.genIndexTypes();
        modelIndexGen.genIndexImplementations();
        modelIndexGen.genIndexSetType();
        System.out.println("    generating node model...");
        this.sb.append("\n");
        this.genModelClass(model.getAllNodeTypes(), InheritanceTypeType.Node);
        System.out.println("    generating edge model...");
        this.sb.append("\n");
        this.genModelClass(model.getAllEdgeTypes(), InheritanceTypeType.Edge);
        System.out.println("    generating class model...");
        this.sb.append("\n");
        this.genModelClass(model.getAllObjectTypes(), InheritanceTypeType.Object);
        System.out.println("    generating transient class model...");
        this.sb.append("\n");
        this.genModelClass(model.getAllTransientObjectTypes(), InheritanceTypeType.TransientObject);
        System.out.println("    generating graph model...");
        this.sb.append("\n");
        this.genGraphModel();
        this.sb.append("\n");
        this.genGraphClass();
        this.sb.append("\n");
        this.genNamedGraphClass();
        this.sb.unindent();
        this.sb.appendFront("}\n");
        System.out.println("    writing to " + this.be.path + " / " + string);
        ModelGen.writeFile(this.be.path, string, this.sb.toString());
        if (this.stubsb != null) {
            String string2 = model.getIdent() + "ModelStub.cs";
            System.out.println("  writing the " + string2 + " stub file...");
            ModelGen.writeFile(this.be.path, string2, this.stubsb.toString());
        }
        if (model.getExternalObjectTypes().isEmpty() && model.getExternalFunctions().isEmpty() && model.getExternalProcedures().isEmpty() && !model.isEmitClassDefined() && !model.isEmitGraphClassDefined() && !model.isCopyClassDefined() && !model.isEqualClassDefined() && !model.isLowerClassDefined()) {
            return;
        }
        string = model.getIdent() + "ModelExternalFunctions.cs";
        System.out.println("  generating the " + string + " file...");
        this.sb = new SourceBuilder();
        object3 = new ModelExternalGen(model, this.sb, this.nodeTypePrefix, this.edgeTypePrefix, this.objectTypePrefix, this.transientObjectTypePrefix);
        ((ModelExternalGen)object3).genExternalFunctionsFile(this.be.unit.getFilename());
        System.out.println("    writing to " + this.be.path + " / " + string);
        ModelGen.writeFile(this.be.path, string, this.sb.toString());
        if (this.be.path.compareTo(new File(".")) == 0) {
            System.out.println("    no copy needed for " + this.be.path + " / " + string);
        } else {
            System.out.println("    copying " + this.be.path + " / " + string + " to " + this.be.path.getAbsoluteFile().getParent() + " / " + string);
            ModelGen.copyFile(new File(this.be.path, string), new File(this.be.path.getAbsoluteFile().getParent(), string));
        }
    }

    private SourceBuilder getStubBuffer() {
        if (this.stubsb == null) {
            this.stubsb = new SourceBuilder();
            this.stubsb.appendFront("// This file has been generated automatically by GrGen (www.grgen.net)\n// Do not modify this file! Any changes will be lost!\n// Rename this file or use a copy!\n// Generated from \"" + this.be.unit.getFilename() + "\" on " + new Date() + "\n\nusing System;\nusing System.Collections.Generic;\nusing GRGEN_LIBGR = de.unika.ipd.grGen.libGr;\nusing GRGEN_LGSP = de.unika.ipd.grGen.lgsp;\nusing GRGEN_MODEL = de.unika.ipd.grGen.Model_" + this.model.getIdent() + ";\n");
        }
        return this.stubsb;
    }

    private void genBearer(Collection<? extends InheritanceType> collection, Collection<? extends InheritanceType> collection2, Collection<? extends InheritanceType> collection3, Collection<? extends InheritanceType> collection4, NodeEdgeEnumBearer nodeEdgeEnumBearer, String string) {
        System.out.println("    generating enums...");
        this.sb.append("\n");
        this.genEnums(nodeEdgeEnumBearer);
        System.out.println("    generating node types...");
        this.sb.append("\n");
        this.genInheritanceTypes(collection, nodeEdgeEnumBearer, string, InheritanceTypeType.Node);
        System.out.println("    generating edge types...");
        this.sb.append("\n");
        this.genInheritanceTypes(collection2, nodeEdgeEnumBearer, string, InheritanceTypeType.Edge);
        System.out.println("    generating object types...");
        this.sb.append("\n");
        this.genInheritanceTypes(collection3, nodeEdgeEnumBearer, string, InheritanceTypeType.Object);
        System.out.println("    generating transient object types...");
        this.sb.append("\n");
        this.genInheritanceTypes(collection4, nodeEdgeEnumBearer, string, InheritanceTypeType.TransientObject);
    }

    private void genEnums(NodeEdgeEnumBearer nodeEdgeEnumBearer) {
        this.sb.appendFront("//\n");
        this.sb.appendFront("// Enums\n");
        this.sb.appendFront("//\n");
        this.sb.append("\n");
        for (EnumType enumType : nodeEdgeEnumBearer.getEnumTypes()) {
            this.sb.appendFront("public enum ENUM_" + ModelGen.formatIdentifiable(enumType) + " { ");
            for (EnumItem enumItem : enumType.getItems()) {
                this.sb.append("@" + ModelGen.formatIdentifiable(enumItem) + " = " + enumItem.getValue().getValue() + ", ");
            }
            this.sb.append("};\n\n");
        }
        this.sb.appendFront("public class Enums\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        for (EnumType enumType : nodeEdgeEnumBearer.getEnumTypes()) {
            this.sb.appendFront("public static GRGEN_LIBGR.EnumAttributeType @" + ModelGen.formatIdentifiable(enumType) + " = new GRGEN_LIBGR.EnumAttributeType(\"" + ModelGen.formatIdentifiable(enumType) + "\", " + (!ModelGen.getPackagePrefix(enumType).equals("") ? "\"" + ModelGen.getPackagePrefix(enumType) + "\"" : "null") + ", \"" + ModelGen.getPackagePrefixDoubleColon(enumType) + ModelGen.formatIdentifiable(enumType) + "\", typeof(GRGEN_MODEL." + ModelGen.getPackagePrefixDot(enumType) + "ENUM_" + ModelGen.formatIdentifiable(enumType) + "), new GRGEN_LIBGR.EnumMember[] {\n");
            this.sb.indent();
            for (EnumItem enumItem : enumType.getItems()) {
                this.sb.appendFront("new GRGEN_LIBGR.EnumMember(" + enumItem.getValue().getValue() + ", \"" + ModelGen.formatIdentifiable(enumItem) + "\"),\n");
            }
            this.sb.unindent();
            this.sb.appendFront("});\n");
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genInheritanceTypes(Collection<? extends InheritanceType> collection, NodeEdgeEnumBearer nodeEdgeEnumBearer, String string, InheritanceTypeType inheritanceTypeType) {
        Collection<InheritanceType> collection2;
        if (inheritanceTypeType == InheritanceTypeType.Node) {
            collection2 = nodeEdgeEnumBearer.getNodeTypes();
            this.sb.appendFront("//\n");
            this.sb.appendFront("// Node types\n");
            this.sb.appendFront("//\n");
            this.sb.append("\n");
            this.sb.appendFront("public enum NodeTypes ");
        } else if (inheritanceTypeType == InheritanceTypeType.Edge) {
            collection2 = nodeEdgeEnumBearer.getEdgeTypes();
            this.sb.appendFront("//\n");
            this.sb.appendFront("// Edge types\n");
            this.sb.appendFront("//\n");
            this.sb.append("\n");
            this.sb.appendFront("public enum EdgeTypes ");
        } else if (inheritanceTypeType == InheritanceTypeType.Object) {
            collection2 = nodeEdgeEnumBearer.getObjectTypes();
            this.sb.appendFront("//\n");
            this.sb.appendFront("// Object types\n");
            this.sb.appendFront("//\n");
            this.sb.append("\n");
            this.sb.appendFront("public enum ObjectTypes ");
        } else {
            collection2 = nodeEdgeEnumBearer.getTransientObjectTypes();
            this.sb.appendFront("//\n");
            this.sb.appendFront("// Transient object types\n");
            this.sb.appendFront("//\n");
            this.sb.append("\n");
            this.sb.appendFront("public enum TransientObjectTypes ");
        }
        this.sb.append("{ ");
        Iterator<InheritanceType> iterator = collection2.iterator();
        while (iterator.hasNext()) {
            InheritanceType inheritanceType = iterator.next();
            this.sb.append("@" + ModelGen.formatIdentifiable(inheritanceType) + "=" + inheritanceType.getInheritanceTypeID());
            if (!iterator.hasNext()) continue;
            this.sb.append(", ");
        }
        this.sb.append(" }");
        this.sb.append(";\n");
        for (InheritanceType inheritanceType : collection2) {
            this.genInheritanceType(collection, inheritanceType, string, inheritanceTypeType);
        }
    }

    private void genInheritanceType(Collection<? extends InheritanceType> collection, InheritanceType inheritanceType, String string, InheritanceTypeType inheritanceTypeType) {
        this.sb.append("\n");
        this.sb.appendFront("// *** " + ModelGen.formatInheritanceTypeValue(inheritanceType) + " " + ModelGen.formatIdentifiable(inheritanceType) + " ***\n");
        this.sb.append("\n");
        if (!this.rootTypes.contains(inheritanceType.getIdent().toString())) {
            this.genInheritanceTypeInterface(inheritanceType);
        }
        if (!inheritanceType.isAbstract()) {
            if (inheritanceTypeType == InheritanceTypeType.Node || inheritanceTypeType == InheritanceTypeType.Edge) {
                this.genGraphElementImplementation(inheritanceType);
            } else {
                this.genObjectImplementation(inheritanceType);
            }
        }
        this.genTypeImplementation(collection, inheritanceType, string);
        this.genAttributeArrayHelpersAndComparers(inheritanceType);
    }

    private void genInheritanceTypeInterface(InheritanceType inheritanceType) {
        String string = "I" + this.getInheritanceTypePrefix(inheritanceType) + ModelGen.formatIdentifiable(inheritanceType);
        this.sb.appendFront("public interface " + string + " : ");
        this.genDirectSuperTypeList(inheritanceType);
        this.sb.append("\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        for (Entity entity : inheritanceType.getMembers()) {
            this.genAttributeAccess(inheritanceType, entity, "");
        }
        this.genMethodInterfaces(inheritanceType, inheritanceType.getFunctionMethods(), inheritanceType.getProcedureMethods(), "");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genDirectSuperTypeList(InheritanceType inheritanceType) {
        String string = "I" + this.getInheritanceTypePrefix(inheritanceType);
        Set<InheritanceType> set = inheritanceType.getDirectSuperTypes();
        boolean bl = true;
        for (InheritanceType inheritanceType2 : set) {
            if (this.rootTypes.contains(inheritanceType2.getIdent().toString())) {
                if (bl) {
                    bl = false;
                } else {
                    this.sb.append(", ");
                }
                this.sb.append(ModelGen.getRootElementInterfaceRef(inheritanceType2));
                continue;
            }
            if (bl) {
                bl = false;
            } else {
                this.sb.append(", ");
            }
            this.sb.append(ModelGen.getPackagePrefixDot(inheritanceType2) + string + ModelGen.formatIdentifiable(inheritanceType2));
        }
    }

    private void genAttributeAccess(InheritanceType inheritanceType, Entity entity, String string) {
        this.sb.appendFront(string);
        if (inheritanceType.getOverriddenMember(entity) != null) {
            this.sb.append("new ");
        }
        if (entity.isConst()) {
            this.sb.append(this.formatAttributeType(entity) + " @" + ModelGen.formatIdentifiable(entity) + " { get; }\n");
        } else {
            this.sb.append(this.formatAttributeType(entity) + " @" + ModelGen.formatIdentifiable(entity) + " { get; set; }\n");
        }
    }

    private void genMethodInterfaces(InheritanceType inheritanceType, Collection<FunctionMethod> collection, Collection<ProcedureMethod> collection2, String string) {
        for (FunctionMethod identifiable : collection) {
            if (inheritanceType.superTypeDefinesFunctionMethod(identifiable)) continue;
            this.sb.appendFront(this.formatType(identifiable.getReturnType()) + " ");
            this.sb.append(identifiable.getIdent().toString() + "(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv, GRGEN_LIBGR.IGraph graph");
            for (Entity entity : identifiable.getParameters()) {
                this.sb.append(", ");
                this.sb.append(this.formatType(entity.getType()));
                this.sb.append(" ");
                this.sb.append(ModelGen.formatEntity(entity));
            }
            this.sb.append(");\n");
            if (!this.model.areFunctionsParallel()) continue;
            this.sb.appendFront(this.formatType(identifiable.getReturnType()) + " ");
            this.sb.append(identifiable.getIdent().toString() + "(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv, GRGEN_LIBGR.IGraph graph");
            for (Entity entity : identifiable.getParameters()) {
                this.sb.append(", ");
                this.sb.append(this.formatType(entity.getType()));
                this.sb.append(" ");
                this.sb.append(ModelGen.formatEntity(entity));
            }
            this.sb.append(", int threadId");
            this.sb.append(");\n");
        }
        for (ProcedureMethod procedureMethod : collection2) {
            if (inheritanceType.superTypeDefinesProcedureMethod(procedureMethod)) continue;
            this.sb.appendFront("void ");
            this.sb.append(procedureMethod.getIdent().toString() + "(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv, GRGEN_LIBGR.IGraph graph");
            for (Entity entity : procedureMethod.getParameters()) {
                this.sb.append(", ");
                this.sb.append(this.formatType(entity.getType()));
                this.sb.append(" ");
                this.sb.append(ModelGen.formatEntity(entity));
            }
            int n = 0;
            for (Type type : procedureMethod.getReturnTypes()) {
                this.sb.append(", out ");
                this.sb.append(this.formatType(type));
                this.sb.append(" ");
                this.sb.append("_out_param_" + n);
                ++n;
            }
            this.sb.append(");\n");
        }
    }

    private void genGraphElementImplementation(InheritanceType inheritanceType) {
        boolean bl = inheritanceType instanceof NodeType;
        String string = bl ? "Node" : "Edge";
        String string2 = "GRGEN_LGSP.LGSP" + string;
        if (this.model.isUniqueResulting()) {
            string2 = string2 + "WithUniqueId";
        }
        if (this.model.isGraphofDefined()) {
            string2 = string2 + "WithReferenceToContainingGraph";
        }
        String string3 = this.formatInheritanceClassName(inheritanceType);
        String string4 = this.formatInheritanceClassRef(inheritanceType);
        String string5 = inheritanceType.getExternalName();
        String string6 = string5 != null ? "global::" + string5 : string4;
        String string7 = ModelGen.formatTypeClassRef(inheritanceType);
        String string8 = this.formatElementInterfaceRef(inheritanceType);
        String string9 = null;
        SourceBuilder sourceBuilder = this.sb;
        String string10 = string3;
        String string11 = string4;
        if (string5 == null) {
            this.sb.append("\n");
            this.sb.appendFront("public sealed partial class " + string3 + " : " + string2 + ", " + string8 + "\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
        } else {
            String string12;
            sourceBuilder = this.getStubBuffer();
            int n = string5.lastIndexOf(46);
            if (n != -1) {
                string9 = string5.substring(0, n);
                string12 = string5.substring(n + 1);
                this.stubsb.append("\n");
                this.stubsb.appendFront("namespace " + string9 + "\n");
                this.stubsb.appendFront("{\n");
                this.stubsb.indent();
            } else {
                string12 = string5;
            }
            string10 = string12;
            string11 = string12;
            this.stubsb.appendFront("public class " + string12 + " : " + string4 + "\n");
            this.stubsb.appendFront("{\n");
            this.stubsb.indent();
            this.stubsb.appendFront("public " + string12 + "() : base() { }\n");
            this.stubsb.append("\n");
            this.sb.append("\n");
            this.sb.appendFront("public abstract class " + string3 + " : " + string2 + ", " + string8 + "\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
        }
        this.sb.appendFront("[ThreadStatic] private static int poolLevel;\n");
        this.sb.appendFront("[ThreadStatic] private static " + string4 + "[] pool;\n");
        this.initAllMembersConst(inheritanceType, string3, "this");
        this.sb.append("\n");
        this.genElementConstructor(inheritanceType, string3, string7);
        this.sb.append("\n");
        this.genElementStaticTypeGetter(string7);
        this.sb.append("\n");
        ModelGen.genElementCloneMethod(inheritanceType, sourceBuilder, string11);
        sourceBuilder.append("\n");
        ModelGen.genElementCopyMethod(inheritanceType, sourceBuilder, string11);
        sourceBuilder.append("\n");
        this.genElementCopyConstructor(inheritanceType, string5, string7, sourceBuilder, string10, string11);
        sourceBuilder.append("\n");
        this.genElementAttributeComparisonMethod(inheritanceType, sourceBuilder, string10);
        sourceBuilder.append("\n");
        this.genElementCreateMethods(inheritanceType, bl, string4, string6);
        this.sb.append("\n");
        this.genElementRecycleMethod(string4);
        this.sb.append("\n");
        this.genAttributesAndAttributeAccessImpl(inheritanceType);
        this.genMethods(inheritanceType);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        if (string5 != null) {
            this.stubsb.unindent();
            this.stubsb.appendFront("}\n");
            if (string9 != null) {
                this.stubsb.unindent();
                this.stubsb.appendFront("}\n");
            }
        }
    }

    private void genObjectImplementation(InheritanceType inheritanceType) {
        String string = inheritanceType instanceof InternalTransientObjectType ? "TransientObject" : "Object";
        String string2 = this.formatInheritanceClassName(inheritanceType);
        String string3 = this.formatInheritanceClassRef(inheritanceType);
        assert (inheritanceType.getExternalName() == null);
        String string4 = ModelGen.formatTypeClassRef(inheritanceType);
        String string5 = this.formatElementInterfaceRef(inheritanceType);
        SourceBuilder sourceBuilder = this.sb;
        String string6 = string2;
        String string7 = string3;
        this.sb.append("\n");
        this.sb.appendFront("public sealed partial class " + string2 + " : GRGEN_LGSP.LGSP" + string + ", " + string5 + "\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.initAllMembersConst(inheritanceType, string2, "this");
        this.sb.append("\n");
        this.genElementConstructor(inheritanceType, string2, string4);
        this.sb.append("\n");
        this.genElementStaticTypeGetter(string4);
        this.sb.append("\n");
        ModelGen.genElementCloneMethod(inheritanceType, sourceBuilder, string7);
        sourceBuilder.append("\n");
        ModelGen.genElementCopyMethod(inheritanceType, sourceBuilder, string7);
        sourceBuilder.append("\n");
        this.genElementCopyConstructor(inheritanceType, null, string4, sourceBuilder, string6, string7);
        sourceBuilder.append("\n");
        this.genElementAttributeComparisonMethod(inheritanceType, sourceBuilder, string6);
        sourceBuilder.append("\n");
        this.genAttributesAndAttributeAccessImpl(inheritanceType);
        this.genMethods(inheritanceType);
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genElementConstructor(InheritanceType inheritanceType, String string, String string2) {
        if (inheritanceType instanceof NodeType) {
            this.sb.appendFront("public " + string + "() : base(" + string2 + ".typeVar)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.initAllMembersNonConst(inheritanceType, "this", false, false);
            this.sb.unindent();
            this.sb.appendFront("}\n");
        } else if (inheritanceType instanceof EdgeType) {
            this.sb.appendFront("public " + string + "(GRGEN_LGSP.LGSPNode source, GRGEN_LGSP.LGSPNode target)\n");
            this.sb.appendFrontIndented(": base(" + string2 + ".typeVar, source, target)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.initAllMembersNonConst(inheritanceType, "this", false, false);
            this.sb.unindent();
            this.sb.appendFront("}\n");
        } else if (inheritanceType instanceof InternalObjectType) {
            this.sb.appendFront("//create object by CreateObject of the type class, not this internal-use constructor\n");
            this.sb.appendFront("public " + string + "(long uniqueId) : base(" + string2 + ".typeVar, uniqueId)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.initAllMembersNonConst(inheritanceType, "this", false, false);
            this.sb.unindent();
            this.sb.appendFront("}\n");
        } else {
            this.sb.appendFront("//create object by CreateTransientObject of the type class, not this internal-use constructor\n");
            this.sb.appendFront("public " + string + "() : base(" + string2 + ".typeVar)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.initAllMembersNonConst(inheritanceType, "this", false, false);
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    private void genElementStaticTypeGetter(String string) {
        this.sb.appendFront("public static " + string + " TypeInstance { get { return " + string + ".typeVar; } }\n");
    }

    private static void genElementCloneMethod(InheritanceType inheritanceType, SourceBuilder sourceBuilder, String string) {
        if (inheritanceType instanceof NodeType) {
            sourceBuilder.appendFront("public override GRGEN_LIBGR.INode Clone() {\n");
            sourceBuilder.appendFrontIndented("return new " + string + "(this, null, null);\n");
            sourceBuilder.appendFront("}\n");
        } else if (inheritanceType instanceof EdgeType) {
            sourceBuilder.appendFront("public override GRGEN_LIBGR.IEdge Clone(GRGEN_LIBGR.INode newSource, GRGEN_LIBGR.INode newTarget) {\n");
            sourceBuilder.appendFrontIndented("return new " + string + "(this, (GRGEN_LGSP.LGSPNode) newSource, (GRGEN_LGSP.LGSPNode) newTarget, null, null);\n");
            sourceBuilder.appendFront("}\n");
        } else if (inheritanceType instanceof InternalTransientObjectType) {
            sourceBuilder.appendFront("public override GRGEN_LIBGR.ITransientObject Clone() {\n");
            sourceBuilder.appendFrontIndented("return new " + string + "(this, null, null);\n");
            sourceBuilder.appendFront("}\n");
        } else {
            sourceBuilder.appendFront("public override GRGEN_LIBGR.IObject Clone(GRGEN_LIBGR.IGraph graph) {\n");
            sourceBuilder.indent();
            sourceBuilder.appendFront(string + " newObject = new " + string + "(this, graph, null);\n");
            sourceBuilder.appendFront("((GRGEN_LIBGR.BaseGraph)graph).ObjectCreated(newObject);\n");
            sourceBuilder.appendFront("return newObject;\n");
            sourceBuilder.unindent();
            sourceBuilder.appendFront("}\n");
        }
    }

    private static void genElementCopyMethod(InheritanceType inheritanceType, SourceBuilder sourceBuilder, String string) {
        if (inheritanceType instanceof NodeType) {
            sourceBuilder.appendFront("public override GRGEN_LIBGR.INode Copy(GRGEN_LIBGR.IGraph graph, IDictionary<object, object> oldToNewObjectMap) {\n");
            sourceBuilder.appendFrontIndented("return new " + string + "(this, graph, oldToNewObjectMap);\n");
            sourceBuilder.appendFront("}\n");
        } else if (inheritanceType instanceof EdgeType) {
            sourceBuilder.appendFront("public override GRGEN_LIBGR.IEdge Copy(GRGEN_LIBGR.INode newSource, GRGEN_LIBGR.INode newTarget, GRGEN_LIBGR.IGraph graph, IDictionary<object, object> oldToNewObjectMap) {\n");
            sourceBuilder.appendFrontIndented("return new " + string + "(this, (GRGEN_LGSP.LGSPNode) newSource, (GRGEN_LGSP.LGSPNode) newTarget, graph, oldToNewObjectMap);\n");
            sourceBuilder.appendFront("}\n");
        } else if (inheritanceType instanceof InternalTransientObjectType) {
            sourceBuilder.appendFront("public override GRGEN_LIBGR.ITransientObject Copy(GRGEN_LIBGR.IGraph graph, IDictionary<object, object> oldToNewObjectMap) {\n");
            sourceBuilder.appendFrontIndented("return new " + string + "(this, graph, oldToNewObjectMap);\n");
            sourceBuilder.appendFront("}\n");
        } else {
            sourceBuilder.appendFront("public override GRGEN_LIBGR.IObject Copy(GRGEN_LIBGR.IGraph graph, IDictionary<object, object> oldToNewObjectMap) {\n");
            sourceBuilder.indent();
            sourceBuilder.appendFront(string + " newObject = new " + string + "(this, graph, oldToNewObjectMap);\n");
            sourceBuilder.appendFront("((GRGEN_LIBGR.BaseGraph)graph).ObjectCreated(newObject);\n");
            sourceBuilder.appendFront("return newObject;\n");
            sourceBuilder.unindent();
            sourceBuilder.appendFront("}\n");
        }
    }

    private void genContainerCopying(SourceBuilder sourceBuilder, Entity entity, String string) {
        if (entity.getType() instanceof ArrayType || entity.getType() instanceof DequeType) {
            String string2 = entity.getType() instanceof ArrayType ? this.formatAttributeType(((ArrayType)entity.getType()).getValueType()) : this.formatAttributeType(((DequeType)entity.getType()).getValueType());
            sourceBuilder.appendFront("for(int i = 0; i < oldElem." + string + ATTR_IMPL_SUFFIX + ".Count; ++i)\n");
            sourceBuilder.appendFront("{\n");
            sourceBuilder.appendFrontIndented(string + ATTR_IMPL_SUFFIX + ".Add((" + string2 + ")Copy(oldElem." + string + ATTR_IMPL_SUFFIX + "[i], graph, oldToNewObjectMap));\n");
            sourceBuilder.appendFront("}\n");
        } else if (entity.getType() instanceof SetType) {
            SetType setType = (SetType)entity.getType();
            String string3 = this.formatAttributeType(setType.getValueType());
            sourceBuilder.appendFront("foreach(KeyValuePair<" + string3 + ", GRGEN_LIBGR.SetValueType> kvp in oldElem." + string + ATTR_IMPL_SUFFIX + ")\n");
            sourceBuilder.appendFront("{\n");
            String string4 = "(" + string3 + ")Copy(kvp.Key, graph, oldToNewObjectMap)";
            sourceBuilder.appendFrontIndented(string + ATTR_IMPL_SUFFIX + "[" + string4 + "] = null;\n");
            sourceBuilder.appendFront("}\n");
        } else if (entity.getType() instanceof MapType) {
            MapType mapType = (MapType)entity.getType();
            String string5 = this.formatAttributeType(mapType.getKeyType());
            String string6 = this.formatAttributeType(mapType.getValueType());
            sourceBuilder.appendFront("foreach(KeyValuePair<" + string5 + "," + string6 + "> kvp in oldElem." + string + ATTR_IMPL_SUFFIX + ")\n");
            sourceBuilder.appendFront("{\n");
            String string7 = "kvp.Key";
            if (mapType.getKeyType() instanceof BaseInternalObjectType) {
                string7 = "(" + string5 + ")Copy(kvp.Key, graph, oldToNewObjectMap)";
            }
            String string8 = "kvp.Value";
            if (mapType.getValueType() instanceof BaseInternalObjectType) {
                string8 = "(" + string6 + ")Copy(kvp.Value, graph, oldToNewObjectMap)";
            }
            sourceBuilder.appendFrontIndented(string + ATTR_IMPL_SUFFIX + "[" + string7 + "] = " + string8 + ";\n");
            sourceBuilder.appendFront("}\n");
        }
    }

    private void genElementCopyConstructor(InheritanceType inheritanceType, String string, String string2, SourceBuilder sourceBuilder, String string3, String string4) {
        if (inheritanceType instanceof NodeType) {
            sourceBuilder.appendFront("private " + string3 + "(" + string4 + " oldElem, GRGEN_LIBGR.IGraph graph, IDictionary<object, object> oldToNewObjectMap) : base(" + (string == null ? string2 + ".typeVar" : "") + ")\n");
        } else if (inheritanceType instanceof EdgeType) {
            sourceBuilder.appendFront("private " + string3 + "(" + string4 + " oldElem, GRGEN_LGSP.LGSPNode newSource, GRGEN_LGSP.LGSPNode newTarget, GRGEN_LIBGR.IGraph graph, IDictionary<object, object> oldToNewObjectMap)\n");
            sourceBuilder.appendFrontIndented(": base(" + (string == null ? string2 + ".typeVar, " : "") + "newSource, newTarget)\n");
        } else if (inheritanceType instanceof InternalObjectType) {
            sourceBuilder.appendFront("private " + string3 + "(" + string4 + " oldElem, GRGEN_LIBGR.IGraph graph, IDictionary<object, object> oldToNewObjectMap) : base(" + (string == null ? string2 + ".typeVar, " : "") + (this.model.isUniqueClassDefined() ? "graph.GlobalVariables.FetchObjectUniqueId()" : "-1") + ")\n");
        } else {
            sourceBuilder.appendFront("private " + string3 + "(" + string4 + " oldElem, GRGEN_LIBGR.IGraph graph, IDictionary<object, object> oldToNewObjectMap) : base(" + (string == null ? string2 + ".typeVar" : "") + ")\n");
        }
        sourceBuilder.appendFront("{\n");
        sourceBuilder.indent();
        if (this.model.isUniqueResulting() && (inheritanceType instanceof NodeType || inheritanceType instanceof EdgeType)) {
            sourceBuilder.appendFront("uniqueId = oldElem.uniqueId;\n");
        }
        if (inheritanceType instanceof InternalObjectType || inheritanceType instanceof InternalTransientObjectType) {
            sourceBuilder.appendFront("if(oldToNewObjectMap != null)\n");
            sourceBuilder.appendFrontIndented("oldToNewObjectMap.Add(oldElem, this);\n");
        }
        for (Entity entity : inheritanceType.getAllMembers()) {
            if (entity.isConst()) continue;
            String string5 = ModelGen.formatIdentifiable(entity);
            if (entity.getType() instanceof ContainerType) {
                if (inheritanceType instanceof InternalTransientObjectType) {
                    sourceBuilder.appendFront("if(oldToNewObjectMap != null) {\n");
                    sourceBuilder.indent();
                    if (((ContainerType)entity.getType()).containsBaseInternalObjectType()) {
                        this.sb.appendFront(string5 + ATTR_IMPL_SUFFIX + " = new " + this.formatAttributeType(entity.getType()) + "();\n");
                        this.genContainerCopying(sourceBuilder, entity, string5);
                    } else {
                        this.sb.appendFront(string5 + ATTR_IMPL_SUFFIX + " = new " + this.formatAttributeType(entity.getType()) + "(oldElem." + string5 + ATTR_IMPL_SUFFIX + ");\n");
                    }
                    sourceBuilder.unindent();
                    sourceBuilder.appendFront("} else\n");
                    sourceBuilder.appendFrontIndented(string5 + ATTR_IMPL_SUFFIX + " = oldElem." + string5 + ATTR_IMPL_SUFFIX + ";\n");
                    continue;
                }
                if (((ContainerType)entity.getType()).containsBaseInternalObjectType()) {
                    sourceBuilder.appendFront("if(oldToNewObjectMap != null) {\n");
                    sourceBuilder.indent();
                    this.sb.appendFront(string5 + ATTR_IMPL_SUFFIX + " = new " + this.formatAttributeType(entity.getType()) + "();\n");
                    this.genContainerCopying(sourceBuilder, entity, string5);
                    sourceBuilder.unindent();
                    sourceBuilder.appendFront("} else\n");
                    this.sb.appendFrontIndented(string5 + ATTR_IMPL_SUFFIX + " = new " + this.formatAttributeType(entity.getType()) + "(oldElem." + string5 + ATTR_IMPL_SUFFIX + ");\n");
                    continue;
                }
                this.sb.appendFront(string5 + ATTR_IMPL_SUFFIX + " = new " + this.formatAttributeType(entity.getType()) + "(oldElem." + string5 + ATTR_IMPL_SUFFIX + ");\n");
                continue;
            }
            if (this.model.isCopyClassDefined() && (entity.getType().classify() == Type.TypeClass.IS_EXTERNAL_CLASS_OBJECT || entity.getType().classify() == Type.TypeClass.IS_OBJECT)) {
                sourceBuilder.appendFront("if(oldToNewObjectMap != null) {\n");
                sourceBuilder.indent();
                sourceBuilder.appendFront("AttributeTypeObjectCopierComparer.Copy(oldElem." + string5 + ATTR_IMPL_SUFFIX + ", graph, oldToNewObjectMap);\n");
                sourceBuilder.unindent();
                sourceBuilder.appendFront("} else\n");
                sourceBuilder.appendFrontIndented(string5 + ATTR_IMPL_SUFFIX + " = oldElem." + string5 + ATTR_IMPL_SUFFIX + ";\n");
                continue;
            }
            if (entity.getType() instanceof BaseInternalObjectType) {
                sourceBuilder.appendFront("if(oldToNewObjectMap != null) {\n");
                sourceBuilder.appendFrontIndented(string5 + ATTR_IMPL_SUFFIX + " = (" + this.formatAttributeType(entity.getType()) + ")Copy(oldElem." + string5 + ATTR_IMPL_SUFFIX + ", graph, oldToNewObjectMap);\n");
                sourceBuilder.appendFront("} else\n");
                sourceBuilder.appendFrontIndented(string5 + ATTR_IMPL_SUFFIX + " = oldElem." + string5 + ATTR_IMPL_SUFFIX + ";\n");
                continue;
            }
            sourceBuilder.appendFront(string5 + ATTR_IMPL_SUFFIX + " = oldElem." + string5 + ATTR_IMPL_SUFFIX + ";\n");
        }
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        sourceBuilder.appendFront("\n");
        ModelGen.genCopyHelper(sourceBuilder, string3);
    }

    private static void genCopyHelper(SourceBuilder sourceBuilder, String string) {
        sourceBuilder.appendFront("private GRGEN_LIBGR.IBaseObject Copy(GRGEN_LIBGR.IBaseObject oldObj, GRGEN_LIBGR.IGraph graph, IDictionary<object, object> oldToNewObjectMap)\n");
        sourceBuilder.appendFront("{\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("if(oldObj == null)\n");
        sourceBuilder.appendFrontIndented("return null;\n");
        sourceBuilder.appendFront("if(oldToNewObjectMap.ContainsKey(oldObj))\n");
        sourceBuilder.appendFrontIndented("return (GRGEN_LIBGR.IBaseObject)oldToNewObjectMap[oldObj];\n");
        sourceBuilder.appendFront("else {\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("if(oldObj is GRGEN_LIBGR.IObject) {\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("GRGEN_LIBGR.IObject newObj = ((GRGEN_LIBGR.IObject)oldObj).Copy(graph, oldToNewObjectMap);\n");
        sourceBuilder.appendFront("return newObj;\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("} else {\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("GRGEN_LIBGR.ITransientObject newObj = ((GRGEN_LIBGR.ITransientObject)oldObj).Copy(graph, oldToNewObjectMap);\n");
        sourceBuilder.appendFront("return newObj;\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
    }

    private void genElementAttributeComparisonMethod(InheritanceType inheritanceType, SourceBuilder sourceBuilder, String string) {
        sourceBuilder.appendFront("public override bool IsDeeplyEqual(GRGEN_LIBGR.IDeepEqualityComparer that, IDictionary<object, object> visitedObjects) {\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("if(visitedObjects.ContainsKey(this) || visitedObjects.ContainsKey(that))\n");
        sourceBuilder.appendFrontIndented("throw new Exception(\"Multiple appearances (and cycles) forbidden in deep equality comparison (only tree-like structures are supported)!\");\n");
        sourceBuilder.appendFront("if(this == that)\n");
        sourceBuilder.appendFrontIndented("return true;\n");
        sourceBuilder.appendFront("if(!(that is " + string + "))\n");
        sourceBuilder.appendFrontIndented("return false;\n");
        sourceBuilder.appendFront(string + " that_ = (" + string + ")that;\n");
        sourceBuilder.appendFront("visitedObjects.Add(this, null);\n");
        sourceBuilder.appendFront("if(that != this)\n");
        sourceBuilder.appendFrontIndented("visitedObjects.Add(that, null);\n");
        sourceBuilder.appendFront("bool result = true\n");
        sourceBuilder.indent();
        for (Entity entity : inheritanceType.getAllMembers()) {
            if (entity.isConst()) continue;
            String string2 = ModelGen.formatIdentifiable(entity);
            if (entity.getType() instanceof MapType || entity.getType() instanceof SetType || entity.getType() instanceof ArrayType || entity.getType() instanceof DequeType) {
                sourceBuilder.appendFront("&& GRGEN_LIBGR.ContainerHelper.DeeplyEqual(" + string2 + ATTR_IMPL_SUFFIX + ", that_." + string2 + ATTR_IMPL_SUFFIX + ", visitedObjects)\n");
                continue;
            }
            if (this.model.isEqualClassDefined() && (entity.getType().classify() == Type.TypeClass.IS_EXTERNAL_CLASS_OBJECT || entity.getType().classify() == Type.TypeClass.IS_OBJECT)) {
                sourceBuilder.appendFront("&& AttributeTypeObjectCopierComparer.IsEqual(" + string2 + ATTR_IMPL_SUFFIX + ", that_." + string2 + ATTR_IMPL_SUFFIX + ", visitedObjects)\n");
                continue;
            }
            if (entity.getType().classify() == Type.TypeClass.IS_GRAPH) {
                sourceBuilder.appendFront("&& GRGEN_LIBGR.GraphHelper.Equal(" + string2 + ATTR_IMPL_SUFFIX + ", that_." + string2 + ATTR_IMPL_SUFFIX + ")\n");
                continue;
            }
            if (entity.getType().classify() == Type.TypeClass.IS_INTERNAL_CLASS_OBJECT || entity.getType().classify() == Type.TypeClass.IS_INTERNAL_TRANSIENT_CLASS_OBJECT || entity.getType().classify() == Type.TypeClass.IS_NODE || entity.getType().classify() == Type.TypeClass.IS_EDGE) {
                sourceBuilder.appendFront("&& GRGEN_LIBGR.ContainerHelper.DeeplyEqual(" + string2 + ATTR_IMPL_SUFFIX + ", that_." + string2 + ATTR_IMPL_SUFFIX + ", visitedObjects)\n");
                continue;
            }
            sourceBuilder.appendFront("&& " + string2 + ATTR_IMPL_SUFFIX + " == that_." + string2 + ATTR_IMPL_SUFFIX + "\n");
        }
        sourceBuilder.appendFront(";\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("visitedObjects.Remove(this);\n");
        sourceBuilder.appendFront("visitedObjects.Remove(that);\n");
        sourceBuilder.appendFront("return result;\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
    }

    private void genElementCreateMethods(InheritanceType inheritanceType, boolean bl, String string, String string2) {
        if (bl) {
            this.sb.appendFront("public static " + string + " CreateNode(GRGEN_LGSP.LGSPGraph graph)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront(string + " node;\n");
            this.sb.appendFront("if(poolLevel == 0)\n");
            this.sb.appendFrontIndented("node = new " + string2 + "();\n");
            this.sb.appendFront("else\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("if(pool == null)\n");
            this.sb.appendFrontIndented("pool = new " + string + "[GRGEN_LGSP.LGSPGraph.poolSize];\n");
            this.sb.appendFront("node = pool[--poolLevel];\n");
            this.sb.appendFront("node.lgspInhead = null;\n");
            this.sb.appendFront("node.lgspOuthead = null;\n");
            this.sb.appendFront("node.lgspFlags &= ~(uint) GRGEN_LGSP.LGSPElemFlags.HAS_VARIABLES;\n");
            this.initAllMembersNonConst(inheritanceType, "node", true, false);
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("graph.AddNode(node);\n");
            this.sb.appendFront("return node;\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.append("\n");
            this.sb.appendFront("public static " + string + " CreateNode(GRGEN_LGSP.LGSPNamedGraph graph, string nodeName)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront(string + " node;\n");
            this.sb.appendFront("if(poolLevel == 0)\n");
            this.sb.appendFrontIndented("node = new " + string2 + "();\n");
            this.sb.appendFront("else\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("if(pool == null)\n");
            this.sb.appendFrontIndented("pool = new " + string + "[GRGEN_LGSP.LGSPGraph.poolSize];\n");
            this.sb.appendFront("node = pool[--poolLevel];\n");
            this.sb.appendFront("node.lgspInhead = null;\n");
            this.sb.appendFront("node.lgspOuthead = null;\n");
            this.sb.appendFront("node.lgspFlags &= ~(uint) GRGEN_LGSP.LGSPElemFlags.HAS_VARIABLES;\n");
            this.initAllMembersNonConst(inheritanceType, "node", true, false);
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("graph.AddNode(node, nodeName);\n");
            this.sb.appendFront("return node;\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        } else {
            this.sb.appendFront("public static " + string + " CreateEdge(GRGEN_LGSP.LGSPGraph graph, GRGEN_LGSP.LGSPNode source, GRGEN_LGSP.LGSPNode target)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront(string + " edge;\n");
            this.sb.appendFront("if(poolLevel == 0)\n");
            this.sb.appendFrontIndented("edge = new " + string2 + "(source, target);\n");
            this.sb.appendFront("else\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("if(pool == null)\n");
            this.sb.appendFrontIndented("pool = new " + string + "[GRGEN_LGSP.LGSPGraph.poolSize];\n");
            this.sb.appendFront("edge = pool[--poolLevel];\n");
            this.sb.appendFront("edge.lgspFlags &= ~(uint) GRGEN_LGSP.LGSPElemFlags.HAS_VARIABLES;\n");
            this.sb.appendFront("edge.lgspSource = source;\n");
            this.sb.appendFront("edge.lgspTarget = target;\n");
            this.initAllMembersNonConst(inheritanceType, "edge", true, false);
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("graph.AddEdge(edge);\n");
            this.sb.appendFront("return edge;\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.append("\n");
            this.sb.appendFront("public static " + string + " CreateEdge(GRGEN_LGSP.LGSPNamedGraph graph, GRGEN_LGSP.LGSPNode source, GRGEN_LGSP.LGSPNode target, string edgeName)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront(string + " edge;\n");
            this.sb.appendFront("if(poolLevel == 0)\n");
            this.sb.appendFrontIndented("edge = new " + string2 + "(source, target);\n");
            this.sb.appendFront("else\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("if(pool == null)\n");
            this.sb.appendFrontIndented("pool = new " + string + "[GRGEN_LGSP.LGSPGraph.poolSize];\n");
            this.sb.appendFront("edge = pool[--poolLevel];\n");
            this.sb.appendFront("edge.lgspFlags &= ~(uint) GRGEN_LGSP.LGSPElemFlags.HAS_VARIABLES;\n");
            this.sb.appendFront("edge.lgspSource = source;\n");
            this.sb.appendFront("edge.lgspTarget = target;\n");
            this.initAllMembersNonConst(inheritanceType, "edge", true, false);
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("graph.AddEdge(edge, edgeName);\n");
            this.sb.appendFront("return edge;\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    private void genElementRecycleMethod(String string) {
        this.sb.appendFront("public override void Recycle()\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(pool == null)\n");
        this.sb.appendFrontIndented("pool = new " + string + "[GRGEN_LGSP.LGSPGraph.poolSize];\n");
        this.sb.appendFront("if(poolLevel < pool.Length)\n");
        this.sb.appendFrontIndented("pool[poolLevel++] = this;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void initAllMembersNonConst(InheritanceType inheritanceType, String string, boolean bl, boolean bl2) {
        this.curMemberOwner = string;
        if (!bl2 && ModelGen.initializationOperationsCount(inheritanceType) > 20) {
            this.sb.appendFront(string + ".ResetAllAttributes();\n");
            this.curMemberOwner = null;
            return;
        }
        this.sb.appendFront("// implicit initialization, container creation of " + ModelGen.formatIdentifiable(inheritanceType) + "\n");
        if (bl) {
            this.genDefaultInits(inheritanceType, string);
        }
        this.genContainerInits(inheritanceType, string);
        for (InheritanceType inheritanceType2 : inheritanceType.getAllSuperTypes()) {
            this.genMemberInitsNonConst(inheritanceType2, inheritanceType, string, bl, bl2);
        }
        this.genMemberInitsNonConst(inheritanceType, inheritanceType, string, bl, bl2);
        this.curMemberOwner = null;
    }

    private void genDefaultInits(InheritanceType inheritanceType, String string) {
        for (Entity entity : inheritanceType.getAllMembers()) {
            Type type;
            if (entity.isConst() || (type = entity.getType()) instanceof MapType || type instanceof SetType || type instanceof ArrayType || type instanceof DequeType) continue;
            String string2 = ModelGen.formatIdentifiable(entity);
            this.sb.appendFront(string + ".@" + string2 + " = ");
            if (type instanceof ByteType || type instanceof ShortType || type instanceof IntType || type instanceof EnumType || type instanceof DoubleType) {
                this.sb.append("0;\n");
                continue;
            }
            if (type instanceof FloatType) {
                this.sb.append("0f;\n");
                continue;
            }
            if (type instanceof LongType) {
                this.sb.append("0L;\n");
                continue;
            }
            if (type instanceof BooleanType) {
                this.sb.append("false;\n");
                continue;
            }
            if (type instanceof StringType || type instanceof ObjectType || type instanceof VoidType || type instanceof ExternalObjectType || type instanceof GraphType || type instanceof InheritanceType) {
                this.sb.append("null;\n");
                continue;
            }
            throw new IllegalArgumentException("Unknown Entity: " + entity + "(" + type + ")");
        }
    }

    private void genContainerInits(InheritanceType inheritanceType, String string) {
        for (Entity entity : inheritanceType.getAllMembers()) {
            ContainerType containerType;
            Type type;
            if (entity.isConst() || !((type = entity.getType()) instanceof MapType) && !(type instanceof SetType) && !(type instanceof ArrayType) && !(type instanceof DequeType)) continue;
            String string2 = ModelGen.formatIdentifiable(entity);
            this.sb.appendFront(string + ".@" + string2 + " = ");
            if (type instanceof MapType) {
                containerType = (MapType)type;
                this.sb.append("new " + this.formatAttributeType(containerType) + "();\n");
                continue;
            }
            if (type instanceof SetType) {
                containerType = (SetType)type;
                this.sb.append("new " + this.formatAttributeType(containerType) + "();\n");
                continue;
            }
            if (type instanceof ArrayType) {
                containerType = (ArrayType)type;
                this.sb.append("new " + this.formatAttributeType(containerType) + "();\n");
                continue;
            }
            if (!(type instanceof DequeType)) continue;
            containerType = (DequeType)type;
            this.sb.append("new " + this.formatAttributeType(containerType) + "();\n");
        }
    }

    private static int initializationOperationsCount(InheritanceType inheritanceType) {
        int n = 0;
        for (InheritanceType iR : inheritanceType.getAllSuperTypes()) {
            block1: for (MemberInit memberInit : iR.getMemberInits()) {
                if (memberInit.getMember().isConst()) continue;
                for (MemberInit memberInit2 : inheritanceType.getMemberInits()) {
                    if (memberInit.getMember() != memberInit2.getMember()) continue;
                    continue block1;
                }
                ++n;
            }
            block3: for (MapInit mapInit : iR.getMapInits()) {
                if (mapInit.getMember().isConst()) continue;
                for (MapInit mapInit2 : inheritanceType.getMapInits()) {
                    if (mapInit.getMember() != mapInit2.getMember()) continue;
                    continue block3;
                }
                n += mapInit.getMapItems().size();
            }
            block5: for (SetInit setInit : iR.getSetInits()) {
                if (setInit.getMember().isConst()) continue;
                for (SetInit setInit2 : inheritanceType.getSetInits()) {
                    if (setInit.getMember() != setInit2.getMember()) continue;
                    continue block5;
                }
                n += setInit.getSetItems().size();
            }
            block7: for (ArrayInit arrayInit : iR.getArrayInits()) {
                if (arrayInit.getMember().isConst()) continue;
                for (ArrayInit arrayInit2 : inheritanceType.getArrayInits()) {
                    if (arrayInit.getMember() != arrayInit2.getMember()) continue;
                    continue block7;
                }
                n += arrayInit.getArrayItems().size();
            }
            block9: for (DequeInit dequeInit : iR.getDequeInits()) {
                if (dequeInit.getMember().isConst()) continue;
                for (DequeInit dequeInit2 : inheritanceType.getDequeInits()) {
                    if (dequeInit.getMember() != dequeInit2.getMember()) continue;
                    continue block9;
                }
                n += dequeInit.getDequeItems().size();
            }
        }
        for (MemberInit memberInit : inheritanceType.getMemberInits()) {
            if (memberInit.getMember().isConst()) continue;
            ++n;
        }
        for (MapInit mapInit : inheritanceType.getMapInits()) {
            if (mapInit.getMember().isConst()) continue;
            n += mapInit.getMapItems().size();
        }
        for (SetInit setInit : inheritanceType.getSetInits()) {
            if (setInit.getMember().isConst()) continue;
            n += setInit.getSetItems().size();
        }
        for (ArrayInit arrayInit : inheritanceType.getArrayInits()) {
            if (arrayInit.getMember().isConst()) continue;
            n += arrayInit.getArrayItems().size();
        }
        for (DequeInit dequeInit : inheritanceType.getDequeInits()) {
            if (dequeInit.getMember().isConst()) continue;
            n += dequeInit.getDequeItems().size();
        }
        return n;
    }

    private void initAllMembersConst(InheritanceType inheritanceType, String string, String string2) {
        this.curMemberOwner = string2;
        LinkedList<String> linkedList = new LinkedList<String>();
        this.sb.append("\n");
        for (InheritanceType object : inheritanceType.getAllSuperTypes()) {
            this.genMemberInitsConst(object, inheritanceType, linkedList);
        }
        this.genMemberInitsConst(inheritanceType, inheritanceType, linkedList);
        this.sb.appendFront("static " + string + "() {\n");
        this.sb.indent();
        for (String string3 : linkedList) {
            this.sb.appendFront(string3 + "();\n");
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.curMemberOwner = null;
    }

    private void genMemberInitsNonConst(InheritanceType inheritanceType, InheritanceType inheritanceType2, String string, boolean bl, boolean bl2) {
        if (this.rootTypes.contains(inheritanceType.getIdent().toString())) {
            return;
        }
        this.sb.appendFront("// explicit initializations of " + ModelGen.formatIdentifiable(inheritanceType) + " for target " + ModelGen.formatIdentifiable(inheritanceType2) + "\n");
        this.genMemberInitsNonConstPrimitiveType(inheritanceType, inheritanceType2, string);
        this.genMemberInitsNonConstMapType(inheritanceType, inheritanceType2, string);
        this.genMemberInitsNonConstSetType(inheritanceType, inheritanceType2, string);
        this.genMemberInitsNonConstArrayType(inheritanceType, inheritanceType2, string);
        this.genMemberInitsNonConstDequeType(inheritanceType, inheritanceType2, string);
    }

    private void genMemberInitsNonConstPrimitiveType(InheritanceType inheritanceType, InheritanceType inheritanceType2, String string) {
        NeededEntities neededEntities = new NeededEntities(EnumSet.of(NeededEntities.Needs.MEMBERS));
        for (MemberInit memberInit : inheritanceType.getMemberInits()) {
            memberInit.getExpression().collectNeededEntities(neededEntities);
        }
        for (MemberInit memberInit : inheritanceType2.getMemberInits()) {
            memberInit.getExpression().collectNeededEntities(neededEntities);
        }
        for (MemberInit memberInit : inheritanceType.getMemberInits()) {
            Entity entity = memberInit.getMember();
            if (memberInit.getMember().isConst() || !neededEntities.members.contains(entity) && !ModelGen.generateInitializationOfTypeAtCreatingTargetTypeInitialization(entity, inheritanceType, inheritanceType2)) continue;
            String string2 = ModelGen.formatIdentifiable(memberInit.getMember());
            this.sb.appendFront(string + ".@" + string2 + " = ");
            this.genExpression(this.sb, memberInit.getExpression(), null);
            this.sb.append(";\n");
        }
    }

    private void genMemberInitsNonConstMapType(InheritanceType inheritanceType, InheritanceType inheritanceType2, String string) {
        for (MapInit mapInit : inheritanceType.getMapInits()) {
            Entity entity = mapInit.getMember();
            if (mapInit.getMember().isConst() || !ModelGen.generateInitializationOfTypeAtCreatingTargetTypeInitialization(entity, inheritanceType, inheritanceType2)) continue;
            String string2 = ModelGen.formatIdentifiable(mapInit.getMember());
            for (ExpressionPair expressionPair : mapInit.getMapItems()) {
                this.sb.appendFront(string + ".@" + string2 + "[");
                this.genExpression(this.sb, expressionPair.getKeyExpr(), null);
                this.sb.append("] = ");
                this.genExpression(this.sb, expressionPair.getValueExpr(), null);
                this.sb.append(";\n");
            }
        }
    }

    private void genMemberInitsNonConstSetType(InheritanceType inheritanceType, InheritanceType inheritanceType2, String string) {
        for (SetInit setInit : inheritanceType.getSetInits()) {
            Entity entity = setInit.getMember();
            if (setInit.getMember().isConst() || !ModelGen.generateInitializationOfTypeAtCreatingTargetTypeInitialization(entity, inheritanceType, inheritanceType2)) continue;
            String string2 = ModelGen.formatIdentifiable(setInit.getMember());
            for (Expression expression : setInit.getSetItems()) {
                this.sb.appendFront(string + ".@" + string2 + "[");
                this.genExpression(this.sb, expression, null);
                this.sb.append("] = null;\n");
            }
        }
    }

    private void genMemberInitsNonConstArrayType(InheritanceType inheritanceType, InheritanceType inheritanceType2, String string) {
        for (ArrayInit arrayInit : inheritanceType.getArrayInits()) {
            Entity entity = arrayInit.getMember();
            if (arrayInit.getMember().isConst() || !ModelGen.generateInitializationOfTypeAtCreatingTargetTypeInitialization(entity, inheritanceType, inheritanceType2)) continue;
            String string2 = ModelGen.formatIdentifiable(arrayInit.getMember());
            for (Expression expression : arrayInit.getArrayItems()) {
                this.sb.appendFront(string + ".@" + string2 + ".Add(");
                this.genExpression(this.sb, expression, null);
                this.sb.append(");\n");
            }
        }
    }

    private void genMemberInitsNonConstDequeType(InheritanceType inheritanceType, InheritanceType inheritanceType2, String string) {
        for (DequeInit dequeInit : inheritanceType.getDequeInits()) {
            Entity entity = dequeInit.getMember();
            if (dequeInit.getMember().isConst() || !ModelGen.generateInitializationOfTypeAtCreatingTargetTypeInitialization(entity, inheritanceType, inheritanceType2)) continue;
            String string2 = ModelGen.formatIdentifiable(dequeInit.getMember());
            for (Expression expression : dequeInit.getDequeItems()) {
                this.sb.appendFront(string + ".@" + string2 + ".Add(");
                this.genExpression(this.sb, expression, null);
                this.sb.append(");\n");
            }
        }
    }

    private void genMemberInitsConst(InheritanceType inheritanceType, InheritanceType inheritanceType2, List<String> list) {
        if (this.rootTypes.contains(inheritanceType.getIdent().toString())) {
            return;
        }
        this.sb.appendFront("// explicit initializations of " + ModelGen.formatIdentifiable(inheritanceType) + " for target " + ModelGen.formatIdentifiable(inheritanceType2) + "\n");
        HashSet<Entity> hashSet = new HashSet<Entity>();
        this.genMemberInitsConstPrimitiveType(inheritanceType, inheritanceType2, hashSet);
        this.genMemberInitsConstMapType(inheritanceType, inheritanceType2, list, hashSet);
        this.genMemberInitsConstSetType(inheritanceType, inheritanceType2, list, hashSet);
        this.genMemberInitsConstArrayType(inheritanceType, inheritanceType2, list, hashSet);
        this.genMemberInitsConstDequeType(inheritanceType, inheritanceType2, list, hashSet);
        this.sb.appendFront("// implicit initializations of " + ModelGen.formatIdentifiable(inheritanceType) + " for target " + ModelGen.formatIdentifiable(inheritanceType2) + "\n");
        this.genMemberImplicitInitsNonConst(inheritanceType, inheritanceType2, hashSet);
    }

    private void genMemberInitsConstPrimitiveType(InheritanceType inheritanceType, InheritanceType inheritanceType2, HashSet<Entity> hashSet) {
        for (MemberInit memberInit : inheritanceType.getMemberInits()) {
            Entity entity = memberInit.getMember();
            if (!entity.isConst() || !ModelGen.generateInitializationOfTypeAtCreatingTargetTypeInitialization(entity, inheritanceType, inheritanceType2)) continue;
            String string = this.formatAttributeType(entity);
            String string2 = ModelGen.formatIdentifiable(entity);
            this.sb.appendFront("private static readonly " + string + " " + string2 + ATTR_IMPL_SUFFIX + " = ");
            this.genExpression(this.sb, memberInit.getExpression(), null);
            this.sb.append(";\n");
            hashSet.add(entity);
        }
    }

    private void genMemberInitsConstMapType(InheritanceType inheritanceType, InheritanceType inheritanceType2, List<String> list, HashSet<Entity> hashSet) {
        for (MapInit mapInit : inheritanceType.getMapInits()) {
            Entity entity = mapInit.getMember();
            if (!entity.isConst() || !ModelGen.generateInitializationOfTypeAtCreatingTargetTypeInitialization(entity, inheritanceType, inheritanceType2)) continue;
            String string = this.formatAttributeType(entity);
            String string2 = ModelGen.formatIdentifiable(entity);
            this.sb.appendFront("private static readonly " + string + " " + string2 + ATTR_IMPL_SUFFIX + " = new " + string + "();\n");
            list.add("init_" + string2);
            this.sb.appendFront("static void init_" + string2 + "() {\n");
            this.sb.indent();
            for (ExpressionPair expressionPair : mapInit.getMapItems()) {
                this.sb.appendFront("");
                this.sb.append(string2 + ATTR_IMPL_SUFFIX);
                this.sb.append("[");
                this.genExpression(this.sb, expressionPair.getKeyExpr(), null);
                this.sb.append("] = ");
                this.genExpression(this.sb, expressionPair.getValueExpr(), null);
                this.sb.append(";\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            hashSet.add(entity);
        }
    }

    private void genMemberInitsConstSetType(InheritanceType inheritanceType, InheritanceType inheritanceType2, List<String> list, HashSet<Entity> hashSet) {
        for (SetInit setInit : inheritanceType.getSetInits()) {
            Entity entity = setInit.getMember();
            if (!entity.isConst() || !ModelGen.generateInitializationOfTypeAtCreatingTargetTypeInitialization(entity, inheritanceType, inheritanceType2)) continue;
            String string = this.formatAttributeType(entity);
            String string2 = ModelGen.formatIdentifiable(entity);
            this.sb.appendFront("private static readonly " + string + " " + string2 + ATTR_IMPL_SUFFIX + " = new " + string + "();\n");
            list.add("init_" + string2);
            this.sb.appendFront("static void init_" + string2 + "() {\n");
            this.sb.indent();
            for (Expression expression : setInit.getSetItems()) {
                this.sb.appendFront("");
                this.sb.append(string2 + ATTR_IMPL_SUFFIX);
                this.sb.append("[");
                this.genExpression(this.sb, expression, null);
                this.sb.append("] = null;\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            hashSet.add(entity);
        }
    }

    private void genMemberInitsConstArrayType(InheritanceType inheritanceType, InheritanceType inheritanceType2, List<String> list, HashSet<Entity> hashSet) {
        for (ArrayInit arrayInit : inheritanceType.getArrayInits()) {
            Entity entity = arrayInit.getMember();
            if (!entity.isConst() || !ModelGen.generateInitializationOfTypeAtCreatingTargetTypeInitialization(entity, inheritanceType, inheritanceType2)) continue;
            String string = this.formatAttributeType(entity);
            String string2 = ModelGen.formatIdentifiable(entity);
            this.sb.appendFront("private static readonly " + string + " " + string2 + ATTR_IMPL_SUFFIX + " = new " + string + "();\n");
            list.add("init_" + string2);
            this.sb.appendFront("static void init_" + string2 + "() {\n");
            this.sb.indent();
            for (Expression expression : arrayInit.getArrayItems()) {
                this.sb.appendFront("");
                this.sb.append(string2 + ATTR_IMPL_SUFFIX);
                this.sb.append(".Add(");
                this.genExpression(this.sb, expression, null);
                this.sb.append(");\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            hashSet.add(entity);
        }
    }

    private void genMemberInitsConstDequeType(InheritanceType inheritanceType, InheritanceType inheritanceType2, List<String> list, HashSet<Entity> hashSet) {
        for (DequeInit dequeInit : inheritanceType.getDequeInits()) {
            Entity entity = dequeInit.getMember();
            if (!entity.isConst() || !ModelGen.generateInitializationOfTypeAtCreatingTargetTypeInitialization(entity, inheritanceType, inheritanceType2)) continue;
            String string = this.formatAttributeType(entity);
            String string2 = ModelGen.formatIdentifiable(entity);
            this.sb.appendFront("private static readonly " + string + " " + string2 + ATTR_IMPL_SUFFIX + " = new " + string + "();\n");
            list.add("init_" + string2);
            this.sb.appendFront("static void init_" + string2 + "() {\n");
            this.sb.indent();
            for (Expression expression : dequeInit.getDequeItems()) {
                this.sb.appendFront("");
                this.sb.append(string2 + ATTR_IMPL_SUFFIX);
                this.sb.append(".Enqueue(");
                this.genExpression(this.sb, expression, null);
                this.sb.append(");\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            hashSet.add(entity);
        }
    }

    private void genMemberImplicitInitsNonConst(InheritanceType inheritanceType, InheritanceType inheritanceType2, HashSet<Entity> hashSet) {
        for (Entity entity : inheritanceType.getMembers()) {
            if (!entity.isConst() || hashSet.contains(entity) || !ModelGen.generateInitializationOfTypeAtCreatingTargetTypeInitialization(entity, inheritanceType, inheritanceType2)) continue;
            Type type = entity.getType();
            String string = this.formatAttributeType(entity);
            String string2 = ModelGen.formatIdentifiable(entity);
            if (type instanceof MapType || type instanceof SetType || type instanceof ArrayType || type instanceof DequeType) {
                this.sb.appendFront("private static readonly " + string + " " + string2 + ATTR_IMPL_SUFFIX + " = new " + string + "();\n");
                continue;
            }
            this.sb.appendFront("private static readonly " + string + " " + string2 + ATTR_IMPL_SUFFIX + ";\n");
        }
    }

    static boolean generateInitializationOfTypeAtCreatingTargetTypeInitialization(Entity entity, InheritanceType inheritanceType, InheritanceType inheritanceType2) {
        LinkedHashSet<InheritanceType> linkedHashSet = new LinkedHashSet<InheritanceType>(inheritanceType.getAllSubTypes());
        linkedHashSet.remove(inheritanceType);
        LinkedHashSet<InheritanceType> linkedHashSet2 = new LinkedHashSet<InheritanceType>(inheritanceType2.getAllSuperTypes());
        linkedHashSet2.add(inheritanceType2);
        LinkedHashSet<InheritanceType> linkedHashSet3 = new LinkedHashSet<InheritanceType>(linkedHashSet);
        linkedHashSet3.retainAll(linkedHashSet2);
        for (InheritanceType inheritanceType3 : linkedHashSet3) {
            for (MemberInit memberInit : inheritanceType3.getMemberInits()) {
                if (entity != memberInit.getMember()) continue;
                return false;
            }
            for (MapInit mapInit : inheritanceType3.getMapInits()) {
                if (entity != mapInit.getMember()) continue;
                return false;
            }
            for (SetInit setInit : inheritanceType3.getSetInits()) {
                if (entity != setInit.getMember()) continue;
                return false;
            }
            for (ArrayInit arrayInit : inheritanceType3.getArrayInits()) {
                if (entity != arrayInit.getMember()) continue;
                return false;
            }
            for (DequeInit dequeInit : inheritanceType3.getDequeInits()) {
                if (entity != dequeInit.getMember()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void genQualAccess(SourceBuilder sourceBuilder, Qualification qualification, Object object) {
        Entity entity = qualification.getOwner();
        sourceBuilder.append("((I" + this.getInheritanceTypePrefix(entity) + ModelGen.formatIdentifiable(entity.getType()) + ") ");
        sourceBuilder.append(ModelGen.formatEntity(entity) + ").@" + ModelGen.formatIdentifiable(qualification.getMember()));
    }

    @Override
    protected void genMemberAccess(SourceBuilder sourceBuilder, Entity entity) {
        if (this.curMemberOwner != null) {
            sourceBuilder.append(this.curMemberOwner + ".");
        }
        sourceBuilder.append("@" + ModelGen.formatIdentifiable(entity));
    }

    private void genAttributesAndAttributeAccessImpl(InheritanceType inheritanceType) {
        SourceBuilder sourceBuilder = this.sb;
        String string = inheritanceType.getExternalName();
        String string2 = "";
        if (string != null) {
            sourceBuilder = this.getStubBuffer();
            string2 = "override ";
            for (Entity entity : inheritanceType.getAllMembers()) {
                this.genAttributeAccess(inheritanceType, entity, "public abstract ");
            }
        }
        for (Entity entity : inheritanceType.getAllMembers()) {
            this.genAttributeGetterSetterAndMember(inheritanceType, sourceBuilder, string2, entity);
        }
        this.genGetAttributeByName(inheritanceType);
        this.genSetAttributeByName(inheritanceType);
        this.genResetAllAttributes(inheritanceType);
    }

    private void genAttributeGetterSetterAndMember(InheritanceType inheritanceType, SourceBuilder sourceBuilder, String string, Entity entity) {
        String string2 = this.formatAttributeType(entity);
        String string3 = ModelGen.formatIdentifiable(entity);
        if (entity.isConst()) {
            sourceBuilder.appendFront("public " + string + string2 + " @" + string3 + "\n");
            sourceBuilder.appendFront("{\n");
            sourceBuilder.appendFrontIndented("get { return " + string3 + ATTR_IMPL_SUFFIX + "; }\n");
            sourceBuilder.appendFront("}\n");
        } else {
            sourceBuilder.append("\n");
            sourceBuilder.appendFront("private " + string2 + " " + string3 + ATTR_IMPL_SUFFIX + ";\n");
            sourceBuilder.appendFront("public " + string + string2 + " @" + string3 + "\n");
            sourceBuilder.appendFront("{\n");
            sourceBuilder.indent();
            sourceBuilder.appendFront("get { return " + string3 + ATTR_IMPL_SUFFIX + "; }\n");
            sourceBuilder.appendFront("set { " + string3 + ATTR_IMPL_SUFFIX + " = value; }\n");
            sourceBuilder.unindent();
            sourceBuilder.appendFront("}\n");
        }
        Entity entity2 = inheritanceType.getOverriddenMember(entity);
        if (entity2 != null) {
            sourceBuilder.append("\n");
            sourceBuilder.appendFront("object " + this.formatElementInterfaceRef(entity2.getOwner()) + ".@" + string3 + "\n");
            sourceBuilder.appendFront("{\n");
            sourceBuilder.indent();
            sourceBuilder.appendFront("get { return " + string3 + ATTR_IMPL_SUFFIX + "; }\n");
            sourceBuilder.appendFront("set { " + string3 + ATTR_IMPL_SUFFIX + " = (" + string2 + ") value; }\n");
            sourceBuilder.unindent();
            sourceBuilder.appendFront("}\n");
        }
    }

    private void genGetAttributeByName(InheritanceType inheritanceType) {
        this.sb.appendFront("public override object GetAttribute(string attrName)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        if (inheritanceType.getAllMembers().size() != 0) {
            this.sb.appendFront("switch(attrName)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (Entity entity : inheritanceType.getAllMembers()) {
                String string = ModelGen.formatIdentifiable(entity);
                this.sb.appendFront("case \"" + string + "\": return this.@" + string + ";\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
        this.sb.appendFront("throw new NullReferenceException(\n");
        this.sb.appendFrontIndented("\"The " + ModelGen.getKindName(inheritanceType) + " type \\\"" + ModelGen.formatIdentifiable(inheritanceType) + "\\\" does not have the attribute \\\"\" + attrName + \"\\\"!\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genSetAttributeByName(InheritanceType inheritanceType) {
        this.sb.appendFront("public override void SetAttribute(string attrName, object value)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        if (inheritanceType.getAllMembers().size() != 0) {
            this.sb.appendFront("switch(attrName)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (Entity entity : inheritanceType.getAllMembers()) {
                String string = ModelGen.formatIdentifiable(entity);
                if (entity.isConst()) {
                    this.sb.appendFront("case \"" + string + "\": ");
                    this.sb.append("throw new NullReferenceException(");
                    this.sb.append("\"The attribute " + string + " of the " + ModelGen.getKindName(inheritanceType) + " type \\\"" + ModelGen.formatIdentifiable(inheritanceType) + "\\\" is read only!\");\n");
                    continue;
                }
                this.sb.appendFront("case \"" + string + "\": this.@" + string + " = (" + this.formatAttributeType(entity) + ") value; return;\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
        this.sb.appendFront("throw new NullReferenceException(\n");
        this.sb.appendFrontIndented("\"The " + ModelGen.getKindName(inheritanceType) + " type \\\"" + ModelGen.formatIdentifiable(inheritanceType) + "\\\" does not have the attribute \\\"\" + attrName + \"\\\"!\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genResetAllAttributes(InheritanceType inheritanceType) {
        this.sb.appendFront("public override void ResetAllAttributes()\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.initAllMembersNonConst(inheritanceType, "this", true, true);
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genParameterPassingMethodCall(InheritanceType inheritanceType, FunctionMethod functionMethod) {
        this.sb.appendFront("case \"" + functionMethod.getIdent().toString() + "\":\n");
        this.sb.appendFrontIndented("return @" + functionMethod.getIdent().toString() + "(actionEnv, graph");
        int n = 0;
        for (Entity entity : functionMethod.getParameters()) {
            this.sb.append(", (" + this.formatType(entity.getType()) + ")arguments[" + n + "]");
            ++n;
        }
        this.sb.append(");\n");
    }

    private void genParameterPassingMethodCall(InheritanceType inheritanceType, ProcedureMethod procedureMethod) {
        this.sb.appendFront("case \"" + procedureMethod.getIdent().toString() + "\":\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        int n = 0;
        for (Type identifiable : procedureMethod.getReturnTypes()) {
            this.sb.appendFront(this.formatType(identifiable));
            this.sb.append(" ");
            this.sb.append("_out_param_" + n + ";\n");
            ++n;
        }
        this.sb.appendFront("@" + procedureMethod.getIdent().toString() + "(actionEnv, graph");
        n = 0;
        for (Entity entity : procedureMethod.getParameters()) {
            this.sb.append(", (" + this.formatType(entity.getType()) + ")arguments[" + n + "]");
            ++n;
        }
        for (n = 0; n < procedureMethod.getReturnTypes().size(); ++n) {
            this.sb.append(", out ");
            this.sb.append("_out_param_" + n);
        }
        this.sb.append(");\n");
        for (n = 0; n < procedureMethod.getReturnTypes().size(); ++n) {
            this.sb.appendFront("ReturnArray_" + procedureMethod.getIdent().toString() + "_" + inheritanceType.getIdent().toString() + "[" + n + "] = ");
            this.sb.append("_out_param_" + n + ";\n");
        }
        this.sb.appendFront("return ReturnArray_" + procedureMethod.getIdent().toString() + "_" + inheritanceType.getIdent().toString() + ";\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genParameterPassingReturnArray(InheritanceType inheritanceType, ProcedureMethod procedureMethod) {
        this.sb.appendFront("private static object[] ReturnArray_" + procedureMethod.getIdent().toString() + "_" + inheritanceType.getIdent().toString() + " = new object[" + procedureMethod.getReturnTypes().size() + "]; // helper array for multi-value-returns, to allow for contravariant parameter assignment\n");
    }

    private void genMethods(InheritanceType inheritanceType) {
        this.sb.append("\n");
        this.genApplyFunctionMethodDispatcher(inheritanceType);
        for (FunctionMethod identifiable : inheritanceType.getAllFunctionMethods()) {
            this.genFunctionMethod(identifiable);
        }
        this.genApplyProcedureMethodDispatcher(inheritanceType);
        for (ProcedureMethod procedureMethod : inheritanceType.getAllProcedureMethods()) {
            ModelGen.forceNotConstant((List<EvalStatement>)procedureMethod.getStatements());
            this.genParameterPassingReturnArray(inheritanceType, procedureMethod);
        }
        for (ProcedureMethod procedureMethod : inheritanceType.getAllProcedureMethods()) {
            this.genProcedureMethod(procedureMethod);
        }
    }

    private void genApplyFunctionMethodDispatcher(InheritanceType inheritanceType) {
        this.sb.appendFront("public override object ApplyFunctionMethod(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv, GRGEN_LIBGR.IGraph graph, string name, object[] arguments)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("switch(name)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        for (FunctionMethod functionMethod : inheritanceType.getAllFunctionMethods()) {
            ModelGen.forceNotConstant((List<EvalStatement>)functionMethod.getStatements());
            this.genParameterPassingMethodCall(inheritanceType, functionMethod);
        }
        this.sb.appendFront("default: throw new NullReferenceException(\"" + ModelGen.formatIdentifiable(inheritanceType) + " does not have the function method \" + name + \"!\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genFunctionMethod(FunctionMethod functionMethod) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = "";
        HashMap<Entity, String> hashMap = new HashMap<Entity, String>();
        this.genLocalContainersEvals(this.sb, functionMethod.getStatements(), linkedList, string, hashMap);
        this.sb.appendFront("public " + this.formatType(functionMethod.getReturnType()) + " ");
        this.sb.append(functionMethod.getIdent().toString() + "(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv_, GRGEN_LIBGR.IGraph graph_");
        for (Entity object2 : functionMethod.getParameters()) {
            this.sb.append(", ");
            this.sb.append(this.formatType(object2.getType()));
            this.sb.append(" ");
            this.sb.append(ModelGen.formatEntity(object2));
        }
        this.sb.append(")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("GRGEN_LGSP.LGSPActionExecutionEnvironment actionEnv = (GRGEN_LGSP.LGSPActionExecutionEnvironment)actionEnv_;\n");
        this.sb.appendFront("GRGEN_LGSP.LGSPGraph graph = (GRGEN_LGSP.LGSPGraph)graph_;\n");
        Object object3 = new ModifyGenerationState(this.model, null, "", false, this.be.system.emitProfilingInstrumentation());
        ModifyEvalGen modifyEvalGen = new ModifyEvalGen(this.be, null, this.nodeTypePrefix, this.edgeTypePrefix, this.objectTypePrefix, this.transientObjectTypePrefix);
        for (EvalStatement evalStatement : functionMethod.getStatements()) {
            ((ModifyGenerationState)object3).functionOrProcedureName = functionMethod.getIdent().toString();
            modifyEvalGen.genEvalStmt(this.sb, (ModifyGenerationStateConst)object3, evalStatement);
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        if (this.model.areFunctionsParallel()) {
            this.sb.appendFront("public " + this.formatType(functionMethod.getReturnType()) + " ");
            this.sb.append(functionMethod.getIdent().toString() + "(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv_, GRGEN_LIBGR.IGraph graph_");
            for (Entity entity : functionMethod.getParameters()) {
                this.sb.append(", ");
                this.sb.append(this.formatType(entity.getType()));
                this.sb.append(" ");
                this.sb.append(ModelGen.formatEntity(entity));
            }
            this.sb.append(", int threadId");
            this.sb.append(")\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("GRGEN_LGSP.LGSPActionExecutionEnvironment actionEnv = (GRGEN_LGSP.LGSPActionExecutionEnvironment)actionEnv_;\n");
            this.sb.appendFront("GRGEN_LGSP.LGSPGraph graph = (GRGEN_LGSP.LGSPGraph)graph_;\n");
            object3 = new ModifyGenerationState(this.model, null, "", true, this.be.system.emitProfilingInstrumentation());
            for (EvalStatement evalStatement : functionMethod.getStatements()) {
                ((ModifyGenerationState)object3).functionOrProcedureName = functionMethod.getIdent().toString();
                modifyEvalGen.genEvalStmt(this.sb, (ModifyGenerationStateConst)object3, evalStatement);
            }
            this.sb.unindent();
            this.sb.append("}\n");
        }
    }

    private void genApplyProcedureMethodDispatcher(InheritanceType inheritanceType) {
        this.sb.appendFront("public override object[] ApplyProcedureMethod(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv, GRGEN_LIBGR.IGraph graph, string name, object[] arguments)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("switch(name)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        for (ProcedureMethod procedureMethod : inheritanceType.getAllProcedureMethods()) {
            this.genParameterPassingMethodCall(inheritanceType, procedureMethod);
        }
        this.sb.appendFront("default: throw new NullReferenceException(\"" + ModelGen.formatIdentifiable(inheritanceType) + " does not have the procedure method \" + name + \"!\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genProcedureMethod(ProcedureMethod procedureMethod) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = "";
        HashMap<Entity, String> hashMap = new HashMap<Entity, String>();
        this.genLocalContainersEvals(this.sb, procedureMethod.getStatements(), linkedList, string, hashMap);
        this.sb.appendFront("public void ");
        this.sb.append(procedureMethod.getIdent().toString() + "(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv_, GRGEN_LIBGR.IGraph graph_");
        for (Entity object22 : procedureMethod.getParameters()) {
            this.sb.append(", ");
            this.sb.append(this.formatType(object22.getType()));
            this.sb.append(" ");
            this.sb.append(ModelGen.formatEntity(object22));
        }
        int n = 0;
        for (Type type : procedureMethod.getReturnTypes()) {
            this.sb.append(", out ");
            this.sb.append(this.formatType(type));
            this.sb.append(" ");
            this.sb.append("_out_param_" + n);
            ++n;
        }
        this.sb.append(")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("GRGEN_LGSP.LGSPActionExecutionEnvironment actionEnv = (GRGEN_LGSP.LGSPActionExecutionEnvironment)actionEnv_;\n");
        this.sb.appendFront("GRGEN_LGSP.LGSPGraph graph = (GRGEN_LGSP.LGSPGraph)graph_;\n");
        ModifyGenerationState modifyGenerationState = new ModifyGenerationState(this.model, null, "", false, this.be.system.emitProfilingInstrumentation());
        ModifyExecGen modifyExecGen = new ModifyExecGen(this.be, this.nodeTypePrefix, this.edgeTypePrefix, this.objectTypePrefix, this.transientObjectTypePrefix);
        ModifyEvalGen modifyEvalGen = new ModifyEvalGen(this.be, modifyExecGen, this.nodeTypePrefix, this.edgeTypePrefix, this.objectTypePrefix, this.transientObjectTypePrefix);
        if (this.be.system.mayFireDebugEvents()) {
            this.sb.appendFront("((GRGEN_LGSP.LGSPSubactionAndOutputAdditionEnvironment)actionEnv).DebugEntering(");
            this.sb.append("\"" + procedureMethod.getIdent().toString() + "\"");
            for (Entity entity : procedureMethod.getParameters()) {
                this.sb.append(", ");
                this.sb.append(ModelGen.formatEntity(entity));
            }
            this.sb.append(");\n");
        }
        for (EvalStatement evalStatement : procedureMethod.getStatements()) {
            modifyGenerationState.functionOrProcedureName = procedureMethod.getIdent().toString();
            modifyEvalGen.genEvalStmt(this.sb, modifyGenerationState, evalStatement);
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genTypeImplementation(Collection<? extends InheritanceType> collection, InheritanceType inheritanceType, String string) {
        Collection<FunctionMethod> collection2;
        String string2 = ModelGen.formatIdentifiable(inheritanceType);
        String string3 = ModelGen.formatTypeClassName(inheritanceType);
        String string4 = ModelGen.formatTypeClassRef(inheritanceType);
        String string5 = this.formatInheritanceClassRef(inheritanceType);
        String string6 = inheritanceType.getExternalName();
        String string7 = string6 != null ? "global::" + string6 : string5;
        String string8 = ModelGen.getKindName(inheritanceType);
        this.sb.append("\n");
        this.sb.appendFront("public sealed partial class " + string3 + " : GRGEN_LIBGR." + string8 + "Type\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("public static " + string4 + " typeVar = new " + string4 + "();\n");
        this.genIsA(collection, inheritanceType);
        this.genIsMyType(collection, inheritanceType);
        this.genAttributeAttributes(inheritanceType);
        this.sb.appendFront("public " + string3 + "() : base((int) " + ModelGen.formatInheritanceTypeValue(inheritanceType) + "Types.@" + string2 + ")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.genAttributeInit(inheritanceType);
        ModelGen.addAnnotations(this.sb, inheritanceType, "annotations");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.appendFront("public override string Name { get { return \"" + string2 + "\"; } }\n");
        this.sb.appendFront("public override string Package { get { return " + (!ModelGen.getPackagePrefix(inheritanceType).equals("") ? "\"" + ModelGen.getPackagePrefix(inheritanceType) + "\"" : "null") + "; } }\n");
        this.sb.appendFront("public override string PackagePrefixedName { get { return \"" + ModelGen.getPackagePrefixDoubleColon(inheritanceType) + string2 + "\"; } }\n");
        switch (inheritanceType.getIdent().toString()) {
            case "Node": {
                this.sb.appendFront("public override string " + ModelGen.formatInheritanceTypeValue(inheritanceType) + "InterfaceName { get { return \"de.unika.ipd.grGen.libGr.INode\"; } }\n");
                break;
            }
            case "AEdge": {
                this.sb.appendFront("public override string " + ModelGen.formatInheritanceTypeValue(inheritanceType) + "InterfaceName { get { return \"de.unika.ipd.grGen.libGr.IEdge\"; } }\n");
                break;
            }
            case "Edge": {
                this.sb.appendFront("public override string " + ModelGen.formatInheritanceTypeValue(inheritanceType) + "InterfaceName { get { return \"de.unika.ipd.grGen.libGr.IDEdge\"; } }\n");
                break;
            }
            case "UEdge": {
                this.sb.appendFront("public override string " + ModelGen.formatInheritanceTypeValue(inheritanceType) + "InterfaceName { get { return \"de.unika.ipd.grGen.libGr.IUEdge\"; } }\n");
                break;
            }
            default: {
                this.sb.appendFront("public override string " + ModelGen.formatInheritanceTypeValue(inheritanceType) + "InterfaceName { get { return \"de.unika.ipd.grGen.Model_" + this.model.getIdent() + "." + ModelGen.getPackagePrefixDot(inheritanceType) + "I" + this.getInheritanceTypePrefix(inheritanceType) + ModelGen.formatIdentifiable(inheritanceType) + "\"; } }\n");
            }
        }
        if (inheritanceType.isAbstract()) {
            this.sb.appendFront("public override string " + ModelGen.formatInheritanceTypeValue(inheritanceType) + "ClassName { get { return null; } }\n");
        } else {
            this.sb.appendFront("public override string " + ModelGen.formatInheritanceTypeValue(inheritanceType) + "ClassName { get { return \"de.unika.ipd.grGen.Model_" + this.model.getIdent() + "." + ModelGen.getPackagePrefixDot(inheritanceType) + this.formatInheritanceClassName(inheritanceType) + "\"; } }\n");
        }
        if (inheritanceType instanceof NodeType) {
            this.sb.appendFront("public override GRGEN_LIBGR.INode CreateNode()\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            if (inheritanceType.isAbstract()) {
                this.sb.appendFront("throw new Exception(\"The abstract node type " + string2 + " cannot be instantiated!\");\n");
            } else {
                this.sb.appendFront("return new " + string7 + "();\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
        } else if (inheritanceType instanceof EdgeType) {
            collection2 = (EdgeType)inheritanceType;
            this.sb.appendFront("public override GRGEN_LIBGR.Directedness Directedness { get { return GRGEN_LIBGR.Directedness.");
            switch (((EdgeType)((Object)collection2)).getDirectedness()) {
                case Arbitrary: {
                    this.sb.append("Arbitrary; } }\n");
                    break;
                }
                case Directed: {
                    this.sb.append("Directed; } }\n");
                    break;
                }
                case Undirected: {
                    this.sb.append("Undirected; } }\n");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Illegal directedness of edge type \"" + ModelGen.formatIdentifiable(inheritanceType) + "\"");
                }
            }
            this.sb.appendFront("public override GRGEN_LIBGR.IEdge CreateEdge(GRGEN_LIBGR.INode source, GRGEN_LIBGR.INode target)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            if (inheritanceType.isAbstract()) {
                this.sb.appendFront("throw new Exception(\"The abstract edge type " + string2 + " cannot be instantiated!\");\n");
            } else {
                this.sb.appendFront("return new " + string7 + "((GRGEN_LGSP.LGSPNode) source, (GRGEN_LGSP.LGSPNode) target);\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n\n");
            this.sb.append("\n");
            this.sb.appendFront("public override void SetSourceAndTarget(GRGEN_LIBGR.IEdge edge, GRGEN_LIBGR.INode source, GRGEN_LIBGR.INode target)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            if (inheritanceType.isAbstract()) {
                this.sb.appendFront("throw new Exception(\"The abstract edge type " + string2 + " does not support source and target setting!\");\n");
            } else {
                this.sb.appendFront("((GRGEN_LGSP.LGSPEdge)edge).SetSourceAndTarget((GRGEN_LGSP.LGSPNode) source, (GRGEN_LGSP.LGSPNode) target);\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
        } else if (inheritanceType instanceof InternalTransientObjectType) {
            this.sb.appendFront("public override GRGEN_LIBGR.ITransientObject CreateTransientObject()\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            if (inheritanceType.isAbstract()) {
                this.sb.appendFront("throw new Exception(\"The abstract transient object class type " + string2 + " cannot be instantiated!\");\n");
            } else {
                this.sb.appendFront("return new " + string7 + "();\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
        } else {
            this.sb.appendFront("public override GRGEN_LIBGR.IObject CreateObject(GRGEN_LIBGR.IGraph graph, long uniqueId)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            if (inheritanceType.isAbstract()) {
                this.sb.appendFront("throw new Exception(\"The abstract object class type " + string2 + " cannot be instantiated!\");\n");
            } else {
                this.sb.appendFront("if(uniqueId != -1) {\n");
                this.sb.indent();
                if (this.model.isUniqueClassDefined()) {
                    this.sb.appendFront(string7 + " newObject = new " + string7 + "(graph.GlobalVariables.RequestObjectUniqueId(uniqueId));\n");
                    this.sb.appendFront("((GRGEN_LIBGR.BaseGraph)graph).ObjectCreated(newObject);\n");
                    this.sb.appendFront("return newObject;\n");
                } else {
                    this.sb.appendFront("throw new Exception(\"The model of the object class type " + string2 + " does not support uniqueIds!\");\n");
                }
                this.sb.unindent();
                this.sb.appendFront("} else {\n");
                this.sb.indent();
                this.sb.appendFront(string7 + " newObject = new " + string7 + "(" + (this.model.isUniqueClassDefined() ? "graph.GlobalVariables.FetchObjectUniqueId()" : "-1") + ");\n");
                this.sb.appendFront("((GRGEN_LIBGR.BaseGraph)graph).ObjectCreated(newObject);\n");
                this.sb.appendFront("return newObject;\n");
                this.sb.unindent();
                this.sb.appendFront("}\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
        this.sb.appendFront("public override bool IsAbstract { get { return " + (inheritanceType.isAbstract() ? "true" : "false") + "; } }\n");
        this.sb.appendFront("public override bool IsConst { get { return " + (inheritanceType.isConst() ? "true" : "false") + "; } }\n");
        this.sb.appendFront("public override GRGEN_LIBGR.Annotations Annotations { get { return annotations; } }\n");
        this.sb.appendFront("public GRGEN_LIBGR.Annotations annotations = new GRGEN_LIBGR.Annotations();\n");
        this.sb.appendFront("public override int NumAttributes { get { return " + inheritanceType.getAllMembers().size() + "; } }\n");
        this.genAttributeTypesEnumerator(inheritanceType);
        this.genGetAttributeType(inheritanceType);
        this.sb.appendFront("public override int NumFunctionMethods { get { return " + inheritanceType.getAllFunctionMethods().size() + "; } }\n");
        this.genFunctionMethodsEnumerator(inheritanceType);
        this.genGetFunctionMethod(inheritanceType);
        this.sb.appendFront("public override int NumProcedureMethods { get { return " + inheritanceType.getAllProcedureMethods().size() + "; } }\n");
        this.genProcedureMethodsEnumerator(inheritanceType);
        this.genGetProcedureMethod(inheritanceType);
        this.sb.appendFront("public override bool IsA(GRGEN_LIBGR.GrGenType other)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("return (this == other) || isA[other.TypeID];\n");
        this.sb.appendFront("}\n");
        if (inheritanceType instanceof NodeType || inheritanceType instanceof EdgeType) {
            this.genCreateWithCopyCommons(inheritanceType);
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        collection2 = inheritanceType.getAllFunctionMethods();
        for (FunctionMethod object2 : collection2) {
            this.genFunctionMethodInfo(object2, inheritanceType, string);
        }
        Collection<ProcedureMethod> collection3 = inheritanceType.getAllProcedureMethods();
        Iterator iterator = collection3.iterator();
        while (iterator.hasNext()) {
            ProcedureMethod procedureMethod = (ProcedureMethod)iterator.next();
            this.genProcedureMethodInfo(procedureMethod, inheritanceType, string);
        }
    }

    private void genIsA(Collection<? extends InheritanceType> collection, InheritanceType inheritanceType) {
        this.sb.appendFront("public static bool[] isA = new bool[] { ");
        for (InheritanceType inheritanceType2 : collection) {
            if (inheritanceType.isCastableTo(inheritanceType2)) {
                this.sb.append("true, ");
                continue;
            }
            this.sb.append("false, ");
        }
        this.sb.append("};\n");
        this.sb.appendFront("public override bool IsA(int typeID) { return isA[typeID]; }\n");
    }

    private void genIsMyType(Collection<? extends InheritanceType> collection, InheritanceType inheritanceType) {
        this.sb.appendFront("public static bool[] isMyType = new bool[] { ");
        for (InheritanceType inheritanceType2 : collection) {
            if (inheritanceType2.isCastableTo(inheritanceType)) {
                this.sb.append("true, ");
                continue;
            }
            this.sb.append("false, ");
        }
        this.sb.append("};\n");
        this.sb.appendFront("public override bool IsMyType(int typeID) { return isMyType[typeID]; }\n");
    }

    private void genAttributeAttributes(InheritanceType inheritanceType) {
        for (Entity entity : inheritanceType.getMembers()) {
            this.sb.appendFront("public static GRGEN_LIBGR.AttributeType " + ModelGen.formatAttributeTypeName(entity) + ";\n");
            if (entity.getType() instanceof MapType) {
                this.sb.appendFront("public static GRGEN_LIBGR.AttributeType " + ModelGen.formatAttributeTypeName(entity) + "_map_domain_type;\n");
                this.sb.appendFront("public static GRGEN_LIBGR.AttributeType " + ModelGen.formatAttributeTypeName(entity) + "_map_range_type;\n");
            }
            if (entity.getType() instanceof SetType) {
                this.sb.appendFront("public static GRGEN_LIBGR.AttributeType " + ModelGen.formatAttributeTypeName(entity) + "_set_member_type;\n");
            }
            if (entity.getType() instanceof ArrayType) {
                this.sb.appendFront("public static GRGEN_LIBGR.AttributeType " + ModelGen.formatAttributeTypeName(entity) + "_array_member_type;\n");
            }
            if (!(entity.getType() instanceof DequeType)) continue;
            this.sb.appendFront("public static GRGEN_LIBGR.AttributeType " + ModelGen.formatAttributeTypeName(entity) + "_deque_member_type;\n");
        }
    }

    private void genAttributeInit(InheritanceType inheritanceType) {
        for (Entity entity : inheritanceType.getMembers()) {
            ContainerType containerType;
            String string = ModelGen.formatAttributeTypeName(entity);
            Type type = entity.getType();
            if (type instanceof MapType) {
                containerType = (MapType)type;
                this.sb.appendFront(string + "_map_domain_type = new GRGEN_LIBGR.AttributeType(");
                this.sb.append("\"" + ModelGen.formatIdentifiable(entity) + "_map_domain_type\", this, ");
                this.genAttributeInitTypeDependentStuff(((MapType)containerType).getKeyType(), entity);
                this.sb.append(");\n");
                this.sb.appendFront(string + "_map_range_type = new GRGEN_LIBGR.AttributeType(");
                this.sb.append("\"" + ModelGen.formatIdentifiable(entity) + "_map_range_type\", this, ");
                this.genAttributeInitTypeDependentStuff(((MapType)containerType).getValueType(), entity);
                this.sb.append(");\n");
            } else if (type instanceof SetType) {
                containerType = (SetType)type;
                this.sb.appendFront(string + "_set_member_type = new GRGEN_LIBGR.AttributeType(");
                this.sb.append("\"" + ModelGen.formatIdentifiable(entity) + "_set_member_type\", this, ");
                this.genAttributeInitTypeDependentStuff(((SetType)containerType).getValueType(), entity);
                this.sb.append(");\n");
            } else if (type instanceof ArrayType) {
                containerType = (ArrayType)type;
                this.sb.appendFront(string + "_array_member_type = new GRGEN_LIBGR.AttributeType(");
                this.sb.append("\"" + ModelGen.formatIdentifiable(entity) + "_array_member_type\", this, ");
                this.genAttributeInitTypeDependentStuff(((ArrayType)containerType).getValueType(), entity);
                this.sb.append(");\n");
            } else if (type instanceof DequeType) {
                containerType = (DequeType)type;
                this.sb.appendFront(string + "_deque_member_type = new GRGEN_LIBGR.AttributeType(");
                this.sb.append("\"" + ModelGen.formatIdentifiable(entity) + "_deque_member_type\", this, ");
                this.genAttributeInitTypeDependentStuff(((DequeType)containerType).getValueType(), entity);
                this.sb.append(");\n");
            }
            this.sb.appendFront(string + " = new GRGEN_LIBGR.AttributeType(");
            this.sb.append("\"" + ModelGen.formatIdentifiable(entity) + "\", this, ");
            this.genAttributeInitTypeDependentStuff(type, entity);
            this.sb.append(");\n");
            ModelGen.addAnnotations(this.sb, entity, string + ".annotations");
        }
    }

    private void genAttributeInitTypeDependentStuff(Type type, Entity entity) {
        if (type instanceof EnumType) {
            this.sb.append(ModelGen.getAttributeKind(type) + ", GRGEN_MODEL." + ModelGen.getPackagePrefixDot(type) + "Enums.@" + ModelGen.formatIdentifiable(type) + ", null, null, null, null, null, typeof(" + this.formatAttributeType(type) + ")");
        } else if (type instanceof MapType) {
            this.sb.append(ModelGen.getAttributeKind(type) + ", null, " + ModelGen.formatAttributeTypeName(entity) + "_map_range_type, " + ModelGen.formatAttributeTypeName(entity) + "_map_domain_type, null, null, null, typeof(" + this.formatAttributeType(type) + ")");
        } else if (type instanceof SetType) {
            this.sb.append(ModelGen.getAttributeKind(type) + ", null, " + ModelGen.formatAttributeTypeName(entity) + "_set_member_type, null, null, null, null, typeof(" + this.formatAttributeType(type) + ")");
        } else if (type instanceof ArrayType) {
            this.sb.append(ModelGen.getAttributeKind(type) + ", null, " + ModelGen.formatAttributeTypeName(entity) + "_array_member_type, null, null, null, null, typeof(" + this.formatAttributeType(type) + ")");
        } else if (type instanceof DequeType) {
            this.sb.append(ModelGen.getAttributeKind(type) + ", null, " + ModelGen.formatAttributeTypeName(entity) + "_deque_member_type, null, null, null, null, typeof(" + this.formatAttributeType(type) + ")");
        } else if (type instanceof NodeType || type instanceof EdgeType) {
            this.sb.append(ModelGen.getAttributeKind(type) + ", null, null, null, \"" + ModelGen.formatIdentifiable(type) + "\"," + (((ContainedInPackage)((Object)type)).getPackageContainedIn() != null ? "\"" + ((ContainedInPackage)((Object)type)).getPackageContainedIn() + "\"" : "null") + ",\"" + ModelGen.getPackagePrefixDoubleColon(type) + ModelGen.formatIdentifiable(type) + "\",typeof(" + this.formatElementInterfaceRef(type) + ")");
        } else if (type instanceof InternalObjectType || type instanceof InternalTransientObjectType) {
            this.sb.append(ModelGen.getAttributeKind(type) + ", null, null, null, \"" + ModelGen.formatIdentifiable(type) + "\"," + (((ContainedInPackage)((Object)type)).getPackageContainedIn() != null ? "\"" + ((ContainedInPackage)((Object)type)).getPackageContainedIn() + "\"" : "null") + ",\"" + ModelGen.getPackagePrefixDoubleColon(type) + ModelGen.formatIdentifiable(type) + "\",typeof(" + this.formatElementInterfaceRef(type) + ")");
        } else {
            this.sb.append(ModelGen.getAttributeKind(type) + ", null, null, null, null, null, null, typeof(" + this.formatAttributeType(type) + ")");
        }
    }

    private static String getAttributeKind(Type type) {
        if (type instanceof ByteType) {
            return "GRGEN_LIBGR.AttributeKind.ByteAttr";
        }
        if (type instanceof ShortType) {
            return "GRGEN_LIBGR.AttributeKind.ShortAttr";
        }
        if (type instanceof IntType) {
            return "GRGEN_LIBGR.AttributeKind.IntegerAttr";
        }
        if (type instanceof LongType) {
            return "GRGEN_LIBGR.AttributeKind.LongAttr";
        }
        if (type instanceof FloatType) {
            return "GRGEN_LIBGR.AttributeKind.FloatAttr";
        }
        if (type instanceof DoubleType) {
            return "GRGEN_LIBGR.AttributeKind.DoubleAttr";
        }
        if (type instanceof BooleanType) {
            return "GRGEN_LIBGR.AttributeKind.BooleanAttr";
        }
        if (type instanceof StringType) {
            return "GRGEN_LIBGR.AttributeKind.StringAttr";
        }
        if (type instanceof EnumType) {
            return "GRGEN_LIBGR.AttributeKind.EnumAttr";
        }
        if (type instanceof ObjectType || type instanceof VoidType || type instanceof ExternalObjectType) {
            return "GRGEN_LIBGR.AttributeKind.ObjectAttr";
        }
        if (type instanceof MapType) {
            return "GRGEN_LIBGR.AttributeKind.MapAttr";
        }
        if (type instanceof SetType) {
            return "GRGEN_LIBGR.AttributeKind.SetAttr";
        }
        if (type instanceof ArrayType) {
            return "GRGEN_LIBGR.AttributeKind.ArrayAttr";
        }
        if (type instanceof DequeType) {
            return "GRGEN_LIBGR.AttributeKind.DequeAttr";
        }
        if (type instanceof NodeType) {
            return "GRGEN_LIBGR.AttributeKind.NodeAttr";
        }
        if (type instanceof EdgeType) {
            return "GRGEN_LIBGR.AttributeKind.EdgeAttr";
        }
        if (type instanceof GraphType) {
            return "GRGEN_LIBGR.AttributeKind.GraphAttr";
        }
        if (type instanceof InternalObjectType) {
            return "GRGEN_LIBGR.AttributeKind.InternalClassObjectAttr";
        }
        if (type instanceof InternalTransientObjectType) {
            return "GRGEN_LIBGR.AttributeKind.InternalClassTransientObjectAttr";
        }
        throw new IllegalArgumentException("Unknown Type: " + type);
    }

    private void genAttributeTypesEnumerator(InheritanceType inheritanceType) {
        Collection<Entity> collection = inheritanceType.getAllMembers();
        this.sb.appendFront("public override IEnumerable<GRGEN_LIBGR.AttributeType> AttributeTypes");
        if (collection.isEmpty()) {
            this.sb.append(" { get { yield break; } }\n");
        } else {
            this.sb.append("\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("get\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (Entity entity : collection) {
                Type type = entity.getOwner();
                if (type == inheritanceType) {
                    this.sb.appendFront("yield return " + ModelGen.formatAttributeTypeName(entity) + ";\n");
                    continue;
                }
                this.sb.appendFront("yield return " + ModelGen.formatTypeClassRef(type) + "." + ModelGen.formatAttributeTypeName(entity) + ";\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    private void genGetAttributeType(InheritanceType inheritanceType) {
        Collection<Entity> collection = inheritanceType.getAllMembers();
        this.sb.appendFront("public override GRGEN_LIBGR.AttributeType GetAttributeType(string name)");
        if (collection.isEmpty()) {
            this.sb.append(" { return null; }\n");
        } else {
            this.sb.append("\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("switch(name)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (Entity entity : collection) {
                Type type = entity.getOwner();
                if (type == inheritanceType) {
                    this.sb.appendFront("case \"" + ModelGen.formatIdentifiable(entity) + "\" : return " + ModelGen.formatAttributeTypeName(entity) + ";\n");
                    continue;
                }
                this.sb.appendFront("case \"" + ModelGen.formatIdentifiable(entity) + "\" : return " + ModelGen.formatTypeClassRef(type) + "." + ModelGen.formatAttributeTypeName(entity) + ";\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("return null;\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    private void genFunctionMethodsEnumerator(InheritanceType inheritanceType) {
        Collection<FunctionMethod> collection = inheritanceType.getAllFunctionMethods();
        this.sb.appendFront("public override IEnumerable<GRGEN_LIBGR.IFunctionDefinition> FunctionMethods");
        if (collection.isEmpty()) {
            this.sb.append(" { get { yield break; } }\n");
        } else {
            this.sb.append("\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("get\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (FunctionMethod functionMethod : collection) {
                this.sb.appendFront("yield return " + ModelGen.formatFunctionMethodInfoName(functionMethod, inheritanceType) + ".Instance;\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    private void genGetFunctionMethod(InheritanceType inheritanceType) {
        Collection<FunctionMethod> collection = inheritanceType.getAllFunctionMethods();
        this.sb.appendFront("public override GRGEN_LIBGR.IFunctionDefinition GetFunctionMethod(string name)");
        if (collection.isEmpty()) {
            this.sb.append(" { return null; }\n");
        } else {
            this.sb.append("\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("switch(name)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (FunctionMethod functionMethod : collection) {
                this.sb.appendFront("case \"" + ModelGen.formatIdentifiable(functionMethod) + "\" : return " + ModelGen.formatFunctionMethodInfoName(functionMethod, inheritanceType) + ".Instance;\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("return null;\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    private void genProcedureMethodsEnumerator(InheritanceType inheritanceType) {
        Collection<ProcedureMethod> collection = inheritanceType.getAllProcedureMethods();
        this.sb.appendFront("public override IEnumerable<GRGEN_LIBGR.IProcedureDefinition> ProcedureMethods");
        if (collection.isEmpty()) {
            this.sb.append(" { get { yield break; } }\n");
        } else {
            this.sb.append("\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("get\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (ProcedureMethod procedureMethod : collection) {
                this.sb.appendFront("yield return " + ModelGen.formatProcedureMethodInfoName(procedureMethod, inheritanceType) + ".Instance;\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    private void genGetProcedureMethod(InheritanceType inheritanceType) {
        Collection<ProcedureMethod> collection = inheritanceType.getAllProcedureMethods();
        this.sb.appendFront("public override GRGEN_LIBGR.IProcedureDefinition GetProcedureMethod(string name)");
        if (collection.isEmpty()) {
            this.sb.append(" { return null; }\n");
        } else {
            this.sb.append("\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            this.sb.appendFront("switch(name)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (ProcedureMethod procedureMethod : collection) {
                this.sb.appendFront("case \"" + ModelGen.formatIdentifiable(procedureMethod) + "\" : return " + ModelGen.formatProcedureMethodInfoName(procedureMethod, inheritanceType) + ".Instance;\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("return null;\n");
            this.sb.unindent();
            this.sb.append("}\n");
        }
    }

    private void getFirstCommonAncestors(InheritanceType inheritanceType, InheritanceType inheritanceType2, Set<InheritanceType> set) {
        if (inheritanceType2.isCastableTo(inheritanceType)) {
            set.add(inheritanceType);
        } else {
            for (InheritanceType inheritanceType3 : inheritanceType.getDirectSuperTypes()) {
                this.getFirstCommonAncestors(inheritanceType3, inheritanceType2, set);
            }
        }
    }

    private void genCreateWithCopyCommons(InheritanceType inheritanceType) {
        String string = this.formatInheritanceClassRef(inheritanceType);
        String string2 = inheritanceType.getExternalName();
        String string3 = string2 != null ? "global::" + string2 : string;
        String string4 = ModelGen.getKindName(inheritanceType);
        if (inheritanceType instanceof NodeType) {
            this.sb.appendFront("public override GRGEN_LIBGR.INode CreateNodeWithCopyCommons(GRGEN_LIBGR.INode oldINode)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
        } else {
            this.sb.appendFront("public override GRGEN_LIBGR.IEdge CreateEdgeWithCopyCommons(GRGEN_LIBGR.INode source, GRGEN_LIBGR.INode target, GRGEN_LIBGR.IEdge oldIEdge)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
        }
        if (inheritanceType.isAbstract()) {
            this.sb.appendFront("throw new Exception(\"Cannot retype to the abstract type " + ModelGen.formatIdentifiable(inheritanceType) + "!\");\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
            return;
        }
        Map<BitSet, LinkedList<InheritanceType>> map = this.getCommonGroups(inheritanceType);
        if (map.size() != 0) {
            if (inheritanceType instanceof NodeType) {
                this.sb.appendFront("GRGEN_LGSP.LGSPNode oldNode = (GRGEN_LGSP.LGSPNode) oldINode;\n");
                this.sb.appendFront(string + " newNode = new " + string3 + "();\n");
            } else {
                this.sb.appendFront("GRGEN_LGSP.LGSPEdge oldEdge = (GRGEN_LGSP.LGSPEdge) oldIEdge;\n");
                this.sb.appendFront(string + " newEdge = new " + string3 + "((GRGEN_LGSP.LGSPNode) source, (GRGEN_LGSP.LGSPNode) target);\n");
            }
            this.sb.appendFront("switch(old" + string4 + ".Type.TypeID)\n");
            this.sb.appendFront("{\n");
            this.sb.indent();
            for (Map.Entry<BitSet, LinkedList<InheritanceType>> entry : map.entrySet()) {
                this.emitCommonGroup(inheritanceType, string4, entry);
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("return new" + string4 + ";\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.append("\n");
        } else {
            if (inheritanceType instanceof NodeType) {
                this.sb.appendFront("return new " + string3 + "();\n");
            } else {
                this.sb.appendFront("return new " + string3 + "((GRGEN_LGSP.LGSPNode) source, (GRGEN_LGSP.LGSPNode) target);\n");
            }
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.append("\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<BitSet, LinkedList<InheritanceType>> getCommonGroups(InheritanceType inheritanceType) {
        boolean bl = inheritanceType instanceof NodeType;
        LinkedHashMap<BitSet, LinkedList<InheritanceType>> linkedHashMap = new LinkedHashMap<BitSet, LinkedList<InheritanceType>>();
        Collection<InheritanceType> collection = bl ? this.model.getAllNodeTypes() : this.model.getAllEdgeTypes();
        for (InheritanceType inheritanceType2 : collection) {
            void var12_19;
            if (inheritanceType2.isAbstract()) continue;
            LinkedHashSet<InheritanceType> linkedHashSet = new LinkedHashSet<InheritanceType>();
            this.getFirstCommonAncestors(inheritanceType2, inheritanceType, linkedHashSet);
            TreeSet<InheritanceType> treeSet = new TreeSet<InheritanceType>(new Comparator<InheritanceType>(){

                @Override
                public int compare(InheritanceType inheritanceType, InheritanceType inheritanceType2) {
                    return inheritanceType2.getMaxDist() - inheritanceType.getMaxDist();
                }
            });
            treeSet.addAll(linkedHashSet);
            for (InheritanceType inheritanceType3 : treeSet) {
                if (!linkedHashSet.contains(inheritanceType3)) continue;
                for (InheritanceType inheritanceType4 : inheritanceType3.getAllSuperTypes()) {
                    linkedHashSet.remove(inheritanceType4);
                }
            }
            boolean bl2 = false;
            block3: for (InheritanceType inheritanceType5 : linkedHashSet) {
                for (Entity entity : inheritanceType5.getAllMembers()) {
                    if (entity.getType().isVoid()) continue;
                    bl2 = true;
                    break block3;
                }
            }
            if (!bl2) continue;
            BitSet bitSet = new BitSet();
            for (InheritanceType inheritanceType6 : linkedHashSet) {
                bitSet.set(inheritanceType6.getTypeID());
            }
            LinkedList linkedList = (LinkedList)linkedHashMap.get(bitSet);
            if (linkedList == null) {
                LinkedList linkedList2 = new LinkedList();
                linkedHashMap.put(bitSet, linkedList2);
            }
            var12_19.add(inheritanceType2);
        }
        return linkedHashMap;
    }

    private void emitCommonGroup(InheritanceType inheritanceType, String string, Map.Entry<BitSet, LinkedList<InheritanceType>> entry) {
        for (InheritanceType object2 : entry.getValue()) {
            this.sb.appendFront("case (int) GRGEN_MODEL." + ModelGen.getPackagePrefixDot(object2) + string + "Types.@" + ModelGen.formatIdentifiable(object2) + ":\n");
        }
        this.sb.indent();
        BitSet bitSet = entry.getKey();
        HashSet<Entity> hashSet = new HashSet<Entity>();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            InheritanceType inheritanceType2 = InheritanceType.getByTypeID(n);
            Collection<Entity> collection = inheritanceType2.getAllMembers();
            if (collection.size() != 0) {
                this.sb.appendFront("// copy attributes for: " + ModelGen.formatIdentifiable(inheritanceType2) + "\n");
                boolean bl = false;
                for (Entity entity : collection) {
                    if (entity.isConst()) {
                        this.sb.appendFrontIndented("// is const: " + ModelGen.formatIdentifiable(entity) + "\n");
                        continue;
                    }
                    if (entity.getType().isVoid()) {
                        this.sb.appendFrontIndented("// is abstract: " + ModelGen.formatIdentifiable(entity) + "\n");
                        continue;
                    }
                    if (hashSet.contains(entity)) {
                        this.sb.appendFrontIndented("// already copied: " + ModelGen.formatIdentifiable(entity) + "\n");
                        continue;
                    }
                    if (!bl) {
                        bl = true;
                        this.sb.appendFront("{\n");
                        this.sb.indent();
                        this.sb.appendFront(ModelGen.formatVarDeclWithCast(this.formatElementInterfaceRef(inheritanceType2), "old") + "old" + string + ";\n");
                    }
                    hashSet.add(entity);
                    String string2 = ModelGen.formatIdentifiable(entity);
                    if (inheritanceType.getOverriddenMember(entity) != null) {
                        this.sb.appendFront("new" + string + ".@" + string2 + " = (" + this.formatAttributeType(entity) + ") old.@" + string2 + ";   // Mono workaround (bug #357287)\n");
                        continue;
                    }
                    if (entity.getType() instanceof MapType || entity.getType() instanceof SetType || entity.getType() instanceof ArrayType || entity.getType() instanceof DequeType) {
                        this.sb.appendFront("new" + string + ".@" + string2 + " = new " + this.formatAttributeType(entity.getType()) + "(old.@" + string2 + ");\n");
                        continue;
                    }
                    this.sb.appendFront("new" + string + ".@" + string2 + " = old.@" + string2 + ";\n");
                }
                if (bl) {
                    this.sb.unindent();
                    this.sb.appendFront("}\n");
                }
            }
            n = bitSet.nextSetBit(n + 1);
        }
        this.sb.appendFront("break;\n");
        this.sb.unindent();
    }

    private void genFunctionMethodInfo(FunctionMethod functionMethod, InheritanceType inheritanceType, String string) {
        String string2 = ModelGen.formatIdentifiable(functionMethod);
        String string3 = ModelGen.formatFunctionMethodInfoName(functionMethod, inheritanceType);
        this.sb.appendFront("public class " + string3 + " : GRGEN_LIBGR.FunctionInfo\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("private static " + string3 + " instance = null;\n");
        this.sb.appendFront("public static " + string3 + " Instance { get { if(instance==null) { instance = new " + string3 + "(); } return instance; } }\n");
        this.sb.append("\n");
        this.sb.appendFront("private " + string3 + "()\n");
        this.sb.indent();
        this.sb.appendFront(": base(\n");
        this.sb.indent();
        this.sb.appendFront("\"" + string2 + "\",\n");
        this.sb.appendFront((string != null ? "\"" + string + "\"" : "null") + ", ");
        this.sb.append("\"" + (string != null ? string + "::" + string2 : string2) + "\",\n");
        this.sb.appendFront("false,\n");
        this.sb.appendFront("new String[] { ");
        for (Entity entity : functionMethod.getParameters()) {
            this.sb.append("\"" + entity.getIdent() + "\", ");
        }
        this.sb.append(" },\n");
        this.sb.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Entity entity : functionMethod.getParameters()) {
            if (entity.getType() instanceof InheritanceType && !(entity.getType() instanceof ExternalObjectType)) {
                this.sb.append(ModelGen.formatTypeClassRef(entity.getType()) + ".typeVar, ");
                continue;
            }
            this.sb.append("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(entity.getType()) + ")), ");
        }
        this.sb.append(" },\n");
        Type type = functionMethod.getReturnType();
        if (type instanceof InheritanceType && !(type instanceof ExternalObjectType)) {
            this.sb.appendFront(ModelGen.formatTypeClassRef(type) + ".typeVar\n");
        } else {
            this.sb.appendFront("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(type) + "))\n");
        }
        this.sb.unindent();
        this.sb.appendFront(")\n");
        this.sb.unindent();
        this.sb.appendFront("{\n");
        this.sb.appendFront("}\n");
        this.sb.appendFront("public override object Apply(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv, GRGEN_LIBGR.IGraph graph, object[] arguments)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("throw new Exception(\"Not implemented, can't call function method without this object!\");\n");
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    private void genProcedureMethodInfo(ProcedureMethod procedureMethod, InheritanceType inheritanceType, String string) {
        String string2 = ModelGen.formatIdentifiable(procedureMethod);
        String string3 = ModelGen.formatProcedureMethodInfoName(procedureMethod, inheritanceType);
        this.sb.appendFront("public class " + string3 + " : GRGEN_LIBGR.ProcedureInfo\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("private static " + string3 + " instance = null;\n");
        this.sb.appendFront("public static " + string3 + " Instance { get { if(instance==null) { instance = new " + string3 + "(); } return instance; } }\n");
        this.sb.append("\n");
        this.sb.appendFront("private " + string3 + "()\n");
        this.sb.indent();
        this.sb.appendFront(": base(\n");
        this.sb.indent();
        this.sb.appendFront("\"" + string2 + "\",\n");
        this.sb.appendFront((string != null ? "\"" + string + "\"" : "null") + ", ");
        this.sb.append("\"" + (string != null ? string + "::" + string2 : string2) + "\",\n");
        this.sb.appendFront("false,\n");
        this.sb.appendFront("new String[] { ");
        for (Entity identifiable : procedureMethod.getParameters()) {
            this.sb.append("\"" + identifiable.getIdent() + "\", ");
        }
        this.sb.append(" },\n");
        this.sb.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Entity entity : procedureMethod.getParameters()) {
            if (entity.getType() instanceof InheritanceType && !(entity.getType() instanceof ExternalObjectType)) {
                this.sb.append(ModelGen.formatTypeClassRef(entity.getType()) + ".typeVar, ");
                continue;
            }
            this.sb.append("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(entity.getType()) + ")), ");
        }
        this.sb.append(" },\n");
        this.sb.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Type type : procedureMethod.getReturnTypes()) {
            if (type instanceof InheritanceType && !(type instanceof ExternalObjectType)) {
                this.sb.append(ModelGen.formatTypeClassRef(type) + ".typeVar, ");
                continue;
            }
            this.sb.append("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(type) + ")), ");
        }
        this.sb.append(" }\n");
        this.sb.unindent();
        this.sb.appendFront(")\n");
        this.sb.unindent();
        this.sb.appendFront("{\n");
        this.sb.appendFront("}\n");
        this.sb.appendFront("public override object[] Apply(GRGEN_LIBGR.IActionExecutionEnvironment actionEnv, GRGEN_LIBGR.IGraph graph, object[] arguments)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("throw new Exception(\"Not implemented, can't call procedure method without this object!\");\n");
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genAttributeArrayHelpersAndComparers(InheritanceType inheritanceType) {
        for (Entity entity : inheritanceType.getAllMembers()) {
            if (!this.hasArrayHelpers(entity)) continue;
            this.genAttributeArrayHelpersAndComparers(inheritanceType, entity);
        }
    }

    private boolean hasArrayHelpers(Entity entity) {
        if (entity.getType().isFilterableType() || entity.getType().classify() == Type.TypeClass.IS_EXTERNAL_CLASS_OBJECT || entity.getType().classify() == Type.TypeClass.IS_OBJECT) {
            if (!(entity.getType().classify() != Type.TypeClass.IS_EXTERNAL_CLASS_OBJECT && entity.getType().classify() != Type.TypeClass.IS_OBJECT || this.model.isEqualClassDefined() && this.model.isLowerClassDefined())) {
                return false;
            }
            return !entity.isConst();
        }
        return false;
    }

    void genAttributeArrayHelpersAndComparers(InheritanceType inheritanceType, Entity entity) {
        String string = this.formatElementInterfaceRef(inheritanceType);
        String string2 = ModelGen.formatIdentifiable(entity);
        String string3 = this.formatAttributeType(entity.getType());
        String string4 = "ArrayHelper_" + inheritanceType.getIdent().toString() + "_" + string2;
        String string5 = "Comparer_" + inheritanceType.getIdent().toString() + "_" + string2;
        String string6 = "ReverseComparer_" + inheritanceType.getIdent().toString() + "_" + string2;
        InheritanceType inheritanceType2 = ModelGen.getNonAbstractTypeOrSubtype(inheritanceType);
        if (inheritanceType2 == null) {
            return;
        }
        if (entity.getType().isOrderableType()) {
            this.genAttributeArrayComparer(inheritanceType, entity);
            this.genAttributeArrayReverseComparer(inheritanceType, entity);
        }
        this.sb.append("\n");
        this.sb.appendFront("public class " + string4 + "\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.genInstanceBearingAttributeForSearch(this.sb, inheritanceType, inheritanceType2);
        this.genIndexOfByMethod(string, string2, string3);
        this.genIndexOfByWithStartMethod(string, string2, string3);
        this.genLastIndexOfByMethod(string, string2, string3);
        this.genLastIndexOfByWithStartMethod(string, string2, string3);
        if (entity.getType().isOrderableType()) {
            this.genIndexOfOrderedByMethod(string, string2, string3, string5);
            this.genArrayOrderAscendingByMethod(string, string5);
            this.genArrayOrderDescendingByMethod(string, string6);
        }
        ModelGen.generateArrayGroupBy(this.sb, "ArrayGroupBy", string, string2, string3);
        ModelGen.generateArrayKeepOneForEach(this.sb, "ArrayKeepOneForEachBy", string, string2, string3);
        this.genArrayExtractMethod(string, string2, string3);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genInstanceBearingAttributeForSearch(SourceBuilder sourceBuilder, InheritanceType inheritanceType, InheritanceType inheritanceType2) {
        if (inheritanceType instanceof EdgeType) {
            sourceBuilder.appendFront("private static " + this.formatElementInterfaceRef(inheritanceType) + " instanceBearingAttributeForSearch = new " + this.formatInheritanceClassRef(inheritanceType2) + "(null, null);\n");
        } else if (inheritanceType instanceof InternalObjectType) {
            sourceBuilder.appendFront("private static " + this.formatElementInterfaceRef(inheritanceType) + " instanceBearingAttributeForSearch = new " + this.formatInheritanceClassRef(inheritanceType2) + "(-1);\n");
        } else {
            sourceBuilder.appendFront("private static " + this.formatElementInterfaceRef(inheritanceType) + " instanceBearingAttributeForSearch = new " + this.formatInheritanceClassRef(inheritanceType2) + "();\n");
        }
    }

    private static InheritanceType getNonAbstractTypeOrSubtype(InheritanceType inheritanceType) {
        InheritanceType inheritanceType2 = null;
        if (!inheritanceType.isAbstract() && inheritanceType.getExternalName() == null) {
            inheritanceType2 = inheritanceType;
        } else {
            for (InheritanceType inheritanceType3 : inheritanceType.getAllSubTypes()) {
                if (inheritanceType3.isAbstract() || inheritanceType.getExternalName() != null) continue;
                inheritanceType2 = inheritanceType3;
                break;
            }
        }
        return inheritanceType2;
    }

    void genIndexOfByMethod(String string, String string2, String string3) {
        this.sb.appendFront("public static int ArrayIndexOfBy(IList<" + string + "> list, " + string3 + " entry)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("for(int i = 0; i < list.Count; ++i)\n");
        this.sb.indent();
        this.sb.appendFront("if(list[i].@" + string2 + ".Equals(entry))\n");
        this.sb.appendFrontIndented("return i;\n");
        this.sb.unindent();
        this.sb.appendFront("return -1;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    void genIndexOfByWithStartMethod(String string, String string2, String string3) {
        this.sb.appendFront("public static int ArrayIndexOfBy(IList<" + string + "> list, " + string3 + " entry, int startIndex)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("for(int i = startIndex; i < list.Count; ++i)\n");
        this.sb.indent();
        this.sb.appendFront("if(list[i].@" + string2 + ".Equals(entry))\n");
        this.sb.appendFrontIndented("return i;\n");
        this.sb.unindent();
        this.sb.appendFront("return -1;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    void genLastIndexOfByMethod(String string, String string2, String string3) {
        this.sb.appendFront("public static int ArrayLastIndexOfBy(IList<" + string + "> list, " + string3 + " entry)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("for(int i = list.Count - 1; i >= 0; --i)\n");
        this.sb.indent();
        this.sb.appendFront("if(list[i].@" + string2 + ".Equals(entry))\n");
        this.sb.appendFrontIndented("return i;\n");
        this.sb.unindent();
        this.sb.appendFront("return -1;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    void genLastIndexOfByWithStartMethod(String string, String string2, String string3) {
        this.sb.appendFront("public static int ArrayLastIndexOfBy(IList<" + string + "> list, " + string3 + " entry, int startIndex)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("for(int i = startIndex; i >= 0; --i)\n");
        this.sb.indent();
        this.sb.appendFront("if(list[i].@" + string2 + ".Equals(entry))\n");
        this.sb.appendFrontIndented("return i;\n");
        this.sb.unindent();
        this.sb.appendFront("return -1;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    void genIndexOfOrderedByMethod(String string, String string2, String string3, String string4) {
        this.sb.appendFront("public static int ArrayIndexOfOrderedBy(List<" + string + "> list, " + string3 + " entry)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("instanceBearingAttributeForSearch.@" + string2 + " = entry;\n");
        this.sb.appendFront("return list.BinarySearch(instanceBearingAttributeForSearch, " + string4 + ".thisComparer);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    void genArrayOrderAscendingByMethod(String string, String string2) {
        this.sb.appendFront("public static List<" + string + "> ArrayOrderAscendingBy(List<" + string + "> list)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("List<" + string + "> newList = new List<" + string + ">(list);\n");
        this.sb.appendFront("newList.Sort(" + string2 + ".thisComparer);\n");
        this.sb.appendFront("return newList;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    void genArrayOrderDescendingByMethod(String string, String string2) {
        this.sb.appendFront("public static List<" + string + "> ArrayOrderDescendingBy(List<" + string + "> list)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("List<" + string + "> newList = new List<" + string + ">(list);\n");
        this.sb.appendFront("newList.Sort(" + string2 + ".thisComparer);\n");
        this.sb.appendFront("return newList;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    void genArrayExtractMethod(String string, String string2, String string3) {
        this.sb.appendFront("public static List<" + string3 + "> Extract(List<" + string + "> list)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("List<" + string3 + "> resultList = new List<" + string3 + ">(list.Count);\n");
        this.sb.appendFront("foreach(" + string + " entry in list)\n");
        this.sb.appendFrontIndented("resultList.Add(entry.@" + string2 + ");\n");
        this.sb.appendFront("return resultList;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    void genAttributeArrayComparer(InheritanceType inheritanceType, Entity entity) {
        String string = this.formatElementInterfaceRef(inheritanceType);
        String string2 = ModelGen.formatIdentifiable(entity);
        String string3 = "Comparer_" + inheritanceType.getIdent().toString() + "_" + string2;
        this.sb.append("\n");
        this.sb.appendFront("public class " + string3 + " : Comparer<" + string + ">\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("public static " + string3 + " thisComparer = new " + string3 + "();\n");
        ModelGen.genCompareMethod(this.sb, string, ModelGen.formatIdentifiable(entity), entity.getType(), true);
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    void genAttributeArrayReverseComparer(InheritanceType inheritanceType, Entity entity) {
        String string = this.formatElementInterfaceRef(inheritanceType);
        String string2 = ModelGen.formatIdentifiable(entity);
        String string3 = "ReverseComparer_" + inheritanceType.getIdent().toString() + "_" + string2;
        this.sb.append("\n");
        this.sb.appendFront("public class " + string3 + " : Comparer<" + string + ">\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("public static " + string3 + " thisComparer = new " + string3 + "();\n");
        ModelGen.genCompareMethod(this.sb, string, ModelGen.formatIdentifiable(entity), entity.getType(), false);
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genModelClass(Collection<? extends InheritanceType> collection, InheritanceTypeType inheritanceTypeType) {
        String string = inheritanceTypeType.toString();
        this.sb.appendFront("//\n");
        this.sb.appendFront("// " + string + " model\n");
        this.sb.appendFront("//\n");
        this.sb.append("\n");
        this.sb.appendFront("public sealed class " + this.model.getIdent() + string + "Model : GRGEN_LIBGR.I" + string + "Model\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        InheritanceType inheritanceType = this.genModelConstructor(inheritanceTypeType, collection);
        if (inheritanceTypeType == InheritanceTypeType.Node) {
            this.sb.appendFront("public bool IsNodeModel { get { return true; } }\n");
        } else if (inheritanceTypeType == InheritanceTypeType.Edge) {
            this.sb.appendFront("public bool IsNodeModel { get { return false; } }\n");
        } else if (inheritanceTypeType == InheritanceTypeType.Object) {
            this.sb.appendFront("public bool IsTransientModel { get { return false; } }\n");
        } else {
            this.sb.appendFront("public bool IsTransientModel { get { return true; } }\n");
        }
        this.sb.appendFront("public GRGEN_LIBGR." + string + "Type RootType { get { return " + ModelGen.formatTypeClassRef(inheritanceType) + ".typeVar; } }\n");
        if (inheritanceTypeType == InheritanceTypeType.Node || inheritanceTypeType == InheritanceTypeType.Edge) {
            this.sb.appendFront("GRGEN_LIBGR.GraphElementType GRGEN_LIBGR.IGraphElementTypeModel.RootType { get { return " + ModelGen.formatTypeClassRef(inheritanceType) + ".typeVar; } }\n");
        } else {
            this.sb.appendFront("GRGEN_LIBGR.BaseObjectType GRGEN_LIBGR.IBaseObjectTypeModel.RootType { get { return " + ModelGen.formatTypeClassRef(inheritanceType) + ".typeVar; } }\n");
        }
        this.sb.appendFront("GRGEN_LIBGR.InheritanceType GRGEN_LIBGR.ITypeModel.RootType { get { return " + ModelGen.formatTypeClassRef(inheritanceType) + ".typeVar; } }\n");
        this.sb.appendFront("public GRGEN_LIBGR." + string + "Type GetType(string name)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("switch(name)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        for (InheritanceType inheritanceType2 : collection) {
            this.sb.appendFront("case \"" + ModelGen.getPackagePrefixDoubleColon(inheritanceType2) + ModelGen.formatIdentifiable(inheritanceType2) + "\" : return " + ModelGen.formatTypeClassRef(inheritanceType2) + ".typeVar;\n");
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.appendFront("return null;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        if (inheritanceTypeType == InheritanceTypeType.Node || inheritanceTypeType == InheritanceTypeType.Edge) {
            this.sb.appendFront("GRGEN_LIBGR.GraphElementType GRGEN_LIBGR.IGraphElementTypeModel.GetType(string name)\n");
            this.sb.appendFront("{\n");
            this.sb.appendFrontIndented("return GetType(name);\n");
            this.sb.appendFront("}\n");
        } else {
            this.sb.appendFront("GRGEN_LIBGR.BaseObjectType GRGEN_LIBGR.IBaseObjectTypeModel.GetType(string name)\n");
            this.sb.appendFront("{\n");
            this.sb.appendFrontIndented("return GetType(name);\n");
            this.sb.appendFront("}\n");
        }
        this.sb.appendFront("GRGEN_LIBGR.InheritanceType GRGEN_LIBGR.ITypeModel.GetType(string name)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("return GetType(name);\n");
        this.sb.appendFront("}\n");
        this.sb.appendFront("private GRGEN_LIBGR." + string + "Type[] types = {\n");
        this.sb.indent();
        for (InheritanceType inheritanceType2 : collection) {
            this.sb.appendFront(ModelGen.formatTypeClassRef(inheritanceType2) + ".typeVar,\n");
        }
        this.sb.unindent();
        this.sb.appendFront("};\n");
        this.sb.appendFront("public GRGEN_LIBGR." + string + "Type[] Types { get { return types; } }\n");
        if (inheritanceTypeType == InheritanceTypeType.Node || inheritanceTypeType == InheritanceTypeType.Edge) {
            this.sb.appendFront("GRGEN_LIBGR.GraphElementType[] GRGEN_LIBGR.IGraphElementTypeModel.Types { get { return types; } }\n");
        } else {
            this.sb.appendFront("GRGEN_LIBGR.BaseObjectType[] GRGEN_LIBGR.IBaseObjectTypeModel.Types { get { return types; } }\n");
        }
        this.sb.appendFront("GRGEN_LIBGR.InheritanceType[] GRGEN_LIBGR.ITypeModel.Types { get { return types; } }\n");
        this.sb.appendFront("private global::System.Type[] typeTypes = {\n");
        this.sb.indent();
        for (InheritanceType inheritanceType3 : collection) {
            this.sb.appendFront("typeof(" + ModelGen.formatTypeClassRef(inheritanceType3) + "),\n");
        }
        this.sb.unindent();
        this.sb.appendFront("};\n");
        this.sb.appendFront("public global::System.Type[] TypeTypes { get { return typeTypes; } }\n");
        this.sb.appendFront("private GRGEN_LIBGR.AttributeType[] attributeTypes = {\n");
        this.sb.indent();
        for (InheritanceType inheritanceType4 : collection) {
            String string2 = ModelGen.formatTypeClassRef(inheritanceType4);
            for (Entity entity : inheritanceType4.getMembers()) {
                this.sb.appendFront(string2 + "." + ModelGen.formatAttributeTypeName(entity) + ",\n");
            }
        }
        this.sb.unindent();
        this.sb.appendFront("};\n");
        this.sb.appendFront("public IEnumerable<GRGEN_LIBGR.AttributeType> AttributeTypes { get { return attributeTypes; } }\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private InheritanceType genModelConstructor(InheritanceTypeType inheritanceTypeType, Collection<? extends InheritanceType> collection) {
        String string = inheritanceTypeType.toString();
        InheritanceType inheritanceType = null;
        this.sb.appendFront("public " + this.model.getIdent() + string + "Model()\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        for (InheritanceType inheritanceType2 : collection) {
            String string2 = ModelGen.formatTypeClassRef(inheritanceType2);
            this.sb.appendFront(string2 + ".typeVar.subOrSameGrGenTypes = " + string2 + ".typeVar.subOrSameTypes = new GRGEN_LIBGR." + string + "Type[] {\n");
            this.sb.indent();
            this.sb.appendFront(string2 + ".typeVar,\n");
            for (InheritanceType inheritanceType3 : collection) {
                if (inheritanceType2 == inheritanceType3 || !inheritanceType3.isCastableTo(inheritanceType2)) continue;
                this.sb.appendFront(ModelGen.formatTypeClassRef(inheritanceType3) + ".typeVar,\n");
            }
            this.sb.unindent();
            this.sb.appendFront("};\n");
            this.sb.appendFront(string2 + ".typeVar.directSubGrGenTypes = " + string2 + ".typeVar.directSubTypes = new GRGEN_LIBGR." + string + "Type[] {\n");
            this.sb.indent();
            for (InheritanceType inheritanceType4 : inheritanceType2.getDirectSubTypes()) {
                if (!collection.contains(inheritanceType4)) continue;
                this.sb.appendFront(ModelGen.formatTypeClassRef(inheritanceType4) + ".typeVar,\n");
            }
            this.sb.unindent();
            this.sb.appendFront("};\n");
            this.sb.appendFront(string2 + ".typeVar.superOrSameGrGenTypes = " + string2 + ".typeVar.superOrSameTypes = new GRGEN_LIBGR." + string + "Type[] {\n");
            this.sb.indent();
            this.sb.appendFront(string2 + ".typeVar,\n");
            for (InheritanceType inheritanceType5 : collection) {
                if (inheritanceType2 == inheritanceType5 || !inheritanceType2.isCastableTo(inheritanceType5)) continue;
                this.sb.appendFront(ModelGen.formatTypeClassRef(inheritanceType5) + ".typeVar,\n");
            }
            this.sb.unindent();
            this.sb.appendFront("};\n");
            this.sb.appendFront(string2 + ".typeVar.directSuperGrGenTypes = " + string2 + ".typeVar.directSuperTypes = new GRGEN_LIBGR." + string + "Type[] {\n");
            this.sb.indent();
            for (InheritanceType inheritanceType6 : inheritanceType2.getDirectSuperTypes()) {
                this.sb.appendFront(ModelGen.formatTypeClassRef(inheritanceType6) + ".typeVar,\n");
            }
            this.sb.unindent();
            this.sb.appendFront("};\n");
            if (!inheritanceType2.isRoot()) continue;
            inheritanceType = inheritanceType2;
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        return inheritanceType;
    }

    private void genGraphModel() {
        String string = this.model.getIdent().toString();
        this.sb.appendFront("//\n");
        this.sb.appendFront("// IGraphModel (LGSPGraphModel) implementation\n");
        this.sb.appendFront("//\n");
        this.sb.appendFront("public sealed class " + string + "GraphModel : GRGEN_LGSP.LGSPGraphModel\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("public " + string + "GraphModel()\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("FullyInitializeExternalObjectTypes();\n");
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.genGraphModelBody(string);
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genGraphClass() {
        String string = this.model.getIdent().toString();
        this.sb.appendFront("//\n");
        this.sb.appendFront("// IGraph (LGSPGraph) implementation\n");
        this.sb.appendFront("//\n");
        this.sb.appendFront("public class " + string + "Graph : GRGEN_LGSP.LGSPGraph\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("public " + string + "Graph(GRGEN_LGSP.LGSPGlobalVariables globalVariables) : base(new " + string + "GraphModel(), globalVariables, GetGraphName())\n");
        this.sb.appendFront("{\n");
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        for (NodeType type : this.model.getNodeTypes()) {
            this.genCreateNodeConvenienceHelper(type, false);
        }
        for (PackageType packageType : this.model.getPackages()) {
            for (NodeType nodeType : packageType.getNodeTypes()) {
                this.genCreateNodeConvenienceHelper(nodeType, false);
            }
        }
        for (EdgeType edgeType : this.model.getEdgeTypes()) {
            this.genCreateEdgeConvenienceHelper(edgeType, false);
        }
        for (PackageType packageType : this.model.getPackages()) {
            for (EdgeType edgeType : packageType.getEdgeTypes()) {
                this.genCreateEdgeConvenienceHelper(edgeType, false);
            }
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genNamedGraphClass() {
        String string = this.model.getIdent().toString();
        this.sb.appendFront("//\n");
        this.sb.appendFront("// INamedGraph (LGSPNamedGraph) implementation\n");
        this.sb.appendFront("//\n");
        this.sb.appendFront("public class " + string + "NamedGraph : GRGEN_LGSP.LGSPNamedGraph\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("public " + string + "NamedGraph(GRGEN_LGSP.LGSPGlobalVariables globalVariables) : base(new " + string + "GraphModel(), globalVariables, GetGraphName(), 0)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        for (NodeType type : this.model.getNodeTypes()) {
            this.genCreateNodeConvenienceHelper(type, true);
        }
        for (PackageType packageType : this.model.getPackages()) {
            for (NodeType nodeType : packageType.getNodeTypes()) {
                this.genCreateNodeConvenienceHelper(nodeType, true);
            }
        }
        for (EdgeType edgeType : this.model.getEdgeTypes()) {
            this.genCreateEdgeConvenienceHelper(edgeType, true);
        }
        for (PackageType packageType : this.model.getPackages()) {
            for (EdgeType edgeType : packageType.getEdgeTypes()) {
                this.genCreateEdgeConvenienceHelper(edgeType, true);
            }
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genCreateNodeConvenienceHelper(NodeType nodeType, boolean bl) {
        if (nodeType.isAbstract()) {
            return;
        }
        String string = ModelGen.getPackagePrefix(nodeType) + ModelGen.formatIdentifiable(nodeType);
        String string2 = this.formatInheritanceClassRef(nodeType);
        this.sb.appendFront("public " + string2 + " CreateNode" + string + "()\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("return " + string2 + ".CreateNode(this);\n");
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        if (!bl) {
            return;
        }
        this.sb.appendFront("public " + string2 + " CreateNode" + string + "(string nodeName)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("return " + string2 + ".CreateNode(this, nodeName);\n");
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    private void genCreateEdgeConvenienceHelper(EdgeType edgeType, boolean bl) {
        if (edgeType.isAbstract()) {
            return;
        }
        String string = ModelGen.getPackagePrefix(edgeType) + ModelGen.formatIdentifiable(edgeType);
        String string2 = this.formatInheritanceClassRef(edgeType);
        this.sb.appendFront("public @" + string2 + " CreateEdge" + string);
        this.sb.append("(GRGEN_LGSP.LGSPNode source, GRGEN_LGSP.LGSPNode target)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("return @" + string2 + ".CreateEdge(this, source, target);\n");
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        if (!bl) {
            return;
        }
        this.sb.appendFront("public @" + string2 + " CreateEdge" + string);
        this.sb.append("(GRGEN_LGSP.LGSPNode source, GRGEN_LGSP.LGSPNode target, string edgeName)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("return @" + string2 + ".CreateEdge(this, source, target, edgeName);\n");
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    private void genGraphModelBody(String string) {
        this.sb.appendFront("private " + string + "NodeModel nodeModel = new " + string + "NodeModel();\n");
        this.sb.appendFront("private " + string + "EdgeModel edgeModel = new " + string + "EdgeModel();\n");
        this.sb.appendFront("private " + string + "ObjectModel objectModel = new " + string + "ObjectModel();\n");
        this.sb.appendFront("private " + string + "TransientObjectModel transientObjectModel = new " + string + "TransientObjectModel();\n");
        this.genPackages();
        this.genEnumAttributeTypes();
        this.genValidates();
        this.genIndexDescriptions();
        this.genIndicesGraphBinding();
        this.sb.append("\n");
        this.sb.appendFront("public override string ModelName { get { return \"" + string + "\"; } }\n");
        this.sb.appendFront("public override GRGEN_LIBGR.INodeModel NodeModel { get { return nodeModel; } }\n");
        this.sb.appendFront("public override GRGEN_LIBGR.IEdgeModel EdgeModel { get { return edgeModel; } }\n");
        this.sb.appendFront("public override GRGEN_LIBGR.IObjectModel ObjectModel { get { return objectModel; } }\n");
        this.sb.appendFront("public override GRGEN_LIBGR.ITransientObjectModel TransientObjectModel { get { return transientObjectModel; } }\n");
        this.sb.appendFront("public override IEnumerable<string> Packages { get { return packages; } }\n");
        this.sb.appendFront("public override IEnumerable<GRGEN_LIBGR.EnumAttributeType> EnumAttributeTypes { get { return enumAttributeTypes; } }\n");
        this.sb.appendFront("public override IEnumerable<GRGEN_LIBGR.ValidateInfo> ValidateInfo { get { return validateInfos; } }\n");
        this.sb.appendFront("public override IEnumerable<GRGEN_LIBGR.IndexDescription> IndexDescriptions { get { return indexDescriptions; } }\n");
        this.sb.appendFront("public static GRGEN_LIBGR.IndexDescription GetIndexDescription(int i) { return indexDescriptions[i]; }\n");
        this.sb.appendFront("public static GRGEN_LIBGR.IndexDescription GetIndexDescription(string indexName)\n ");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("for(int i=0; i<indexDescriptions.Length; ++i)\n");
        this.sb.indent();
        this.sb.appendFront("if(indexDescriptions[i].Name==indexName)\n");
        this.sb.appendFrontIndented("return indexDescriptions[i];\n");
        this.sb.unindent();
        this.sb.appendFront("return null;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.appendFront("public override bool GraphElementsReferenceContainingGraph { get { return " + (this.model.isGraphofDefined() ? "true" : "false") + "; } }\n");
        this.sb.appendFront("public override bool GraphElementUniquenessIsEnsured { get { return " + (this.model.isUniqueResulting() ? "true" : "false") + "; } }\n");
        this.sb.appendFront("public override bool GraphElementUniquenessIsUserRequested { get { return " + (this.model.isUniqueDefined() ? "true" : "false") + "; } }\n");
        this.sb.appendFront("public override bool ObjectUniquenessIsEnsured { get { return " + (this.model.isUniqueClassDefined() ? "true" : "false") + "; } }\n");
        this.sb.appendFront("public override bool GraphElementsAreAccessibleByUniqueId { get { return " + (this.model.isUniqueIndexDefined() ? "true" : "false") + "; } }\n");
        this.sb.appendFront("public override bool AreFunctionsParallelized { get { return " + this.model.areFunctionsParallel() + "; } }\n");
        this.sb.appendFront("public override int BranchingFactorForEqualsAny { get { return " + this.model.isoParallel() + "; } }\n");
        this.sb.appendFront("public override int ThreadPoolSizeForSequencesParallelExecution { get { return " + this.model.sequencesParallel() + "; } }\n");
        this.genGraphModelBodyAccessToExternalParts();
        this.genArrayHelperDispatchers();
        this.sb.append("\n");
        this.sb.appendFront("public override void FailAssertion() { Debug.Assert(false); }\n");
        this.sb.appendFront("public override string MD5Hash { get { return \"" + this.be.unit.getTypeDigest() + "\"; } }\n");
    }

    private void genArrayHelperDispatchers() {
        this.sb.append("\n");
        this.sb.appendFront("public override global::System.Collections.IList ArrayOrderAscendingBy(global::System.Collections.IList array, string member)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.genArrayHelperDispatcher("ArrayOrderAscendingBy", true, false, false);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public override global::System.Collections.IList ArrayOrderDescendingBy(global::System.Collections.IList array, string member)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.genArrayHelperDispatcher("ArrayOrderDescendingBy", true, false, false);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public override global::System.Collections.IList ArrayGroupBy(global::System.Collections.IList array, string member)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.genArrayHelperDispatcher("ArrayGroupBy", false, false, false);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public override global::System.Collections.IList ArrayKeepOneForEach(global::System.Collections.IList array, string member)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.genArrayHelperDispatcher("ArrayKeepOneForEachBy", false, false, false);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public override int ArrayIndexOfBy(global::System.Collections.IList array, string member, object value)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.genArrayHelperDispatcher("ArrayIndexOfBy", false, true, false);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public override int ArrayIndexOfBy(global::System.Collections.IList array, string member, object value, int startIndex)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.genArrayHelperDispatcher("ArrayIndexOfBy", false, true, true);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public override int ArrayLastIndexOfBy(global::System.Collections.IList array, string member, object value)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.genArrayHelperDispatcher("ArrayLastIndexOfBy", false, true, false);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public override int ArrayLastIndexOfBy(global::System.Collections.IList array, string member, object value, int startIndex)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.genArrayHelperDispatcher("ArrayLastIndexOfBy", false, true, true);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public override int ArrayIndexOfOrderedBy(global::System.Collections.IList array, string member, object value)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.genArrayHelperDispatcher("ArrayIndexOfOrderedBy", true, true, false);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    private void genArrayHelperDispatcher(String string, boolean bl, boolean bl2, boolean bl3) {
        this.sb.appendFront("if(array.Count == 0)\n");
        this.sb.appendFrontIndented("return " + (bl2 ? "-1" : "array") + ";\n");
        this.sb.appendFront("if(!(array[0] is GRGEN_LIBGR.IAttributeBearer))\n");
        this.sb.appendFrontIndented("return " + (bl2 ? "-1" : "null") + ";\n");
        this.sb.appendFront("GRGEN_LIBGR.IAttributeBearer elem = (GRGEN_LIBGR.IAttributeBearer)array[0];\n");
        this.sb.appendFront("switch(elem.Type.PackagePrefixedName)\n");
        this.sb.appendFront("{\n");
        for (InheritanceType inheritanceType : this.model.getAllInheritanceTypes()) {
            if (ModelGen.getNonAbstractTypeOrSubtype(inheritanceType) == null) continue;
            this.genArrayHelperByTypeDispatcher(inheritanceType, string, bl, bl2, bl3);
        }
        this.sb.appendFront("default: return " + (bl2 ? "-1" : "null") + ";\n");
        this.sb.appendFront("}\n");
    }

    private void genArrayHelperByTypeDispatcher(InheritanceType inheritanceType, String string, boolean bl, boolean bl2, boolean bl3) {
        this.sb.appendFront("case \"" + ModelGen.getPackagePrefixDoubleColon(inheritanceType) + ModelGen.formatIdentifiable(inheritanceType) + "\":\n");
        this.sb.indent();
        this.sb.appendFront("switch(member)\n");
        this.sb.appendFront("{\n");
        for (Entity entity : inheritanceType.getAllMembers()) {
            if (!this.hasArrayHelpers(entity) || bl && !entity.getType().isOrderableType()) continue;
            this.genArrayHelperByMemberDispatcher(inheritanceType, entity, string, bl2, bl3);
        }
        this.sb.appendFront("default:\n");
        this.sb.appendFrontIndented("return " + (bl2 ? "-1" : "null") + ";\n");
        this.sb.appendFront("}\n");
        this.sb.unindent();
    }

    private void genArrayHelperByMemberDispatcher(InheritanceType inheritanceType, Entity entity, String string, boolean bl, boolean bl2) {
        String string2 = this.formatType(inheritanceType);
        String string3 = ModelGen.formatIdentifiable(entity);
        String string4 = this.formatAttributeType(entity);
        String string5 = ModelGen.getPackagePrefixDot(inheritanceType) + "ArrayHelper_" + inheritanceType.getIdent().toString() + "_" + string3;
        this.sb.appendFront("case \"" + string3 + "\":\n");
        this.sb.appendFrontIndented("return " + string5 + "." + string + "((List<" + string2 + ">)array");
        if (bl) {
            this.sb.append(", (" + string4 + ")value");
        }
        if (bl2) {
            this.sb.append(", startIndex");
        }
        this.sb.append(");\n");
    }

    private void genGraphModelBodyAccessToExternalParts() {
        if (this.model.isEmitClassDefined()) {
            this.sb.append("\n");
            this.sb.appendFront("public override object Parse(TextReader reader, GRGEN_LIBGR.AttributeType attrType, GRGEN_LIBGR.IGraph graph)\n");
            this.sb.appendFront("{\n");
            this.sb.appendFrontIndented("return AttributeTypeObjectEmitterParser.Parse(reader, attrType, graph);\n");
            this.sb.appendFront("}\n");
            this.sb.appendFront("public override string Serialize(object attribute, GRGEN_LIBGR.AttributeType attrType, GRGEN_LIBGR.IGraph graph)\n");
            this.sb.appendFront("{\n");
            this.sb.appendFrontIndented("return AttributeTypeObjectEmitterParser.Serialize(attribute, attrType, graph);\n");
            this.sb.appendFront("}\n");
            this.sb.appendFront("public override string Emit(object attribute, GRGEN_LIBGR.AttributeType attrType, GRGEN_LIBGR.IGraph graph)\n");
            this.sb.appendFront("{\n");
            this.sb.appendFrontIndented("return AttributeTypeObjectEmitterParser.Emit(attribute, attrType, graph);\n");
            this.sb.appendFront("}\n");
            this.sb.appendFront("public override void External(string line, GRGEN_LIBGR.IGraph graph)\n");
            this.sb.appendFront("{\n");
            this.sb.appendFrontIndented("AttributeTypeObjectEmitterParser.External(line, graph);\n");
            this.sb.appendFront("}\n");
        }
        if (this.model.isEmitGraphClassDefined()) {
            this.sb.append("\n");
            this.sb.appendFront("public override GRGEN_LIBGR.INamedGraph AsGraph(object attribute, GRGEN_LIBGR.AttributeType attrType, GRGEN_LIBGR.IGraph graph)\n");
            this.sb.appendFront("{\n");
            this.sb.appendFrontIndented("return AttributeTypeObjectEmitterParser.AsGraph(attribute, attrType, graph);\n");
            this.sb.appendFront("}\n");
        }
        this.genExternalObjectTypes();
        this.sb.appendFront("public override GRGEN_LIBGR.ExternalObjectType[] ExternalObjectTypes { get { return externalObjectTypes; } }\n");
        this.sb.append("\n");
        this.sb.appendFront("private void FullyInitializeExternalObjectTypes()\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("externalObjectType_object.InitDirectSupertypes( new GRGEN_LIBGR.ExternalObjectType[] { } );\n");
        for (ExternalObjectType externalObjectType : this.model.getExternalObjectTypes()) {
            this.sb.appendFront("externalObjectType_" + externalObjectType.getIdent() + ".InitDirectSupertypes( new GRGEN_LIBGR.ExternalObjectType[] { ");
            boolean bl = false;
            for (InheritanceType inheritanceType : externalObjectType.getDirectSuperTypes()) {
                this.sb.append("externalObjectType_" + inheritanceType.getIdent() + ", ");
                bl = true;
            }
            if (!bl) {
                this.sb.append("externalObjectType_object ");
            }
            this.sb.append("} );\n");
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        if (this.model.isEqualClassDefined() && this.model.isLowerClassDefined()) {
            this.sb.append("\n");
            this.sb.appendFront("public override bool IsEqualClassDefined { get { return true; } }\n");
            this.sb.appendFront("public override bool IsLowerClassDefined { get { return true; } }\n");
            this.sb.appendFront("public override bool IsEqual(object this_, object that, IDictionary<object, object> visitedObjects)\n");
            this.sb.appendFront("{\n");
            this.sb.appendFrontIndented("return AttributeTypeObjectCopierComparer.IsEqual(this_, that, visitedObjects);\n");
            this.sb.appendFront("}\n");
            this.sb.appendFront("public override bool IsLower(object this_, object that, IDictionary<object, object> visitedObjects)\n");
            this.sb.appendFront("{\n");
            this.sb.appendFrontIndented("return AttributeTypeObjectCopierComparer.IsLower(this_, that, visitedObjects);\n");
            this.sb.appendFront("}\n");
        } else if (this.model.isEqualClassDefined()) {
            this.sb.append("\n");
            this.sb.appendFront("public override bool IsEqualClassDefined { get { return true; } }\n");
            this.sb.appendFront("public override bool IsEqual(object this_, object that, IDictionary<object, object> visitedObjects)\n");
            this.sb.appendFront("{\n");
            this.sb.appendFrontIndented("return AttributeTypeObjectCopierComparer.IsEqual(this_, that, visitedObjects);\n");
            this.sb.appendFront("}\n");
        }
    }

    private void genExternalObjectTypes() {
        this.sb.append("\n");
        this.sb.appendFront("public static GRGEN_LIBGR.ExternalObjectType externalObjectType_object = new ExternalObjectType_object();\n");
        for (ExternalObjectType externalObjectType : this.model.getExternalObjectTypes()) {
            this.sb.appendFront("public static GRGEN_LIBGR.ExternalObjectType externalObjectType_" + externalObjectType.getIdent() + " = new ExternalObjectType_" + externalObjectType.getIdent() + "();\n");
        }
        this.sb.appendFront("private GRGEN_LIBGR.ExternalObjectType[] externalObjectTypes = { ");
        this.sb.append("externalObjectType_object");
        for (ExternalObjectType externalObjectType : this.model.getExternalObjectTypes()) {
            this.sb.append(", externalObjectType_" + externalObjectType.getIdent());
        }
        this.sb.append(" };\n");
    }

    private void genPackages() {
        this.sb.appendFront("private string[] packages = {\n");
        this.sb.indent();
        for (PackageType packageType : this.model.getPackages()) {
            this.sb.appendFront("\"" + packageType.getIdent() + "\",\n");
        }
        this.sb.unindent();
        this.sb.appendFront("};\n");
    }

    private void genValidates() {
        this.sb.appendFront("private GRGEN_LIBGR.ValidateInfo[] validateInfos = {\n");
        for (EdgeType type : this.model.getEdgeTypes()) {
            this.genValidate(type);
        }
        for (PackageType packageType : this.model.getPackages()) {
            for (EdgeType edgeType : packageType.getEdgeTypes()) {
                this.genValidate(edgeType);
            }
        }
        this.sb.appendFront("};\n");
    }

    private void genValidate(EdgeType edgeType) {
        for (ConnAssert connAssert : edgeType.getConnAsserts()) {
            this.sb.appendFront("new GRGEN_LIBGR.ValidateInfo(");
            this.sb.append(ModelGen.formatTypeClassRef(edgeType) + ".typeVar, ");
            this.sb.append(ModelGen.formatTypeClassRef(connAssert.getSrcType()) + ".typeVar, ");
            this.sb.append(ModelGen.formatTypeClassRef(connAssert.getTgtType()) + ".typeVar, ");
            this.sb.append(ModelGen.formatLong(connAssert.getSrcLower()) + ", ");
            this.sb.append(ModelGen.formatLong(connAssert.getSrcUpper()) + ", ");
            this.sb.append(ModelGen.formatLong(connAssert.getTgtLower()) + ", ");
            this.sb.append(ModelGen.formatLong(connAssert.getTgtUpper()) + ", ");
            this.sb.append(connAssert.getBothDirections());
            this.sb.append("),\n");
        }
    }

    private void genIndexDescriptions() {
        this.sb.appendFront("private static GRGEN_LIBGR.IndexDescription[] indexDescriptions = {\n");
        for (Index index : this.model.getIndices()) {
            if (index instanceof AttributeIndex) {
                this.genIndexDescription((AttributeIndex)index);
                continue;
            }
            this.genIndexDescription((IncidenceCountIndex)index);
        }
        this.sb.appendFront("};\n");
    }

    private void genIndexDescription(AttributeIndex attributeIndex) {
        this.sb.appendFront("new GRGEN_LIBGR.AttributeIndexDescription(");
        this.sb.append("\"" + attributeIndex.getIdent() + "\", ");
        this.sb.append(ModelGen.formatTypeClassName(attributeIndex.type) + ".typeVar, ");
        this.sb.append(ModelGen.formatTypeClassName(attributeIndex.entity.getOwner()) + "." + ModelGen.formatAttributeTypeName(attributeIndex.entity));
        this.sb.append("),\n");
    }

    private void genIndexDescription(IncidenceCountIndex incidenceCountIndex) {
        this.sb.appendFront("new GRGEN_LIBGR.IncidenceCountIndexDescription(");
        this.sb.append("\"" + incidenceCountIndex.getIdent() + "\", ");
        switch (incidenceCountIndex.Direction()) {
            case OUTGOING: {
                this.sb.append("GRGEN_LIBGR.IncidenceDirection.OUTGOING, ");
                break;
            }
            case INCOMING: {
                this.sb.append("GRGEN_LIBGR.IncidenceDirection.INCOMING, ");
                break;
            }
            case INCIDENT: {
                this.sb.append("GRGEN_LIBGR.IncidenceDirection.INCIDENT, ");
                break;
            }
            case INVALID: {
                throw new RuntimeException("Internal compiler error");
            }
        }
        this.sb.append(ModelGen.formatTypeClassRefInstance(incidenceCountIndex.getStartNodeType()) + ", ");
        this.sb.append(ModelGen.formatTypeClassRefInstance(incidenceCountIndex.getIncidentEdgeType()) + ", ");
        this.sb.append(ModelGen.formatTypeClassRefInstance(incidenceCountIndex.getAdjacentNodeType()));
        this.sb.append("),\n");
    }

    private void genIndicesGraphBinding() {
        this.sb.appendFront("public override GRGEN_LIBGR.IUniquenessHandler CreateUniquenessHandler(GRGEN_LIBGR.IGraph graph) {\n");
        this.sb.indent();
        if (this.model.isUniqueIndexDefined()) {
            this.sb.appendFront("return new GRGEN_LGSP.LGSPUniquenessIndex((GRGEN_LGSP.LGSPGraph)graph); // must be called before the indices so that its event handler is registered first, doing the unique id computation the indices depend upon\n");
        } else if (this.model.isUniqueResulting()) {
            this.sb.appendFront("return new GRGEN_LGSP.LGSPUniquenessEnsurer((GRGEN_LGSP.LGSPGraph)graph); // must be called before the indices so that its event handler is registered first, doing the unique id computation the indices depend upon\n");
        } else {
            this.sb.appendFront("return null;\n");
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.appendFront("public override GRGEN_LIBGR.IIndexSet CreateIndexSet(GRGEN_LIBGR.IGraph graph) {\n");
        this.sb.appendFrontIndented("return new " + this.model.getIdent() + "IndexSet((GRGEN_LGSP.LGSPGraph)graph);\n");
        this.sb.appendFront("}\n");
        this.sb.appendFront("public override void FillIndexSetAsClone(GRGEN_LIBGR.IGraph graph, GRGEN_LIBGR.IGraph originalGraph, IDictionary<GRGEN_LIBGR.IGraphElement, GRGEN_LIBGR.IGraphElement> oldToNewMap) {\n");
        this.sb.indent();
        if (this.model.isUniqueResulting()) {
            this.sb.appendFront("((GRGEN_LGSP.LGSPUniquenessEnsurer)graph.UniquenessHandler).FillAsClone((GRGEN_LGSP.LGSPUniquenessEnsurer)originalGraph.UniquenessHandler, oldToNewMap);\n");
        }
        this.sb.appendFront("((" + this.model.getIdent() + "IndexSet)graph.Indices).FillAsClone((GRGEN_LGSP.LGSPGraph)originalGraph, oldToNewMap);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    private void genEnumAttributeTypes() {
        this.sb.appendFront("private GRGEN_LIBGR.EnumAttributeType[] enumAttributeTypes = {\n");
        this.sb.indent();
        for (EnumType primitiveType : this.model.getEnumTypes()) {
            this.genEnumAttributeType(primitiveType);
        }
        for (PackageType packageType : this.model.getPackages()) {
            for (EnumType enumType : packageType.getEnumTypes()) {
                this.genEnumAttributeType(enumType);
            }
        }
        this.sb.unindent();
        this.sb.appendFront("};\n");
    }

    private void genEnumAttributeType(EnumType enumType) {
        this.sb.appendFront("GRGEN_MODEL." + ModelGen.getPackagePrefixDot(enumType) + "Enums.@" + ModelGen.formatIdentifiable(enumType) + ",\n");
    }

    private static String getKindName(InheritanceType inheritanceType) {
        if (inheritanceType instanceof NodeType) {
            return "Node";
        }
        if (inheritanceType instanceof EdgeType) {
            return "Edge";
        }
        if (inheritanceType instanceof InternalTransientObjectType) {
            return "TransientObject";
        }
        return "Object";
    }

    static enum InheritanceTypeType {
        Node,
        Edge,
        Object,
        TransientObject;

    }
}

