/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.be;

import de.unika.ipd.grgen.be.IDTypeModel;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.Identifiable;
import de.unika.ipd.grgen.ir.Unit;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import de.unika.ipd.grgen.ir.model.type.EnumType;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.ir.type.CompoundType;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.util.Base;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class IDBase
extends Base
implements IDTypeModel {
    public final Map<NodeType, Integer> nodeTypeMap = new LinkedHashMap<NodeType, Integer>();
    public final Map<EdgeType, Integer> edgeTypeMap = new LinkedHashMap<EdgeType, Integer>();
    public final Map<Entity, Integer> nodeAttrMap = new LinkedHashMap<Entity, Integer>();
    public final Map<Entity, Integer> edgeAttrMap = new LinkedHashMap<Entity, Integer>();
    public final Map<EnumType, Integer> enumMap = new LinkedHashMap<EnumType, Integer>();
    public final Map<Rule, Integer> actionRuleMap = new LinkedHashMap<Rule, Integer>();
    public final Map<Rule, Integer> subpatternRuleMap = new LinkedHashMap<Rule, Integer>();
    private short[][] nodeTypeIsAMatrix;
    private short[][] edgeTypeIsAMatrix;
    private int[][] nodeTypeSuperTypes;
    private int[][] edgeTypeSuperTypes;
    private int[][] nodeTypeSubTypes;
    private int[][] edgeTypeSubTypes;
    private String[] nodeTypeNames;
    private String[] edgeTypeNames;
    private int edgeRoot;
    private int nodeRoot;

    private void addMembers(CompoundType compoundType) {
        for (Entity entity : compoundType.getMembers()) {
            if (compoundType instanceof NodeType) {
                this.nodeAttrMap.put(entity, new Integer(this.nodeAttrMap.size()));
                continue;
            }
            if (compoundType instanceof EdgeType) {
                this.edgeAttrMap.put(entity, new Integer(this.edgeAttrMap.size()));
                continue;
            }
            assert (false) : "Wrong type";
        }
    }

    private void makeTypeIds(Unit unit) {
        unit.canonicalize();
        for (Type type : unit.getActionsGraphModel().getTypes()) {
            if (type instanceof NodeType) {
                this.nodeTypeMap.put((NodeType)type, new Integer(this.nodeTypeMap.size()));
            } else if (type instanceof EdgeType) {
                this.edgeTypeMap.put((EdgeType)type, new Integer(this.edgeTypeMap.size()));
            } else if (type instanceof EnumType) {
                this.enumMap.put((EnumType)type, new Integer(this.enumMap.size()));
            }
            if (!(type instanceof CompoundType)) continue;
            CompoundType compoundType = (CompoundType)type;
            this.addMembers(compoundType);
        }
    }

    public static final short[][] computeIsA(Map<? extends InheritanceType, Integer> map) {
        int n = 0;
        Object object = map.values().iterator();
        while (object.hasNext()) {
            int n2 = object.next();
            n = n2 > n ? n2 : n;
        }
        object = new short[n + 1][n + 1];
        for (InheritanceType inheritanceType : map.keySet()) {
            int n3 = map.get(inheritanceType);
            object[n3][n3] = true;
            for (InheritanceType inheritanceType2 : inheritanceType.getDirectSuperTypes()) {
                int n4 = map.get(inheritanceType2);
                object[n3][n4] = true;
            }
        }
        object = IDBase.floydWarshall((short[][])object);
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i][i] = false;
        }
        return object;
    }

    private static short[][] floydWarshall(short[][] sArray) {
        int n = sArray.length;
        short[][] sArray2 = sArray;
        short[][] sArray3 = new short[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n; ++k) {
                    short s = sArray2[j][i];
                    short s2 = sArray2[i][k];
                    int n2 = s == 0 || s2 == 0 ? Short.MAX_VALUE : s + s2;
                    int n3 = sArray2[j][k];
                    n3 = n3 == 0 ? Short.MAX_VALUE : n3;
                    n3 = n3 < n2 ? n3 : n2;
                    sArray3[j][k] = (short)(n3 == Short.MAX_VALUE ? 0 : n3);
                }
            }
            short[][] sArray4 = sArray2;
            sArray2 = sArray3;
            sArray3 = sArray4;
        }
        return sArray3;
    }

    private static int[][] computeSuperTypes(Map<? extends InheritanceType, Integer> map) {
        int[][] nArrayArray = new int[map.size()][];
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (InheritanceType inheritanceType : map.keySet()) {
            linkedList.clear();
            int n = map.get(inheritanceType);
            for (InheritanceType inheritanceType2 : inheritanceType.getDirectSuperTypes()) {
                linkedList.add(map.get(inheritanceType2));
            }
            nArrayArray[n] = new int[linkedList.size()];
            int n2 = 0;
            Iterator object2 = linkedList.iterator();
            while (object2.hasNext()) {
                nArrayArray[n][n2] = (Integer)object2.next();
                ++n2;
            }
        }
        return nArrayArray;
    }

    private static int[][] computeSubTypes(Map<? extends InheritanceType, Integer> map) {
        int[][] nArrayArray = new int[map.size()][];
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (InheritanceType inheritanceType : map.keySet()) {
            linkedList.clear();
            int n = map.get(inheritanceType);
            for (InheritanceType inheritanceType2 : inheritanceType.getDirectSubTypes()) {
                linkedList.add(map.get(inheritanceType2));
            }
            nArrayArray[n] = new int[linkedList.size()];
            int n2 = 0;
            Iterator object2 = linkedList.iterator();
            while (object2.hasNext()) {
                nArrayArray[n][n2] = (Integer)object2.next();
                ++n2;
            }
        }
        return nArrayArray;
    }

    private static String[] makeNames(Map<? extends InheritanceType, Integer> map) {
        String[] stringArray = new String[map.size()];
        for (InheritanceType inheritanceType : map.keySet()) {
            int n = map.get(inheritanceType);
            stringArray[n] = inheritanceType.getIdent().toString();
        }
        return stringArray;
    }

    private void makeSubpatternIds(Unit unit) {
        int n = 0;
        for (Rule rule : unit.getSubpatternRules()) {
            this.subpatternRuleMap.put(rule, new Integer(n));
            ++n;
        }
    }

    private void makeActionIds(Unit unit) {
        int n = 0;
        for (Rule rule : unit.getActionRules()) {
            this.actionRuleMap.put(rule, new Integer(n));
            ++n;
        }
    }

    protected static final int getTypeId(Map<? extends Identifiable, Integer> map, IR iR) {
        Integer n = map.get(iR);
        return n;
    }

    @Override
    public final int getId(EdgeType edgeType) {
        return IDBase.getTypeId(this.edgeTypeMap, edgeType);
    }

    @Override
    public final int getId(NodeType nodeType) {
        return IDBase.getTypeId(this.nodeTypeMap, nodeType);
    }

    @Override
    public final int getId(Type type, boolean bl) {
        return bl ? IDBase.getTypeId(this.nodeTypeMap, type) : IDBase.getTypeId(this.edgeTypeMap, type);
    }

    @Override
    public final short[][] getIsAMatrix(boolean bl) {
        return bl ? this.nodeTypeIsAMatrix : this.edgeTypeIsAMatrix;
    }

    @Override
    public final String getTypeName(boolean bl, int n) {
        return bl ? this.nodeTypeNames[n] : this.edgeTypeNames[n];
    }

    @Override
    public final int[] getSuperTypes(boolean bl, int n) {
        return bl ? this.nodeTypeSuperTypes[n] : this.edgeTypeSuperTypes[n];
    }

    @Override
    public final int[] getSubTypes(boolean bl, int n) {
        return bl ? this.nodeTypeSubTypes[n] : this.edgeTypeSubTypes[n];
    }

    @Override
    public final int getRootType(boolean bl) {
        return bl ? this.nodeRoot : this.edgeRoot;
    }

    @Override
    public final int[] getIDs(boolean bl) {
        Map<InheritanceType, Integer> map = bl ? this.nodeTypeMap : this.edgeTypeMap;
        int[] nArray = new int[map.size()];
        int n = 0;
        Iterator<Integer> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            nArray[n++] = iterator.next();
        }
        return nArray;
    }

    protected final void makeTypes(Unit unit) {
        this.makeTypeIds(unit);
        this.makeSubpatternIds(unit);
        this.makeActionIds(unit);
        this.nodeTypeIsAMatrix = IDBase.computeIsA(this.nodeTypeMap);
        this.edgeTypeIsAMatrix = IDBase.computeIsA(this.edgeTypeMap);
        this.nodeTypeSuperTypes = IDBase.computeSuperTypes(this.nodeTypeMap);
        this.edgeTypeSuperTypes = IDBase.computeSuperTypes(this.edgeTypeMap);
        this.nodeTypeSubTypes = IDBase.computeSubTypes(this.nodeTypeMap);
        this.edgeTypeSubTypes = IDBase.computeSubTypes(this.edgeTypeMap);
        this.nodeTypeNames = IDBase.makeNames(this.nodeTypeMap);
        this.edgeTypeNames = IDBase.makeNames(this.edgeTypeMap);
    }
}

