/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.PatternGraphBase;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.util.GraphDumpVisitor;
import de.unika.ipd.grgen.util.GraphDumpable;
import de.unika.ipd.grgen.util.GraphDumpableProxy;
import de.unika.ipd.grgen.util.Walkable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class DumpVisitor
extends GraphDumpVisitor {
    private void dumpGraph(PatternGraphBase patternGraphBase, String string) {
        Object object;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Collection<Node> collection = patternGraphBase.getNodes();
        this.dumper.beginSubgraph(patternGraphBase);
        for (Node object32 : collection) {
            debug.report(4, "node: " + object32);
            object = new PrefixNode(object32, string);
            hashMap.put(object32, object);
            this.dumper.node((GraphDumpable)object);
        }
        Collection<Edge> collection2 = patternGraphBase.getEdges();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            object = (Edge)iterator.next();
            GraphDumpable graphDumpable = new PrefixNode((GraphDumpable)object, string);
            hashMap.put(object, graphDumpable);
            debug.report(4, "true edge from: " + patternGraphBase.getSource((Edge)object) + " to: " + patternGraphBase.getTarget((Edge)object));
            PrefixNode prefixNode = (PrefixNode)hashMap.get(patternGraphBase.getSource((Edge)object));
            PrefixNode prefixNode2 = (PrefixNode)hashMap.get(patternGraphBase.getTarget((Edge)object));
            debug.report(4, "edge from: " + prefixNode + " to: " + prefixNode2);
            this.dumper.node(graphDumpable);
            this.dumper.edge(prefixNode, graphDumpable);
            this.dumper.edge(graphDumpable, prefixNode2);
        }
        if (patternGraphBase instanceof PatternGraphLhs) {
            PatternGraphLhs patternGraphLhs = (PatternGraphLhs)patternGraphBase;
            for (Collection collection3 : patternGraphLhs.getHomomorphic()) {
                if (collection3.isEmpty()) continue;
                for (GraphDumpable graphDumpable : collection3) {
                    for (Entity entity : collection3) {
                        PrefixNode prefixNode = (PrefixNode)hashMap.get(graphDumpable);
                        PrefixNode prefixNode3 = (PrefixNode)hashMap.get(entity);
                        this.dumper.edge(prefixNode, prefixNode3, "hom", 1);
                    }
                }
            }
        }
        this.dumper.endSubgraph();
    }

    @Override
    public void visit(Walkable walkable) {
        assert (walkable instanceof IR) : "must have an ir object to dump";
        if (walkable instanceof Node || walkable instanceof Edge || walkable instanceof PatternGraphBase) {
            return;
        }
        if (walkable instanceof Rule && ((Rule)((Object)walkable)).getRight() != null) {
            PrefixNode prefixNode;
            Rule rule = (Rule)((Object)walkable);
            this.dumper.beginSubgraph(rule);
            if (rule.getRight() == null) {
                this.dumpGraph(rule.getPattern(), "");
                this.dumper.endSubgraph();
            }
            this.dumpGraph(rule.getLeft(), "l");
            this.dumpGraph(rule.getRight(), "r");
            for (Node object : rule.getCommonNodes()) {
                PrefixNode prefixNode2 = new PrefixNode(object, "l");
                prefixNode = new PrefixNode(object, "r");
                this.dumper.edge(prefixNode2, prefixNode, null, 2);
            }
            for (Edge edge : rule.getCommonEdges()) {
                prefixNode = new PrefixNode(edge, "l");
                PrefixNode prefixNode3 = new PrefixNode(edge, "r");
                this.dumper.edge(prefixNode, prefixNode3, null, 2);
            }
            this.dumper.endSubgraph();
        } else {
            super.visit(walkable);
        }
    }

    private class PrefixNode
    extends GraphDumpableProxy {
        private String prefix;

        public PrefixNode(GraphDumpable graphDumpable, String string) {
            super(graphDumpable);
            this.prefix = string;
        }

        @Override
        public String getNodeId() {
            return this.prefix + this.getGraphDumpable().getNodeId();
        }

        public String toString() {
            return this.getNodeId();
        }
    }
}

