/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.ImperativeStmt;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class Exec
extends IR
implements ImperativeStmt {
    private Set<Expression> parameters = new LinkedHashSet<Expression>();
    private Set<Entity> neededEntities;
    private Set<Entity> neededEntitiesForComputation;
    private String xgrsString;
    private int lineNr;

    public Exec(String string, Set<Expression> set, int n) {
        super("exec");
        this.xgrsString = string;
        this.parameters = set;
        this.lineNr = n;
    }

    public String getXGRSString() {
        return this.xgrsString;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public Set<Expression> getArguments() {
        return Collections.unmodifiableSet(this.parameters);
    }

    public Set<Entity> getNeededEntities(boolean bl) {
        if (bl) {
            if (this.neededEntitiesForComputation == null) {
                NeededEntities neededEntities = new NeededEntities(EnumSet.of(NeededEntities.Needs.ALL_ENTITIES, NeededEntities.Needs.COMPUTATION_CONTEXT));
                for (Expression expression : this.getArguments()) {
                    expression.collectNeededEntities(neededEntities);
                }
                this.neededEntitiesForComputation = neededEntities.entities;
            }
            return this.neededEntitiesForComputation;
        }
        if (this.neededEntities == null) {
            NeededEntities neededEntities = new NeededEntities(EnumSet.of(NeededEntities.Needs.ALL_ENTITIES));
            for (Expression expression : this.getArguments()) {
                expression.collectNeededEntities(neededEntities);
            }
            this.neededEntities = neededEntities.entities;
        }
        return this.neededEntities;
    }
}

