/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.MemberExpression;
import de.unika.ipd.grgen.ir.expr.array.ArrayMapExpr;
import de.unika.ipd.grgen.ir.expr.array.ArrayRemoveIfExpr;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.Variable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class NeededEntities {
    public boolean isGraphUsed;
    public HashSet<Node> nodes;
    public HashSet<Edge> edges;
    public HashSet<Variable> variables;
    public HashSet<Entity> entities;
    public HashSet<Entity> members;
    public HashMap<GraphEntity, HashSet<Entity>> attrEntityMap;
    public HashSet<Node> attrNodes;
    public HashSet<Edge> attrEdges;
    public boolean collectContainerExprs;
    public HashSet<Expression> containerExprs;
    public boolean collectComputationContext = false;
    public HashSet<Expression> lambdaExprs;

    public NeededEntities(EnumSet<Needs> enumSet) {
        if (enumSet.contains((Object)Needs.NODES)) {
            this.nodes = new LinkedHashSet<Node>();
        }
        if (enumSet.contains((Object)Needs.EDGES)) {
            this.edges = new LinkedHashSet<Edge>();
        }
        if (enumSet.contains((Object)Needs.VARS)) {
            this.variables = new LinkedHashSet<Variable>();
        }
        if (enumSet.contains((Object)Needs.ALL_ENTITIES)) {
            this.entities = new LinkedHashSet<Entity>();
        }
        if (enumSet.contains((Object)Needs.ALL_ATTRIBUTES)) {
            this.attrEntityMap = new LinkedHashMap<GraphEntity, HashSet<Entity>>();
            this.attrNodes = new LinkedHashSet<Node>();
            this.attrEdges = new LinkedHashSet<Edge>();
        }
        if (enumSet.contains((Object)Needs.CONTAINER_EXPRS)) {
            this.collectContainerExprs = true;
            this.containerExprs = new LinkedHashSet<Expression>();
        }
        if (enumSet.contains((Object)Needs.MEMBERS)) {
            this.members = new LinkedHashSet<Entity>();
        }
        if (enumSet.contains((Object)Needs.COMPUTATION_CONTEXT)) {
            this.collectComputationContext = true;
        }
        if (enumSet.contains((Object)Needs.LAMBDAS)) {
            this.lambdaExprs = new LinkedHashSet<Expression>();
        }
    }

    public void add(GraphEntity graphEntity) {
        if ((graphEntity.getContext() & 0x40) == 64 && !this.collectComputationContext) {
            return;
        }
        if (graphEntity instanceof Node) {
            if (this.nodes != null) {
                this.nodes.add((Node)graphEntity);
            }
        } else if (graphEntity instanceof Edge) {
            if (this.edges != null) {
                this.edges.add((Edge)graphEntity);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported entity (" + graphEntity + ")");
        }
        if (this.entities != null) {
            this.entities.add(graphEntity);
        }
    }

    public void add(Node node) {
        if ((node.getContext() & 0x40) == 64 && !this.collectComputationContext) {
            return;
        }
        if (this.nodes != null) {
            this.nodes.add(node);
        }
        if (this.entities != null) {
            this.entities.add(node);
        }
    }

    public void add(Edge edge) {
        if ((edge.getContext() & 0x40) == 64 && !this.collectComputationContext) {
            return;
        }
        if (this.edges != null) {
            this.edges.add(edge);
        }
        if (this.entities != null) {
            this.entities.add(edge);
        }
    }

    public void add(Variable variable) {
        if ((variable.getContext() & 0x40) == 64 && !this.collectComputationContext) {
            return;
        }
        if (!(this.variables == null || variable.isLambdaExpressionVariable && this.lambdaExprs == null)) {
            this.variables.add(variable);
        }
        if (!(this.entities == null || variable.isLambdaExpressionVariable && this.lambdaExprs == null)) {
            this.entities.add(variable);
        }
    }

    public void addAttr(GraphEntity graphEntity, Entity entity) {
        if ((graphEntity.getContext() & 0x40) == 64 && !this.collectComputationContext) {
            return;
        }
        if (this.attrEntityMap == null) {
            this.add(graphEntity);
            return;
        }
        HashSet<Entity> hashSet = this.attrEntityMap.get(graphEntity);
        if (hashSet == null) {
            hashSet = new LinkedHashSet<Entity>();
            this.attrEntityMap.put(graphEntity, hashSet);
        }
        hashSet.add(entity);
        if (graphEntity instanceof Node) {
            this.attrNodes.add((Node)graphEntity);
        } else if (graphEntity instanceof Edge) {
            this.attrEdges.add((Edge)graphEntity);
        } else {
            throw new UnsupportedOperationException("Unsupported entity (" + graphEntity + ")");
        }
    }

    public void add(Expression expression) {
        if (this.collectContainerExprs) {
            this.containerExprs.add(expression);
        }
    }

    public void add(MemberExpression memberExpression) {
        if (this.members != null) {
            this.members.add(memberExpression.getMember());
        }
    }

    public void add(ArrayMapExpr arrayMapExpr) {
        if (this.lambdaExprs != null) {
            this.lambdaExprs.add(arrayMapExpr);
        }
    }

    public void add(ArrayRemoveIfExpr arrayRemoveIfExpr) {
        if (this.lambdaExprs != null) {
            this.lambdaExprs.add(arrayRemoveIfExpr);
        }
    }

    public void needsGraph() {
        this.isGraphUsed = true;
    }

    public static enum Needs {
        NODES,
        EDGES,
        VARS,
        ALL_ENTITIES,
        ALL_ATTRIBUTES,
        CONTAINER_EXPRS,
        COMPUTATION_CONTEXT,
        MEMBERS,
        LAMBDAS;

    }
}

