/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir;

import de.unika.ipd.grgen.ir.ActionsBearer;
import de.unika.ipd.grgen.ir.ComposedActionsBearer;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.FilterFunction;
import de.unika.ipd.grgen.ir.executable.Function;
import de.unika.ipd.grgen.ir.executable.MatchClassFilterFunction;
import de.unika.ipd.grgen.ir.executable.Procedure;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.executable.Sequence;
import de.unika.ipd.grgen.ir.model.Model;
import de.unika.ipd.grgen.ir.model.NodeEdgeEnumBearer;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.model.type.PackageType;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.type.DefinedMatchType;
import de.unika.ipd.grgen.ir.type.PackageActionType;
import de.unika.ipd.grgen.util.Util;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Unit
extends IR
implements ActionsBearer {
    private final List<Model> models = new LinkedList<Model>();
    private final List<Rule> subpatternRules = new LinkedList<Rule>();
    private final List<Rule> actionRules = new LinkedList<Rule>();
    private final List<FilterFunction> filterFunctions = new LinkedList<FilterFunction>();
    private final List<DefinedMatchType> matchClasses = new LinkedList<DefinedMatchType>();
    private final List<MatchClassFilterFunction> matchClassFilterFunctions = new LinkedList<MatchClassFilterFunction>();
    private final List<Function> functions = new LinkedList<Function>();
    private final List<Procedure> procedures = new LinkedList<Procedure>();
    private final List<Sequence> sequences = new LinkedList<Sequence>();
    private final List<PackageActionType> packages = new LinkedList<PackageActionType>();
    private String digest = "";
    private boolean digestValid = false;
    private String unitName;
    private String filename;

    public Unit(String string, String string2) {
        super("unit");
        this.unitName = string;
        this.filename = string2;
    }

    public void addModel(Model model) {
        this.models.add(model);
        this.digestValid = false;
    }

    public Collection<Model> getModels() {
        return Collections.unmodifiableCollection(this.models);
    }

    public void addSubpatternRule(Rule rule) {
        this.subpatternRules.add(rule);
    }

    @Override
    public Collection<Rule> getSubpatternRules() {
        return Collections.unmodifiableCollection(this.subpatternRules);
    }

    public void addActionRule(Rule rule) {
        this.actionRules.add(rule);
    }

    @Override
    public Collection<Rule> getActionRules() {
        return Collections.unmodifiableCollection(this.actionRules);
    }

    public void addFilterFunction(FilterFunction filterFunction) {
        this.filterFunctions.add(filterFunction);
    }

    @Override
    public Collection<FilterFunction> getFilterFunctions() {
        return Collections.unmodifiableCollection(this.filterFunctions);
    }

    public void addMatchClass(DefinedMatchType definedMatchType) {
        this.matchClasses.add(definedMatchType);
    }

    @Override
    public Collection<DefinedMatchType> getMatchClasses() {
        return Collections.unmodifiableCollection(this.matchClasses);
    }

    public void addMatchClassFilterFunction(MatchClassFilterFunction matchClassFilterFunction) {
        this.matchClassFilterFunctions.add(matchClassFilterFunction);
    }

    @Override
    public Collection<MatchClassFilterFunction> getMatchClassFilterFunctions() {
        return Collections.unmodifiableCollection(this.matchClassFilterFunctions);
    }

    public void addFunction(Function function) {
        this.functions.add(function);
    }

    @Override
    public Collection<Function> getFunctions() {
        return Collections.unmodifiableCollection(this.functions);
    }

    public void addProcedure(Procedure procedure) {
        this.procedures.add(procedure);
    }

    @Override
    public Collection<Procedure> getProcedures() {
        return Collections.unmodifiableCollection(this.procedures);
    }

    public void addSequence(Sequence sequence) {
        this.sequences.add(sequence);
    }

    @Override
    public Collection<Sequence> getSequences() {
        return Collections.unmodifiableCollection(this.sequences);
    }

    public void addPackage(PackageActionType packageActionType) {
        this.packages.add(packageActionType);
    }

    public Collection<PackageActionType> getPackages() {
        return Collections.unmodifiableCollection(this.packages);
    }

    public Model getActionsGraphModel() {
        return this.models.get(0);
    }

    public String getActionsGraphModelName() {
        return this.models.get(0).getIdent().toString();
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public void addFields(Map<String, Object> map) {
        super.addFields(map);
        map.put("models", this.models.iterator());
    }

    @Override
    protected void canonicalizeLocal() {
        for (Model model : this.models) {
            model.canonicalize();
        }
    }

    public void addToDigest(StringBuffer stringBuffer) {
        for (Model model : this.models) {
            model.addToDigest(stringBuffer);
        }
    }

    private void buildDigest() {
        StringBuffer stringBuffer = new StringBuffer();
        this.addToDigest(stringBuffer);
        try {
            byte[] byArray = stringBuffer.toString().getBytes("US-ASCII");
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            this.digest = Util.hexString(messageDigest.digest(byArray));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            this.digest = "<error>";
        }
        this.digestValid = true;
    }

    public final String getTypeDigest() {
        if (!this.digestValid) {
            this.buildDigest();
        }
        return this.digest;
    }

    public void postPatchIR() {
        for (Model model : this.models) {
            Unit.postPatchIR(model);
            for (PackageType packageType : model.getPackages()) {
                Unit.postPatchIR(packageType);
            }
        }
        Unit.postPatchIR(new ComposedActionsBearer(this));
    }

    public static void postPatchIR(NodeEdgeEnumBearer nodeEdgeEnumBearer) {
        for (InheritanceType inheritanceType : nodeEdgeEnumBearer.getNodeTypes()) {
            inheritanceType.getAllMembers();
        }
        for (InheritanceType inheritanceType : nodeEdgeEnumBearer.getEdgeTypes()) {
            inheritanceType.getAllMembers();
        }
        for (InheritanceType inheritanceType : nodeEdgeEnumBearer.getObjectTypes()) {
            inheritanceType.getAllMembers();
        }
        for (InheritanceType inheritanceType : nodeEdgeEnumBearer.getTransientObjectTypes()) {
            inheritanceType.getAllMembers();
        }
    }

    public static void postPatchIR(ActionsBearer actionsBearer) {
    }

    public void checkForEmptyPatternsInIterateds() {
        Unit.checkForEmptyPatternsInIterateds(new ComposedActionsBearer(this));
    }

    public static void checkForEmptyPatternsInIterateds(ActionsBearer actionsBearer) {
        for (Rule rule : actionsBearer.getActionRules()) {
            rule.pattern.checkForEmptyPatternsInIterateds();
        }
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            rule.pattern.checkForEmptyPatternsInIterateds();
        }
    }

    public void checkForEmptySubpatternRecursions() {
        Unit.checkForEmptySubpatternRecursions(new ComposedActionsBearer(this));
    }

    public static void checkForEmptySubpatternRecursions(ActionsBearer actionsBearer) {
        HashSet<PatternGraphLhs> hashSet = new HashSet<PatternGraphLhs>();
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            hashSet.add(rule.pattern);
            rule.pattern.checkForEmptySubpatternRecursions(hashSet);
            hashSet.clear();
        }
    }

    public void checkForNeverSucceedingSubpatternRecursions() {
        Unit.checkForNeverSucceedingSubpatternRecursions(new ComposedActionsBearer(this));
    }

    public static void checkForNeverSucceedingSubpatternRecursions(ActionsBearer actionsBearer) {
        HashSet<PatternGraphLhs> hashSet = new HashSet<PatternGraphLhs>();
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            hashSet.add(rule.pattern);
            if (rule.pattern.isNeverTerminatingSuccessfully(hashSet)) {
                error.warning(rule.getIdent().getCoords(), "Matching the subpattern " + rule.getIdent() + " will never terminate successfully (endless recursion on any path, only (potentially) terminated by failing matching).");
            }
            hashSet.clear();
        }
    }

    public void checkForMultipleRetypes() {
        Unit.checkForMultipleRetypes(new ComposedActionsBearer(this));
    }

    public static void checkForMultipleRetypes(ActionsBearer actionsBearer) {
        HashSet<Node> hashSet = new HashSet<Node>();
        HashSet<Edge> hashSet2 = new HashSet<Edge>();
        for (Rule rule : actionsBearer.getActionRules()) {
            if (rule.getRight() == null) continue;
            rule.pattern.checkForMultipleRetypes(hashSet, hashSet2, rule.getRight());
            hashSet.clear();
            hashSet2.clear();
        }
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            if (rule.getRight() == null) continue;
            rule.pattern.checkForMultipleRetypes(hashSet, hashSet2, rule.getRight());
            hashSet.clear();
            hashSet2.clear();
        }
    }

    public void checkForMultipleDeletesOrRetypes() {
        ComposedActionsBearer composedActionsBearer = new ComposedActionsBearer(this);
        Unit.checkForMultipleDeletesOrRetypesGlobal(composedActionsBearer);
        Unit.checkForMultipleRetypesLocal(composedActionsBearer);
    }

    public static void checkForMultipleDeletesOrRetypesGlobal(ActionsBearer actionsBearer) {
        HashMap<Rule, HashSet<Rule>> hashMap = new HashMap<Rule, HashSet<Rule>>();
        for (Rule arrayDeque2 : actionsBearer.getSubpatternRules()) {
            hashMap.put(arrayDeque2, new HashSet());
        }
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            rule.computeUsageDependencies(hashMap, rule);
        }
        HashMap hashMap2 = new HashMap();
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            hashMap2.put(rule, new HashMap());
            for (Entity entity : rule.getParameters()) {
                ((HashMap)hashMap2.get(rule)).put(entity, null);
            }
        }
        ArrayDeque<Rule> arrayDeque = new ArrayDeque<Rule>();
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            arrayDeque.add(rule);
        }
        while (arrayDeque.size() > 0) {
            Rule rule = (Rule)arrayDeque.remove();
            boolean bl = rule.checkForMultipleDeletesOrRetypes(new HashMap<Entity, Rule>(), hashMap2);
            if (!bl) continue;
            for (Rule rule2 : hashMap.get(rule)) {
                if (arrayDeque.contains(rule2)) continue;
                arrayDeque.add(rule2);
            }
        }
        for (Rule rule : actionsBearer.getActionRules()) {
            rule.checkForMultipleDeletesOrRetypes(new HashMap<Entity, Rule>(), hashMap2);
        }
    }

    public static void checkForMultipleRetypesLocal(ActionsBearer actionsBearer) {
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            rule.checkForMultipleRetypesLocal();
        }
        for (Rule rule : actionsBearer.getActionRules()) {
            rule.checkForMultipleRetypesLocal();
        }
    }

    public void transmitExecUsageToRules() {
        Unit.transmitExecUsageToRules(new ComposedActionsBearer(this));
    }

    public static void transmitExecUsageToRules(ActionsBearer actionsBearer) {
        boolean bl;
        HashMap<Rule, HashSet<Rule>> hashMap = new HashMap<Rule, HashSet<Rule>>();
        for (Rule iterator : actionsBearer.getSubpatternRules()) {
            hashMap.put(iterator, new HashSet());
        }
        for (Rule rule : actionsBearer.getActionRules()) {
            hashMap.put(rule, new HashSet());
        }
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            rule.computeUsageDependencies(hashMap, rule);
        }
        for (Rule rule : actionsBearer.getActionRules()) {
            rule.computeUsageDependencies(hashMap, rule);
        }
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            rule.mightThereBeDeferredExecs = rule.isUsingNonDirectExec(false);
        }
        for (Rule rule : actionsBearer.getActionRules()) {
            rule.mightThereBeDeferredExecs = rule.isUsingNonDirectExec(true);
        }
        do {
            bl = false;
            for (Rule rule : actionsBearer.getSubpatternRules()) {
                if (!rule.mightThereBeDeferredExecs) continue;
                for (Rule rule2 : hashMap.get(rule)) {
                    if (rule2.mightThereBeDeferredExecs) continue;
                    rule2.mightThereBeDeferredExecs = true;
                    bl = true;
                }
            }
        } while (bl);
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            rule.mightThereBeDeferredExecs = false;
        }
    }

    public void resolvePatternLockedModifier() {
        Unit.resolvePatternLockedModifier(new ComposedActionsBearer(this));
    }

    public static void resolvePatternLockedModifier(ActionsBearer actionsBearer) {
        for (Rule rule : actionsBearer.getActionRules()) {
            rule.pattern.resolvePatternLockedModifier();
        }
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            rule.pattern.resolvePatternLockedModifier();
        }
    }

    public void ensureDirectlyNestingPatternContainsAllNonLocalElementsOfNestedPattern() {
        Unit.ensureDirectlyNestingPatternContainsAllNonLocalElementsOfNestedPattern(new ComposedActionsBearer(this));
    }

    public static void ensureDirectlyNestingPatternContainsAllNonLocalElementsOfNestedPattern(ActionsBearer actionsBearer) {
        HashSet<Node> hashSet = new HashSet<Node>();
        HashSet<Edge> hashSet2 = new HashSet<Edge>();
        HashSet<Variable> hashSet3 = new HashSet<Variable>();
        for (Rule rule : actionsBearer.getActionRules()) {
            rule.pattern.ensureDirectlyNestingPatternContainsAllNonLocalElementsOfNestedPattern(hashSet, hashSet2, hashSet3, rule.getRight());
            hashSet.clear();
            hashSet2.clear();
            hashSet3.clear();
        }
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            rule.pattern.ensureDirectlyNestingPatternContainsAllNonLocalElementsOfNestedPattern(hashSet, hashSet2, hashSet3, rule.getRight());
            hashSet.clear();
            hashSet2.clear();
            hashSet3.clear();
        }
    }

    public void checkForRhsElementsUsedOnLhs() {
        Unit.checkForRhsElementsUsedOnLhs(new ComposedActionsBearer(this));
    }

    public static void checkForRhsElementsUsedOnLhs(ActionsBearer actionsBearer) {
        for (Rule rule : actionsBearer.getActionRules()) {
            rule.checkForRhsElementsUsedOnLhs();
        }
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            rule.checkForRhsElementsUsedOnLhs();
        }
    }

    public void setDependencyLevelOfInterElementDependencies() {
        Unit.setDependencyLevelOfInterElementDependencies(new ComposedActionsBearer(this));
    }

    public static void setDependencyLevelOfInterElementDependencies(ActionsBearer actionsBearer) {
        for (Rule rule : actionsBearer.getActionRules()) {
            rule.setDependencyLevelOfInterElementDependencies();
        }
        for (Rule rule : actionsBearer.getSubpatternRules()) {
            rule.setDependencyLevelOfInterElementDependencies();
        }
    }

    public void checkForParallelizedModelIfParallelizedActionExists() {
        Unit.checkForParallelizedModelIfParallelizedActionExists(new ComposedActionsBearer(this), this.getActionsGraphModel());
    }

    public static void checkForParallelizedModelIfParallelizedActionExists(ActionsBearer actionsBearer, Model model) {
        if (!model.areFunctionsParallel()) {
            for (Rule rule : actionsBearer.getActionRules()) {
                if (!rule.getAnnotations().containsKey("parallelize")) continue;
                error.error(rule.getIdent().getCoords(), "Parallelized matching is requested from the action " + rule.getIdent() + ", but parallelization is not requested in the model (\"for function[parallelize=true];\").");
            }
        }
    }
}

