/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.executable;

import de.unika.ipd.grgen.ir.ContainedInPackage;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.Exec;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.Identifiable;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.executable.MatchingAction;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.GraphEntityExpression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.Alternative;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.IndexAccessOrdering;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.OrderedReplacement;
import de.unika.ipd.grgen.ir.pattern.OrderedReplacements;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.PatternGraphRhs;
import de.unika.ipd.grgen.ir.pattern.RetypedEdge;
import de.unika.ipd.grgen.ir.pattern.RetypedNode;
import de.unika.ipd.grgen.ir.pattern.SubpatternDependentReplacement;
import de.unika.ipd.grgen.ir.pattern.SubpatternUsage;
import de.unika.ipd.grgen.ir.stmt.EvalStatements;
import de.unika.ipd.grgen.ir.stmt.ImperativeStmt;
import de.unika.ipd.grgen.ir.type.DefinedMatchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Rule
extends MatchingAction
implements ContainedInPackage {
    private static final String[] childrenNames = new String[]{"left", "right", "eval"};
    private String packageContainedIn;
    private PatternGraphRhs right;
    private final List<DefinedMatchType> implementedMatchClasses = new LinkedList<DefinedMatchType>();
    private final Collection<EvalStatements> evalStatements = new LinkedList<EvalStatements>();
    private int minMatches;
    private int maxMatches;
    public boolean wasReplacementAlreadyCalled;
    public boolean mightThereBeDeferredExecs;
    public RuleKind ruleKind;

    public static String toString(RuleKind ruleKind) {
        switch (ruleKind) {
            case Rule: {
                return "rule";
            }
            case Test: {
                return "test";
            }
            case Subpattern: {
                return "(sub)pattern";
            }
            case AlternativeCase: {
                return "alternative case";
            }
            case Iterated: {
                return "iterated";
            }
        }
        throw new RuntimeException("Unexpected case");
    }

    public Rule(Ident ident, RuleKind ruleKind) {
        super("rule", ident);
        this.setChildrenNames(childrenNames);
        this.ruleKind = ruleKind;
        this.minMatches = -1;
        this.maxMatches = -1;
        this.mightThereBeDeferredExecs = false;
    }

    public Rule(Ident ident, int n, int n2) {
        super("rule", ident);
        this.setChildrenNames(childrenNames);
        this.ruleKind = RuleKind.Iterated;
        this.minMatches = n;
        this.maxMatches = n2;
        this.mightThereBeDeferredExecs = false;
    }

    public void initialize(PatternGraphLhs patternGraphLhs, PatternGraphRhs patternGraphRhs) {
        super.setPattern(patternGraphLhs);
        this.right = patternGraphRhs;
        if (patternGraphRhs == null) {
            patternGraphLhs.setNameSuffix("test");
        } else {
            patternGraphLhs.setName("L");
            patternGraphRhs.setName("R");
        }
    }

    @Override
    public String getPackageContainedIn() {
        return this.packageContainedIn;
    }

    public void setPackageContainedIn(String string) {
        this.packageContainedIn = string;
    }

    public boolean isSubpattern() {
        return this.ruleKind == RuleKind.Subpattern;
    }

    public Collection<EvalStatements> getEvals() {
        return Collections.unmodifiableCollection(this.evalStatements);
    }

    public void addEval(EvalStatements evalStatements) {
        this.evalStatements.add(evalStatements);
    }

    public Collection<Node> getCommonNodes() {
        HashSet<Node> hashSet = new HashSet<Node>(this.pattern.getNodes());
        hashSet.retainAll(this.right.getNodes());
        return hashSet;
    }

    public Collection<Edge> getCommonEdges() {
        HashSet<Edge> hashSet = new HashSet<Edge>(this.pattern.getEdges());
        hashSet.retainAll(this.right.getEdges());
        return hashSet;
    }

    public Collection<SubpatternUsage> getCommonSubpatternUsages() {
        HashSet<SubpatternUsage> hashSet = new HashSet<SubpatternUsage>(this.pattern.getSubpatternUsages());
        hashSet.retainAll(this.right.getSubpatternUsages());
        return hashSet;
    }

    public PatternGraphLhs getLeft() {
        return this.pattern;
    }

    public PatternGraphRhs getRight() {
        return this.right;
    }

    public Collection<DefinedMatchType> getImplementedMatchClasses() {
        return this.implementedMatchClasses;
    }

    public void addImplementedMatchClass(DefinedMatchType definedMatchType) {
        this.implementedMatchClasses.add(definedMatchType);
    }

    public int getMinMatches() {
        return this.minMatches;
    }

    public int getMaxMatches() {
        return this.maxMatches;
    }

    public void checkForRhsElementsUsedOnLhs() {
        PatternGraphLhs patternGraphLhs = this.getLeft();
        for (Node graphEntity : patternGraphLhs.getNodes()) {
            if ((graphEntity.context & 1) != 1) continue;
            error.error(graphEntity.getIdent().getCoords(), "Nodes declared in the rewrite part cannot be accessed in the pattern part (as is the case for " + graphEntity.getIdent() + ").");
        }
        for (Edge edge : patternGraphLhs.getEdges()) {
            if ((edge.context & 1) != 1) continue;
            error.error(edge.getIdent().getCoords(), "Edges declared in the rewrite part cannot be accessed in the pattern part (as is the case for " + edge.getIdent() + ").");
        }
    }

    public void computeUsageDependencies(HashMap<Rule, HashSet<Rule>> hashMap, Rule rule) {
        for (SubpatternUsage identifiable : this.pattern.getSubpatternUsages()) {
            HashSet<Rule> hashSet = hashMap.get(identifiable.subpatternAction);
            hashSet.add(rule);
        }
        for (Alternative alternative : this.pattern.getAlts()) {
            for (Rule rule2 : alternative.getAlternativeCases()) {
                rule2.computeUsageDependencies(hashMap, rule);
            }
        }
        for (Rule rule3 : this.pattern.getIters()) {
            rule3.computeUsageDependencies(hashMap, rule);
        }
    }

    public boolean checkForMultipleDeletesOrRetypes(HashMap<Entity, Rule> hashMap, HashMap<Rule, HashMap<Entity, Rule>> hashMap2) {
        Identifiable identifiable;
        IR iR;
        Object object;
        if (this.right == null) {
            return false;
        }
        for (Node object3 : this.pattern.getNodes()) {
            for (Node node : this.pattern.getHomomorphic(object3)) {
                if (!this.right.hasNode(node)) {
                    if (hashMap.containsKey(object3) && hashMap.get(object3) != this) {
                        Rule.reportMultipleDeleteOrRetype(object3, hashMap.get(object3), this);
                    } else {
                        hashMap.put(object3, this);
                    }
                }
                if (!node.changesType(this.right)) continue;
                if (hashMap.containsKey(object3) && hashMap.get(object3) != this) {
                    Rule.reportMultipleDeleteOrRetype(object3, hashMap.get(object3), this);
                    continue;
                }
                hashMap.put(object3, this);
            }
        }
        for (Edge edge : this.pattern.getEdges()) {
            for (Edge edge2 : this.pattern.getHomomorphic(edge)) {
                if (!this.right.hasEdge(edge2)) {
                    if (hashMap.containsKey(edge) && hashMap.get(edge) != this) {
                        Rule.reportMultipleDeleteOrRetype(edge, hashMap.get(edge), this);
                    } else {
                        hashMap.put(edge, this);
                    }
                }
                if (!edge2.changesType(this.right)) continue;
                if (hashMap.containsKey(edge) && hashMap.get(edge) != this) {
                    Rule.reportMultipleDeleteOrRetype(edge, hashMap.get(edge), this);
                    continue;
                }
                hashMap.put(edge, this);
            }
        }
        for (SubpatternUsage subpatternUsage : this.pattern.getSubpatternUsages()) {
            boolean bl = false;
            for (OrderedReplacements orderedReplacements : this.right.getOrderedReplacements()) {
                for (OrderedReplacement orderedReplacement : orderedReplacements.orderedReplacements) {
                    if (!(orderedReplacement instanceof SubpatternDependentReplacement) || ((SubpatternDependentReplacement)orderedReplacement).getSubpatternUsage() != subpatternUsage) continue;
                    bl = true;
                }
            }
            if (!bl) continue;
            List<Entity> list = subpatternUsage.subpatternAction.getParameters();
            Iterator<Entity> iterator = list.iterator();
            object = subpatternUsage.subpatternConnections;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                assert (iterator.hasNext());
                iR = (Expression)iterator2.next();
                identifiable = iterator.next();
                if (!(iR instanceof GraphEntityExpression)) continue;
                GraphEntity graphEntity = ((GraphEntityExpression)iR).getGraphEntity();
                HashMap<Entity, Rule> hashMap3 = hashMap2.get(subpatternUsage.subpatternAction);
                Rule rule = hashMap3.get(identifiable);
                if (rule == null) continue;
                if (hashMap.containsKey(graphEntity)) {
                    Rule.reportMultipleDeleteOrRetype(graphEntity, hashMap.get(graphEntity), rule);
                    continue;
                }
                hashMap.put(graphEntity, rule);
            }
        }
        for (Alternative alternative : this.pattern.getAlts()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Rule rule : alternative.getAlternativeCases()) {
                object = new HashMap<Entity, Rule>(hashMap);
                rule.checkForMultipleDeletesOrRetypes((HashMap<Entity, Rule>)object, hashMap2);
                arrayList.add(object);
            }
            for (HashMap hashMap4 : arrayList) {
                for (Entity entity : hashMap4.keySet()) {
                    iR = hashMap.get(entity);
                    identifiable = (Rule)hashMap4.get(entity);
                    if (iR != null || identifiable == null) continue;
                    hashMap.put(entity, (Rule)identifiable);
                }
            }
        }
        for (Rule rule : this.pattern.getIters()) {
            rule.checkForMultipleDeletesOrRetypes(hashMap, hashMap2);
        }
        boolean bl = false;
        if (hashMap2.containsKey(this)) {
            HashMap<Entity, Rule> hashMap5 = hashMap2.get(this);
            for (Entity entity : hashMap5.keySet()) {
                Rule rule = hashMap5.get(entity);
                object = hashMap.get(entity);
                if (rule != null || object == null) continue;
                hashMap5.put(entity, (Rule)object);
                bl = true;
            }
        }
        return bl;
    }

    static void reportMultipleDeleteOrRetype(Entity entity, Rule rule, Rule rule2) {
        error.error(entity.getIdent().getCoords(), "The " + entity.getKind() + " " + entity.getIdent() + " or a hom " + entity.getKind() + " may get deleted or retyped in " + Rule.toString(rule.ruleKind) + " " + rule.getIdent() + " [declared at " + rule.getIdent().getCoords() + "] and in " + Rule.toString(rule2.ruleKind) + " " + rule2.getIdent() + " [declared at " + rule2.getIdent().getCoords() + "] (only one such place is allowed, determinable at compile time).");
    }

    public void checkForMultipleRetypesLocal() {
        if (this.right == null) {
            return;
        }
        for (Node identifiable : this.pattern.getNodes()) {
            for (Node node : this.pattern.getHomomorphic(identifiable)) {
                if (identifiable == node || !identifiable.changesType(this.right) || !node.changesType(this.right)) continue;
                Rule.reportMultipleRetype(identifiable, node);
            }
        }
        for (Edge edge : this.pattern.getEdges()) {
            for (Edge edge2 : this.pattern.getHomomorphic(edge)) {
                if (edge == edge2 || !edge.changesType(this.right) || !edge2.changesType(this.right)) continue;
                Rule.reportMultipleRetype(edge, edge2);
            }
        }
        for (Alternative alternative : this.pattern.getAlts()) {
            for (Rule rule : alternative.getAlternativeCases()) {
                rule.checkForMultipleRetypesLocal();
            }
        }
        for (Rule rule : this.pattern.getIters()) {
            rule.checkForMultipleRetypesLocal();
        }
    }

    static void reportMultipleRetype(Entity entity, Entity entity2) {
        error.error(entity.getIdent().getCoords(), "The " + entity.getKind() + " " + entity.getIdent() + " and the hom " + entity.getKind() + " " + entity2.getIdent() + entity2.getIdent().getCoords().getDeclarationCoords(false) + " are both retyped, so a homomorphically matched graph element may get retyped multiple times.");
    }

    public boolean isUsingNonDirectExec(boolean bl) {
        if (this.right == null) {
            return false;
        }
        if (!bl) {
            for (ImperativeStmt object : this.right.getImperativeStmts()) {
                if (!(object instanceof Exec)) continue;
                return true;
            }
        }
        for (Alternative alternative : this.pattern.getAlts()) {
            for (Rule rule : alternative.getAlternativeCases()) {
                if (!rule.isUsingNonDirectExec(false)) continue;
                return true;
            }
        }
        for (Rule rule : this.pattern.getIters()) {
            if (!rule.isUsingNonDirectExec(false)) continue;
            return true;
        }
        return false;
    }

    public void setDependencyLevelOfInterElementDependencies() {
        boolean bl;
        PatternGraphLhs patternGraphLhs = this.getLeft();
        int n = 0;
        do {
            Object object;
            bl = false;
            for (Node node : patternGraphLhs.getNodes()) {
                if (node.storageAccessIndex != null && node.storageAccessIndex.indexGraphEntity != null) {
                    object = node.storageAccessIndex.indexGraphEntity;
                    if (node.getDependencyLevel() <= ((GraphEntity)object).getDependencyLevel()) {
                        node.incrementDependencyLevel();
                        n = Math.max(node.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (node.storageAccess != null && node.storageAccess.storageAttribute != null) {
                    object = node.storageAccess.storageAttribute;
                    if (node.getDependencyLevel() <= ((GraphEntity)((Qualification)object).getOwner()).getDependencyLevel()) {
                        node.incrementDependencyLevel();
                        n = Math.max(node.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (node.indexAccess != null) {
                    object = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.CONTAINER_EXPRS));
                    node.indexAccess.collectNeededEntities((NeededEntities)object);
                    GraphEntity graphEntity = this.getAtMostOneNeededGraphElement((NeededEntities)object, node);
                    if (graphEntity != null && node.getDependencyLevel() <= graphEntity.getDependencyLevel()) {
                        node.incrementDependencyLevel();
                        n = Math.max(node.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (!node.multipleIndexAccesses.isEmpty()) {
                    object = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.CONTAINER_EXPRS));
                    for (IndexAccessOrdering indexAccessOrdering : node.multipleIndexAccesses) {
                        indexAccessOrdering.collectNeededEntities((NeededEntities)object);
                    }
                    GraphEntity graphEntity = this.getAtMostOneNeededGraphElement((NeededEntities)object, node);
                    if (graphEntity != null && node.getDependencyLevel() <= graphEntity.getDependencyLevel()) {
                        node.incrementDependencyLevel();
                        n = Math.max(node.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (node.nameMapAccess != null) {
                    object = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.CONTAINER_EXPRS));
                    node.nameMapAccess.collectNeededEntities((NeededEntities)object);
                    GraphEntity graphEntity = this.getAtMostOneNeededGraphElement((NeededEntities)object, node);
                    if (graphEntity != null && node.getDependencyLevel() <= graphEntity.getDependencyLevel()) {
                        node.incrementDependencyLevel();
                        n = Math.max(node.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (node.uniqueIndexAccess != null) {
                    object = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.CONTAINER_EXPRS));
                    node.uniqueIndexAccess.collectNeededEntities((NeededEntities)object);
                    GraphEntity graphEntity = this.getAtMostOneNeededGraphElement((NeededEntities)object, node);
                    if (graphEntity != null && node.getDependencyLevel() <= graphEntity.getDependencyLevel()) {
                        node.incrementDependencyLevel();
                        n = Math.max(node.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (!(node instanceof RetypedNode) || node.getDependencyLevel() > ((RetypedNode)node).getCombinedDependencyLevel()) continue;
                node.incrementDependencyLevel();
                n = Math.max(node.getDependencyLevel(), n);
                bl = true;
            }
            for (Edge edge : patternGraphLhs.getEdges()) {
                if (edge.storageAccessIndex != null && edge.storageAccessIndex.indexGraphEntity != null) {
                    object = edge.storageAccessIndex.indexGraphEntity;
                    if (edge.getDependencyLevel() <= ((GraphEntity)object).getDependencyLevel()) {
                        edge.incrementDependencyLevel();
                        n = Math.max(edge.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (edge.storageAccess != null && edge.storageAccess.storageAttribute != null) {
                    object = edge.storageAccess.storageAttribute;
                    if (edge.getDependencyLevel() <= ((GraphEntity)((Qualification)object).getOwner()).getDependencyLevel()) {
                        edge.incrementDependencyLevel();
                        n = Math.max(edge.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (edge.indexAccess != null) {
                    object = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.CONTAINER_EXPRS));
                    edge.indexAccess.collectNeededEntities((NeededEntities)object);
                    GraphEntity graphEntity = this.getAtMostOneNeededGraphElement((NeededEntities)object, edge);
                    if (graphEntity != null && edge.getDependencyLevel() <= graphEntity.getDependencyLevel()) {
                        edge.incrementDependencyLevel();
                        n = Math.max(edge.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (!edge.multipleIndexAccesses.isEmpty()) {
                    object = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.CONTAINER_EXPRS));
                    for (IndexAccessOrdering indexAccessOrdering : edge.multipleIndexAccesses) {
                        indexAccessOrdering.collectNeededEntities((NeededEntities)object);
                    }
                    GraphEntity graphEntity = this.getAtMostOneNeededGraphElement((NeededEntities)object, edge);
                    if (graphEntity != null && edge.getDependencyLevel() <= graphEntity.getDependencyLevel()) {
                        edge.incrementDependencyLevel();
                        n = Math.max(edge.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (edge.nameMapAccess != null) {
                    object = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.CONTAINER_EXPRS));
                    edge.nameMapAccess.collectNeededEntities((NeededEntities)object);
                    GraphEntity graphEntity = this.getAtMostOneNeededGraphElement((NeededEntities)object, edge);
                    if (graphEntity != null && edge.getDependencyLevel() <= graphEntity.getDependencyLevel()) {
                        edge.incrementDependencyLevel();
                        n = Math.max(edge.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (edge.uniqueIndexAccess != null) {
                    object = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.CONTAINER_EXPRS));
                    edge.uniqueIndexAccess.collectNeededEntities((NeededEntities)object);
                    GraphEntity graphEntity = this.getAtMostOneNeededGraphElement((NeededEntities)object, edge);
                    if (graphEntity != null && edge.getDependencyLevel() <= graphEntity.getDependencyLevel()) {
                        edge.incrementDependencyLevel();
                        n = Math.max(edge.getDependencyLevel(), n);
                        bl = true;
                    }
                }
                if (!(edge instanceof RetypedEdge) || edge.getDependencyLevel() > ((RetypedEdge)edge).oldEdge.getDependencyLevel()) continue;
                edge.incrementDependencyLevel();
                n = Math.max(edge.getDependencyLevel(), n);
                bl = true;
            }
            if (n < 1000) continue;
            error.error(this.getIdent().getCoords(), "Cycle in match node/edge by storage map access or storage attribute detected.");
            break;
        } while (bl);
        for (Alternative alternative : this.pattern.getAlts()) {
            for (Rule rule : alternative.getAlternativeCases()) {
                rule.setDependencyLevelOfInterElementDependencies();
            }
        }
        for (Rule rule : this.pattern.getIters()) {
            rule.setDependencyLevelOfInterElementDependencies();
        }
    }

    public GraphEntity getAtMostOneNeededGraphElement(NeededEntities neededEntities, GraphEntity graphEntity) {
        HashSet<GraphEntity> hashSet = new HashSet<GraphEntity>();
        for (Node graphEntity2 : neededEntities.nodes) {
            if (this.getParameters().indexOf(graphEntity2) != -1) continue;
            if (graphEntity2.isDefToBeYieldedTo()) {
                error.error(graphEntity.getIdent().getCoords(), "Cannot use a def node (" + graphEntity2.getIdent() + ") for an index access or name map access of " + graphEntity.getIdent() + ".");
            }
            hashSet.add(graphEntity2);
        }
        for (Edge edge : neededEntities.edges) {
            if (this.getParameters().indexOf(edge) != -1) continue;
            if (edge.isDefToBeYieldedTo()) {
                error.error(graphEntity.getIdent().getCoords(), "Cannot use a def edge (" + edge.getIdent() + ") for an index access or name map access of " + graphEntity.getIdent() + ".");
            }
            hashSet.add(edge);
        }
        if (hashSet.size() == 1) {
            return (GraphEntity)hashSet.iterator().next();
        }
        if (hashSet.size() > 1) {
            error.error(graphEntity.getIdent().getCoords(), "There are " + hashSet.size() + " entities specified in an index access or name map access of " + graphEntity.getIdent() + " (only one is allowed).");
        }
        return null;
    }

    public static enum RuleKind {
        Rule,
        Test,
        Subpattern,
        AlternativeCase,
        Iterated;

    }
}

