/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.expr;

import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Operator
extends Expression {
    protected List<Expression> operands = new ArrayList<Expression>();
    private OperatorCode opCode;

    public Operator(Type type, OperatorCode operatorCode) {
        super("operator", type);
        this.opCode = operatorCode;
    }

    public OperatorCode getOpCode() {
        return this.opCode;
    }

    public int arity() {
        return this.operands.size();
    }

    public Expression getOperand(int n) {
        return n >= 0 || n < this.operands.size() ? this.operands.get(n) : null;
    }

    public void addOperand(Expression expression) {
        this.operands.add(expression);
    }

    @Override
    public String getEdgeLabel(int n) {
        return "op " + n;
    }

    @Override
    public String getNodeLabel() {
        return this.getType().getIdent() + " " + this.opCode.toString().toLowerCase() + "(" + (Object)((Object)this.opCode) + ")";
    }

    public Collection<Expression> getWalkableChildren() {
        return this.operands;
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        for (Expression expression : this.getWalkableChildren()) {
            expression.collectNeededEntities(neededEntities);
        }
    }

    public static enum OperatorCode {
        COND,
        LOG_OR,
        LOG_AND,
        BIT_OR,
        BIT_XOR,
        BIT_AND,
        EQ,
        NE,
        LT,
        LE,
        GT,
        GE,
        SHL,
        SHR,
        BIT_SHR,
        ADD,
        SUB,
        MUL,
        DIV,
        MOD,
        LOG_NOT,
        BIT_NOT,
        NEG,
        IN,
        EXCEPT,
        SE;

    }
}

