/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.expr.array;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.type.container.ArrayType;
import java.util.Collection;

public class ArrayInit
extends Expression {
    private Collection<Expression> arrayItems;
    private Entity member;
    private ArrayType arrayType;
    private boolean isConst;

    public ArrayInit(Collection<Expression> collection, Entity entity, ArrayType arrayType, boolean bl) {
        super("array init", entity != null ? entity.getType() : arrayType);
        this.arrayItems = collection;
        this.member = entity;
        this.arrayType = arrayType;
        this.isConst = bl;
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        neededEntities.add(this);
        for (Expression expression : this.arrayItems) {
            expression.collectNeededEntities(neededEntities);
        }
    }

    public Collection<Expression> getArrayItems() {
        return this.arrayItems;
    }

    public void setMember(Entity entity) {
        assert (this.member == null && entity != null);
        this.member = entity;
    }

    public Entity getMember() {
        return this.member;
    }

    public ArrayType getArrayType() {
        return this.arrayType;
    }

    public void forceNotConstant() {
        this.isConst = false;
    }

    public boolean isConstant() {
        return this.isConst;
    }

    public String getAnonymousArrayName() {
        return "anonymous_array_" + this.getId();
    }
}

