/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.expr.deque;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.type.container.DequeType;
import java.util.Collection;

public class DequeInit
extends Expression {
    private Collection<Expression> dequeItems;
    private Entity member;
    private DequeType dequeType;
    private boolean isConst;

    public DequeInit(Collection<Expression> collection, Entity entity, DequeType dequeType, boolean bl) {
        super("deque init", entity != null ? entity.getType() : dequeType);
        this.dequeItems = collection;
        this.member = entity;
        this.dequeType = dequeType;
        this.isConst = bl;
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        neededEntities.add(this);
        for (Expression expression : this.dequeItems) {
            expression.collectNeededEntities(neededEntities);
        }
    }

    public Collection<Expression> getDequeItems() {
        return this.dequeItems;
    }

    public void setMember(Entity entity) {
        assert (this.member == null && entity != null);
        this.member = entity;
    }

    public Entity getMember() {
        return this.member;
    }

    public DequeType getDequeType() {
        return this.dequeType;
    }

    public void forceNotConstant() {
        this.isConst = false;
    }

    public boolean isConstant() {
        return this.isConst;
    }

    public String getAnonymousDequeName() {
        return "anonymous_deque_" + this.getId();
    }
}

