/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.model;

import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.Identifiable;
import de.unika.ipd.grgen.ir.executable.ExternalFunction;
import de.unika.ipd.grgen.ir.executable.ExternalProcedure;
import de.unika.ipd.grgen.ir.model.Index;
import de.unika.ipd.grgen.ir.model.NodeEdgeEnumBearer;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import de.unika.ipd.grgen.ir.model.type.EnumType;
import de.unika.ipd.grgen.ir.model.type.ExternalObjectType;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.model.type.InternalObjectType;
import de.unika.ipd.grgen.ir.model.type.InternalTransientObjectType;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.ir.model.type.PackageType;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.ir.type.basic.PrimitiveType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Model
extends Identifiable
implements NodeEdgeEnumBearer {
    private List<Model> usedModels = new LinkedList<Model>();
    private List<PackageType> packages = new LinkedList<PackageType>();
    private List<Type> types = new LinkedList<Type>();
    private Set<NodeType> nodeTypes = new LinkedHashSet<NodeType>();
    private Set<EdgeType> edgeTypes = new LinkedHashSet<EdgeType>();
    private Set<InternalObjectType> objectTypes = new LinkedHashSet<InternalObjectType>();
    private Set<InternalTransientObjectType> transientObjectTypes = new LinkedHashSet<InternalTransientObjectType>();
    private Set<EnumType> enumTypes = new LinkedHashSet<EnumType>();
    private Set<Index> indices = new LinkedHashSet<Index>();
    private Set<ExternalObjectType> externalObjectTypes = new LinkedHashSet<ExternalObjectType>();
    private Set<ExternalFunction> externalFuncs = new LinkedHashSet<ExternalFunction>();
    private Set<ExternalProcedure> externalProcs = new LinkedHashSet<ExternalProcedure>();
    private boolean isEmitClassDefined;
    private boolean isEmitGraphClassDefined;
    private boolean isCopyClassDefined;
    private boolean isEqualClassDefined;
    private boolean isLowerClassDefined;
    private boolean isGraphofDefined;
    private boolean isUniqueDefined;
    private boolean isUniqueResulting;
    private boolean isUniqueClassDefined;
    private boolean isUniqueIndexDefined;
    private boolean areFunctionsParallel;
    private int isoParallel;
    private int sequencesParallel;
    private Collection<NodeType> allNodeTypes;
    private Collection<EdgeType> allEdgeTypes;
    private Collection<InternalObjectType> allObjectTypes;
    private Collection<InternalTransientObjectType> allTransientObjectTypes;
    private Collection<InheritanceType> allGraphElementTypes;
    private Collection<InheritanceType> allInheritanceTypes;

    public Model(Ident ident, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, int n, int n2) {
        super("model", ident);
        this.isEmitClassDefined = bl;
        this.isEmitGraphClassDefined = bl2;
        this.isCopyClassDefined = bl3;
        this.isEqualClassDefined = bl4;
        this.isLowerClassDefined = bl5;
        this.isGraphofDefined = bl6;
        this.isUniqueDefined = bl7;
        this.isUniqueResulting = bl7;
        this.isUniqueClassDefined = bl8;
        this.isUniqueIndexDefined = bl9;
        this.areFunctionsParallel = bl10;
        this.isoParallel = n;
        this.sequencesParallel = n2;
    }

    public void addUsedModel(Model model) {
        this.usedModels.add(model);
        for (Type identifiable : model.getTypes()) {
            this.addType(identifiable);
        }
        for (PackageType packageType : model.getPackages()) {
            this.addPackage(packageType);
        }
        for (ExternalFunction externalFunction : model.getExternalFunctions()) {
            this.addExternalFunction(externalFunction);
        }
    }

    public void addPackage(PackageType packageType) {
        this.packages.add(packageType);
    }

    public Collection<PackageType> getPackages() {
        return Collections.unmodifiableCollection(this.packages);
    }

    public void addType(Type type) {
        this.types.add(type);
        if (type instanceof NodeType) {
            this.nodeTypes.add((NodeType)type);
        } else if (type instanceof EdgeType) {
            this.edgeTypes.add((EdgeType)type);
        } else if (type instanceof EnumType) {
            this.enumTypes.add((EnumType)type);
        } else if (type instanceof ExternalObjectType) {
            this.externalObjectTypes.add((ExternalObjectType)type);
        } else if (type instanceof InternalObjectType) {
            this.objectTypes.add((InternalObjectType)type);
        } else if (type instanceof InternalTransientObjectType) {
            this.transientObjectTypes.add((InternalTransientObjectType)type);
        } else if (!(type instanceof PrimitiveType)) assert (false) : "Unexpected type added to model: " + type;
    }

    public void addIndex(Index index) {
        this.indices.add(index);
    }

    public Collection<Index> getIndices() {
        return Collections.unmodifiableCollection(this.indices);
    }

    public void addExternalFunction(ExternalFunction externalFunction) {
        this.externalFuncs.add(externalFunction);
    }

    public Collection<ExternalFunction> getExternalFunctions() {
        return Collections.unmodifiableCollection(this.externalFuncs);
    }

    public void addExternalProcedure(ExternalProcedure externalProcedure) {
        this.externalProcs.add(externalProcedure);
    }

    public Collection<ExternalProcedure> getExternalProcedures() {
        return Collections.unmodifiableCollection(this.externalProcs);
    }

    public Collection<Type> getTypes() {
        return Collections.unmodifiableCollection(this.types);
    }

    @Override
    public Collection<NodeType> getNodeTypes() {
        return Collections.unmodifiableCollection(this.nodeTypes);
    }

    public Collection<NodeType> getAllNodeTypes() {
        if (this.allNodeTypes == null) {
            ArrayList<NodeType> arrayList = new ArrayList<NodeType>();
            arrayList.addAll(this.getNodeTypes());
            for (PackageType object : this.getPackages()) {
                arrayList.addAll(object.getNodeTypes());
            }
            int n = 0;
            for (NodeType nodeType : arrayList) {
                nodeType.setInheritanceTypeID(n);
                ++n;
            }
            this.allNodeTypes = Collections.unmodifiableCollection(arrayList);
        }
        return this.allNodeTypes;
    }

    @Override
    public Collection<EdgeType> getEdgeTypes() {
        return Collections.unmodifiableCollection(this.edgeTypes);
    }

    public Collection<EdgeType> getAllEdgeTypes() {
        if (this.allEdgeTypes == null) {
            ArrayList<EdgeType> arrayList = new ArrayList<EdgeType>();
            arrayList.addAll(this.getEdgeTypes());
            for (PackageType object : this.getPackages()) {
                arrayList.addAll(object.getEdgeTypes());
            }
            int n = 0;
            for (EdgeType edgeType : arrayList) {
                edgeType.setInheritanceTypeID(n);
                ++n;
            }
            this.allEdgeTypes = Collections.unmodifiableCollection(arrayList);
        }
        return this.allEdgeTypes;
    }

    public Collection<InheritanceType> getAllGraphElementTypes() {
        if (this.allGraphElementTypes == null) {
            ArrayList<InheritanceType> arrayList = new ArrayList<InheritanceType>();
            arrayList.addAll(this.getAllNodeTypes());
            arrayList.addAll(this.getAllEdgeTypes());
            this.allGraphElementTypes = Collections.unmodifiableCollection(arrayList);
        }
        return this.allGraphElementTypes;
    }

    @Override
    public Collection<InternalObjectType> getObjectTypes() {
        return Collections.unmodifiableCollection(this.objectTypes);
    }

    public Collection<InternalObjectType> getAllObjectTypes() {
        if (this.allObjectTypes == null) {
            ArrayList<InternalObjectType> arrayList = new ArrayList<InternalObjectType>();
            arrayList.addAll(this.getObjectTypes());
            for (PackageType object : this.getPackages()) {
                arrayList.addAll(object.getObjectTypes());
            }
            int n = 0;
            for (InternalObjectType internalObjectType : arrayList) {
                internalObjectType.setInheritanceTypeID(n);
                ++n;
            }
            this.allObjectTypes = Collections.unmodifiableCollection(arrayList);
        }
        return this.allObjectTypes;
    }

    @Override
    public Collection<InternalTransientObjectType> getTransientObjectTypes() {
        return Collections.unmodifiableCollection(this.transientObjectTypes);
    }

    public Collection<InternalTransientObjectType> getAllTransientObjectTypes() {
        if (this.allTransientObjectTypes == null) {
            ArrayList<InternalTransientObjectType> arrayList = new ArrayList<InternalTransientObjectType>();
            arrayList.addAll(this.getTransientObjectTypes());
            for (PackageType object : this.getPackages()) {
                arrayList.addAll(object.getTransientObjectTypes());
            }
            int n = 0;
            for (InternalTransientObjectType internalTransientObjectType : arrayList) {
                internalTransientObjectType.setInheritanceTypeID(n);
                ++n;
            }
            this.allTransientObjectTypes = Collections.unmodifiableCollection(arrayList);
        }
        return this.allTransientObjectTypes;
    }

    public Collection<InheritanceType> getAllInheritanceTypes() {
        if (this.allInheritanceTypes == null) {
            ArrayList<InheritanceType> arrayList = new ArrayList<InheritanceType>();
            arrayList.addAll(this.getAllNodeTypes());
            arrayList.addAll(this.getAllEdgeTypes());
            arrayList.addAll(this.getAllObjectTypes());
            arrayList.addAll(this.getAllTransientObjectTypes());
            this.allInheritanceTypes = Collections.unmodifiableCollection(arrayList);
        }
        return this.allInheritanceTypes;
    }

    @Override
    public Collection<EnumType> getEnumTypes() {
        return Collections.unmodifiableCollection(this.enumTypes);
    }

    public Collection<ExternalObjectType> getExternalObjectTypes() {
        return Collections.unmodifiableCollection(this.externalObjectTypes);
    }

    public Collection<Model> getUsedModels() {
        return Collections.unmodifiableCollection(this.usedModels);
    }

    public boolean isEmitClassDefined() {
        return this.isEmitClassDefined;
    }

    public boolean isEmitGraphClassDefined() {
        return this.isEmitGraphClassDefined;
    }

    public boolean isCopyClassDefined() {
        return this.isCopyClassDefined;
    }

    public boolean isEqualClassDefined() {
        return this.isEqualClassDefined;
    }

    public boolean isLowerClassDefined() {
        return this.isLowerClassDefined;
    }

    public boolean isGraphofDefined() {
        return this.isGraphofDefined;
    }

    public boolean isUniqueDefined() {
        return this.isUniqueDefined;
    }

    public void forceUniqueDefined() {
        this.isUniqueDefined = true;
    }

    public boolean isUniqueResulting() {
        return this.isUniqueResulting;
    }

    public void forceUniqueResulting() {
        this.isUniqueResulting = true;
    }

    public boolean isUniqueClassDefined() {
        return this.isUniqueClassDefined;
    }

    public boolean isUniqueIndexDefined() {
        return this.isUniqueIndexDefined;
    }

    public void forceFunctionsParallel() {
        this.areFunctionsParallel = true;
    }

    public boolean areFunctionsParallel() {
        return this.areFunctionsParallel;
    }

    public int isoParallel() {
        return this.isoParallel;
    }

    public int sequencesParallel() {
        return this.sequencesParallel;
    }

    @Override
    protected void canonicalizeLocal() {
        for (Type type : this.types) {
            type.canonicalize();
            if (!(type instanceof EdgeType)) continue;
            ((EdgeType)type).canonicalizeConnectionAsserts();
        }
    }

    public void addToDigest(StringBuffer stringBuffer) {
        stringBuffer.append(this);
        stringBuffer.append('[');
        for (Model identifiable : this.usedModels) {
            identifiable.addToDigest(stringBuffer);
        }
        for (Type type : this.types) {
            type.addToDigest(stringBuffer);
        }
        stringBuffer.append(']');
    }

    @Override
    public void addFields(Map<String, Object> map) {
        super.addFields(map);
        map.put("usedModels", this.usedModels.iterator());
        map.put("types", this.types.iterator());
    }
}

