/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.model.type;

import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.model.NodeEdgeEnumBearer;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import de.unika.ipd.grgen.ir.model.type.EnumType;
import de.unika.ipd.grgen.ir.model.type.InternalObjectType;
import de.unika.ipd.grgen.ir.model.type.InternalTransientObjectType;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.ir.type.basic.PrimitiveType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PackageType
extends PrimitiveType
implements NodeEdgeEnumBearer {
    private List<Type> types = new LinkedList<Type>();
    private Set<NodeType> nodeTypes = new LinkedHashSet<NodeType>();
    private Set<EdgeType> edgeTypes = new LinkedHashSet<EdgeType>();
    private Set<InternalObjectType> objectTypes = new LinkedHashSet<InternalObjectType>();
    private Set<InternalTransientObjectType> transientObjectTypes = new LinkedHashSet<InternalTransientObjectType>();
    private Set<EnumType> enumTypes = new LinkedHashSet<EnumType>();

    public PackageType(Ident ident) {
        super("package type", ident);
    }

    public void addType(Type type) {
        this.types.add(type);
        if (type instanceof NodeType) {
            NodeType nodeType = (NodeType)type;
            nodeType.setPackageContainedIn(this.getIdent().toString());
            this.nodeTypes.add(nodeType);
        } else if (type instanceof EdgeType) {
            EdgeType edgeType = (EdgeType)type;
            edgeType.setPackageContainedIn(this.getIdent().toString());
            this.edgeTypes.add(edgeType);
        } else if (type instanceof InternalObjectType) {
            InternalObjectType internalObjectType = (InternalObjectType)type;
            internalObjectType.setPackageContainedIn(this.getIdent().toString());
            this.objectTypes.add(internalObjectType);
        } else if (type instanceof InternalTransientObjectType) {
            InternalTransientObjectType internalTransientObjectType = (InternalTransientObjectType)type;
            internalTransientObjectType.setPackageContainedIn(this.getIdent().toString());
            this.transientObjectTypes.add(internalTransientObjectType);
        } else if (type instanceof EnumType) {
            EnumType enumType = (EnumType)type;
            enumType.setPackageContainedIn(this.getIdent().toString());
            this.enumTypes.add(enumType);
        } else assert (false) : "Unexpected type added to package: " + type;
    }

    public Collection<Type> getTypes() {
        return Collections.unmodifiableCollection(this.types);
    }

    @Override
    public Collection<NodeType> getNodeTypes() {
        return Collections.unmodifiableCollection(this.nodeTypes);
    }

    @Override
    public Collection<EdgeType> getEdgeTypes() {
        return Collections.unmodifiableCollection(this.edgeTypes);
    }

    @Override
    public Collection<InternalObjectType> getObjectTypes() {
        return Collections.unmodifiableCollection(this.objectTypes);
    }

    @Override
    public Collection<InternalTransientObjectType> getTransientObjectTypes() {
        return Collections.unmodifiableCollection(this.transientObjectTypes);
    }

    @Override
    public Collection<EnumType> getEnumTypes() {
        return Collections.unmodifiableCollection(this.enumTypes);
    }

    @Override
    protected void canonicalizeLocal() {
        for (Type type : this.types) {
            type.canonicalize();
            if (!(type instanceof EdgeType)) continue;
            ((EdgeType)type).canonicalizeConnectionAsserts();
        }
    }

    @Override
    public void addToDigest(StringBuffer stringBuffer) {
        stringBuffer.append(this);
        stringBuffer.append('[');
        for (Type type : this.types) {
            type.addToDigest(stringBuffer);
        }
        stringBuffer.append(']');
    }
}

