/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.pattern;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.expr.Constant;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.pattern.Alternative;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.OrderedReplacement;
import de.unika.ipd.grgen.ir.pattern.OrderedReplacements;
import de.unika.ipd.grgen.ir.pattern.PatternGraphBase;
import de.unika.ipd.grgen.ir.pattern.PatternGraphRhs;
import de.unika.ipd.grgen.ir.pattern.SubpatternUsage;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.EvalStatements;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class PatternGraphLhs
extends PatternGraphBase {
    private final Collection<Alternative> alts = new LinkedList<Alternative>();
    private final Collection<Rule> iters = new LinkedList<Rule>();
    private final Collection<PatternGraphLhs> negs = new LinkedList<PatternGraphLhs>();
    private final Collection<PatternGraphLhs> idpts = new LinkedList<PatternGraphLhs>();
    private final List<Expression> conds = new LinkedList<Expression>();
    private final List<EvalStatements> yields = new LinkedList<EvalStatements>();
    private final List<Collection<Node>> homNodesLists = new LinkedList<Collection<Node>>();
    private final List<Collection<Edge>> homEdgesLists = new LinkedList<Collection<Edge>>();
    private final HashMap<Node, HashSet<Node>> totallyHomNodes = new HashMap();
    private final HashMap<Edge, HashSet<Edge>> totallyHomEdges = new HashMap();
    int modifiers;
    final int PATTERN_NOT_YET_VISITED = 0;
    final int PATTERN_MAYBE_EMPTY = 1;
    final int PATTERN_NOT_EMPTY = 2;
    int mayPatternBeEmptyComputationState = 0;
    private boolean iterationBreaking = false;

    public PatternGraphLhs(String string, int n) {
        super(string);
        this.modifiers = n;
    }

    public void addAlternative(Alternative alternative) {
        this.alts.add(alternative);
    }

    public Collection<Alternative> getAlts() {
        return Collections.unmodifiableCollection(this.alts);
    }

    public void addIterated(Rule rule) {
        this.iters.add(rule);
    }

    public Collection<Rule> getIters() {
        return Collections.unmodifiableCollection(this.iters);
    }

    public void addNegGraph(PatternGraphLhs patternGraphLhs) {
        int n = this.negs.size();
        patternGraphLhs.setName("N" + n);
        this.negs.add(patternGraphLhs);
    }

    public Collection<PatternGraphLhs> getNegs() {
        return Collections.unmodifiableCollection(this.negs);
    }

    public void addIdptGraph(PatternGraphLhs patternGraphLhs) {
        int n = this.idpts.size();
        patternGraphLhs.setName("I" + n);
        this.idpts.add(patternGraphLhs);
    }

    public Collection<PatternGraphLhs> getIdpts() {
        return Collections.unmodifiableCollection(this.idpts);
    }

    public void addCondition(Expression expression) {
        this.conds.add(expression);
    }

    public void addYield(EvalStatements evalStatements) {
        this.yields.add(evalStatements);
    }

    public void addHomomorphicNodes(Collection<Node> collection) {
        this.homNodesLists.add(collection);
    }

    public void addHomomorphicEdges(Collection<Edge> collection) {
        this.homEdgesLists.add(collection);
    }

    public void addTotallyHomomorphic(Node node, HashSet<Node> hashSet) {
        this.totallyHomNodes.put(node, hashSet);
    }

    public void addTotallyHomomorphic(Edge edge, HashSet<Edge> hashSet) {
        this.totallyHomEdges.put(edge, hashSet);
    }

    public void setIterationBreaking(boolean bl) {
        this.iterationBreaking = bl;
    }

    public boolean isIterationBreaking() {
        return this.iterationBreaking;
    }

    public Collection<Expression> getConditions() {
        return Collections.unmodifiableCollection(this.conds);
    }

    public Collection<EvalStatements> getYields() {
        return Collections.unmodifiableCollection(this.yields);
    }

    public Collection<Collection<? extends GraphEntity>> getHomomorphic() {
        LinkedHashSet<Collection<GraphEntity>> linkedHashSet = new LinkedHashSet<Collection<GraphEntity>>();
        linkedHashSet.addAll(this.homEdgesLists);
        linkedHashSet.addAll(this.homNodesLists);
        return Collections.unmodifiableCollection(linkedHashSet);
    }

    public Collection<Node> getHomomorphic(Node node) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Collection<Node> collection : this.homNodesLists) {
            if (!collection.contains(node)) continue;
            linkedList.addAll(collection);
        }
        linkedList.add(node);
        return linkedList;
    }

    public Collection<Edge> getHomomorphic(Edge edge) {
        LinkedList<Edge> linkedList = new LinkedList<Edge>();
        for (Collection<Edge> collection : this.homEdgesLists) {
            if (!collection.contains(edge)) continue;
            linkedList.addAll(collection);
        }
        linkedList.add(edge);
        return linkedList;
    }

    public boolean isHomomorphic(Node node, Node node2) {
        if (this.isTotallyHomomorphic(node, node2)) {
            return true;
        }
        return this.homToAllNodes.contains(node) || this.homToAllNodes.contains(node2) || this.getHomomorphic(node).contains(node2);
    }

    public boolean isHomomorphic(Edge edge, Edge edge2) {
        if (this.isTotallyHomomorphic(edge, edge2)) {
            return true;
        }
        return this.homToAllEdges.contains(edge) || this.homToAllEdges.contains(edge2) || this.getHomomorphic(edge).contains(edge2);
    }

    public boolean isHomomorphicGlobal(HashMap<Entity, String> hashMap, Node node, Node node2) {
        if (this.isTotallyHomomorphic(node, node2)) {
            return true;
        }
        if (!this.getHomomorphic(node).contains(node2)) {
            return false;
        }
        return hashMap.containsKey(node) != hashMap.containsKey(node2);
    }

    public boolean isHomomorphicGlobal(HashMap<Entity, String> hashMap, Edge edge, Edge edge2) {
        if (this.isTotallyHomomorphic(edge, edge2)) {
            return true;
        }
        if (!this.getHomomorphic(edge).contains(edge2)) {
            return false;
        }
        return hashMap.containsKey(edge) != hashMap.containsKey(edge2);
    }

    public boolean isTotallyHomomorphic(Node node, Node node2) {
        if (this.isTotallyHomomorphic(node) && this.totallyHomNodes.get(node).contains(node2)) {
            return false;
        }
        if (this.isTotallyHomomorphic(node2) && this.totallyHomNodes.get(node2).contains(node)) {
            return false;
        }
        return this.isTotallyHomomorphic(node) || this.isTotallyHomomorphic(node2);
    }

    public boolean isTotallyHomomorphic(Edge edge, Edge edge2) {
        if (this.isTotallyHomomorphic(edge) && this.totallyHomEdges.get(edge).contains(edge2)) {
            return false;
        }
        if (this.isTotallyHomomorphic(edge2) && this.totallyHomEdges.get(edge2).contains(edge)) {
            return false;
        }
        return this.isTotallyHomomorphic(edge) || this.isTotallyHomomorphic(edge2);
    }

    public boolean isTotallyHomomorphic(Node node) {
        return this.totallyHomNodes.containsKey(node);
    }

    public boolean isTotallyHomomorphic(Edge edge) {
        return this.totallyHomEdges.containsKey(edge);
    }

    public boolean isPatternpathLocked() {
        return (this.modifiers & 0x20) == 32;
    }

    public void resolvePatternLockedModifier() {
        for (PatternGraphLhs patternGraphLhs : this.getNegs()) {
            if ((patternGraphLhs.modifiers & 0x10) != 16) continue;
            for (Node node : this.getNodes()) {
                if (patternGraphLhs.hasNode(node)) continue;
                patternGraphLhs.addSingleNode(node);
            }
            for (Edge edge : this.getEdges()) {
                if (patternGraphLhs.hasEdge(edge)) continue;
                patternGraphLhs.addSingleEdge(edge);
            }
        }
        for (PatternGraphLhs patternGraphLhs : this.getIdpts()) {
            if ((patternGraphLhs.modifiers & 0x10) != 16) continue;
            for (Node node : this.getNodes()) {
                if (patternGraphLhs.hasNode(node)) continue;
                patternGraphLhs.addSingleNode(node);
            }
            for (Edge edge : this.getEdges()) {
                if (patternGraphLhs.hasEdge(edge)) continue;
                patternGraphLhs.addSingleEdge(edge);
            }
        }
        for (PatternGraphLhs patternGraphLhs : this.getNegs()) {
            patternGraphLhs.resolvePatternLockedModifier();
        }
        for (PatternGraphLhs patternGraphLhs : this.getIdpts()) {
            patternGraphLhs.resolvePatternLockedModifier();
        }
    }

    public void ensureDirectlyNestingPatternContainsAllNonLocalElementsOfNestedPattern(HashSet<Node> hashSet, HashSet<Edge> hashSet2, HashSet<Variable> hashSet3, PatternGraphRhs patternGraphRhs) {
        Iterator<Entity> iterator;
        Object object;
        Object object22;
        if (patternGraphRhs != null) {
            this.insertElementsFromRhsDeclaredInNestingRhsToReplParams(patternGraphRhs);
        }
        if (patternGraphRhs != null) {
            this.insertElementsFromRhsDeclaredInNestingLhsToLocalLhs(patternGraphRhs);
        }
        for (Node iR : this.getNodes()) {
            hashSet.add(iR);
        }
        for (Edge edge : this.getEdges()) {
            hashSet2.add(edge);
        }
        for (Variable variable : this.getVars()) {
            hashSet3.add(variable);
        }
        for (Alternative alternative : this.getAlts()) {
            for (Rule rule : alternative.getAlternativeCases()) {
                PatternGraphLhs patternGraphLhs = rule.getLeft();
                object22 = new HashSet<Node>(hashSet);
                HashSet<Edge> hashSet4 = new HashSet<Edge>(hashSet2);
                object = new HashSet<Variable>(hashSet3);
                patternGraphLhs.ensureDirectlyNestingPatternContainsAllNonLocalElementsOfNestedPattern((HashSet<Node>)object22, hashSet4, (HashSet<Variable>)object, rule.getRight());
            }
        }
        for (Rule rule : this.getIters()) {
            iterator = rule.getLeft();
            HashSet<Node> hashSet5 = new HashSet<Node>(hashSet);
            HashSet<Edge> hashSet6 = new HashSet<Edge>(hashSet2);
            object22 = new HashSet<Variable>(hashSet3);
            ((PatternGraphLhs)((Object)iterator)).ensureDirectlyNestingPatternContainsAllNonLocalElementsOfNestedPattern(hashSet5, hashSet6, (HashSet<Variable>)object22, rule.getRight());
        }
        for (PatternGraphLhs patternGraphLhs : this.getNegs()) {
            iterator = new HashSet<Node>(hashSet);
            HashSet<Edge> hashSet7 = new HashSet<Edge>(hashSet2);
            HashSet<Variable> hashSet8 = new HashSet<Variable>(hashSet3);
            patternGraphLhs.ensureDirectlyNestingPatternContainsAllNonLocalElementsOfNestedPattern((HashSet<Node>)((Object)iterator), hashSet7, hashSet8, null);
        }
        for (PatternGraphLhs patternGraphLhs : this.getIdpts()) {
            iterator = new HashSet<Node>(hashSet);
            HashSet<Edge> hashSet9 = new HashSet<Edge>(hashSet2);
            HashSet<Variable> hashSet10 = new HashSet<Variable>(hashSet3);
            patternGraphLhs.ensureDirectlyNestingPatternContainsAllNonLocalElementsOfNestedPattern((HashSet<Node>)((Object)iterator), hashSet9, hashSet10, null);
        }
        for (Alternative alternative : this.getAlts()) {
            for (Rule rule : alternative.getAlternativeCases()) {
                PatternGraphLhs patternGraphLhs = rule.getLeft();
                for (Node node : patternGraphLhs.getNodes()) {
                    if (this.hasNode(node) || !hashSet.contains(node)) continue;
                    this.addSingleNode(node);
                    this.addHomToAll(node);
                    object = rule.getRight();
                    if (object != null && !((PatternGraphBase)object).hasNode(node)) {
                        ((PatternGraphBase)object).addSingleNode(node);
                    }
                    if (patternGraphRhs == null || patternGraphRhs.hasNode(node) || patternGraphRhs.getDeletedElements().contains(node)) continue;
                    patternGraphRhs.addSingleNode(node);
                }
                for (Edge edge : patternGraphLhs.getEdges()) {
                    if (this.hasEdge(edge) || !hashSet2.contains(edge)) continue;
                    this.addSingleEdge(edge);
                    this.addHomToAll(edge);
                    object = rule.getRight();
                    if (object != null && !((PatternGraphBase)object).hasEdge(edge)) {
                        ((PatternGraphBase)object).addSingleEdge(edge);
                    }
                    if (patternGraphRhs == null || patternGraphRhs.hasEdge(edge) || patternGraphRhs.getDeletedElements().contains(edge)) continue;
                    patternGraphRhs.addSingleEdge(edge);
                }
                for (Variable variable : patternGraphLhs.getVars()) {
                    if (this.hasVar(variable) || !hashSet3.contains(variable)) continue;
                    this.addVariable(variable);
                }
                if (patternGraphRhs == null) continue;
                object22 = rule.getRight().getReplParameters();
                Iterator<Entity> iterator2 = object22.iterator();
                while (iterator2.hasNext()) {
                    Entity entity;
                    object = iterator2.next();
                    if (object instanceof Node) {
                        entity = (Node)object;
                        if (entity.directlyNestingLHSGraph != this && !patternGraphRhs.getReplParameters().contains(entity)) {
                            patternGraphRhs.addReplParameter(entity);
                        }
                    }
                    if (object instanceof Edge) {
                        entity = (Edge)object;
                        if (((Edge)entity).directlyNestingLHSGraph != this && !patternGraphRhs.getReplParameters().contains(entity)) {
                            patternGraphRhs.addReplParameter(entity);
                        }
                    }
                    if (!(object instanceof Variable)) continue;
                    entity = (Variable)object;
                    if (((Variable)entity).directlyNestingLHSGraph == this || patternGraphRhs.getReplParameters().contains(entity)) continue;
                    patternGraphRhs.addReplParameter(entity);
                }
            }
        }
        for (Rule rule : this.getIters()) {
            iterator = rule.getLeft();
            for (Node node : ((PatternGraphBase)((Object)iterator)).getNodes()) {
                if (this.hasNode(node) || !hashSet.contains(node)) continue;
                this.addSingleNode(node);
                this.addHomToAll(node);
                object22 = rule.getRight();
                if (object22 != null && !((PatternGraphBase)object22).hasNode(node)) {
                    ((PatternGraphBase)object22).addSingleNode(node);
                }
                if (patternGraphRhs == null || patternGraphRhs.hasNode(node) || patternGraphRhs.getDeletedElements().contains(node)) continue;
                patternGraphRhs.addSingleNode(node);
            }
            for (Edge edge : ((PatternGraphBase)((Object)iterator)).getEdges()) {
                if (this.hasEdge(edge) || !hashSet2.contains(edge)) continue;
                this.addSingleEdge(edge);
                this.addHomToAll(edge);
                object22 = rule.getRight();
                if (object22 != null && !((PatternGraphBase)object22).hasEdge(edge)) {
                    ((PatternGraphBase)object22).addSingleEdge(edge);
                }
                if (patternGraphRhs == null || patternGraphRhs.hasEdge(edge) || patternGraphRhs.getDeletedElements().contains(edge)) continue;
                patternGraphRhs.addSingleEdge(edge);
            }
            for (Variable variable : ((PatternGraphBase)((Object)iterator)).getVars()) {
                if (this.hasVar(variable) || !hashSet3.contains(variable)) continue;
                this.addVariable(variable);
            }
            if (patternGraphRhs == null) continue;
            List<Entity> list = rule.getRight().getReplParameters();
            for (Object object22 : list) {
                if (object22 instanceof Node) {
                    Node node = (Node)object22;
                    if (node.directlyNestingLHSGraph != this && !patternGraphRhs.getReplParameters().contains(node)) {
                        patternGraphRhs.addReplParameter(node);
                    }
                }
                if (object22 instanceof Edge) {
                    Edge edge = (Edge)object22;
                    if (edge.directlyNestingLHSGraph != this && !patternGraphRhs.getReplParameters().contains(edge)) {
                        patternGraphRhs.addReplParameter(edge);
                    }
                }
                if (!(object22 instanceof Variable)) continue;
                Variable variable = (Variable)object22;
                if (variable.directlyNestingLHSGraph == this || patternGraphRhs.getReplParameters().contains(variable)) continue;
                patternGraphRhs.addReplParameter(variable);
            }
        }
        for (PatternGraphLhs patternGraphLhs : this.getNegs()) {
            for (Node node : patternGraphLhs.getNodes()) {
                if (this.hasNode(node) || !hashSet.contains(node)) continue;
                this.addSingleNode(node);
                this.addHomToAll(node);
                if (patternGraphRhs == null || patternGraphRhs.hasNode(node) || patternGraphRhs.getDeletedElements().contains(node)) continue;
                patternGraphRhs.addSingleNode(node);
            }
            for (Edge edge : patternGraphLhs.getEdges()) {
                if (this.hasEdge(edge) || !hashSet2.contains(edge)) continue;
                this.addSingleEdge(edge);
                this.addHomToAll(edge);
                if (patternGraphRhs == null || patternGraphRhs.hasEdge(edge) || patternGraphRhs.getDeletedElements().contains(edge)) continue;
                patternGraphRhs.addSingleEdge(edge);
            }
            for (Variable variable : patternGraphLhs.getVars()) {
                if (this.hasVar(variable) || !hashSet3.contains(variable)) continue;
                this.addVariable(variable);
            }
        }
        for (PatternGraphLhs patternGraphLhs : this.getIdpts()) {
            for (Node node : patternGraphLhs.getNodes()) {
                if (this.hasNode(node) || !hashSet.contains(node)) continue;
                this.addSingleNode(node);
                this.addHomToAll(node);
                if (patternGraphRhs == null || patternGraphRhs.hasNode(node) || patternGraphRhs.getDeletedElements().contains(node)) continue;
                patternGraphRhs.addSingleNode(node);
            }
            for (Edge edge : patternGraphLhs.getEdges()) {
                if (this.hasEdge(edge) || !hashSet2.contains(edge)) continue;
                this.addSingleEdge(edge);
                this.addHomToAll(edge);
                if (patternGraphRhs == null || patternGraphRhs.hasEdge(edge) || patternGraphRhs.getDeletedElements().contains(edge)) continue;
                patternGraphRhs.addSingleEdge(edge);
            }
            for (Variable variable : patternGraphLhs.getVars()) {
                if (this.hasVar(variable) || !hashSet3.contains(variable)) continue;
                this.addVariable(variable);
            }
        }
    }

    public void insertElementsFromRhsDeclaredInNestingRhsToReplParams(PatternGraphRhs patternGraphRhs) {
        if (patternGraphRhs == null) {
            return;
        }
        for (Node entity : patternGraphRhs.getNodes()) {
            if (entity.directlyNestingLHSGraph == this || patternGraphRhs.replParametersContain(entity) || (entity.context & 1) != 1) continue;
            patternGraphRhs.addReplParameter(entity);
        }
        for (Variable variable : patternGraphRhs.getVars()) {
            if (variable.directlyNestingLHSGraph == this || patternGraphRhs.replParametersContain(variable) || (variable.context & 1) != 1) continue;
            patternGraphRhs.addReplParameter(variable);
        }
        for (Edge edge : patternGraphRhs.getEdges()) {
            if (edge.directlyNestingLHSGraph == this || (edge.context & 1) != 1) continue;
            error.error(edge.getIdent().getCoords(), "Cannot access a newly created edge (" + edge.getIdent() + ") in a nested rewrite part.");
        }
        PatternGraphLhs.checkThatEvalhereIsNotAccessingCreatedEdges(patternGraphRhs);
    }

    public static void checkThatEvalhereIsNotAccessingCreatedEdges(PatternGraphRhs patternGraphRhs) {
        if (patternGraphRhs == null) {
            return;
        }
        for (OrderedReplacements orderedReplacements : patternGraphRhs.getOrderedReplacements()) {
            for (OrderedReplacement orderedReplacement : orderedReplacements.orderedReplacements) {
                if (!(orderedReplacement instanceof EvalStatement)) continue;
                EvalStatement evalStatement = (EvalStatement)orderedReplacement;
                NeededEntities neededEntities = new NeededEntities(EnumSet.of(NeededEntities.Needs.EDGES, NeededEntities.Needs.ALL_ATTRIBUTES));
                evalStatement.collectNeededEntities(neededEntities);
                for (Edge edge : neededEntities.edges) {
                    if ((edge.context & 1) != 1) continue;
                    error.error(edge.getIdent().getCoords(), "Cannot access a newly created edge (" + edge.getIdent() + ") from an evalhere statement.");
                }
                for (Edge edge : neededEntities.attrEdges) {
                    if ((edge.context & 1) != 1) continue;
                    error.error(edge.getIdent().getCoords(), "Cannot access a newly created edge (" + edge.getIdent() + ") from an evalhere statement.");
                }
            }
        }
    }

    public void insertElementsFromRhsDeclaredInNestingLhsToLocalLhs(PatternGraphRhs patternGraphRhs) {
        if (patternGraphRhs == null) {
            return;
        }
        for (Node entity : patternGraphRhs.getNodes()) {
            if (entity.directlyNestingLHSGraph == this || patternGraphRhs.replParametersContain(entity) || this.hasNode(entity)) continue;
            this.addSingleNode(entity);
            this.addHomToAll(entity);
        }
        for (Edge edge : patternGraphRhs.getEdges()) {
            if (edge.directlyNestingLHSGraph == this || patternGraphRhs.replParametersContain(edge) || this.hasEdge(edge)) continue;
            this.addSingleEdge(edge);
            this.addHomToAll(edge);
        }
        for (Variable variable : patternGraphRhs.getVars()) {
            if (variable.directlyNestingLHSGraph == this || patternGraphRhs.replParametersContain(variable)) continue;
            this.addVariable(variable);
        }
    }

    public void checkForEmptyPatternsInIterateds() {
        if (this.mayPatternBeEmptyComputationState != 0) {
            return;
        }
        this.mayPatternBeEmptyComputationState = 1;
        block0: for (Node iR : this.getNodes()) {
            if (iR.directlyNestingLHSGraph != this) continue;
            for (Node node : this.getHomomorphic(iR)) {
                if (node.directlyNestingLHSGraph == this) continue;
                continue block0;
            }
            this.mayPatternBeEmptyComputationState = 2;
            break;
        }
        if (this.mayPatternBeEmptyComputationState != 2) {
            block2: for (Edge edge : this.getEdges()) {
                if (edge.directlyNestingLHSGraph != this) continue;
                for (Edge edge2 : this.getHomomorphic(edge)) {
                    if (edge2.directlyNestingLHSGraph == this) continue;
                    continue block2;
                }
                this.mayPatternBeEmptyComputationState = 2;
                break;
            }
        }
        for (Alternative alternative : this.getAlts()) {
            boolean bl = true;
            for (Rule rule : alternative.getAlternativeCases()) {
                rule.pattern.checkForEmptyPatternsInIterateds();
                if (rule.pattern.mayPatternBeEmptyComputationState != 1) continue;
                bl = false;
            }
            if (!bl) continue;
            this.mayPatternBeEmptyComputationState = 2;
        }
        for (Rule rule : this.getIters()) {
            rule.pattern.checkForEmptyPatternsInIterateds();
            if (rule.pattern.mayPatternBeEmptyComputationState == 1) {
                if (rule.getMaxMatches() == 0) {
                    error.error(rule.getIdent().getCoords(), "An unbounded pattern cardinality construct (iterated, multiple, [*]) must contain at least one locally defined node or edge (not being homomorphic to an enclosing element) or a nested subpattern or alternative not being empty.");
                    continue;
                }
                if (rule.getMaxMatches() <= 1) continue;
                error.warning(rule.getIdent().getCoords(), "Maybe empty pattern in pattern cardinality construct (you must expect empty matches).");
                continue;
            }
            if (rule.getMinMatches() <= 0) continue;
            this.mayPatternBeEmptyComputationState = 2;
        }
        for (SubpatternUsage subpatternUsage : this.getSubpatternUsages()) {
            subpatternUsage.subpatternAction.pattern.checkForEmptyPatternsInIterateds();
            if (subpatternUsage.subpatternAction.pattern.mayPatternBeEmptyComputationState != 2) continue;
            this.mayPatternBeEmptyComputationState = 2;
        }
        for (PatternGraphLhs patternGraphLhs : this.getNegs()) {
            patternGraphLhs.checkForEmptyPatternsInIterateds();
        }
        for (PatternGraphLhs patternGraphLhs : this.getIdpts()) {
            patternGraphLhs.checkForEmptyPatternsInIterateds();
        }
    }

    public void checkForEmptySubpatternRecursions(HashSet<PatternGraphLhs> hashSet) {
        HashSet<PatternGraphLhs> hashSet2;
        block0: for (Node iR : this.getNodes()) {
            if (iR.directlyNestingLHSGraph != this) continue;
            for (Node node : this.getHomomorphic(iR)) {
                if (node.directlyNestingLHSGraph == this) continue;
                continue block0;
            }
            return;
        }
        block2: for (Edge edge : this.getEdges()) {
            if (edge.directlyNestingLHSGraph != this) continue;
            for (Edge edge2 : this.getHomomorphic(edge)) {
                if (edge2.directlyNestingLHSGraph == this) continue;
                continue block2;
            }
            return;
        }
        for (Expression expression : this.getConditions()) {
            if (expression instanceof Constant && ((Constant)expression).value instanceof Boolean) {
                hashSet2 = (Constant)expression;
                if (((Boolean)((Constant)((Object)hashSet2)).value).booleanValue()) continue;
            }
            return;
        }
        for (Alternative alternative : this.getAlts()) {
            for (Rule rule : alternative.getAlternativeCases()) {
                HashSet<PatternGraphLhs> hashSet3 = new HashSet<PatternGraphLhs>(hashSet);
                rule.pattern.checkForEmptySubpatternRecursions(hashSet3);
            }
        }
        for (Rule rule : this.getIters()) {
            hashSet2 = new HashSet<PatternGraphLhs>(hashSet);
            rule.pattern.checkForEmptySubpatternRecursions(hashSet2);
        }
        for (PatternGraphLhs patternGraphLhs : this.getNegs()) {
            hashSet2 = new HashSet<PatternGraphLhs>(hashSet);
            patternGraphLhs.checkForEmptySubpatternRecursions(hashSet2);
        }
        for (PatternGraphLhs patternGraphLhs : this.getIdpts()) {
            hashSet2 = new HashSet<PatternGraphLhs>(hashSet);
            patternGraphLhs.checkForEmptySubpatternRecursions(hashSet2);
        }
        for (SubpatternUsage subpatternUsage : this.getSubpatternUsages()) {
            if (!hashSet.contains(subpatternUsage.subpatternAction.pattern)) {
                hashSet2 = new HashSet<PatternGraphLhs>(hashSet);
                hashSet2.add(subpatternUsage.subpatternAction.pattern);
                subpatternUsage.subpatternAction.pattern.checkForEmptySubpatternRecursions(hashSet2);
                continue;
            }
            error.error(subpatternUsage.subpatternAction.getIdent().getCoords(), "The (sub)pattern " + subpatternUsage.subpatternAction.getIdent() + " (potentially) calls itself again with only empty patterns in between, yielding an endless loop during pattern matching.");
        }
    }

    public boolean isNeverTerminatingSuccessfully(HashSet<PatternGraphLhs> hashSet) {
        boolean bl = false;
        for (Alternative iR : this.getAlts()) {
            boolean bl2 = true;
            for (Rule rule : iR.getAlternativeCases()) {
                HashSet<PatternGraphLhs> hashSet2 = new HashSet<PatternGraphLhs>(hashSet);
                bl2 &= rule.pattern.isNeverTerminatingSuccessfully(hashSet2);
            }
            bl |= bl2;
        }
        for (Rule rule : this.getIters()) {
            HashSet<PatternGraphLhs> hashSet3 = new HashSet<PatternGraphLhs>(hashSet);
            if (rule.getMinMatches() <= 0) continue;
            bl |= rule.pattern.isNeverTerminatingSuccessfully(hashSet3);
        }
        for (PatternGraphLhs patternGraphLhs : this.getNegs()) {
            HashSet<PatternGraphLhs> hashSet4 = new HashSet<PatternGraphLhs>(hashSet);
            bl |= patternGraphLhs.isNeverTerminatingSuccessfully(hashSet4);
        }
        for (PatternGraphLhs patternGraphLhs : this.getIdpts()) {
            HashSet<PatternGraphLhs> hashSet5 = new HashSet<PatternGraphLhs>(hashSet);
            bl |= patternGraphLhs.isNeverTerminatingSuccessfully(hashSet5);
        }
        for (SubpatternUsage subpatternUsage : this.getSubpatternUsages()) {
            if (!hashSet.contains(subpatternUsage.subpatternAction.pattern)) {
                HashSet<PatternGraphLhs> hashSet6 = new HashSet<PatternGraphLhs>(hashSet);
                hashSet6.add(subpatternUsage.subpatternAction.pattern);
                bl |= subpatternUsage.subpatternAction.pattern.isNeverTerminatingSuccessfully(hashSet6);
                continue;
            }
            return true;
        }
        return bl;
    }

    public void checkForMultipleRetypes(HashSet<Node> hashSet, HashSet<Edge> hashSet2, PatternGraphBase patternGraphBase) {
        Object object;
        for (Node identifiable : this.getNodes()) {
            hashSet.add(identifiable);
        }
        for (Edge edge : this.getEdges()) {
            hashSet2.add(edge);
        }
        for (Alternative alternative : this.getAlts()) {
            for (Rule rule : alternative.getAlternativeCases()) {
                object = rule.getLeft();
                HashSet<Node> hashSet3 = new HashSet<Node>(hashSet);
                HashSet<Edge> hashSet4 = new HashSet<Edge>(hashSet2);
                ((PatternGraphLhs)object).checkForMultipleRetypes(hashSet3, hashSet4, rule.getRight());
            }
        }
        for (Rule rule : this.getIters()) {
            PatternGraphLhs patternGraphLhs = rule.getLeft();
            HashSet<Node> hashSet5 = new HashSet<Node>(hashSet);
            object = new HashSet<Edge>(hashSet2);
            patternGraphLhs.checkForMultipleRetypes(hashSet5, (HashSet<Edge>)object, rule.getRight());
            if (rule.getMaxMatches() == 1) continue;
            patternGraphLhs.checkForMultipleRetypesDoCheck(hashSet, hashSet2, rule.getRight());
        }
    }

    public void checkForMultipleRetypesDoCheck(HashSet<Node> hashSet, HashSet<Edge> hashSet2, PatternGraphBase patternGraphBase) {
        for (Node identifiable : patternGraphBase.getNodes()) {
            if (identifiable.getRetypedNode(patternGraphBase) == null) continue;
            if (hashSet.contains(identifiable)) {
                error.error(identifiable.getIdent().getCoords(), "A retyping of nodes from a nesting pattern is forbidden if they are contained in a construct which can get matched more than once (due to some kind of iterated) (this occurs for " + identifiable + ").");
                continue;
            }
            for (Node node : this.getHomomorphic(identifiable)) {
                if (!hashSet.contains(node)) continue;
                error.error(identifiable.getIdent().getCoords(), "A retyping of nodes which might be hom to nodes from a nesting pattern is forbidden if they are contained in a construct which can get matched more than once (due to some kind of iterated) (this occurs for " + identifiable + ").");
            }
        }
        for (Edge edge : patternGraphBase.getEdges()) {
            if (edge.getRetypedEdge(patternGraphBase) == null) continue;
            if (hashSet2.contains(edge)) {
                error.error(edge.getIdent().getCoords(), "A retyping of edges from a nesting pattern is forbidden if they are contained in a construct which can get matched more than once (due to some kind of iterated) (this occurs for " + edge + ").");
                continue;
            }
            for (Edge edge2 : this.getHomomorphic(edge)) {
                if (!hashSet2.contains(edge2)) continue;
                error.error(edge.getIdent().getCoords(), "A retyping of edges which might be hom to edges from a nesting pattern is forbidden if they are contained in construct which can get matched more than once (due to some kind of iterated) (this occurs for " + edge + ").");
            }
        }
        for (Alternative alternative : this.getAlts()) {
            for (Rule rule : alternative.getAlternativeCases()) {
                PatternGraphLhs patternGraphLhs = rule.getLeft();
                patternGraphLhs.checkForMultipleRetypesDoCheck(hashSet, hashSet2, rule.getRight());
            }
        }
        for (Rule rule : this.getIters()) {
            PatternGraphLhs patternGraphLhs = rule.getLeft();
            patternGraphLhs.checkForMultipleRetypesDoCheck(hashSet, hashSet2, rule.getRight());
        }
    }
}

