/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.stmt;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.AssignmentBase;
import de.unika.ipd.grgen.ir.type.DefinedMatchType;
import de.unika.ipd.grgen.ir.type.MatchType;
import java.util.HashSet;

public class Assignment
extends AssignmentBase {
    private Qualification target;

    public Assignment(Qualification qualification, Expression expression) {
        super("assignment");
        this.target = qualification;
        this.expr = expression;
    }

    protected Assignment(String string, Qualification qualification, Expression expression) {
        super(string);
        this.target = qualification;
        this.expr = expression;
    }

    public Qualification getTarget() {
        return this.target;
    }

    @Override
    public String toString() {
        return this.getTarget() + " = " + this.getExpression();
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        Entity entity = this.target.getOwner();
        if (!(Assignment.isGlobalVariable(entity) || entity.getType() instanceof MatchType || entity.getType() instanceof DefinedMatchType)) {
            if (entity instanceof GraphEntity) {
                neededEntities.add((GraphEntity)entity);
            } else {
                neededEntities.add((Variable)entity);
            }
        }
        HashSet<Variable> hashSet = neededEntities.variables;
        neededEntities.variables = null;
        this.target.collectNeededEntities(neededEntities);
        neededEntities.variables = hashSet;
        this.getExpression().collectNeededEntities(neededEntities);
    }
}

