/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.stmt;

import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;

public class CompoundAssignmentVar
extends EvalStatement {
    private Variable target;
    private CompoundAssignmentType operation;
    private Expression expr;

    public CompoundAssignmentVar(Variable variable, CompoundAssignmentType compoundAssignmentType, Expression expression) {
        super("compound assignment var");
        this.target = variable;
        this.operation = compoundAssignmentType;
        this.expr = expression;
    }

    public Variable getTarget() {
        return this.target;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public CompoundAssignmentType getOperation() {
        return this.operation;
    }

    @Override
    public String toString() {
        return this.getTarget() + (this.operation == CompoundAssignmentType.UNION ? " |= " : (this.operation == CompoundAssignmentType.INTERSECTION ? " &= " : " \\= ")) + this.getExpression();
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        if (!CompoundAssignmentVar.isGlobalVariable(this.target)) {
            neededEntities.add(this.target);
        }
        this.getExpression().collectNeededEntities(neededEntities);
    }

    public static enum CompoundAssignmentType {
        NONE,
        UNION,
        INTERSECTION,
        WITHOUT,
        CONCATENATE,
        ASSIGN;

    }
}

