/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.type;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.Identifiable;
import de.unika.ipd.grgen.ir.executable.FunctionMethod;
import de.unika.ipd.grgen.ir.executable.ProcedureMethod;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class CompoundType
extends Type {
    private List<Entity> members = new LinkedList<Entity>();
    private List<FunctionMethod> functionMethods = new LinkedList<FunctionMethod>();
    private List<ProcedureMethod> procedureMethods = new LinkedList<ProcedureMethod>();

    public CompoundType(String string, Ident ident) {
        super(string, ident);
    }

    public Collection<Entity> getMembers() {
        return Collections.unmodifiableCollection(this.members);
    }

    public void addMember(Entity entity) {
        this.members.add(entity);
        entity.setOwner(this);
    }

    public Collection<FunctionMethod> getFunctionMethods() {
        return Collections.unmodifiableCollection(this.functionMethods);
    }

    public void addFunctionMethod(FunctionMethod functionMethod) {
        this.functionMethods.add(functionMethod);
        functionMethod.setOwner(this);
    }

    public void addProcedureMethod(ProcedureMethod procedureMethod) {
        this.procedureMethods.add(procedureMethod);
        procedureMethod.setOwner(this);
    }

    public Collection<ProcedureMethod> getProcedureMethods() {
        return Collections.unmodifiableCollection(this.procedureMethods);
    }

    @Override
    protected void canonicalizeLocal() {
        Collections.sort(this.members, Identifiable.COMPARATOR);
    }

    @Override
    public void addFields(Map<String, Object> map) {
        super.addFields(map);
        map.put("members", this.members.iterator());
    }

    @Override
    public void addToDigest(StringBuffer stringBuffer) {
        stringBuffer.append(this);
        stringBuffer.append('[');
        int n = 0;
        for (Entity entity : this.members) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(entity);
            ++n;
        }
        stringBuffer.append(']');
    }
}

