/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.type;

import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.type.TypeExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class TypeExprSetOperator
extends TypeExpr {
    private final SetOperator op;
    private final List<TypeExpr> children = new ArrayList<TypeExpr>();

    public TypeExprSetOperator(SetOperator setOperator) {
        this.op = setOperator;
    }

    public final void addOperand(TypeExpr typeExpr) {
        this.children.add(typeExpr);
    }

    @Override
    public Collection<InheritanceType> evaluate() {
        HashSet<InheritanceType> hashSet = new HashSet<InheritanceType>();
        assert (this.children.size() == 2) : "Arity 2 required";
        Collection<InheritanceType> collection = this.children.get(0).evaluate();
        Collection<InheritanceType> collection2 = this.children.get(1).evaluate();
        hashSet.addAll(collection);
        switch (this.op) {
            case UNION: {
                hashSet.addAll(collection2);
                break;
            }
            case DIFFERENCE: {
                hashSet.removeAll(collection2);
                break;
            }
            case INTERSECT: {
                hashSet.retainAll(collection2);
            }
        }
        return hashSet;
    }

    public static enum SetOperator {
        UNION,
        DIFFERENCE,
        INTERSECT;

    }
}

