/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.parser;

import de.unika.ipd.grgen.Sys;
import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.UnitNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterAutoSuppliedDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.IteratedDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.IntConstNode;
import de.unika.ipd.grgen.ast.model.ConnAssertNode;
import de.unika.ipd.grgen.ast.model.decl.ModelNode;
import de.unika.ipd.grgen.ast.model.type.ArbitraryEdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.DirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalTransientObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.model.type.UndirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.parser.Coords;
import de.unika.ipd.grgen.parser.Scope;
import de.unika.ipd.grgen.parser.Symbol;
import de.unika.ipd.grgen.parser.SymbolTable;
import de.unika.ipd.grgen.util.Annotations;
import de.unika.ipd.grgen.util.Base;
import de.unika.ipd.grgen.util.EmptyAnnotations;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;

public abstract class ParserEnvironment
extends Base {
    public static final String MODEL_SUFFIX = ".gm";
    public static final int TYPES = 0;
    public static final int PATTERNS = 0;
    public static final int ENTITIES = 1;
    public static final int ACTIONS = 2;
    public static final int ALTERNATIVES = 3;
    public static final int ITERATEDS = 4;
    public static final int NEGATIVES = 5;
    public static final int INDEPENDENTS = 6;
    public static final int REPLACES = 7;
    public static final int MODELS = 8;
    public static final int FUNCTIONS_AND_EXTERNAL_FUNCTIONS = 9;
    public static final int COMPUTATION_BLOCKS = 10;
    public static final int INDICES = 11;
    public static final int PACKAGES = 12;
    private final SymbolTable[] symTabs = new SymbolTable[]{new SymbolTable("types", 0), new SymbolTable("entities", 1), new SymbolTable("actions", 2), new SymbolTable("alternatives", 3), new SymbolTable("iterateds", 4), new SymbolTable("negatives", 5), new SymbolTable("independents", 6), new SymbolTable("replaces", 7), new SymbolTable("models", 8), new SymbolTable("functions and external functions", 9), new SymbolTable("computation blocks", 10), new SymbolTable("indices", 11), new SymbolTable("packages", 12)};
    private final IntConstNode one = new IntConstNode(Coords.getBuiltin(), 1);
    private final IntConstNode zero = new IntConstNode(Coords.getBuiltin(), 0);
    private Scope currScope;
    private final IdentNode nodeRoot;
    private final IdentNode arbitraryEdgeRoot;
    private final IdentNode directedEdgeRoot;
    private final IdentNode undirectedEdgeRoot;
    private final IdentNode internalObjectRoot;
    private final IdentNode internalTransientObjectRoot;
    private final Sys system;
    private final ModelNode stdModel;
    private HashSet<String> keywords = new HashSet();
    private IdentNode packageId;
    private IdentNode id;
    private CollectNode<IdentNode> matchTypeChilds = new CollectNode();

    public ParserEnvironment(Sys sys) {
        this.system = sys;
        this.currScope = new Scope(sys.getErrorReporter());
        BaseNode.setCurrScope(this.currScope);
        for (int i = 0; i < this.symTabs.length; ++i) {
            this.symTabs[i].enterKeyword("byte");
            this.symTabs[i].enterKeyword("short");
            this.symTabs[i].enterKeyword("int");
            this.symTabs[i].enterKeyword("long");
            this.symTabs[i].enterKeyword("string");
            this.symTabs[i].enterKeyword("boolean");
            this.symTabs[i].enterKeyword("float");
            this.symTabs[i].enterKeyword("double");
            this.symTabs[i].enterKeyword("object");
            this.symTabs[i].enterKeyword("graph");
        }
        this.initLexerKeywords();
        CollectNode<IdentNode> collectNode = new CollectNode<IdentNode>();
        CollectNode<IdentNode> collectNode2 = new CollectNode<IdentNode>();
        this.stdModel = new ModelNode(this.predefine(1, "Std"), collectNode, collectNode2, new CollectNode<IdentNode>(), new CollectNode<IdentNode>(), new CollectNode<IdentNode>(), new CollectNode<ModelNode>(), false, false, false, false, false, false, false, false, false, false, 0, 0);
        NodeTypeNode nodeTypeNode = new NodeTypeNode(new CollectNode<IdentNode>(), new CollectNode<BaseNode>(), 0, null);
        this.nodeRoot = this.predefineType("Node", nodeTypeNode);
        NodeTypeNode.nodeType = nodeTypeNode;
        ArbitraryEdgeTypeNode arbitraryEdgeTypeNode = new ArbitraryEdgeTypeNode(new CollectNode<IdentNode>(), new CollectNode<ConnAssertNode>(), new CollectNode<BaseNode>(), 2, null);
        this.arbitraryEdgeRoot = this.predefineType("AEdge", arbitraryEdgeTypeNode);
        CollectNode<IdentNode> collectNode3 = new CollectNode<IdentNode>();
        collectNode3.addChild(this.arbitraryEdgeRoot);
        EdgeTypeNode.arbitraryEdgeType = arbitraryEdgeTypeNode;
        DirectedEdgeTypeNode directedEdgeTypeNode = new DirectedEdgeTypeNode(collectNode3, new CollectNode<ConnAssertNode>(), new CollectNode<BaseNode>(), 0, null);
        this.directedEdgeRoot = this.predefineType("Edge", directedEdgeTypeNode);
        EdgeTypeNode.directedEdgeType = directedEdgeTypeNode;
        UndirectedEdgeTypeNode undirectedEdgeTypeNode = new UndirectedEdgeTypeNode(collectNode3, new CollectNode<ConnAssertNode>(), new CollectNode<BaseNode>(), 0, null);
        this.undirectedEdgeRoot = this.predefineType("UEdge", undirectedEdgeTypeNode);
        EdgeTypeNode.undirectedEdgeType = undirectedEdgeTypeNode;
        InternalObjectTypeNode internalObjectTypeNode = new InternalObjectTypeNode(new CollectNode<IdentNode>(), new CollectNode<BaseNode>(), 0);
        this.internalObjectRoot = this.predefineType("Object", internalObjectTypeNode);
        InternalObjectTypeNode.internalObjectType = internalObjectTypeNode;
        InternalTransientObjectTypeNode internalTransientObjectTypeNode = new InternalTransientObjectTypeNode(new CollectNode<IdentNode>(), new CollectNode<BaseNode>(), 0);
        this.internalTransientObjectRoot = this.predefineType("TransientObject", internalTransientObjectTypeNode);
        InternalTransientObjectTypeNode.internalTransientObjectType = internalTransientObjectTypeNode;
        collectNode2.addChild(this.nodeRoot);
        collectNode2.addChild(this.arbitraryEdgeRoot);
        collectNode2.addChild(this.directedEdgeRoot);
        collectNode2.addChild(this.undirectedEdgeRoot);
        collectNode2.addChild(this.internalObjectRoot);
        collectNode2.addChild(this.internalTransientObjectRoot);
        collectNode2.addChild(this.predefineType("byte", BasicTypeNode.byteType));
        collectNode2.addChild(this.predefineType("short", BasicTypeNode.shortType));
        collectNode2.addChild(this.predefineType("int", BasicTypeNode.intType));
        collectNode2.addChild(this.predefineType("long", BasicTypeNode.longType));
        collectNode2.addChild(this.predefineType("string", BasicTypeNode.stringType));
        collectNode2.addChild(this.predefineType("boolean", BasicTypeNode.booleanType));
        collectNode2.addChild(this.predefineType("float", BasicTypeNode.floatType));
        collectNode2.addChild(this.predefineType("double", BasicTypeNode.doubleType));
        collectNode2.addChild(this.predefineType("object", BasicTypeNode.objectType));
        collectNode2.addChild(this.predefineType("graph", BasicTypeNode.graphType));
    }

    public ModelNode getStdModel() {
        return this.stdModel;
    }

    public File findModel(String string) {
        File file = this.system.getModelPath();
        String string2 = string.endsWith(MODEL_SUFFIX) ? string : string + MODEL_SUFFIX;
        File file2 = file.getPath().equals(".") ? new File(string2) : new File(file, string2);
        debug.report(4, "trying: " + file2);
        File file3 = null;
        if (file2.exists()) {
            file3 = file2;
        }
        return file3;
    }

    private IdentNode predefine(int n, String string) {
        return new IdentNode(this.define(n, string, Coords.BUILTIN));
    }

    private IdentNode predefineType(String string, TypeNode typeNode) {
        IdentNode identNode = this.predefine(0, string);
        identNode.setDecl(new TypeDeclNode(identNode, typeNode));
        return identNode;
    }

    public Scope getCurrScope() {
        return this.currScope;
    }

    public void pushScope(IdentNode identNode) {
        this.currScope = this.currScope.newScope(identNode);
        BaseNode.setCurrScope(this.currScope);
    }

    public void pushScope(String string, Coords coords) {
        this.pushScope(new IdentNode(new Symbol.Definition(this.getCurrScope(), coords, new Symbol(string, SymbolTable.getInvalid()))));
    }

    public void popScope() {
        if (!this.currScope.isRoot()) {
            this.currScope = this.currScope.leaveScope();
        }
        BaseNode.setCurrScope(this.currScope);
    }

    public Symbol.Definition define(int n, String string, Coords coords) {
        assert (n >= 0 && n < this.symTabs.length) : "Illegal symbol table index";
        Symbol symbol = this.symTabs[n].get(string);
        return this.currScope.define(symbol, coords);
    }

    public IdentNode defineAnonymousEntity(String string, Coords coords) {
        Symbol.Definition definition = this.currScope.defineAnonymous(string, this.symTabs[1], coords);
        return new IdentNode(definition);
    }

    public Symbol.Occurrence occurs(int n, String string, Coords coords) {
        assert (n >= 0 && n < this.symTabs.length) : "Illegal symbol table index";
        Symbol symbol = this.symTabs[n].get(string);
        return this.currScope.occurs(symbol, coords);
    }

    public boolean test(int n, String string) {
        assert (n >= 0 && n < this.symTabs.length) : "Illegal symbol table index";
        return this.symTabs[n].test(string);
    }

    public void setCurrentPackage(IdentNode identNode) {
        this.packageId = identNode;
    }

    public IdentNode getCurrentPackage() {
        return this.packageId;
    }

    public void setCurrentActionOrSubpattern(IdentNode identNode) {
        this.id = identNode;
    }

    public IdentNode getCurrentActionOrSubpattern() {
        return this.id;
    }

    public void setMatchTypeChilds(CollectNode<IdentNode> collectNode) {
        this.matchTypeChilds = collectNode;
    }

    public void addMatchTypeChild(IdentNode identNode) {
        this.matchTypeChilds.addChild(identNode);
    }

    public IdentNode getMatchTypeChild(IdentNode identNode, IdentNode identNode2) {
        for (IdentNode identNode3 : this.matchTypeChilds.getChildren()) {
            String string = "match<" + identNode.getSymbol().getText() + "." + identNode2.getSymbol().getText() + ">";
            if (!identNode3.getSymbol().getText().equals(string)) continue;
            return identNode3;
        }
        identNode2.reportError("An iterated " + identNode.getSymbol().getText() + "." + identNode2.getSymbol().getText() + " is not known.");
        return IdentNode.getInvalid();
    }

    public IdentNode getNodeRoot() {
        return this.nodeRoot;
    }

    public IdentNode getDirectedEdgeRoot() {
        return this.directedEdgeRoot;
    }

    public IdentNode getArbitraryEdgeRoot() {
        return this.arbitraryEdgeRoot;
    }

    public IdentNode getUndirectedEdgeRoot() {
        return this.undirectedEdgeRoot;
    }

    public IdentNode getInternalObjectRoot() {
        return this.internalObjectRoot;
    }

    public IdentNode getInternalTransientObjectRoot() {
        return this.internalTransientObjectRoot;
    }

    public IntConstNode getOne() {
        return this.one;
    }

    public IntConstNode getZero() {
        return this.zero;
    }

    public Sys getSystem() {
        return this.system;
    }

    public static BaseNode initNode() {
        return BaseNode.getErrorNode();
    }

    public static ExprNode initExprNode() {
        return ExprNode.getInvalid();
    }

    public static VarDeclNode initVarNode(PatternGraphLhsNode patternGraphLhsNode, int n) {
        return VarDeclNode.getInvalidVar(patternGraphLhsNode, n);
    }

    public NodeDeclNode getDummyNodeDecl(int n, PatternGraphLhsNode patternGraphLhsNode) {
        return NodeDeclNode.getDummy(this.defineAnonymousEntity("dummy_node", new Coords()), this.getNodeRoot(), n, patternGraphLhsNode);
    }

    public static IdentNode getDummyIdent() {
        return IdentNode.getInvalid();
    }

    public static Annotations getEmptyAnnotations() {
        return EmptyAnnotations.get();
    }

    public static Coords getInvalidCoords() {
        return Coords.getInvalid();
    }

    public boolean isLexerKeyword(String string) {
        return this.keywords.contains(string);
    }

    private void initLexerKeywords() {
        this.keywords.add("abstract");
        this.keywords.add("alternative");
        this.keywords.add("arbitrary");
        this.keywords.add("array");
        this.keywords.add("auto");
        this.keywords.add("break");
        this.keywords.add("case");
        this.keywords.add("class");
        this.keywords.add("copy");
        this.keywords.add("connect");
        this.keywords.add("const");
        this.keywords.add("continue");
        this.keywords.add("count");
        this.keywords.add("def");
        this.keywords.add("delete");
        this.keywords.add("directed");
        this.keywords.add("do");
        this.keywords.add("edge");
        this.keywords.add("else");
        this.keywords.add("emit");
        this.keywords.add("emitdebug");
        this.keywords.add("emithere");
        this.keywords.add("emitheredebug");
        this.keywords.add("enum");
        this.keywords.add("eval");
        this.keywords.add("evalhere");
        this.keywords.add("exact");
        this.keywords.add("exec");
        this.keywords.add("extends");
        this.keywords.add("external");
        this.keywords.add("false");
        this.keywords.add("filter");
        this.keywords.add("for");
        this.keywords.add("function");
        this.keywords.add("hom");
        this.keywords.add("if");
        this.keywords.add("in");
        this.keywords.add("independent");
        this.keywords.add("index");
        this.keywords.add("induced");
        this.keywords.add("iterated");
        this.keywords.add("lock");
        this.keywords.add("map");
        this.keywords.add("match");
        this.keywords.add("modify");
        this.keywords.add("multiple");
        this.keywords.add("nameof");
        this.keywords.add("negative");
        this.keywords.add("node");
        this.keywords.add("null");
        this.keywords.add("optional");
        this.keywords.add("package");
        this.keywords.add("pattern");
        this.keywords.add("patternpath");
        this.keywords.add("procedure");
        this.keywords.add("deque");
        this.keywords.add("replace");
        this.keywords.add("return");
        this.keywords.add("rule");
        this.keywords.add("sequence");
        this.keywords.add("set");
        this.keywords.add("switch");
        this.keywords.add("test");
        this.keywords.add("true");
        this.keywords.add("typeof");
        this.keywords.add("undirected");
        this.keywords.add("using");
        this.keywords.add("visited");
        this.keywords.add("while");
        this.keywords.add("yield");
    }

    public static boolean isKnownPackage(String string) {
        switch (string) {
            case "Math": 
            case "File": 
            case "Time": 
            case "Debug": 
            case "Transaction": {
                return true;
            }
        }
        return false;
    }

    public static boolean isKnownFunction(Token token, Token token2, CollectNode<ExprNode> collectNode) {
        return ParserEnvironment.isMathFunction(token, token2, collectNode) || ParserEnvironment.isFileFunction(token, token2, collectNode) || ParserEnvironment.isTimeFunction(token, token2, collectNode) || ParserEnvironment.isGlobalFunction(token, token2, collectNode);
    }

    static boolean isMathFunction(Token token, Token token2, CollectNode<ExprNode> collectNode) {
        if (token == null || !token.getText().equals("Math")) {
            return false;
        }
        switch (token2.getText()) {
            case "min": 
            case "max": 
            case "sin": 
            case "cos": 
            case "tan": 
            case "arcsin": 
            case "arccos": 
            case "arctan": 
            case "sqr": 
            case "sqrt": 
            case "pow": 
            case "log": 
            case "ceil": 
            case "floor": 
            case "round": 
            case "truncate": 
            case "abs": 
            case "sgn": 
            case "pi": 
            case "e": 
            case "byteMin": 
            case "byteMax": 
            case "shortMin": 
            case "shortMax": 
            case "intMin": 
            case "intMax": 
            case "longMin": 
            case "longMax": 
            case "floatMin": 
            case "floatMax": 
            case "doubleMin": 
            case "doubleMax": {
                return true;
            }
        }
        return false;
    }

    static boolean isFileFunction(Token token, Token token2, CollectNode<ExprNode> collectNode) {
        if (token == null || !token.getText().equals("File")) {
            return false;
        }
        switch (token2.getText()) {
            case "exists": 
            case "import": {
                return true;
            }
        }
        return false;
    }

    static boolean isTimeFunction(Token token, Token token2, CollectNode<ExprNode> collectNode) {
        if (token == null || !token.getText().equals("Time")) {
            return false;
        }
        switch (token2.getText()) {
            case "now": {
                return true;
            }
        }
        return false;
    }

    public static boolean isGlobalFunction(Token token, Token token2, CollectNode<ExprNode> collectNode) {
        return ParserEnvironment.isGlobalFunction(token2.getText(), collectNode.getChildren().size());
    }

    public static boolean isGlobalFunction(String string, int n) {
        switch (string) {
            case "nodes": 
            case "edges": {
                return n <= 1;
            }
            case "countNodes": 
            case "countEdges": {
                return n <= 1;
            }
            case "empty": 
            case "size": {
                return n == 0;
            }
            case "source": 
            case "target": {
                return n == 1;
            }
            case "opposite": {
                return n == 2;
            }
            case "nodeByName": 
            case "edgeByName": {
                return n >= 1 && n <= 2;
            }
            case "nodeByUnique": 
            case "edgeByUnique": {
                return n >= 1 && n <= 2;
            }
            case "incoming": 
            case "outgoing": 
            case "incident": {
                return n >= 1 && n <= 3;
            }
            case "adjacentIncoming": 
            case "adjacentOutgoing": 
            case "adjacent": {
                return n >= 1 && n <= 3;
            }
            case "reachableIncoming": 
            case "reachableOutgoing": 
            case "reachable": {
                return n >= 1 && n <= 3;
            }
            case "reachableEdgesIncoming": 
            case "reachableEdgesOutgoing": 
            case "reachableEdges": {
                return n >= 1 && n <= 3;
            }
            case "boundedReachableIncoming": 
            case "boundedReachableOutgoing": 
            case "boundedReachable": {
                return n >= 2 && n <= 4;
            }
            case "boundedReachableEdgesIncoming": 
            case "boundedReachableEdgesOutgoing": 
            case "boundedReachableEdges": {
                return n >= 2 && n <= 4;
            }
            case "boundedReachableWithRemainingDepthIncoming": 
            case "boundedReachableWithRemainingDepthOutgoing": 
            case "boundedReachableWithRemainingDepth": {
                return n >= 2 && n <= 4;
            }
            case "countIncoming": 
            case "countOutgoing": 
            case "countIncident": {
                return n >= 1 && n <= 3;
            }
            case "countAdjacentIncoming": 
            case "countAdjacentOutgoing": 
            case "countAdjacent": {
                return n >= 1 && n <= 3;
            }
            case "countReachableIncoming": 
            case "countReachableOutgoing": 
            case "countReachable": {
                return n >= 1 && n <= 3;
            }
            case "countReachableEdgesIncoming": 
            case "countReachableEdgesOutgoing": 
            case "countReachableEdges": {
                return n >= 1 && n <= 3;
            }
            case "countBoundedReachableIncoming": 
            case "countBoundedReachableOutgoing": 
            case "countBoundedReachable": {
                return n >= 2 && n <= 4;
            }
            case "countBoundedReachableEdgesIncoming": 
            case "countBoundedReachableEdgesOutgoing": 
            case "countBoundedReachableEdges": {
                return n >= 2 && n <= 4;
            }
            case "isIncoming": 
            case "isOutgoing": 
            case "isIncident": {
                return n >= 2 && n <= 4;
            }
            case "isAdjacentIncoming": 
            case "isAdjacentOutgoing": 
            case "isAdjacent": {
                return n >= 2 && n <= 4;
            }
            case "isReachableIncoming": 
            case "isReachableOutgoing": 
            case "isReachable": {
                return n >= 2 && n <= 4;
            }
            case "isReachableEdgesIncoming": 
            case "isReachableEdgesOutgoing": 
            case "isReachableEdges": {
                return n >= 2 && n <= 4;
            }
            case "isBoundedReachableIncoming": 
            case "isBoundedReachableOutgoing": 
            case "isBoundedReachable": {
                return n >= 3 && n <= 5;
            }
            case "isBoundedReachableEdgesIncoming": 
            case "isBoundedReachableEdgesOutgoing": 
            case "isBoundedReachableEdges": {
                return n >= 3 && n <= 5;
            }
            case "random": {
                return n >= 0 && n <= 1;
            }
            case "canonize": {
                return n == 1;
            }
            case "inducedSubgraph": 
            case "definedSubgraph": {
                return n == 1;
            }
            case "equalsAny": 
            case "equalsAnyStructurally": {
                return n == 2;
            }
            case "getEquivalent": 
            case "getEquivalentStructurally": {
                return n == 2;
            }
            case "copy": 
            case "clone": {
                return n == 1;
            }
            case "nameof": {
                return n == 1 || n == 0;
            }
            case "uniqueof": {
                return n == 1 || n == 0;
            }
            case "graphof": {
                return n == 1;
            }
        }
        return false;
    }

    public static boolean isIsInIndexFunction(String string) {
        switch (string) {
            case "isInNodesFromIndex": {
                return true;
            }
            case "isInNodesFromIndexSame": 
            case "isInNodesFromIndexFrom": 
            case "isInNodesFromIndexFromExclusive": 
            case "isInNodesFromIndexTo": 
            case "isInNodesFromIndexToExclusive": {
                return true;
            }
            case "isInNodesFromIndexFromTo": 
            case "isInNodesFromIndexFromExclusiveTo": 
            case "isInNodesFromIndexFromToExclusive": 
            case "isInNodesFromIndexFromExclusiveToExclusive": {
                return true;
            }
            case "isInEdgesFromIndex": {
                return true;
            }
            case "isInEdgesFromIndexSame": 
            case "isInEdgesFromIndexFrom": 
            case "isInEdgesFromIndexFromExclusive": 
            case "isInEdgesFromIndexTo": 
            case "isInEdgesFromIndexToExclusive": {
                return true;
            }
            case "isInEdgesFromIndexFromTo": 
            case "isInEdgesFromIndexFromExclusiveTo": 
            case "isInEdgesFromIndexFromToExclusive": 
            case "isInEdgesFromIndexFromExclusiveToExclusive": {
                return true;
            }
        }
        return false;
    }

    public static boolean isNonIsInIndexFunction(String string) {
        switch (string) {
            case "nodesFromIndex": {
                return true;
            }
            case "nodesFromIndexSame": 
            case "nodesFromIndexFrom": 
            case "nodesFromIndexFromExclusive": 
            case "nodesFromIndexTo": 
            case "nodesFromIndexToExclusive": {
                return true;
            }
            case "nodesFromIndexFromTo": 
            case "nodesFromIndexFromExclusiveTo": 
            case "nodesFromIndexFromToExclusive": 
            case "nodesFromIndexFromExclusiveToExclusive": {
                return true;
            }
            case "edgesFromIndex": {
                return true;
            }
            case "edgesFromIndexSame": 
            case "edgesFromIndexFrom": 
            case "edgesFromIndexFromExclusive": 
            case "edgesFromIndexTo": 
            case "edgesFromIndexToExclusive": {
                return true;
            }
            case "edgesFromIndexFromTo": 
            case "edgesFromIndexFromExclusiveTo": 
            case "edgesFromIndexFromToExclusive": 
            case "edgesFromIndexFromExclusiveToExclusive": {
                return true;
            }
            case "countNodesFromIndex": {
                return true;
            }
            case "countNodesFromIndexSame": 
            case "countNodesFromIndexFrom": 
            case "countNodesFromIndexFromExclusive": 
            case "countNodesFromIndexTo": 
            case "countNodesFromIndexToExclusive": {
                return true;
            }
            case "countNodesFromIndexFromTo": 
            case "countNodesFromIndexFromExclusiveTo": 
            case "countNodesFromIndexFromToExclusive": 
            case "countNodesFromIndexFromExclusiveToExclusive": {
                return true;
            }
            case "countEdgesFromIndex": {
                return true;
            }
            case "countEdgesFromIndexSame": 
            case "countEdgesFromIndexFrom": 
            case "countEdgesFromIndexFromExclusive": 
            case "countEdgesFromIndexTo": 
            case "countEdgesFromIndexToExclusive": {
                return true;
            }
            case "countEdgesFromIndexFromTo": 
            case "countEdgesFromIndexFromExclusiveTo": 
            case "countEdgesFromIndexFromToExclusive": 
            case "countEdgesFromIndexFromExclusiveToExclusive": {
                return true;
            }
            case "nodesFromIndexAsArrayAscending": 
            case "nodesFromIndexAsArrayDescending": {
                return true;
            }
            case "nodesFromIndexSameAsArray": 
            case "nodesFromIndexFromAsArrayAscending": 
            case "nodesFromIndexFromExclusiveAsArrayAscending": 
            case "nodesFromIndexToAsArrayAscending": 
            case "nodesFromIndexToExclusiveAsArrayAscending": 
            case "nodesFromIndexFromAsArrayDescending": 
            case "nodesFromIndexFromExclusiveAsArrayDescending": 
            case "nodesFromIndexToAsArrayDescending": 
            case "nodesFromIndexToExclusiveAsArrayDescending": {
                return true;
            }
            case "nodesFromIndexFromToAsArrayAscending": 
            case "nodesFromIndexFromExclusiveToAsArrayAscending": 
            case "nodesFromIndexFromToExclusiveAsArrayAscending": 
            case "nodesFromIndexFromExclusiveToExclusiveAsArrayAscending": 
            case "nodesFromIndexFromToAsArrayDescending": 
            case "nodesFromIndexFromExclusiveToAsArrayDescending": 
            case "nodesFromIndexFromToExclusiveAsArrayDescending": 
            case "nodesFromIndexFromExclusiveToExclusiveAsArrayDescending": {
                return true;
            }
            case "edgesFromIndexAsArrayAscending": 
            case "edgesFromIndexAsArrayDescending": {
                return true;
            }
            case "edgesFromIndexSameAsArray": 
            case "edgesFromIndexFromAsArrayAscending": 
            case "edgesFromIndexFromExclusiveAsArrayAscending": 
            case "edgesFromIndexToAsArrayAscending": 
            case "edgesFromIndexToExclusiveAsArrayAscending": 
            case "edgesFromIndexFromAsArrayDescending": 
            case "edgesFromIndexFromExclusiveAsArrayDescending": 
            case "edgesFromIndexToAsArrayDescending": 
            case "edgesFromIndexToExclusiveAsArrayDescending": {
                return true;
            }
            case "edgesFromIndexFromToAsArrayAscending": 
            case "edgesFromIndexFromExclusiveToAsArrayAscending": 
            case "edgesFromIndexFromToExclusiveAsArrayAscending": 
            case "edgesFromIndexFromExclusiveToExclusiveAsArrayAscending": 
            case "edgesFromIndexFromToAsArrayDescending": 
            case "edgesFromIndexFromExclusiveToAsArrayDescending": 
            case "edgesFromIndexFromToExclusiveAsArrayDescending": 
            case "edgesFromIndexFromExclusiveToExclusiveAsArrayDescending": {
                return true;
            }
            case "nodesFromIndexMultipleFromTo": 
            case "edgesFromIndexMultipleFromTo": {
                return true;
            }
            case "countFromIndex": {
                return true;
            }
            case "minNodeFromIndex": 
            case "maxNodeFromIndex": 
            case "minEdgeFromIndex": 
            case "maxEdgeFromIndex": 
            case "indexSize": {
                return true;
            }
        }
        return false;
    }

    public static boolean isKnownForFunction(String string) {
        switch (string) {
            case "adjacent": 
            case "adjacentIncoming": 
            case "adjacentOutgoing": 
            case "incident": 
            case "incoming": 
            case "outgoing": 
            case "reachable": 
            case "reachableIncoming": 
            case "reachableOutgoing": 
            case "reachableEdges": 
            case "reachableEdgesIncoming": 
            case "reachableEdgesOutgoing": 
            case "boundedReachable": 
            case "boundedReachableIncoming": 
            case "boundedReachableOutgoing": 
            case "boundedReachableEdges": 
            case "boundedReachableEdgesIncoming": 
            case "boundedReachableEdgesOutgoing": 
            case "nodes": 
            case "edges": {
                return true;
            }
        }
        return false;
    }

    public static boolean isKnownForIndexFunction(String string) {
        switch (string) {
            case "nodesFromIndexSame": 
            case "edgesFromIndexSame": {
                return true;
            }
            case "nodesFromIndexAscending": 
            case "nodesFromIndexFromAscending": 
            case "nodesFromIndexFromExclusiveAscending": 
            case "nodesFromIndexToAscending": 
            case "nodesFromIndexToExclusiveAscending": 
            case "nodesFromIndexFromToAscending": 
            case "nodesFromIndexFromExclusiveToAscending": 
            case "nodesFromIndexFromToExclusiveAscending": 
            case "nodesFromIndexFromExclusiveToExclusiveAscending": 
            case "edgesFromIndexAscending": 
            case "edgesFromIndexFromAscending": 
            case "edgesFromIndexFromExclusiveAscending": 
            case "edgesFromIndexToAscending": 
            case "edgesFromIndexToExclusiveAscending": 
            case "edgesFromIndexFromToAscending": 
            case "edgesFromIndexFromExclusiveToAscending": 
            case "edgesFromIndexFromToExclusiveAscending": 
            case "edgesFromIndexFromExclusiveToExclusiveAscending": {
                return true;
            }
            case "nodesFromIndexDescending": 
            case "nodesFromIndexFromDescending": 
            case "nodesFromIndexFromExclusiveDescending": 
            case "nodesFromIndexToDescending": 
            case "nodesFromIndexToExclusiveDescending": 
            case "nodesFromIndexFromToDescending": 
            case "nodesFromIndexFromExclusiveToDescending": 
            case "nodesFromIndexFromToExclusiveDescending": 
            case "nodesFromIndexFromExclusiveToExclusiveDescending": 
            case "edgesFromIndexDescending": 
            case "edgesFromIndexFromDescending": 
            case "edgesFromIndexFromExclusiveDescending": 
            case "edgesFromIndexToDescending": 
            case "edgesFromIndexToExclusiveDescending": 
            case "edgesFromIndexFromToDescending": 
            case "edgesFromIndexFromExclusiveToDescending": 
            case "edgesFromIndexFromToExclusiveDescending": 
            case "edgesFromIndexFromExclusiveToExclusiveDescending": {
                return true;
            }
            case "nodesFromIndexMultipleFromTo": 
            case "edgesFromIndexMultipleFromTo": {
                return true;
            }
        }
        return false;
    }

    public static boolean isKnownProcedure(Token token, Token token2, CollectNode<ExprNode> collectNode) {
        return ParserEnvironment.isFileProcedure(token, token2, collectNode) || ParserEnvironment.isTransactionProcedure(token, token2, collectNode) || ParserEnvironment.isDebugProcedure(token, token2, collectNode) || ParserEnvironment.isSynchronizationProcedure(token, token2, collectNode) || ParserEnvironment.isGlobalProcedure(token, token2, collectNode);
    }

    static boolean isFileProcedure(Token token, Token token2, CollectNode<ExprNode> collectNode) {
        if (token == null || !token.getText().equals("File")) {
            return false;
        }
        switch (token2.getText()) {
            case "export": 
            case "delete": {
                return true;
            }
        }
        return false;
    }

    static boolean isTransactionProcedure(Token token, Token token2, CollectNode<ExprNode> collectNode) {
        if (token == null || !token.getText().equals("Transaction")) {
            return false;
        }
        switch (token2.getText()) {
            case "start": 
            case "pause": 
            case "resume": 
            case "commit": 
            case "rollback": {
                return true;
            }
        }
        return false;
    }

    static boolean isDebugProcedure(Token token, Token token2, CollectNode<ExprNode> collectNode) {
        if (token == null || !token.getText().equals("Debug")) {
            return false;
        }
        switch (token2.getText()) {
            case "add": 
            case "rem": 
            case "emit": 
            case "halt": 
            case "highlight": {
                return true;
            }
        }
        return false;
    }

    static boolean isSynchronizationProcedure(Token token, Token token2, CollectNode<ExprNode> collectNode) {
        if (token == null || !token.getText().equals("Synchronization")) {
            return false;
        }
        switch (token2.getText()) {
            case "enter": 
            case "tryenter": 
            case "exit": {
                return true;
            }
        }
        return false;
    }

    public static boolean isGlobalProcedure(Token token, Token token2, CollectNode<ExprNode> collectNode) {
        return ParserEnvironment.isGlobalProcedure(token2.getText(), collectNode.getChildren().size());
    }

    public static boolean isGlobalProcedure(String string, int n) {
        switch (string) {
            case "valloc": {
                return n == 0;
            }
            case "vfree": 
            case "vfreenonreset": 
            case "vreset": {
                return n == 1;
            }
            case "record": {
                return n == 1;
            }
            case "emit": 
            case "emitdebug": {
                return true;
            }
            case "add": {
                return n == 1 || n == 3;
            }
            case "rem": {
                return n == 1;
            }
            case "clear": {
                return n == 0;
            }
            case "retype": {
                return n == 2;
            }
            case "addCopy": {
                return n == 1 || n == 3;
            }
            case "addClone": {
                return n == 1 || n == 3;
            }
            case "merge": {
                return n >= 2 && n <= 3;
            }
            case "redirectSource": {
                return n >= 2 && n <= 3;
            }
            case "redirectTarget": {
                return n >= 2 && n <= 3;
            }
            case "redirectSourceAndTarget": {
                return n >= 3 && n <= 5;
            }
            case "insert": {
                return n == 1;
            }
            case "insertCopy": {
                return n == 2;
            }
            case "insertInduced": 
            case "insertDefined": {
                return n == 2;
            }
            case "getEquivalentOrAdd": 
            case "getEquivalentStructurallyOrAdd": {
                return n == 2;
            }
            case "assert": 
            case "assertAlways": {
                return true;
            }
        }
        return false;
    }

    public static boolean isArrayAttributeAccessMethodName(String string) {
        switch (string) {
            case "indexOfBy": 
            case "indexOfOrderedBy": 
            case "lastIndexOfBy": 
            case "orderAscendingBy": 
            case "orderDescendingBy": 
            case "groupBy": 
            case "keepOneForEach": 
            case "extract": {
                return true;
            }
        }
        return false;
    }

    public static boolean isAutoSuppliedFilterName(String string) {
        switch (string) {
            case "keepFirst": 
            case "keepLast": 
            case "removeFirst": 
            case "removeLast": 
            case "keepFirstFraction": 
            case "keepLastFraction": 
            case "removeFirstFraction": 
            case "removeLastFraction": {
                return true;
            }
        }
        return false;
    }

    public static boolean isAutoGeneratedBaseFilterName(String string) {
        switch (string) {
            case "orderAscendingBy": 
            case "orderDescendingBy": 
            case "groupBy": 
            case "keepSameAsFirst": 
            case "keepSameAsLast": 
            case "keepOneForEach": 
            case "keepOneForEachAccumulateBy": {
                return true;
            }
        }
        return false;
    }

    public ArrayList<FilterAutoDeclNode> getFiltersAutoSupplied(IteratedDeclNode iteratedDeclNode) {
        ArrayList<FilterAutoDeclNode> arrayList = new ArrayList<FilterAutoDeclNode>();
        if (iteratedDeclNode != null) {
            arrayList.add(this.getFilterAutoSupplied("keepFirst", iteratedDeclNode));
            arrayList.add(this.getFilterAutoSupplied("keepLast", iteratedDeclNode));
            arrayList.add(this.getFilterAutoSupplied("removeFirst", iteratedDeclNode));
            arrayList.add(this.getFilterAutoSupplied("removeLast", iteratedDeclNode));
            arrayList.add(this.getFilterAutoSupplied("keepFirstFraction", iteratedDeclNode));
            arrayList.add(this.getFilterAutoSupplied("keepLastFraction", iteratedDeclNode));
            arrayList.add(this.getFilterAutoSupplied("removeFirstFraction", iteratedDeclNode));
            arrayList.add(this.getFilterAutoSupplied("removeLastFraction", iteratedDeclNode));
        }
        return arrayList;
    }

    public FilterAutoDeclNode getFilterAutoSupplied(String string, IteratedDeclNode iteratedDeclNode) {
        IdentNode identNode = new IdentNode(this.define(2, string, iteratedDeclNode.getCoords()));
        return new FilterAutoSuppliedDeclNode(identNode, iteratedDeclNode.getIdentNode());
    }

    public abstract UnitNode parseActions(File var1);

    public abstract ModelNode parseModel(File var1);

    public abstract void pushFile(Lexer var1, File var2) throws RecognitionException;

    public abstract boolean popFile(Lexer var1);

    public abstract String getFilename();

    public abstract boolean hadError();
}

