/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.parser;

import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.parser.Coords;
import de.unika.ipd.grgen.parser.Symbol;
import de.unika.ipd.grgen.parser.SymbolTable;
import de.unika.ipd.grgen.parser.SymbolTableException;
import de.unika.ipd.grgen.util.report.ErrorReporter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Scope {
    private final Scope parent;
    private final IdentNode ident;
    private final ErrorReporter reporter;
    private final Map<Symbol, Symbol.Definition> defs = new HashMap<Symbol, Symbol.Definition>();
    private final Map<String, Integer> anonIds = new HashMap<String, Integer>();
    private final List<Scope> childs = new LinkedList<Scope>();
    private final List<Symbol.Occurrence> occFixup = new LinkedList<Symbol.Occurrence>();
    private static final Scope INVALID = null;

    public static Scope getInvalid() {
        return INVALID;
    }

    public Scope(ErrorReporter errorReporter) {
        this.parent = null;
        this.reporter = errorReporter;
        this.ident = null;
    }

    private Scope(Scope scope, IdentNode identNode) {
        this.parent = scope;
        this.ident = identNode;
        this.reporter = scope != null ? scope.reporter : null;
    }

    public boolean definedHere(Symbol symbol) {
        return this.getLocalDef(symbol).isValid();
    }

    public boolean defined(Symbol symbol) {
        return this.getCurrDef(symbol).isValid();
    }

    public Symbol.Definition getLocalDef(Symbol symbol) {
        Symbol.Definition definition = Symbol.Definition.getInvalid();
        if (this.defs.containsKey(symbol)) {
            definition = this.defs.get(symbol);
        }
        return definition;
    }

    public Symbol.Definition getCurrDef(Symbol symbol) {
        Symbol.Definition definition = this.getLocalDef(symbol);
        if (!definition.isValid() && !this.isRoot()) {
            definition = this.parent.getCurrDef(symbol);
        }
        return definition;
    }

    public Symbol.Occurrence occurs(Symbol symbol, Coords coords) {
        Symbol.Occurrence occurrence = symbol.occurs(this, coords);
        this.occFixup.add(occurrence);
        return occurrence;
    }

    public Symbol.Definition define(Symbol symbol) {
        return this.define(symbol, new Coords());
    }

    public Symbol.Definition define(Symbol symbol, Coords coords) {
        Symbol.Definition definition = Symbol.Definition.getInvalid();
        if (symbol.isKeyword() && symbol.getDefinitionCount() > 0) {
            this.reporter.error(coords, "Cannot redefine keyword " + symbol + ".");
            definition = Symbol.Definition.getInvalid();
        } else if (this.definedHere(symbol)) {
            definition = this.getLocalDef(symbol);
            this.reporter.error(coords, "Symbol " + symbol + " has already been defined in this scope [at: " + definition.coords + "].");
            definition = Symbol.Definition.getInvalid();
        } else if (this.defined(symbol) && symbol.getSymbolTable().getSymbolTableId() != 4 && this.getIdentNode().getSymbol().getSymbolTable().getSymbolTableId() != 12) {
            definition = this.getCurrDef(symbol);
            this.reporter.error(coords, "Symbol " + symbol + " has already been defined in some parent scope [at: " + definition.coords + "].");
            definition = Symbol.Definition.getInvalid();
        } else {
            try {
                definition = symbol.define(this, coords);
                this.defs.put(symbol, definition);
            }
            catch (SymbolTableException symbolTableException) {
                this.reporter.error(coords, symbolTableException.getMessage());
            }
        }
        return definition;
    }

    public Symbol.Definition defineAnonymous(String string, SymbolTable symbolTable, Coords coords) {
        int n = 0;
        if (this.anonIds.containsKey(string)) {
            n = this.anonIds.get(string);
        }
        this.anonIds.put(string, n + 1);
        return this.define(Symbol.makeAnonymous(string + n, symbolTable), coords);
    }

    public Scope newScope(IdentNode identNode) {
        Scope scope = new Scope(this, identNode);
        this.childs.add(scope);
        return scope;
    }

    public Scope newOrReuseScope(IdentNode identNode) {
        for (Scope scope : this.childs) {
            if (!scope.getIdentNode().toString().equals(identNode.toString())) continue;
            return scope;
        }
        Scope scope = new Scope(this, identNode);
        this.childs.add(scope);
        return scope;
    }

    public Scope leaveScope() {
        for (Symbol.Occurrence occurrence : this.occFixup) {
            occurrence.def = this.getCurrDef(occurrence.symbol);
        }
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Scope getParent() {
        return this.parent;
    }

    public Scope getRoot() {
        Scope scope = this;
        while (!scope.isRoot()) {
            scope = scope.getParent();
        }
        return scope;
    }

    public String getName() {
        if (this.ident == null) {
            return "<ROOT>";
        }
        return this.ident.toString();
    }

    public IdentNode getIdentNode() {
        return this.ident;
    }

    public String getPath() {
        String string = "";
        if (!this.isRoot()) {
            string = string + this.parent + ".";
        }
        return string + this.getName();
    }

    public final String toStringWithOpeningCoords() {
        return this.toString() + " [opened at " + (this.ident != null ? this.ident.getCoords() : "0,0") + "]";
    }

    public String toString() {
        return this.getName();
    }
}

