/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.parser;

import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.parser.Coords;
import de.unika.ipd.grgen.parser.Scope;
import de.unika.ipd.grgen.parser.SymbolTable;
import de.unika.ipd.grgen.parser.SymbolTableException;

public class Symbol {
    private static final Symbol INVALID = new Symbol("<invalid>", SymbolTable.getInvalid());
    private int definitions = 0;
    private final SymbolTable symbolTable;
    private final String text;

    public Symbol(String string, SymbolTable symbolTable) {
        assert (string != null);
        this.text = string;
        this.symbolTable = symbolTable;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public Occurrence occurs(Scope scope, Coords coords) {
        return new Occurrence(scope, coords, this);
    }

    public Definition define(Scope scope, Coords coords) throws SymbolTableException {
        if (this.isKeyword() && this.definitions > 0) {
            throw new SymbolTableException(coords, "keyword cannot be redefined");
        }
        ++this.definitions;
        return new Definition(scope, coords, this);
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.getText();
    }

    public boolean isKeyword() {
        return false;
    }

    public int getDefinitionCount() {
        return this.definitions;
    }

    public static Symbol makeAnonymous(String string, SymbolTable symbolTable) {
        return new Symbol("$" + string, symbolTable);
    }

    public static class Definition
    extends Occurrence {
        protected IdentNode node;
        protected boolean anonymous = false;
        private static final Definition INVALID = new Definition(Scope.getInvalid(), Coords.INVALID, Symbol.access$100());

        public static Definition getInvalid() {
            return INVALID;
        }

        public Definition(Scope scope, Coords coords, Symbol symbol) {
            super(scope, coords, symbol);
            this.def = this;
        }

        public Definition declareAnonymous() {
            this.anonymous = true;
            return this;
        }

        public boolean isValid() {
            return this.symbol != INVALID;
        }

        public IdentNode getNode() {
            return this.node;
        }

        public void setNode(IdentNode identNode) {
            this.node = identNode;
        }
    }

    public static class Occurrence {
        protected final Scope scope;
        protected final Coords coords;
        protected final Symbol symbol;
        protected Definition def;

        public Occurrence(Scope scope, Coords coords, Symbol symbol) {
            this.symbol = symbol;
            this.scope = scope;
            this.coords = coords;
        }

        public String toString() {
            return "" + this.symbol + "(" + this.coords + "," + this.scope + ")";
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public Coords getCoords() {
            return this.coords;
        }

        public Scope getScope() {
            return this.scope;
        }

        public Definition getDefinition() {
            return this.def;
        }

        public void setDefinition(Definition definition) {
            this.def = definition;
        }

        public boolean isAnonymous() {
            return this.symbol.text.startsWith("$") || this.def.anonymous;
        }
    }
}

