/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.parser;

import de.unika.ipd.grgen.parser.Symbol;
import java.util.HashMap;

public class SymbolTable {
    public static final int IRRELEVANT = 0;
    private static final SymbolTable INVALID = new SymbolTable("<invalid>", 0);
    private final HashMap<String, Symbol> symbolMap = new HashMap();
    private final String name;
    private final int id;

    public static final SymbolTable getInvalid() {
        return INVALID;
    }

    public SymbolTable(String string, int n) {
        this.name = string;
        this.id = n;
    }

    public boolean equals(Object object) {
        if (object instanceof SymbolTable) {
            return this.name.equals(((SymbolTable)object).name);
        }
        return false;
    }

    public final String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.symbolMap.toString();
    }

    public Symbol enterKeyword(String string) {
        assert (!this.symbolMap.containsKey(string)) : "keywords cannot be put twice in the symbol table";
        Symbol symbol = new Symbol(string, this){

            @Override
            public boolean isKeyword() {
                return true;
            }
        };
        this.symbolMap.put(string, symbol);
        return symbol;
    }

    public Symbol get(String string) {
        if (!this.symbolMap.containsKey(string)) {
            this.symbolMap.put(string, new Symbol(string, this));
        }
        return this.symbolMap.get(string);
    }

    public boolean test(String string) {
        return this.symbolMap.containsKey(string);
    }

    int getSymbolTableId() {
        return this.id;
    }
}

