/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.parser.antlr;

import de.unika.ipd.grgen.Sys;
import de.unika.ipd.grgen.ast.UnitNode;
import de.unika.ipd.grgen.ast.model.decl.ModelNode;
import de.unika.ipd.grgen.parser.ParserEnvironment;
import de.unika.ipd.grgen.parser.antlr.GrGenLexer;
import de.unika.ipd.grgen.parser.antlr.GrGenParser;
import de.unika.ipd.grgen.parser.antlr.SubunitInclude;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.RecognitionException;

public class GRParserEnvironment
extends ParserEnvironment {
    private boolean hadError = false;
    private Stack<SubunitInclude> includes = new Stack();
    private HashSet<String> filesOnStack = new HashSet();
    private HashSet<String> modelsOnStack = new HashSet();
    private HashMap<String, ModelNode> models = new HashMap();
    private File baseDir = null;
    private String filename;

    public GRParserEnvironment(Sys sys) {
        super(sys);
    }

    @Override
    public void pushFile(Lexer lexer, File file) throws RecognitionException {
        String string;
        if (this.baseDir != null && !file.isAbsolute()) {
            file = new File(this.baseDir, file.getPath());
        }
        if (this.filesOnStack.contains(string = file.getPath())) {
            System.err.println("GrGen: [ERROR at " + this.getFilename() + ":" + lexer.getLine() + "," + lexer.getCharPositionInLine() + "] found circular include with file \"" + string + "\"");
            System.exit(1);
        }
        this.filesOnStack.add(string);
        try {
            CharStream charStream = lexer.getCharStream();
            int n = charStream.mark();
            this.includes.push(new SubunitInclude(charStream, n));
            ANTLRFileStream aNTLRFileStream = new ANTLRFileStream(file.getPath());
            lexer.setCharStream(aNTLRFileStream);
            lexer.reset();
            this.filename = file.getPath();
        }
        catch (IOException iOException) {
            System.err.println("GrGen: [ERROR at " + this.getFilename() + ":" + lexer.getLine() + "," + lexer.getCharPositionInLine() + "] included file could not be found: \"" + string + "\"");
            System.exit(1);
        }
    }

    @Override
    public boolean popFile(Lexer lexer) {
        if (this.includes.size() > 1 && this.includes.peek().charStream != null) {
            this.filesOnStack.remove(lexer.getSourceName());
            SubunitInclude subunitInclude = this.includes.pop();
            lexer.setCharStream(subunitInclude.charStream);
            lexer.getCharStream().rewind(subunitInclude.marking);
            this.filename = lexer.getCharStream().getSourceName();
            return true;
        }
        return false;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public UnitNode parseActions(File file) {
        UnitNode unitNode = null;
        this.baseDir = file.getParentFile();
        try {
            ANTLRFileStream aNTLRFileStream = new ANTLRFileStream(file.getPath());
            GrGenLexer grGenLexer = new GrGenLexer(aNTLRFileStream);
            grGenLexer.setEnv(this);
            CommonTokenStream commonTokenStream = new CommonTokenStream(grGenLexer);
            GrGenParser grGenParser = new GrGenParser(commonTokenStream);
            this.includes.push(new SubunitInclude(grGenParser));
            this.filename = file.getPath();
            try {
                grGenParser.setEnv(this);
                unitNode = grGenParser.textActions();
                this.hadError = this.hadError || grGenParser.hadError();
            }
            catch (RecognitionException recognitionException) {
                recognitionException.printStackTrace(System.err);
                System.err.println("parser exception: " + recognitionException.getMessage());
                System.exit(1);
            }
            this.includes.pop();
        }
        catch (IOException iOException) {
            System.err.println("input file not found: " + iOException.getMessage());
            System.exit(1);
        }
        return unitNode;
    }

    @Override
    public ModelNode parseModel(File file) {
        ModelNode modelNode = null;
        String string = file.getAbsolutePath();
        if (this.modelsOnStack.contains(string)) {
            System.err.println("GrGen: [ERROR at " + this.getFilename() + "] found circular model usage with file \"" + string + "\"");
            System.exit(1);
        }
        if ((modelNode = this.models.get(string)) != null) {
            return modelNode;
        }
        this.modelsOnStack.add(string);
        try {
            ANTLRFileStream aNTLRFileStream = new ANTLRFileStream(file.getPath());
            GrGenLexer grGenLexer = new GrGenLexer(aNTLRFileStream);
            grGenLexer.setEnv(this);
            CommonTokenStream commonTokenStream = new CommonTokenStream(grGenLexer);
            GrGenParser grGenParser = new GrGenParser(commonTokenStream);
            this.includes.push(new SubunitInclude(grGenParser));
            String string2 = this.filename;
            this.filename = file.getPath();
            try {
                grGenParser.setEnv(this);
                modelNode = grGenParser.textTypes();
                this.hadError = this.hadError || grGenParser.hadError();
            }
            catch (RecognitionException recognitionException) {
                recognitionException.printStackTrace(System.err);
                System.err.println("parser exception: " + recognitionException.getMessage());
                System.exit(1);
            }
            this.filename = string2;
            this.includes.pop();
        }
        catch (IOException iOException) {
            System.err.println("cannot load graph model: " + iOException.getMessage());
            System.exit(1);
        }
        this.modelsOnStack.remove(string);
        this.models.put(string, modelNode);
        return modelNode;
    }

    @Override
    public boolean hadError() {
        return this.hadError;
    }
}

