/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.util;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.Identifiable;
import de.unika.ipd.grgen.ir.expr.Cast;
import de.unika.ipd.grgen.ir.expr.Constant;
import de.unika.ipd.grgen.ir.expr.EnumExpression;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Operator;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.expr.Typeof;
import de.unika.ipd.grgen.ir.expr.VariableExpression;
import de.unika.ipd.grgen.ir.expr.graph.Visited;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.type.Type;

public class Formatter {
    private static String getOperatorSymbol(Operator.OperatorCode operatorCode) {
        switch (operatorCode) {
            case LOG_OR: {
                return "||";
            }
            case LOG_AND: {
                return "&&";
            }
            case BIT_OR: {
                return "|";
            }
            case BIT_XOR: {
                return "^";
            }
            case BIT_AND: {
                return "&";
            }
            case EQ: {
                return "==";
            }
            case NE: {
                return "!=";
            }
            case LT: {
                return "<";
            }
            case LE: {
                return "<=";
            }
            case GT: {
                return ">";
            }
            case GE: {
                return ">=";
            }
            case SHL: {
                return "<<";
            }
            case SHR: {
                return ">>";
            }
            case BIT_SHR: {
                return ">>";
            }
            case ADD: {
                return "+";
            }
            case SUB: {
                return "-";
            }
            case MUL: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case MOD: {
                return "%";
            }
            case LOG_NOT: {
                return "!";
            }
            case BIT_NOT: {
                return "~";
            }
            case NEG: {
                return "-";
            }
            case IN: {
                return "in";
            }
            case EXCEPT: {
                return "\\";
            }
            case SE: {
                return "~~";
            }
        }
        throw new RuntimeException("internal failure");
    }

    public static String formatConditionEval(Expression expression) {
        StringBuffer stringBuffer = new StringBuffer();
        Formatter.formatConditionEvalAux(stringBuffer, expression);
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void formatConditionEvalAux(StringBuffer stringBuffer, Expression expression) {
        if (expression instanceof Operator) {
            Operator operator = (Operator)expression;
            switch (operator.arity()) {
                case 1: {
                    stringBuffer.append("(" + Formatter.getOperatorSymbol(operator.getOpCode()) + " ");
                    Formatter.formatConditionEvalAux(stringBuffer, operator.getOperand(0));
                    stringBuffer.append(")");
                    return;
                }
                case 2: {
                    Formatter.formatConditionEvalAux(stringBuffer, operator.getOperand(0));
                    stringBuffer.append(" " + Formatter.getOperatorSymbol(operator.getOpCode()) + " ");
                    Formatter.formatConditionEvalAux(stringBuffer, operator.getOperand(1));
                    return;
                }
                case 3: {
                    if (operator.getOpCode() != Operator.OperatorCode.COND) throw new UnsupportedOperationException("Unsupported Operation arrity (" + operator.arity() + ")");
                    stringBuffer.append("(");
                    Formatter.formatConditionEvalAux(stringBuffer, operator.getOperand(0));
                    stringBuffer.append(") ? (");
                    Formatter.formatConditionEvalAux(stringBuffer, operator.getOperand(1));
                    stringBuffer.append(") : (");
                    Formatter.formatConditionEvalAux(stringBuffer, operator.getOperand(2));
                    stringBuffer.append(")");
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported Operation arrity (" + operator.arity() + ")");
                }
            }
        } else if (expression instanceof Qualification) {
            Qualification qualification = (Qualification)expression;
            Entity entity = qualification.getOwner();
            if (entity instanceof Node) {
                stringBuffer.append(Formatter.formatIdentifiable(entity) + "." + Formatter.formatIdentifiable(qualification.getMember()));
                return;
            } else {
                if (!(entity instanceof Edge)) throw new UnsupportedOperationException("Unsupported Entity (" + entity + ")");
                stringBuffer.append(Formatter.formatIdentifiable(entity) + "." + Formatter.formatIdentifiable(qualification.getMember()));
            }
            return;
        } else if (expression instanceof Constant) {
            Constant constant = (Constant)expression;
            Type type = constant.getType();
            switch (type.classify()) {
                case IS_STRING: {
                    stringBuffer.append("'" + constant.getValue() + "'");
                    return;
                }
                case IS_BOOLEAN: {
                    Boolean bl = (Boolean)constant.getValue();
                    if (bl.booleanValue()) {
                        stringBuffer.append("true");
                        return;
                    }
                    stringBuffer.append("false");
                    return;
                }
                case IS_INTEGER: {
                    stringBuffer.append(constant.getValue().toString());
                    return;
                }
            }
            return;
        } else if (expression instanceof EnumExpression) {
            EnumExpression enumExpression = (EnumExpression)expression;
            stringBuffer.append("ENUM_" + enumExpression.getType().getIdent().toString() + ".@" + enumExpression.getEnumItem().toString());
            return;
        } else if (expression instanceof Typeof) {
            Typeof typeof = (Typeof)expression;
            stringBuffer.append(Formatter.formatIdentifiable(typeof.getEntity()) + ".type");
            return;
        } else if (expression instanceof Cast) {
            Cast cast = (Cast)expression;
            Type type = cast.getType();
            if (type.classify() == Type.TypeClass.IS_STRING) {
                Formatter.formatConditionEvalAux(stringBuffer, cast.getExpression());
                stringBuffer.append(".ToString()");
                return;
            } else {
                String string = "";
                switch (type.classify()) {
                    case IS_INTEGER: {
                        string = "int";
                        break;
                    }
                    case IS_FLOAT: {
                        string = "float";
                        break;
                    }
                    case IS_DOUBLE: {
                        string = "double";
                        break;
                    }
                    case IS_BOOLEAN: {
                        string = "bool";
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("This is either a forbidden cast, which should have been rejected on building the IR, or an allowed cast, which should have been processed by the above code.");
                    }
                }
                stringBuffer.append("((" + string + ") ");
                Formatter.formatConditionEvalAux(stringBuffer, cast.getExpression());
                stringBuffer.append(")");
            }
            return;
        } else if (expression instanceof VariableExpression) {
            Variable variable = ((VariableExpression)expression).getVariable();
            stringBuffer.append(variable.getIdent());
            return;
        } else if (expression instanceof Visited) {
            Visited visited = (Visited)expression;
            Formatter.formatConditionEvalAux(stringBuffer, visited.getEntity());
            stringBuffer.append(".visited[");
            Formatter.formatConditionEvalAux(stringBuffer, visited.getVisitorID());
            stringBuffer.append("]");
            return;
        } else {
            stringBuffer.append("Unsupported expression type (" + expression + ")");
        }
    }

    private static String formatIdentifiable(Identifiable identifiable) {
        String string = identifiable.getIdent().toString();
        return string.replace('$', '_');
    }
}

