/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.util;

public class SourceBuilder {
    private StringBuilder stringBuilder = new StringBuilder(16);
    private int indentationLevel = 0;

    public SourceBuilder indent() {
        ++this.indentationLevel;
        return this;
    }

    public SourceBuilder unindent() {
        --this.indentationLevel;
        return this;
    }

    public SourceBuilder append(String string) {
        this.stringBuilder.append(string);
        return this;
    }

    public SourceBuilder appendFront(String string) {
        for (int i = 0; i < this.indentationLevel; ++i) {
            this.stringBuilder.append("\t");
        }
        this.stringBuilder.append(string);
        return this;
    }

    public SourceBuilder appendFrontIndented(String string) {
        for (int i = 0; i < this.indentationLevel + 1; ++i) {
            this.stringBuilder.append("\t");
        }
        this.stringBuilder.append(string);
        return this;
    }

    public SourceBuilder append(boolean bl) {
        this.stringBuilder.append(bl);
        return this;
    }

    public String getIndent() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.indentationLevel; ++i) {
            stringBuilder.append("\t");
        }
        return stringBuilder.toString();
    }

    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public int length() {
        return this.stringBuilder.length();
    }

    public void delete(int n, int n2) {
        this.stringBuilder.delete(n, n2);
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public void setIndentationLevel(int n) {
        this.indentationLevel = n;
    }
}

