/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.util.report;

import de.unika.ipd.grgen.util.report.EmptyLocation;
import de.unika.ipd.grgen.util.report.Location;
import de.unika.ipd.grgen.util.report.Reporter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DebugReporter
extends Reporter {
    private Pattern pattern = Pattern.compile(".*");
    private Matcher matcher = this.pattern.matcher("");
    private boolean inclusive = true;
    private boolean includeClassName = false;
    private String prefix = "";
    private boolean enableStackTrace = true;

    public DebugReporter(int n) {
        this.setMask(n);
    }

    public void setFilter(String string) {
        this.pattern = Pattern.compile(string);
        this.matcher = this.pattern.matcher("");
    }

    public void setFilterInclusive(boolean bl) {
        this.inclusive = bl;
    }

    public void setStackTrace(boolean bl) {
        this.enableStackTrace = bl;
    }

    protected void makePrefix() {
        if (this.enableStackTrace) {
            StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
            StackTraceElement stackTraceElement = stackTraceElementArray[2];
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append(' ');
            }
            String string = stackTraceElement.getClassName();
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            if (this.includeClassName) {
                stringBuffer.append(string);
                stringBuffer.append('.');
            }
            stringBuffer.append(stackTraceElement.getMethodName());
            this.prefix = stringBuffer.toString();
        } else {
            this.prefix = "";
        }
    }

    @Override
    public boolean willReport(int n) {
        int n2;
        int n3 = n2 = this.inclusive ? 1 : 0;
        if (this.prefix.length() != 0) {
            boolean bl = this.matcher.reset(this.prefix).matches();
            n2 += bl ? 1 : 0;
        }
        return (n2 == 0 || n2 == 2) && super.willReport(n);
    }

    @Override
    public void report(int n, Location location, String string) {
        this.makePrefix();
        super.report(n, location, this.prefix + ": " + string);
    }

    @Override
    public void report(int n, String string) {
        this.makePrefix();
        super.report(n, EmptyLocation.getEmptyLocation(), this.prefix + ": " + string);
    }
}

