/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.util.report;

import de.unika.ipd.grgen.util.report.EmptyLocation;
import de.unika.ipd.grgen.util.report.Handler;
import de.unika.ipd.grgen.util.report.Location;
import java.util.HashSet;
import java.util.Set;

public abstract class Reporter {
    private int mask = 0;
    protected final Set<Handler> handlers = new HashSet<Handler>();

    public void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }

    public void setMask(int n) {
        this.mask = n;
    }

    public void enableChannel(int n) {
        this.mask |= n;
    }

    public void disableChannel(int n) {
        this.mask &= ~n;
    }

    public void disable() {
        this.mask = 0;
    }

    public boolean isDisabled() {
        return this.mask == 0;
    }

    public boolean willReport(int n) {
        return (n & this.mask) != 0;
    }

    public void report(int n, Location location, String string) {
        if (this.willReport(n)) {
            for (Handler handler : this.handlers) {
                handler.report(n, location, string);
            }
        }
    }

    public void report(int n, String string) {
        this.report(n, EmptyLocation.getEmptyLocation(), string);
    }
}

