/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.util.report;

import de.unika.ipd.grgen.util.report.Handler;
import de.unika.ipd.grgen.util.report.Location;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class TreeHandler
extends DefaultTreeModel
implements Handler {
    private static final long serialVersionUID = 9154761780509127571L;
    private EnterNode current;

    public TreeHandler() {
        super(null);
        EnterNode enterNode = new EnterNode(null, "ROOT");
        this.setRoot(enterNode);
        this.current = enterNode;
    }

    @Override
    public void report(int n, Location location, String string) {
        this.current.add(new MsgNode(this.current, n, location, string));
    }

    public void entering(String string) {
        EnterNode enterNode = new EnterNode(this.current, string);
        this.current.add(enterNode);
        this.current = enterNode;
    }

    public void leaving() {
        EnterNode enterNode = (EnterNode)this.current.getParent();
        if (enterNode != null) {
            this.current = enterNode;
        }
    }

    private class MsgNode
    implements TreeNode {
        private String msg;

        public MsgNode(TreeNode treeNode, int n, Location location, String string) {
            this.msg = string;
        }

        @Override
        public TreeNode getChildAt(int n) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return 0;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Enumeration<? extends TreeNode> children() {
            return null;
        }

        public String toString() {
            return this.msg;
        }
    }

    class EnterNode
    implements TreeNode {
        private Vector<TreeNode> children = new Vector();
        private String text;
        private TreeNode parent;

        public EnterNode(TreeNode treeNode, String string) {
            this.text = string;
            this.parent = treeNode;
        }

        public void add(TreeNode treeNode) {
            this.children.add(treeNode);
        }

        @Override
        public TreeNode getChildAt(int n) {
            return this.children.get(n);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return this.children.indexOf(treeNode);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        public Enumeration<TreeNode> children() {
            return this.children.elements();
        }

        public String toString() {
            return this.text;
        }

        public int[] getAddedChildIndices() {
            int[] nArray = new int[this.children.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            return nArray;
        }
    }
}

