/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.VCG;

import java.awt.Color;
import java.util.HashMap;

public class VCGColor {
    private static final HashMap<String, Color> mapColorName2Color = new HashMap();
    private static final HashMap<Integer, Color> mapColorNum2Color = new HashMap();
    private static final Color[] colors = new Color[]{new Color(255, 255, 255), new Color(100, 100, 255), new Color(255, 0, 0), new Color(0, 255, 0), new Color(255, 255, 0), new Color(255, 0, 255), new Color(0, 255, 255), new Color(128, 128, 128), new Color(0, 0, 200), new Color(128, 0, 0), new Color(0, 128, 0), new Color(128, 128, 0), new Color(128, 0, 128), new Color(0, 128, 128), new Color(184, 134, 11), new Color(196, 196, 196), new Color(160, 160, 255), new Color(255, 128, 128), new Color(128, 255, 128), new Color(255, 255, 128), new Color(255, 128, 255), new Color(128, 255, 255), new Color(128, 0, 255), new Color(64, 224, 208), new Color(127, 255, 212), new Color(205, 198, 115), new Color(128, 0, 128), new Color(154, 205, 50), new Color(255, 105, 180), new Color(255, 165, 0), new Color(218, 112, 214), new Color(0, 0, 0)};
    private static final String[] colorNames = new String[]{"WHITE", "BLUE", "RED", "GREEN", "YELLOW", "MAGENTA", "CYAN", "DARKGREY", "DARKBLUE", "DARKRED", "DARKGREEN", "DARKYELLOW", "DARKMAGENTA", "DARKCYAN", "GOLD", "LIGHTGREY", "LIGHTBLUE", "LIGHTRED", "LIGHTGREEN", "LIGHTYELLOW", "LIGHTMAGENTA", "LIGHTCYAN", "LILAC", "TURQUOISE", "AQUAMARINE", "KHAKI", "PURPLE", "YELLOWGREEN", "PINK", "ORANGE", "ORCHID", "BLACK"};

    public static Color getColorByName(String colorName) {
        return mapColorName2Color.get(colorName);
    }

    public static Color getColorByNum(int colorNum) {
        return mapColorNum2Color.get(colorNum);
    }

    public static Color getColor(String colorId) {
        Color c = mapColorName2Color.get(colorId);
        if (c == null) {
            try {
                c = mapColorNum2Color.get(Integer.valueOf(colorId));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return c;
    }

    public static Color getColorIgnoreCase(String colorId) {
        return VCGColor.getColor(colorId.toUpperCase());
    }

    public static void addColor(int colorNum, Color c) {
        assert (!mapColorNum2Color.containsKey(colorNames));
        mapColorNum2Color.put(colorNum, c);
    }

    static {
        for (int i = 0; i < colors.length; ++i) {
            mapColorName2Color.put(colorNames[i], colors[i]);
            mapColorNum2Color.put(i, colors[i]);
        }
    }
}

