/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp;

import de.unika.ipd.ycomp.view.ViewConstants;
import de.unika.ipd.ycomp.view.YCompView;
import java.io.File;
import javax.swing.SwingUtilities;

class YComp
implements ViewConstants {
    YComp() {
    }

    static void usage() {
        System.out.println("Usage: YComp [options] [filename]\n-p <port>      Sets YComp into server mode at TCP port <port>.\n--dolayout     Layouts the graph after loading a graph.\n--autoreload   Enable \"Reload on Change\".\n--nomaximize   Do not maximize the YComp window at startup.\n--export <out> Exports the graph into the file <out>.\n               The format is determined by the extension of <out>.\n--help         Shows this help text and exits");
    }

    public static void main(String[] args) {
        YCompView yComp = null;
        boolean serverEdition = false;
        boolean doLayout = false;
        boolean autoReload = false;
        boolean maximize = true;
        int serverPort = 0;
        String filename = null;
        String exportTo = null;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-p")) {
                if (++i2 >= args.length) {
                    System.err.println("Missing port number!");
                    YComp.usage();
                    return;
                }
                serverEdition = true;
                serverPort = Integer.parseInt(args[i2]);
                continue;
            }
            if (args[i2].equals("--dolayout")) {
                doLayout = true;
                continue;
            }
            if (args[i2].equals("--autoreload")) {
                autoReload = true;
                continue;
            }
            if (args[i2].equals("--nomaximize")) {
                maximize = false;
                continue;
            }
            if (args[i2].equals("--export")) {
                if (++i2 >= args.length) {
                    System.err.println("Missing <out> parameter!");
                    YComp.usage();
                    return;
                }
                exportTo = args[i2];
                continue;
            }
            if (args[i2].equals("--help")) {
                YComp.usage();
                return;
            }
            if (args[i2].equals("-")) {
                filename = "-";
                continue;
            }
            if (args[i2].charAt(0) == '-') {
                System.err.println("Unknown option: " + args[i2]);
                YComp.usage();
                return;
            }
            if (filename != null) {
                System.err.println("Filename already specified!");
                YComp.usage();
                return;
            }
            filename = args[i2];
            if (new File(filename).exists()) continue;
            System.err.println("File does not exist: " + filename);
            return;
        }
        if (serverEdition) {
            if (filename != null) {
                System.err.println("Filename not supported in server mode!");
                return;
            }
            yComp = new YCompView(serverPort);
        } else {
            if (exportTo != null) {
                YCompView.exportTo(filename, exportTo);
                return;
            }
            yComp = new YCompView();
        }
        yComp.setLayoutAfterOpen(doLayout);
        yComp.setReloadOnChange(autoReload);
        yComp.startInFrame("yComp Version 1.3.14", maximize);
        if (filename != null) {
            SwingUtilities.invokeLater(new OpenRunnable(yComp, filename));
        }
    }

    private static class OpenRunnable
    implements Runnable {
        YCompView ycomp;
        String filename;

        public OpenRunnable(YCompView ycomp, String filename) {
            this.ycomp = ycomp;
            this.filename = filename;
        }

        public void run() {
            this.ycomp.open(null, this.filename, false);
        }
    }
}

