/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.io;

import C.A.E;
import C.A.H;
import C.A.Y;
import C.A.Z;
import C.G.Q;
import C.G.c;
import C.G.p;
import C.H.F;
import C.I.$B;
import C.I.I;
import C.I.mA;
import C.J.K;
import C.J.L;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;

public class TikzIOHandler
extends F {
    private HashMap<Y, Integer> mapNodeToInt;
    private HashMap<Color, String> mapColorNames;
    private int node_id = 0;
    private int color_id = 0;
    private static final double format_w = 21.0;
    private static final double format_h = 29.7;
    private static final double border_l = 3.0;
    private static final double border_r = 3.0;
    private static final double border_t = 3.5;
    private static final double border_b = 5.0;
    private double scale_f;
    private double scale_text;
    private double max_height;
    private double max_width;
    private static final String arrow_style = "-latex";

    private String getId(Y n) {
        Integer p2 = this.mapNodeToInt.get(n);
        if (p2 != null) {
            return "n" + p2;
        }
        this.mapNodeToInt.put(n, ++this.node_id);
        return "n" + this.node_id;
    }

    private double scale(double x) {
        return x * this.scale_f;
    }

    private double scaleX(double x) {
        return x * this.scale_f;
    }

    private double scaleY(double y2) {
        return (this.max_height - y2) * this.scale_f;
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean canWriteSubset() {
        return true;
    }

    public void write(I g2, OutputStream os) throws IOException {
        H e2;
        Y n;
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        E nc = g2.k();
        Z ec = g2.a();
        Rectangle bb = g2.\u00a5();
        this.max_height = bb.getHeight();
        this.max_width = bb.getWidth();
        double scale_w = 15.0 / this.max_width;
        double scale_h = 21.2 / this.max_height;
        this.scale_f = scale_w > scale_h ? scale_w : scale_h;
        out.println("% Scale factor " + this.scale_f);
        this.scale_text = this.scale_f * 1.0 / 0.0275;
        this.mapNodeToInt = new HashMap();
        this.mapColorNames = new HashMap();
        nc.toFirst();
        nc.current();
        while (nc.ok()) {
            n = (Y)nc.current();
            mA nr = g2.f(n);
            if (!nr.isTransparent()) {
                this.defineColor(nr.getFillColor(), out);
            }
            nc.next();
        }
        ec.toFirst();
        ec.current();
        while (ec.ok()) {
            e2 = (H)ec.current();
            $B er = g2.X(e2);
            if (er.f()) {
                this.defineColor(er.i(), out);
            }
            ec.next();
        }
        out.println("% Bounding Box: " + this.max_width + ", " + this.max_height);
        out.println("\\begin{tikzpicture}");
        nc.toFirst();
        nc.current();
        while (nc.ok()) {
            n = (Y)nc.current();
            this.drawNode(g2, n, out);
            nc.next();
        }
        ec.toFirst();
        ec.current();
        while (ec.ok()) {
            e2 = (H)ec.current();
            this.drawEdge(g2, e2, out);
            ec.next();
        }
        out.println("\\end{tikzpicture}");
        out.flush();
        out.close();
    }

    public void read(I arg0, InputStream is) throws IOException {
        throw new IOException("Reading is not supported");
    }

    public String getFileFormatString() {
        return "Tikz Graphics";
    }

    public String getFileNameExtension() {
        return "tex";
    }

    private static String escape(String label) {
        StringBuffer res = new StringBuffer();
        assert (label != null);
        char[] dst = new char[label.length()];
        label.getChars(0, label.length(), dst, 0);
        block4: for (int i2 = 0; i2 < dst.length; ++i2) {
            switch (dst[i2]) {
                case '\n': {
                    res.append(" \\\\\n");
                    continue block4;
                }
                case '$': 
                case '%': 
                case '&': 
                case '\\': 
                case '_': {
                    res.append('\\');
                }
                default: {
                    res.append(dst[i2]);
                }
            }
        }
        return new String(res);
    }

    private String getColorString(Color c2, boolean visible, String prefix) {
        if (!visible) {
            return "";
        }
        String name = this.mapColorNames.get(c2);
        if (name != null) {
            return prefix + "=" + name + ", ";
        }
        return "";
    }

    private void defineColor(Color c2, PrintWriter out) {
        String name = this.mapColorNames.get(c2);
        if (name == null) {
            name = "color" + this.color_id++;
            this.mapColorNames.put(c2, name);
            out.println("\\definecolor{" + name + "}{RGB}{" + c2.getRed() + "," + c2.getGreen() + "," + c2.getBlue() + "}");
        }
    }

    private void drawNode(I g2, Y n, PrintWriter out) {
        p l2 = g2.W(n);
        mA nr = g2.f(n);
        double x = l2.getX();
        double y2 = l2.getY();
        double w = l2.getWidth();
        double h = l2.getHeight();
        double cx = x + w / 2.0;
        double cy = y2 + h / 2.0;
        String id = this.getId(n);
        String label = TikzIOHandler.escape(g2.e(n));
        boolean s2 = true;
        c[] nll = g2.V(n);
        x = this.scaleX(x);
        y2 = this.scaleY(y2);
        cx = this.scaleX(cx);
        cy = this.scaleY(cy);
        w = this.scale(w);
        h = this.scale(h);
        String color = this.getColorString(nr.getFillColor(), !nr.isTransparent(), "fill");
        if (s2) {
            out.println("\t\\node[" + color + "draw, minimum width=" + w + "cm, minimum height=" + h + "cm] (" + id + ") at (" + cx + "cm ," + cy + "cm) {};");
            if (label.length() > 0) {
                K r = nll[0].getBox();
                double lx = this.scaleX(r.f() + r.c() / 2.0);
                double ly = this.scaleY(r.g() + r.d() / 2.0);
                out.println("\t% " + nll.length + " node layouts");
                if (g2.e(n).indexOf(10) >= 0) {
                    label = "\n\\begin{minipage}{" + this.scale(r.c()) + "cm}\\centering\n" + label + "\n\\end{minipage}\n";
                }
                out.println("\t\\node[scale=" + this.scale_text + ", transform shape] at (" + lx + "cm ," + ly + "cm) {" + label + "};");
            }
        } else {
            out.println("\t\\draw (" + x + "cm, " + y2 + "cm) rectangle (" + (x + w) + "cm, " + (y2 + h) + "cm);");
        }
    }

    private L dock_coord(I g2, Y n, L p2) {
        p l2 = g2.W(n);
        double x = l2.getX() + l2.getWidth() / 2.0;
        double y2 = l2.getY() + l2.getHeight() / 2.0;
        return new L(p2.A() + x, p2.B() + y2);
    }

    private void drawEdge(I g2, H e2, PrintWriter out) {
        L point;
        Q l2 = g2.Q(e2);
        $B er = g2.X(e2);
        String label = TikzIOHandler.escape(g2.Y(e2));
        C.G.F[] ell = g2.M(e2);
        String color = this.getColorString(er.i(), er.f(), "color");
        L last = this.dock_coord(g2, e2.X(), l2.J());
        out.print("\t\\draw[" + color + arrow_style + "] (" + this.scaleX(last.A()) + "cm ," + this.scaleY(last.B()) + "cm) ");
        for (int i2 = 0; i2 < l2.I(); ++i2) {
            point = l2.A(i2);
            out.print("-- (" + this.scaleX(point.A()) + "cm ," + this.scaleY(point.B()) + "cm) ");
            last = point;
        }
        point = this.dock_coord(g2, e2.V(), l2.K());
        out.println("-- (" + this.scaleX(point.A()) + "cm ," + this.scaleY(point.B()) + "cm);");
        K r = ell[0].getBox();
        double lx = this.scaleX(r.f() + r.c() / 2.0);
        double ly = this.scaleY(r.g() + r.d() / 2.0);
        label = "\n\t\t\\scalebox{" + this.scale_text + "}{" + label + "}\n\t";
        out.println("\t\\node[] at (" + lx + "cm ," + ly + "cm) {" + label + "};");
    }
}

