/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.io;

import C.B.I;
import C.E.JA;
import C.E.lA;
import C.H.F;
import de.unika.ipd.ycomp.VCG.VCGLexer;
import de.unika.ipd.ycomp.VCG.VCGParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;

public class VCGIOHandler
extends F {
    private HashMap<String, Object> settings;

    public String getLayoutAlgorithm() {
        return this.settings.get("layoutalgorithm").toString();
    }

    public void setupLayoutAlgo(I layouter) {
        String[] boolSettings;
        Object orientation = this.settings.get("orientation");
        if (orientation != null) {
            this.setOrientation(layouter, orientation);
        }
        for (String bs : boolSettings = new String[]{"CREATE_REFERENCE_NODES", "REFERENCE_NODES_HAVE_LABELS", "USE_STRUCTURAL_INFORMATION", "USE_ATTRIBUTE_INFORMATION", "CREATE_LOOP_TREE", "CREATE_SCC_GROUPS", "COLOR_BACKEDGES_GREEN", "BACKLOOP_ROUTING", "ACT_ON_SELECTION_ONLY", "LAYOUT_AGAINST_ORIENTATION"}) {
            String lc = bs.toLowerCase();
            Object val = this.settings.get(lc);
            if (val == null) continue;
            if (val instanceof Boolean) {
                layouter.getOptionHandler().G(bs, (boolean)((Boolean)val));
                continue;
            }
            System.out.println("Warning: Invalid value '" + val + "'in graph option: " + bs);
        }
    }

    private void setOrientation(I layouter, Object orientation) {
        lA optHandler = layouter.getOptionHandler();
        for (int i2 = 0; i2 < optHandler.\u00f1(); ++i2) {
            JA optSec = optHandler.G(i2);
            for (int j = 0; j < optSec.size(); ++j) {
                if (!optSec.E(j).j().equals("ORIENTATION")) continue;
                String orient = orientation.toString().toUpperCase();
                optSec.E(j).C(orient);
                return;
            }
        }
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean canWriteSubset() {
        return false;
    }

    public void read(C.I.I graph, InputStream in) throws IOException {
        VCGLexer lexer = new VCGLexer(new ANTLRInputStream(in));
        VCGParser parser = new VCGParser(new CommonTokenStream(lexer));
        try {
            parser.init(graph);
            parser.graph_start(graph);
        }
        catch (RecognitionException e2) {
            System.out.println("Syntax Error: " + e2);
            e2.printStackTrace();
        }
        this.settings = parser.getSettings();
    }

    public void write(C.I.I g2, OutputStream os) throws IOException {
        throw new IOException("cannot write");
    }

    public String getFileFormatString() {
        return "VCG Files";
    }

    public String getFileNameExtension() {
        return "vcg";
    }
}

