/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.module;

import C.A.E;
import C.A.H;
import C.A.K;
import C.A.X;
import C.A.Y;
import C.A.Z;
import C.B.I;
import C.D.D;
import C.E.lA;
import C.G.G;
import C.G.G.O;
import C.G.G.V;
import C.G.Q;
import C.G.g;
import C.I.A.A;
import C.I.mA;
import C.I.o;
import C.J.L;
import de.unika.ipd.ycomp.algo.Algo;
import de.unika.ipd.ycomp.algo.LoopAnalysis;
import de.unika.ipd.ycomp.attributes.AttributeCarrier;
import de.unika.ipd.ycomp.attributes.AttributeManager;
import de.unika.ipd.ycomp.layout.CompilerGraphLayouter;
import de.unika.ipd.ycomp.module.interval.IntervalAnalysis;
import de.unika.ipd.ycomp.reference.Couple;
import de.unika.ipd.ycomp.reference.ReferenceManager;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

public class CompilerGraphLayoutModule
extends I {
    public static final String ACT_ON_SELECTION_ONLY = "ACT_ON_SELECTION_ONLY";
    public static final String BACKLOOP_ROUTING = "BACKLOOP_ROUTING";
    public static final String EDGE_ROUTING = "EDGE_ROUTING";
    public static final String NODE_PLACEMENT = "NODE_PLACEMENT";
    public static final String ORIENTATION = "ORIENTATION";
    public static final String MAXIMAL_DURATION = "MAXIMAL_DURATION";
    public static final String MINIMAL_EDGE_DISTANCE = "MINIMAL_EDGE_DISTANCE";
    public static final String MINIMAL_FIRST_SEGMENT_LENGTH = "MINIMAL_FIRST_SEGMENT_LENGTH";
    public static final String MINIMAL_NODE_DISTANCE = "MINIMAL_NODE_DISTANCE";
    public static final String MINIMAL_LAYER_DISTANCE = "MINIMAL_LAYER_DISTANCE";
    public static final String LAYOUT = "LAYOUT";
    public static final String HIERARCHIC = "HIERARCHIC";
    public static final String FREE = "FREE";
    public static final String SIDE_SLIDER = "SIDE_SLIDER";
    public static final String CENTER_SLIDER = "CENTER_SLIDER";
    public static final String AS_IS = "AS_IS";
    public static final String BEST = "BEST";
    public static final String GENERIC = "GENERIC";
    public static final String NONE = "NONE";
    public static final String ORTHOGONAL = "ORTHOGONAL";
    public static final String POLYLINE = "POLYLINE";
    public static final String TREE = "TREE";
    public static final String LINEAR_SEGMENTS = "LINEAR_SEGMENTS";
    public static final String PENDULUM = "PENDULUM";
    public static final String SIMPLEX = "SIMPLEX";
    public static final String MEDIAN_SIMPLEX = "MEDIAN_SIMPLEX";
    public static final String RIGHT_TO_LEFT = "RIGHT_TO_LEFT";
    public static final String BOTTOM_TO_TOP = "BOTTOM_TO_TOP";
    public static final String LEFT_TO_RIGHT = "LEFT_TO_RIGHT";
    public static final String TOP_TO_BOTTOM = "TOP_TO_BOTTOM";
    public static final String CONTROL_FLOW = "Control Flow";
    private static final String[] orientEnum = new String[]{"TOP_TO_BOTTOM", "LEFT_TO_RIGHT", "BOTTOM_TO_TOP", "RIGHT_TO_LEFT"};
    public static final String[] layoutStyles = new String[]{"PENDULUM", "LINEAR_SEGMENTS", "POLYLINE", "TREE", "SIMPLEX", "MEDIAN_SIMPLEX"};
    public static final String[] routingStyles = new String[]{"POLYLINE", "ORTHOGONAL"};
    private CompilerGraphLayouter layouter;
    private ReferenceManager reference;
    private HashSet<Y> loopTreeSet = new HashSet();
    private A hm;
    private boolean referenceNodesLabels = false;
    private LoopAnalysis loopAnalysis;
    private boolean againstOrientation;
    private C.I.I graphOfLoopAnalysis = null;
    private LinkedList<Y> loopGroupNodes = null;
    private HashSet<H> backedges = null;
    private HashMap<Y, Rectangle2D.Double> groupNodePositions = null;

    public CompilerGraphLayoutModule(ReferenceManager reference) {
        super("COMPILERGRAPH", "yFiles Layout Team", "Sugiyama based layout");
        this.reference = reference;
    }

    public lA createOptionHandler() {
        this.createLayouter();
        lA op = new lA(this.getModuleName());
        op.V("REFERENCE");
        op.B("CREATE_REFERENCE_NODES", true);
        op.B("REFERENCE_NODES_HAVE_LABELS", false);
        op.B("USE_STRUCTURAL_INFORMATION", true);
        op.B("USE_ATTRIBUTE_INFORMATION", true);
        op.A("CONTROL_FLOW_CLASSNAME", CONTROL_FLOW);
        op.V("INTERVAL_ANALYSIS");
        op.B("CREATE_LOOP_TREE", true);
        op.B("CREATE_SCC_GROUPS", false);
        op.B("COLOR_BACKEDGES_GREEN", false);
        op.A("PERFORM_ANALYSIS_ON_LEVEL", 1);
        op.V(LAYOUT);
        op.A(MINIMAL_LAYER_DISTANCE, (int)this.layouter.getMinimalLayerDistance());
        op.A(MINIMAL_NODE_DISTANCE, (int)this.layouter.getMinimalNodeDistance());
        op.A(MINIMAL_EDGE_DISTANCE, (int)this.layouter.getMinimalEdgeDistance());
        op.A(MINIMAL_FIRST_SEGMENT_LENGTH, (int)this.layouter.getMinimalFirstSegmentLength());
        op.A(MAXIMAL_DURATION, 5);
        op.A(ORIENTATION, orientEnum, 2);
        op.A(NODE_PLACEMENT, layoutStyles, (int)this.layouter.getLayoutStyle());
        op.A(EDGE_ROUTING, routingStyles, (int)this.layouter.getRoutingStyle());
        op.B(BACKLOOP_ROUTING, true);
        op.B(ACT_ON_SELECTION_ONLY, false);
        op.B("LAYOUT_AGAINST_ORIENTATION", true);
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mainrun() {
        this.createLayouter();
        C.I.I graph = this.getGraph2D();
        if (graph.t()) {
            return;
        }
        this.hm = A.E(this.getGraph2D());
        lA op = this.getOptionHandler();
        this.layouter.setMaximalDuration(op.T(MAXIMAL_DURATION) * 1000);
        this.layouter.setMinimalNodeDistance(op.T(MINIMAL_NODE_DISTANCE));
        this.layouter.setMinimalEdgeDistance(op.T(MINIMAL_EDGE_DISTANCE));
        this.layouter.setMinimalFirstSegmentLength(op.T(MINIMAL_FIRST_SEGMENT_LENGTH));
        this.layouter.setMinimalLayerDistance(op.T(MINIMAL_LAYER_DISTANCE));
        C.G.K ol = (C.G.K)this.layouter.getOrientationLayouter();
        this.againstOrientation = op.Y("LAYOUT_AGAINST_ORIENTATION");
        if (this.againstOrientation) {
            if (op.Q(ORIENTATION).equals(TOP_TO_BOTTOM)) {
                ol.X((byte)2);
            } else if (op.Q(ORIENTATION).equals(LEFT_TO_RIGHT)) {
                ol.X((byte)3);
            } else if (op.Q(ORIENTATION).equals(BOTTOM_TO_TOP)) {
                ol.X((byte)0);
            } else if (op.Q(ORIENTATION).equals(RIGHT_TO_LEFT)) {
                ol.X((byte)1);
            }
        } else if (op.Q(ORIENTATION).equals(TOP_TO_BOTTOM)) {
            ol.X((byte)0);
        } else if (op.Q(ORIENTATION).equals(LEFT_TO_RIGHT)) {
            ol.X((byte)1);
        } else if (op.Q(ORIENTATION).equals(BOTTOM_TO_TOP)) {
            ol.X((byte)2);
        } else if (op.Q(ORIENTATION).equals(RIGHT_TO_LEFT)) {
            ol.X((byte)3);
        }
        this.layouter.setLabelLayouterEnabled(false);
        String ls = op.S(NODE_PLACEMENT);
        if (ls.equals(PENDULUM)) {
            this.layouter.setLayoutStyle((byte)0);
        } else if (ls.equals(POLYLINE)) {
            this.layouter.setLayoutStyle((byte)2);
        } else if (ls.equals(LINEAR_SEGMENTS)) {
            this.layouter.setLayoutStyle((byte)1);
        } else if (ls.equals(TREE)) {
            this.layouter.setLayoutStyle((byte)3);
        } else if (ls.equals(SIMPLEX)) {
            this.layouter.setLayoutStyle((byte)4);
        } else if (ls.equals(MEDIAN_SIMPLEX)) {
            this.layouter.setLayoutStyle((byte)5);
        }
        String rs = op.S(EDGE_ROUTING);
        if (rs.equals(POLYLINE)) {
            this.layouter.setRoutingStyle((byte)0);
        } else if (rs.equals(ORTHOGONAL)) {
            this.layouter.setRoutingStyle((byte)1);
        }
        this.layouter.setSubgraphLayouterEnabled(op.Y(ACT_ON_SELECTION_ONLY));
        this.layouter.setLayeringStrategy((byte)2);
        C.G.G.D layerSequencer = this.layouter.getLayerSequencer();
        if (layerSequencer instanceof O) {
            O cls = (O)layerSequencer;
            cls.B((byte)0);
            cls.G(true);
            cls.E(40);
            this.layouter.setLayerSequencer(cls);
        }
        Object dp = null;
        K oldSdp = graph.C(G.SOURCE_PORT_CONSTRAINT_KEY);
        K oldTdp = graph.C(G.TARGET_PORT_CONSTRAINT_KEY);
        if (op.Y(BACKLOOP_ROUTING)) {
            g spc = null;
            g tpc = null;
            switch (ol.\u03ab()) {
                case 0: {
                    spc = g.I((byte)2);
                    tpc = g.I((byte)1);
                    break;
                }
                case 1: {
                    spc = g.I((byte)4);
                    tpc = g.I((byte)8);
                    break;
                }
                case 3: {
                    spc = g.I((byte)8);
                    tpc = g.I((byte)4);
                    break;
                }
                case 2: {
                    spc = g.I((byte)1);
                    tpc = g.I((byte)2);
                }
            }
            BackloopConstraintDP sdp = new BackloopConstraintDP(spc, oldSdp);
            BackloopConstraintDP tdp = new BackloopConstraintDP(tpc, oldTdp);
            if (oldSdp != null) {
                graph.F(G.SOURCE_PORT_CONSTRAINT_KEY);
            }
            if (oldTdp != null) {
                graph.F(G.TARGET_PORT_CONSTRAINT_KEY);
            }
            graph.A(G.SOURCE_PORT_CONSTRAINT_KEY, sdp);
            graph.A(G.TARGET_PORT_CONSTRAINT_KEY, tdp);
        }
        this.doReferenceNodesActions(op);
        this.loopAnalysis = null;
        this.doIntervalAnalysisAction(op);
        if (this.againstOrientation) {
            this.turnEdges();
        }
        V._C cf = V.B(graph);
        E nodeCursor = graph.k();
        while (nodeCursor.ok()) {
            Y node = nodeCursor.B();
            String nodeLabel = graph.e(node);
            if (nodeLabel.startsWith("Phi")) {
                Z ec = node.M();
                while (ec.ok()) {
                    H e2 = ec.D();
                    Y source = e2.X();
                    if (source.O() == 0) {
                        cf.B(source, node);
                    } else if (!graph.e(source).startsWith("Phi")) {
                        cf.B(node, source);
                    }
                    ec.next();
                }
            }
            nodeCursor.next();
        }
        V cl = new V(this.layouter.getLayerer());
        this.layouter.setLayerer(cl);
        if (A.G(graph)) {
            this.groupNodePositions = new HashMap();
            for (Y node : graph.\u00a2()) {
                if (!this.hm.V(node)) continue;
                mA nr = graph.f(node);
                this.groupNodePositions.put(node, nr.getBoundingBox());
            }
            C.I.A.O glc = new C.I.A.O(graph);
            glc.F();
            try {
                this.launchLayouter(this.layouter);
            }
            finally {
                glc.H();
            }
            this.groupNodePositions = null;
        } else {
            this.launchLayouter(this.layouter);
        }
        cf.A();
        if (op.Y(BACKLOOP_ROUTING)) {
            graph.F(G.SOURCE_PORT_CONSTRAINT_KEY);
            graph.F(G.TARGET_PORT_CONSTRAINT_KEY);
            if (oldSdp != null) {
                graph.A(G.SOURCE_PORT_CONSTRAINT_KEY, oldSdp);
            }
            if (oldTdp != null) {
                graph.A(G.TARGET_PORT_CONSTRAINT_KEY, oldTdp);
            }
        }
        if (dp != null) {
            graph.F(O.\u00cf);
        }
    }

    private void turnEdges() {
        C.I.I g2 = this.getGraph2D();
        for (H e2 : g2.m()) {
            g2.E(e2);
        }
    }

    public void reverseLayoutedEdges(C.I.I graph2d, C.G.H layout) {
        for (H edge : graph2d.m()) {
            graph2d.E(edge);
            Q edgeLayout = layout.K(edge);
            L src = edgeLayout.J();
            L tgt = edgeLayout.K();
            edgeLayout.A(tgt);
            edgeLayout.B(src);
            int pointCount = edgeLayout.I();
            for (int i2 = pointCount / 2 - 1; i2 >= 0; --i2) {
                L p1 = edgeLayout.A(i2);
                L p2 = edgeLayout.A(pointCount - i2 - 1);
                double tempx = p1.A();
                double tempy = p1.B();
                edgeLayout.A(i2, p2.A(), p2.B());
                edgeLayout.A(pointCount - i2 - 1, tempx, tempy);
            }
        }
    }

    protected void performAnimation(o view, C.G.H layout) {
        C.I.I graph2d = this.getGraph2D();
        if (this.againstOrientation) {
            this.reverseLayoutedEdges(graph2d, layout);
        }
        if (this.groupNodePositions != null) {
            for (Map.Entry<Y, Rectangle2D.Double> entry : this.groupNodePositions.entrySet()) {
                graph2d.f(entry.getKey()).setFrame(entry.getValue());
            }
        }
        super.performAnimation(view, layout);
    }

    private boolean dirtyStructure(A hm, Y source, Y target) {
        return hm.G(source) && hm.G(target);
    }

    private boolean dirtyAttribute(AttributeManager am, H edge, String s2) {
        String classname = am.getClassNameOfEdge(edge);
        if (classname == null) {
            return true;
        }
        return !classname.toLowerCase().startsWith(s2);
    }

    private boolean isDirtyEdge(H edge, boolean structuralInformation, boolean attributeInformation, String controlFlowClassname) {
        Y target;
        Y source;
        AttributeManager am = AttributeManager.getInstance(this.getGraph2D());
        if (this.hm.F(edge)) {
            source = this.hm.B(edge);
            target = this.hm.A(edge);
        } else {
            source = edge.X();
            target = edge.V();
        }
        return !(this.hm.A(source) == this.hm.A(target) || structuralInformation && !this.dirtyStructure(this.hm, source, target) || attributeInformation && !this.dirtyAttribute(am, edge, controlFlowClassname));
    }

    private void doReferenceNodesActions(lA op) {
        boolean createReferenceNodes = op.Y("CREATE_REFERENCE_NODES");
        boolean referenceNodesLabels = op.Y("REFERENCE_NODES_HAVE_LABELS");
        boolean structuralInformation = op.Y("USE_STRUCTURAL_INFORMATION");
        boolean attributeInformation = op.Y("USE_ATTRIBUTE_INFORMATION");
        boolean changed = this.referenceNodesLabels != referenceNodesLabels;
        this.referenceNodesLabels = referenceNodesLabels;
        if (createReferenceNodes) {
            String controlFlowClassname = op.S("CONTROL_FLOW_CLASSNAME").toLowerCase();
            if (changed) {
                this.reference.removeCouples();
            }
            Z ec = this.getGraph2D().a();
            ec.toFirst();
            while (ec.ok()) {
                if (this.isDirtyEdge(ec.D(), structuralInformation, attributeInformation, controlFlowClassname)) {
                    this.reference.createCouple(ec.D(), referenceNodesLabels, false);
                }
                ec.next();
            }
        } else {
            this.reference.removeCouples();
        }
    }

    private void doIntervalAnalysisAction(lA op) {
        boolean calculateLoopTree = op.Y("CREATE_LOOP_TREE");
        boolean createSCCGroups = op.Y("CREATE_SCC_GROUPS");
        int toLevel = op.T("PERFORM_ANALYSIS_ON_LEVEL");
        if (calculateLoopTree || createSCCGroups) {
            A hm = A.E(this.getGraph2D());
            if (this.getGraph2D() == this.graphOfLoopAnalysis) {
                for (Y oldLoopNode : this.loopGroupNodes) {
                    if (!this.getGraph2D().J(oldLoopNode)) continue;
                    this.getGraph2D().B(oldLoopNode);
                }
                for (H oldBackedge : this.backedges) {
                    Couple couple = this.reference.getCouple(oldBackedge);
                    if (couple == null) continue;
                    this.reference.deleteCouple(couple, false);
                }
                this.graphOfLoopAnalysis = null;
                this.loopGroupNodes = null;
            }
            GroupOnLevelFinder groupOnLevelFinder = new GroupOnLevelFinder(hm, toLevel);
            HashMap<Y, Boolean> config = Algo.getFoldingConfiguration(hm);
            Algo.foldLevel(hm, toLevel);
            IntervalAnalysis analysis = new IntervalAnalysis(hm, hm.C());
            if (calculateLoopTree) {
                this.loopAnalysis = new LoopAnalysis(hm, this.getGraph2D());
                this.loopAnalysis.doLoopAnalysis();
                hm.B(groupOnLevelFinder);
                Y parent = groupOnLevelFinder.getParent();
                this.loopGroupNodes = this.loopAnalysis.createLoopGroups(parent);
                this.graphOfLoopAnalysis = this.getGraph2D();
            } else {
                WeakHashMap<Y, ArrayList<X>> rnsccs = analysis.getRootNodesAndStrongComponents();
                for (Y node : rnsccs.keySet()) {
                    ArrayList<X> all = rnsccs.get(node);
                    for (X region : all) {
                        if (region == null || region.isEmpty()) continue;
                        Y representant = region.G();
                        Y parentNode = hm.A(representant);
                        if (this.getGraph2D().e(representant).startsWith("SCC-") || (parentNode == null || this.getGraph2D().e(parentNode).startsWith("SCC-")) && parentNode != null) continue;
                        Y sccNode = hm.N(parentNode);
                        this.getGraph2D().A((Object)sccNode, new AttributeCarrier());
                        mA nr = this.getGraph2D().f(sccNode);
                        nr.setLabelText("SCC-" + all.indexOf(region));
                        nr.setFillColor(new Color(247, 220, 240));
                        nr.setFillColor2(new Color(225, 225, 225));
                        hm.F(region, sccNode);
                    }
                }
            }
            Algo.setFoldingConfiguration(hm, config);
            if (calculateLoopTree) {
                this.backedges = this.loopAnalysis.getBackedges();
                for (H backedge : this.backedges) {
                    this.reference.createCouple(backedge, false, true);
                }
            }
        } else {
            for (Y n2 : this.loopTreeSet) {
                C.A.D g2;
                if (!this.getGraph2D().e(n2).startsWith("#LOOP-") || (g2 = n2.H()) == null) continue;
                g2.B(n2);
            }
            this.loopTreeSet.clear();
        }
    }

    public void dispose() {
        this.layouter = null;
    }

    public CompilerGraphLayouter createLayouter() {
        if (this.layouter == null) {
            this.layouter = new CompilerGraphLayouter(this.reference);
        }
        return this.layouter;
    }

    public ReferenceManager getReference() {
        return this.reference;
    }

    public void setReference(ReferenceManager reference) {
        this.reference = reference;
    }

    static final class BackloopConstraintDP
    extends D {
        private g pc;
        private K delegate;
        private static final g anySide = g.I((byte)0);

        BackloopConstraintDP(g pc, K delegate) {
            this.pc = pc;
            this.delegate = delegate;
        }

        public Object get(Object o2) {
            Object delegateResult;
            if (this.delegate != null && (delegateResult = this.delegate.get(o2)) != null) {
                return delegateResult;
            }
            H e2 = (H)o2;
            if (e2.Y()) {
                return anySide;
            }
            return this.pc;
        }
    }

    private class GroupOnLevelFinder
    implements A._F {
        private Y parent = null;
        private A hm;
        private int toLevel;

        public GroupOnLevelFinder(A hm, int level) {
            this.hm = hm;
            this.toLevel = level;
        }

        public void visitNode(Y n2) {
            if (this.hm.V(n2) && this.hm.F(n2) == this.toLevel - 1) {
                this.parent = n2;
            }
        }

        public Y getParent() {
            return this.parent;
        }
    }
}

