/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.module.interval;

import C.A.D;
import C.A.E;
import C.A.H;
import C.A.X;
import C.A.Y;
import C.I.A.A;
import C.I.AB;
import C.I.I;
import C.I.KB;
import C.I.UA;
import C.I.o;
import C.I.sA;
import C.I.wA;
import de.unika.ipd.ycomp.module.interval.RootFinder;
import de.unika.ipd.ycomp.module.interval.SimpleNodeMap;
import de.unika.ipd.ycomp.module.interval.TarjanDominance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalAnalysis {
    public D graph;
    public HashMap<Y, Kind> kindMap;
    public SimpleNodeMap<Integer> lowLink;
    public SimpleNodeMap<Integer> dfn;
    public SimpleNodeMap<X> loopContains;
    public SimpleNodeMap<X> generators;
    public SimpleNodeMap<Y> loopParent;
    public SimpleNodeMap<Y> loopEntry;
    public SimpleNodeMap<Y> idom;
    private int nextDfn;
    private X stack = new X();
    public Y root;
    public RootFinder dfs;
    private ArrayList<Y[]> backedges;
    private int preorder;
    private int postorder;
    private HashMap<Y, Integer> pre;
    private HashMap<Y, Integer> rpost;

    public IntervalAnalysis(A hierarchy, D graph) {
        this.graph = graph;
        this.dfs = new RootFinder();
        this.lowLink = new SimpleNodeMap();
        this.dfn = new SimpleNodeMap();
        this.loopContains = new SimpleNodeMap();
        this.generators = new SimpleNodeMap();
        this.loopParent = new SimpleNodeMap();
        this.loopEntry = new SimpleNodeMap();
        this.kindMap = new HashMap();
        this.backedges = new ArrayList();
        this.pre = new HashMap();
        this.rpost = new HashMap();
    }

    public boolean isBackEdge(Y source, Y target) {
        for (Y[] n2 : this.backedges) {
            if (!source.equals(n2[0]) || !target.equals(n2[1])) continue;
            return true;
        }
        return false;
    }

    public void performDfs() {
        this.preorder = 1;
        this.postorder = this.graph.b();
        for (Y n2 : this.graph.\u00a2()) {
            this.pre.put(n2, 0);
            this.rpost.put(n2, 0);
        }
        this.dfs.start(this.graph);
        this.root = this.dfs.rootNode;
        this.backedgeDfs(this.root);
        this.idom = new TarjanDominance().calculate(this.graph, this.root);
    }

    private void backedgeDfs(Y n2) {
        this.pre.put(n2, this.preorder);
        ++this.preorder;
        E succ = n2.D();
        succ.toFirst();
        while (succ.ok()) {
            Y s2 = succ.B();
            if (this.pre.get(s2) == 0) {
                this.backedgeDfs(s2);
            } else if (this.rpost.get(s2) == 0) {
                this.backedges.add(new Y[]{n2, s2});
            }
            succ.next();
        }
        this.rpost.put(n2, this.postorder);
        --this.postorder;
    }

    public D getGraph() {
        return this.graph;
    }

    public ArrayList<ArrayList<Y>> calculateLoopTree() {
        ArrayList<Y> list = new ArrayList<Y>();
        this.performDfs();
        for (Y b2 : this.dfs.dfsMap.keySet()) {
            list.add(b2);
        }
        Collections.sort(list, new Comparator<Y>(){

            @Override
            public int compare(Y o1, Y o2) {
                return IntervalAnalysis.this.dfs.dfsMap.get(o1).compareTo(IntervalAnalysis.this.dfs.dfsMap.get(o2));
            }
        });
        for (Y b2 : list) {
            this.generators.set(b2, new X());
            this.loopEntry.set(b2, b2);
            this.loopContains.set(b2, new X(b2));
        }
        for (Y b2 : list) {
            if (!this.generators.get(b2).isEmpty()) {
                this.findBody(this.generators.get(b2), b2, Kind.MULTIPLE_ENTRY_LOOP);
            }
            this.loopContains.set(b2, this.findLoop(b2));
        }
        return this.produceList();
    }

    private ArrayList<ArrayList<Y>> produceList() {
        E nc = this.getGraph().k();
        ArrayList<ArrayList<Y>> list = new ArrayList<ArrayList<Y>>();
        HashSet<ArrayList> trashSet = new HashSet<ArrayList>();
        nc.toFirst();
        while (nc.ok()) {
            Y n2 = nc.B();
            ArrayList<Y> nl = new ArrayList<Y>(this.loopContains.get(n2));
            if (!nl.isEmpty()) {
                nl.add(n2);
                list.add(nl);
            }
            nc.next();
        }
        for (ArrayList arrayList : list) {
            for (ArrayList arrayList2 : list) {
                if (!arrayList.containsAll(arrayList2) || arrayList.equals(arrayList2)) continue;
                arrayList.removeAll(arrayList2);
                arrayList.add(arrayList2);
                trashSet.add(arrayList2);
            }
        }
        list.removeAll(trashSet);
        return list;
    }

    public X findLoop(Y b2) {
        Y z = b2;
        X loop = new X();
        E pred = b2.F();
        pred.toFirst();
        while (pred.ok()) {
            Y p2 = pred.B();
            if (this.isBackEdge(p2, b2)) {
                z = this.commonDominator(z, p2);
                if (!loop.contains(p2) && p2 != b2) {
                    loop.add(p2);
                }
            }
            pred.next();
        }
        if (z != b2) {
            X nl = this.generators.get(z);
            nl.addAll((Collection)loop);
            this.generators.set(z, nl);
        } else {
            loop = this.findBody(loop, z, Kind.SINGLE_ENTRY_LOOP);
        }
        return loop;
    }

    private X findBody(X generators, Y head, Kind kind) {
        X loop = new X();
        X queue = new X();
        E nc = generators.H();
        loop.addAll((Collection)generators);
        queue.addAll((Collection)generators);
        while (!queue.isEmpty()) {
            Y b2 = queue.I();
            nc = this.loopEntry.get(b2).F();
            nc.toFirst();
            while (nc.ok()) {
                Y l2;
                Y p2 = nc.B();
                if (p2 != head && !loop.contains(l2 = this.loopAncestor(p2))) {
                    queue.add(l2);
                    loop.add(l2);
                }
                nc.next();
            }
        }
        return loop;
    }

    private Y loopAncestor(Y b2) {
        while (this.loopParent.get(b2) != null) {
            b2 = this.loopParent.get(b2);
        }
        return b2;
    }

    public Y commonDominator(Y z, Y b2) {
        if (this.dominates(b2, z)) {
            return b2;
        }
        while (!this.dominates(z, b2)) {
            z = this.idom.get(z);
        }
        return z;
    }

    private boolean dominates(Y z, Y b2) {
        if (b2 == null) {
            return false;
        }
        if (b2 == z) {
            return true;
        }
        return this.dominates(z, this.idom.get(b2));
    }

    private void initialize() {
        E nc = this.getGraph().k();
        nc.toFirst();
        while (nc.ok()) {
            Y x = nc.B();
            this.dfn.set(x, 0);
            this.lowLink.set(x, 0);
            nc.next();
        }
        this.nextDfn = 0;
        this.stack.clear();
    }

    public ArrayList<X> getStrongComponents(Y x) {
        ArrayList<X> allSCC = new ArrayList<X>();
        E succ = x.D();
        this.lowLink.set(x, ++this.nextDfn);
        this.dfn.set(x, this.nextDfn);
        this.stack.push(x);
        succ.toFirst();
        while (succ.ok()) {
            Y y2 = succ.B();
            if (this.dfn.get(y2) == 0) {
                allSCC.addAll(this.getStrongComponents(y2));
                this.lowLink.set(x, Math.min(this.lowLink.get(x), this.lowLink.get(y2)));
            } else if (this.dfn.get(y2) < this.dfn.get(x) && this.stack.contains(y2)) {
                this.lowLink.set(x, Math.min(this.lowLink.get(x), this.dfn.get(y2)));
            }
            succ.next();
        }
        if (this.lowLink.get(x) == this.dfn.get(x)) {
            X sCC = new X();
            while (!this.stack.isEmpty()) {
                Y z = this.stack.G();
                if (this.dfn.get(z) < this.dfn.get(x)) {
                    if (!sCC.isEmpty()) {
                        allSCC.add(sCC);
                    }
                    return allSCC;
                }
                this.stack.I();
                sCC.add(z);
            }
            if (!sCC.isEmpty()) {
                allSCC.add(sCC);
            }
        }
        return allSCC;
    }

    public WeakHashMap<Y, ArrayList<X>> getRootNodesAndStrongComponents() {
        ArrayList<Object> allSCC = new ArrayList();
        E nc = this.getGraph().k();
        WeakHashMap<Y, ArrayList<X>> rootsAndSCCs = new WeakHashMap<Y, ArrayList<X>>();
        this.initialize();
        nc.toFirst();
        while (nc.ok()) {
            Y x = nc.B();
            if (this.dfn.get(x) == 0) {
                allSCC = this.getStrongComponents(x);
                rootsAndSCCs.put(x, allSCC);
            }
            nc.next();
        }
        return rootsAndSCCs;
    }

    public X naturalLoop(Y m, Y n2) {
        X loop = new X();
        X myStack = new X();
        loop.add(m);
        if (m == n2) {
            return loop;
        }
        loop.add(n2);
        myStack.add(m);
        while (!myStack.isEmpty()) {
            Y p2 = myStack.I();
            E pred = p2.F();
            pred.toFirst();
            while (pred.ok()) {
                Y q2 = pred.B();
                if (!loop.contains(q2)) {
                    loop.add(q2);
                    myStack.push(q2);
                }
                pred.next();
            }
        }
        return loop;
    }

    private SimpleNodeMap<Y> tarjanDominance() {
        TarjanDominance tarjan = new TarjanDominance();
        return tarjan.calculate(this.graph, this.root);
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        o view = new o();
        A hierarchy = new A(view.A());
        final IntervalAnalysis analysis = new IntervalAnalysis(hierarchy, view.A());
        sA editMode = new sA();
        editMode.showNodeTips(true);
        view.D(editMode);
        AB actions = new AB(view);
        ActionMap amap = actions.D();
        InputMap imap = actions.A(amap);
        view.\u00ba().setActionMap(amap);
        view.\u00ba().setInputMap(0, imap);
        panel.add((Component)view, "Center");
        JToolBar toolbar = new JToolBar();
        JToolBar toolbar2 = new JToolBar();
        toolbar.add(new AbstractAction("naturalLoop()"){
            private static final long serialVersionUID = 3933065740321389430L;

            public void actionPerformed(ActionEvent e2) {
                X nl;
                E nc = ((I)analysis.getGraph()).\u00f0();
                if (nc.size() > 2 || nc.size() < 1) {
                    return;
                }
                nc.toFirst();
                Y a2 = nc.B();
                nc.toLast();
                Y b2 = nc.B();
                if (new X(a2.D()).contains(b2)) {
                    nl = analysis.naturalLoop(a2, b2);
                    System.out.println(">>naturalLoop(" + a2 + ", " + b2 + "):");
                } else {
                    nl = analysis.naturalLoop(b2, a2);
                    System.out.println(">>naturalLoop(" + b2 + ", " + a2 + "):");
                }
                System.out.println(nl);
            }
        });
        toolbar.add(new AbstractAction("strongComponents()"){
            private static final long serialVersionUID = -3024983101344016981L;

            public void actionPerformed(ActionEvent e2) {
                System.out.println(">>doStrongComponents():");
                WeakHashMap<Y, ArrayList<X>> sCCs = analysis.getRootNodesAndStrongComponents();
                System.out.println(sCCs);
            }
        });
        toolbar.add(new AbstractAction("Backedges"){
            private static final long serialVersionUID = 444010704789496730L;

            public void actionPerformed(ActionEvent e2) {
                System.out.println("Backedges:");
                for (H edge : analysis.graph.m()) {
                    if (!analysis.isBackEdge(edge.X(), edge.V())) continue;
                    System.out.println(edge);
                }
            }
        });
        toolbar2.add(new AbstractAction("Tarjan Dominance"){
            private static final long serialVersionUID = -5714110445791732557L;

            public void actionPerformed(ActionEvent e2) {
                System.out.println("Tarjan Dominance:");
                System.out.println(analysis.tarjanDominance());
            }
        });
        toolbar.add(new AbstractAction("Common Dominator:"){
            private static final long serialVersionUID = -5964378196571882762L;

            public void actionPerformed(ActionEvent e2) {
                E nc = ((I)analysis.getGraph()).\u00f0();
                if (nc.size() != 2) {
                    return;
                }
                nc.toFirst();
                Y a2 = nc.B();
                nc.toLast();
                Y b2 = nc.B();
                System.out.println("common dominator(" + a2 + ", " + b2 + "):");
                System.out.println(analysis.commonDominator(a2, b2));
            }
        });
        toolbar2.add(new AbstractAction("dominates()"){
            private static final long serialVersionUID = -8426388832410694876L;

            public void actionPerformed(ActionEvent e2) {
                E nc = ((I)analysis.getGraph()).\u00f0();
                if (nc.size() != 2) {
                    return;
                }
                nc.toFirst();
                Y a2 = nc.B();
                nc.toLast();
                Y b2 = nc.B();
                System.out.print("" + a2 + " dominates " + b2 + ": ");
                System.out.println(analysis.dominates(a2, b2));
            }
        });
        toolbar2.add(new AbstractAction("getRoot()"){
            private static final long serialVersionUID = 3661968557216078277L;

            public void actionPerformed(ActionEvent e2) {
                System.out.println("getRoot():");
                System.out.println(analysis.root);
            }
        });
        toolbar2.add(new AbstractAction("calculateLoopTree()"){
            private static final long serialVersionUID = -3364778985025121021L;

            public void actionPerformed(ActionEvent e2) {
                E nc = ((I)analysis.getGraph()).\u00f0();
                ArrayList<ArrayList<Y>> loops = analysis.calculateLoopTree();
                System.out.println("calculateLoopTree():");
                if (nc.size() >= 1) {
                    System.out.println("Loop Tree: " + loops);
                    System.out.println();
                    System.out.println("Comp-Map: " + analysis.dfs.compMap);
                    System.out.println("Dfs-Map: " + analysis.dfs.dfsMap);
                    System.out.println();
                    System.out.println("Tarjan Dominance: " + analysis.idom);
                    System.out.println("Loop contains: " + analysis.loopContains);
                    System.out.println("Loop entry: " + analysis.loopEntry);
                    System.out.println("Loop parent: " + analysis.loopParent);
                    System.out.println("Loop generators: " + analysis.generators);
                }
            }
        });
        panel.add((Component)toolbar, "North");
        panel.add((Component)toolbar2, "South");
        KB mwl = new KB();
        view.\u00ba().addMouseWheelListener(mwl);
        view.D(new wA());
        view.A().\u00ea().B(UA.G);
        JFrame frame = new JFrame("Interval Analysis");
        frame.setDefaultCloseOperation(3);
        frame.setBounds(100, 100, 600, 300);
        frame.add(panel);
        frame.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        SINGLE_ENTRY_LOOP,
        MULTIPLE_ENTRY_LOOP,
        LOOP_TREE_ROOT;

    }
}

