/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.module.interval;

import C.A.D;
import C.A.E;
import C.A.Y;
import de.unika.ipd.ycomp.module.interval.SimpleNodeMap;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TarjanDominance<T> {
    private int[] parent;
    private int[] ancestor;
    private int[] vertex;
    private int[] semi;
    private int[] label;
    private int[] size;
    private int[] child;
    private int[] dom;
    private BitSet[] succ;
    private BitSet[] pred;
    private BitSet[] bucket;
    private Y[] nodes;
    private Map<Y, Integer> indexMap = new HashMap<Y, Integer>();
    private int start;
    private int n;
    private Y node;
    private Y s;

    TarjanDominance() {
    }

    private void init(D flowGraph, Y root) {
        int i2;
        E flowNodes = flowGraph.k();
        this.n = flowNodes.size() + 1;
        this.parent = new int[this.n];
        this.ancestor = new int[this.n];
        this.vertex = new int[this.n];
        this.semi = new int[this.n];
        this.label = new int[this.n];
        this.size = new int[this.n];
        this.child = new int[this.n];
        this.dom = new int[this.n];
        this.succ = new BitSet[this.n];
        this.pred = new BitSet[this.n];
        this.bucket = new BitSet[this.n];
        for (i2 = 0; i2 < this.n; ++i2) {
            this.succ[i2] = new BitSet(this.n);
            this.pred[i2] = new BitSet(this.n);
            this.bucket[i2] = new BitSet(this.n);
        }
        this.nodes = new Y[this.n];
        i2 = 1;
        flowNodes.toFirst();
        while (flowNodes.ok()) {
            this.nodes[i2] = this.node = flowNodes.B();
            this.indexMap.put(this.node, i2++);
            flowNodes.next();
        }
        flowNodes.toFirst();
        while (flowNodes.ok()) {
            this.node = flowNodes.B();
            int index = this.indexMap.get(this.node);
            E successors = this.node.D();
            successors.toFirst();
            while (successors.ok()) {
                this.s = successors.B();
                this.succ[index].set(this.indexMap.get(this.s));
                successors.next();
            }
            flowNodes.next();
        }
        this.start = this.indexMap.get(root);
    }

    private int dfs(int v, int n2) {
        this.semi[v] = ++n2;
        this.vertex[n2] = this.label[v] = v;
        this.child[v] = 0;
        this.ancestor[v] = 0;
        this.size[v] = 1;
        BitSet succ = this.succ[v];
        int w = succ.nextSetBit(0);
        while (w >= 0) {
            if (this.semi[w] == 0) {
                this.parent[w] = v;
                n2 = this.dfs(w, n2);
            }
            this.pred[w].set(v);
            w = succ.nextSetBit(w + 1);
        }
        return n2;
    }

    private void compress(int v) {
        if (this.ancestor[this.ancestor[v]] != 0) {
            this.compress(this.ancestor[v]);
            if (this.semi[this.label[this.ancestor[v]]] < this.semi[this.label[v]]) {
                this.label[v] = this.label[this.ancestor[v]];
            }
            this.ancestor[v] = this.ancestor[this.ancestor[v]];
        }
    }

    private int eval(int v) {
        if (this.ancestor[v] == 0) {
            return v;
        }
        this.compress(v);
        return this.label[v];
    }

    private void link(int v, int w) {
        this.ancestor[w] = v;
    }

    private void main() {
        int w;
        int n2;
        int i2;
        for (i2 = n2 = this.dfs(this.start, 0); i2 >= 0; --i2) {
            int u2;
            w = this.vertex[i2];
            int v = this.pred[w].nextSetBit(0);
            while (v != -1) {
                u2 = this.eval(v);
                if (this.semi[u2] < this.semi[w]) {
                    this.semi[w] = this.semi[u2];
                }
                v = this.pred[w].nextSetBit(v + 1);
            }
            this.bucket[this.vertex[this.semi[w]]].set(w);
            this.link(this.parent[w], w);
            BitSet tmp = this.bucket[this.parent[w]];
            int v2 = tmp.nextSetBit(0);
            while (v2 != -1) {
                tmp.clear(v2);
                u2 = this.eval(v2);
                this.dom[v2] = this.semi[u2] < this.semi[v2] ? u2 : this.parent[w];
                v2 = tmp.nextSetBit(v2 + 1);
            }
        }
        for (i2 = 1; i2 < n2; ++i2) {
            w = this.vertex[i2];
            if (this.dom[w] == this.vertex[this.semi[w]]) continue;
            this.dom[w] = this.dom[this.dom[w]];
        }
        this.dom[this.start] = 0;
    }

    public SimpleNodeMap<Y> calculate(D fg, Y root) {
        this.init(fg, root);
        this.main();
        SimpleNodeMap<Y> res = new SimpleNodeMap<Y>();
        for (int i2 = 1; i2 < this.dom.length; ++i2) {
            res.set(this.nodes[i2], this.nodes[this.dom[i2]]);
        }
        return res;
    }
}

