/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.reference;

import C.A.C;
import C.A.D;
import C.A.E;
import C.A.G;
import C.A.H;
import C.A.X;
import C.A.Y;
import C.A._;
import C.A.a;
import C.I.$B;
import C.I.A.A;
import C.I.I;
import C.I.mA;
import de.unika.ipd.ycomp.algo.Algo;
import de.unika.ipd.ycomp.algo.FolderOpener;
import de.unika.ipd.ycomp.attributes.AttributeCarrier;
import de.unika.ipd.ycomp.reference.Couple;
import de.unika.ipd.ycomp.reference.CoupleCursor;
import de.unika.ipd.ycomp.reference.CoupleList;
import de.unika.ipd.ycomp.reference.ReferenceNodeException;
import de.unika.ipd.ycomp.reference.ReferenceNodeRealizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceManager
implements _ {
    private I graph2d;
    private HashMap<Y, LinkedList<Couple>> referencedNodeCouples = new HashMap();
    private HashSet<H> noReferenceSet = new HashSet();
    private WeakHashMap<H, Couple> origEdgeToCouple;
    private WeakHashMap<Y, Couple> refNodeToCouple;
    private HashMap<H, Couple> refEdgeToCouple = new HashMap();
    private CoupleList coupleList;
    public A hierarchy;
    private boolean removingCouples = false;
    private static a managerList = new a();

    public ReferenceManager(I graph) {
        this(graph, new A(graph));
    }

    public ReferenceManager(I graph, A hierarchy) {
        this.graph2d = graph;
        this.hierarchy = hierarchy;
        managerList.add(this);
        this.origEdgeToCouple = new WeakHashMap();
        this.refNodeToCouple = new WeakHashMap();
        this.coupleList = new CoupleList();
        graph.A(this);
    }

    public I getGraph2D() {
        return this.graph2d;
    }

    public void setGraph(I graph) {
        this.graph2d = graph;
    }

    protected void finalize() throws Throwable {
        managerList.remove(this);
    }

    public void clear() {
        this.refNodeToCouple.clear();
        this.refEdgeToCouple.clear();
        this.origEdgeToCouple.clear();
        this.coupleList.clear();
        this.referencedNodeCouples.clear();
    }

    public void createCouple(H edge, boolean referenceNodesLabels, boolean isControlFlow) {
        Y b2;
        Y a2;
        if (this.noReferenceSet.contains(edge)) {
            return;
        }
        if (this.hierarchy.F(edge)) {
            a2 = this.hierarchy.B(edge);
            b2 = this.hierarchy.A(edge);
        } else {
            a2 = edge.X();
            b2 = edge.V();
        }
        Y refA = this.getGraph2D().B(new ReferenceNodeRealizer(isControlFlow));
        this.getGraph2D().A((Object)refA, new AttributeCarrier());
        Y parentA = this.hierarchy.A(a2);
        if (parentA != null) {
            this.hierarchy.F(new X(refA), parentA);
        }
        Y refB = this.getGraph2D().B(new ReferenceNodeRealizer(isControlFlow));
        this.getGraph2D().A((Object)refB, new AttributeCarrier());
        Y parentB = this.hierarchy.A(b2);
        if (parentB != null) {
            this.hierarchy.F(new X(refB), parentB);
        }
        if (referenceNodesLabels) {
            String refLabel = this.getGraph2D().f(b2).getLabelText();
            mA nr = this.getGraph2D().f(refA);
            nr.setLabelText(refLabel);
            nr.setWidth(10.0 + nr.getLabel().getWidth());
            nr = this.getGraph2D().f(refB);
            refLabel = this.getGraph2D().f(a2).getLabelText();
            nr.setLabelText(refLabel);
            nr.setWidth(10.0 + nr.getLabel().getWidth());
        }
        this.getGraph2D().B(refA, this.getGraph2D().P(a2));
        this.getGraph2D().B(refB, this.getGraph2D().P(b2));
        $B er = this.getGraph2D().X(edge);
        $B defaultr = this.getGraph2D().\u00ea();
        this.getGraph2D().A(er);
        er.S();
        H edgeA = this.hierarchy.B(a2, refA);
        this.getGraph2D().A((Object)edgeA, new AttributeCarrier());
        H edgeB = this.hierarchy.B(refB, b2);
        this.getGraph2D().A((Object)edgeB, new AttributeCarrier());
        this.getGraph2D().A(defaultr);
        Couple couple = new Couple(edge, edgeA, edgeB, isControlFlow);
        this.origEdgeToCouple.put(edge, couple);
        this.refNodeToCouple.put(refA, couple);
        this.refNodeToCouple.put(refB, couple);
        this.refEdgeToCouple.put(edgeA, couple);
        this.refEdgeToCouple.put(edgeB, couple);
        this.addReferencedNode(a2, couple);
        this.addReferencedNode(b2, couple);
        this.coupleList.add(couple);
        this.getGraph2D().I(edge);
    }

    public void createCouple(H edge) {
        this.createCouple(edge, false, false);
    }

    private void addReferencedNode(Y node, Couple couple) {
        LinkedList<Couple> list = this.referencedNodeCouples.get(node);
        if (list == null) {
            list = new LinkedList();
            this.referencedNodeCouples.put(node, list);
        }
        list.addFirst(couple);
    }

    private void removeCoupleFromReferencedNode(Y node, Couple couple) {
        LinkedList<Couple> list = this.referencedNodeCouples.get(node);
        if (list == null) {
            System.err.println("removeReferencedNode: Couple list does not exist anymore for node \"" + this.graph2d.e(node) + "\"");
            return;
        }
        list.remove(couple);
        if (list.size() == 0) {
            this.referencedNodeCouples.remove(node);
        }
    }

    public void deleteCouple(Couple couple, boolean noRecreate) throws ReferenceNodeException {
        Y node1 = couple.getSrcRefNode();
        Y node2 = couple.getTgtRefNode();
        H edge = couple.getOrigEdge();
        HashMap<Y, Boolean> config = Algo.getFoldingConfiguration(this.hierarchy);
        FolderOpener folderOpener = new FolderOpener(this.hierarchy, 0);
        this.hierarchy.A(folderOpener);
        boolean oldRemovingCouples = this.removingCouples;
        this.removingCouples = true;
        this.getGraph2D().B(node1);
        this.getGraph2D().B(node2);
        this.getGraph2D().A(edge);
        this.removingCouples = oldRemovingCouples;
        Algo.setFoldingConfiguration(this.hierarchy, config);
        if (!this.coupleList.remove(couple)) {
            throw new ReferenceNodeException("Couple does not exist!", couple);
        }
        this.origEdgeToCouple.remove(edge);
        this.refNodeToCouple.remove(node1);
        this.refNodeToCouple.remove(node2);
        this.refEdgeToCouple.remove(couple.getSrcRefEdge());
        this.refEdgeToCouple.remove(couple.getTgtRefEdge());
        this.removeCoupleFromReferencedNode(couple.getSource(), couple);
        this.removeCoupleFromReferencedNode(couple.getTarget(), couple);
        if (noRecreate) {
            this.noReferenceSet.add(edge);
        }
    }

    public void deleteCoupleNoFold(Couple couple, boolean unhideEdge, Y noDeleteNode) {
        Y node1 = couple.getSrcRefNode();
        Y node2 = couple.getTgtRefNode();
        H edge = couple.getOrigEdge();
        if (!this.coupleList.remove(couple)) {
            System.err.println("deleteCoupleSimple: Couple does not exist!");
            return;
        }
        this.origEdgeToCouple.remove(edge);
        this.refNodeToCouple.remove(node1);
        this.refNodeToCouple.remove(node2);
        this.refEdgeToCouple.remove(couple.getSrcRefEdge());
        this.refEdgeToCouple.remove(couple.getTgtRefEdge());
        this.removeCoupleFromReferencedNode(couple.getSource(), couple);
        this.removeCoupleFromReferencedNode(couple.getTarget(), couple);
        boolean oldRemovingCouples = this.removingCouples;
        this.removingCouples = true;
        if (noDeleteNode != node1) {
            this.getGraph2D().B(node1);
        }
        if (noDeleteNode != node2) {
            this.getGraph2D().B(node2);
        }
        if (unhideEdge) {
            this.getGraph2D().A(edge);
        }
        this.removingCouples = oldRemovingCouples;
    }

    public void removeCouples() {
        HashMap<Y, Boolean> config = Algo.getFoldingConfiguration(this.hierarchy);
        FolderOpener folderOpener = new FolderOpener(this.hierarchy, 0);
        this.hierarchy.A(folderOpener);
        this.removingCouples = true;
        CoupleCursor cc = this.coupleList.couples();
        cc.toFirst();
        while (cc.ok()) {
            Couple couple = cc.couple();
            try {
                this.getGraph2D().A(couple.getOrigEdge());
                this.getGraph2D().B(couple.getSrcRefNode());
                this.getGraph2D().B(couple.getTgtRefNode());
            }
            catch (IllegalArgumentException e2) {
                // empty catch block
            }
            cc.next();
        }
        Algo.setFoldingConfiguration(this.hierarchy, config);
        this.refNodeToCouple.clear();
        this.refEdgeToCouple.clear();
        this.origEdgeToCouple.clear();
        this.coupleList.clear();
        this.referencedNodeCouples.clear();
        this.removingCouples = false;
    }

    @Override
    public void onGraphEvent(C ev) {
        if (this.removingCouples) {
            return;
        }
        switch (ev.C()) {
            case 2: {
                Y node = (Y)ev.A();
                LinkedList<Couple> coupleList = this.referencedNodeCouples.get(node);
                if (coupleList != null) {
                    LinkedList copiedList = (LinkedList)coupleList.clone();
                    for (Couple couple : copiedList) {
                        this.deleteCoupleNoFold(couple, true, null);
                    }
                    break;
                }
                Couple refCouple = this.refNodeToCouple.get(node);
                if (refCouple == null) break;
                this.deleteCoupleNoFold(refCouple, false, node);
                break;
            }
            case 5: {
                Couple couple;
                H edge = (H)ev.A();
                if (!this.isReferenceEdge(edge) || (couple = this.getCouple(edge)) == null) break;
                this.deleteCoupleNoFold(couple, false, null);
                break;
            }
        }
    }

    public boolean isReferenceNode(Y node) {
        return this.refNodeToCouple.containsKey(node);
    }

    public boolean isReferenceEdge(H edge) {
        return this.refEdgeToCouple.containsKey(edge);
    }

    public LinkedList<Couple> getCouplesForNode(Y node) {
        return this.referencedNodeCouples.get(node);
    }

    public boolean isReferencedNode(Y node) {
        return this.referencedNodeCouples.containsKey(node);
    }

    public boolean hasReferenceNode(Y node) {
        E nc = node.J();
        nc.B();
        while (nc.ok()) {
            if (this.isReferenceNode(nc.B())) {
                return true;
            }
            nc.next();
        }
        return false;
    }

    public Couple getCouple(Y ref) {
        return this.refNodeToCouple.get(ref);
    }

    public Y getSource(H edge) {
        if (this.isReferenceEdge(edge)) {
            return this.getCouple(edge).getSource();
        }
        return this.hierarchy.B(edge);
    }

    public Y getTarget(H edge) {
        if (this.isReferenceEdge(edge)) {
            return this.getCouple(edge).getTarget();
        }
        return this.hierarchy.A(edge);
    }

    public Couple getCouple(H edge) {
        Couple couple = this.refNodeToCouple.get(edge.X());
        if (couple != null) {
            return couple;
        }
        couple = this.refNodeToCouple.get(edge.V());
        if (couple != null) {
            return couple;
        }
        return this.origEdgeToCouple.get(edge);
    }

    public Y getOther(Y ref) throws ReferenceNodeException {
        if (this.isReferenceNode(ref)) {
            return this.getCouple(ref).getOther(ref);
        }
        throw new ReferenceNodeException("Not a reference node: " + ref.toString(), ref);
    }

    public Y getRealNode(Y ref) throws ReferenceNodeException {
        if (this.isReferenceNode(ref)) {
            Couple couple = this.getCouple(ref);
            if (ref == couple.getSrcRefNode()) {
                return couple.getSource();
            }
            return couple.getTarget();
        }
        throw new ReferenceNodeException("Not a reference node: " + ref.toString(), ref);
    }

    public CoupleCursor couples() {
        return this.coupleList.couples();
    }

    public static ReferenceManager getInstance(D g2) {
        G amlc = managerList.cursor();
        while (amlc.ok()) {
            ReferenceManager am = (ReferenceManager)amlc.current();
            if (am.getGraph2D() == g2) {
                return am;
            }
            amlc.next();
        }
        return null;
    }

    public void clearNoRefs() {
        this.noReferenceSet.clear();
    }
}

