/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.tooltip;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import sun.swing.UIAction;

public class YCompToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    Timer enterTimer = new Timer(750, new insideTimerAction());
    Timer exitTimer;
    String toolTipText;
    Point preferredLocation;
    JComponent insideComponent;
    MouseEvent mouseEvent;
    boolean showImmediately;
    static final YCompToolTipManager sharedInstance = new YCompToolTipManager();
    transient Popup tipWindow;
    private Window window;
    JToolTip tip;
    private Rectangle popupRect = null;
    boolean enabled = true;
    private boolean tipShowing = false;
    private KeyStroke postTip;
    private KeyStroke hideTip;
    private Action postTipAction;
    private Action hideTipAction;
    private FocusListener focusChangeListener = null;
    private MouseMotionListener moveBeforeEnterListener = null;
    protected boolean lightWeightPopupEnabled = true;
    protected boolean heavyWeightPopupEnabled = false;

    YCompToolTipManager() {
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.postTip = KeyStroke.getKeyStroke(112, 2);
        this.postTipAction = new Actions(Actions.SHOW);
        this.hideTip = KeyStroke.getKeyStroke(27, 0);
        this.hideTipAction = new Actions(Actions.HIDE);
        this.moveBeforeEnterListener = new MoveBeforeEnterListener();
    }

    boolean isLeftToRight(Component c2) {
        return c2.getComponentOrientation().isLeftToRight();
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
        if (!flag) {
            this.hideTipWindow();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setLightWeightPopupEnabled(boolean aFlag) {
        this.lightWeightPopupEnabled = aFlag;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setInitialDelay(int milliseconds) {
        this.enterTimer.setInitialDelay(milliseconds);
    }

    public int getInitialDelay() {
        return this.enterTimer.getInitialDelay();
    }

    public void setReshowDelay(int milliseconds) {
        this.exitTimer.setInitialDelay(milliseconds);
    }

    public int getReshowDelay() {
        return this.exitTimer.getInitialDelay();
    }

    void showTipWindow() {
        if (this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        for (Container p2 = this.insideComponent.getParent(); p2 != null && !(p2 instanceof JPopupMenu); p2 = p2.getParent()) {
            if (!(p2 instanceof Window)) continue;
            if (((Window)p2).isFocused()) break;
            return;
        }
        if (this.enabled) {
            Point screenLocation = this.insideComponent.getLocationOnScreen();
            Point location = new Point();
            Rectangle sBounds = this.insideComponent.getGraphicsConfiguration().getBounds();
            boolean leftToRight = this.isLeftToRight(this.insideComponent);
            this.hideTipWindow();
            this.tip = this.insideComponent.createToolTip();
            this.tip.setTipText(this.toolTipText);
            Dimension size = this.tip.getPreferredSize();
            if (this.preferredLocation != null) {
                location.x = screenLocation.x + this.preferredLocation.x;
                location.y = screenLocation.y + this.preferredLocation.y;
                if (!leftToRight) {
                    location.x -= size.width;
                }
            } else {
                location.x = screenLocation.x + this.mouseEvent.getX();
                location.y = screenLocation.y + this.mouseEvent.getY() + 20;
                if (!leftToRight && location.x - size.width >= 0) {
                    location.x -= size.width;
                }
            }
            if (this.popupRect == null) {
                this.popupRect = new Rectangle();
            }
            this.popupRect.setBounds(location.x, location.y, size.width, size.height);
            if (location.x < sBounds.x) {
                location.x = sBounds.x;
            } else if (location.x - sBounds.x + size.width > sBounds.width) {
                location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
            }
            if (location.y < sBounds.y) {
                location.y = sBounds.y;
            } else if (location.y - sBounds.y + size.height > sBounds.height) {
                location.y = sBounds.y + Math.max(0, sBounds.height - size.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = popupFactory.getPopup(this.insideComponent, this.tip, location.x, location.y);
            this.tipWindow.show();
            Window componentWindow = SwingUtilities.windowForComponent(this.insideComponent);
            this.window = SwingUtilities.windowForComponent(this.tip);
            if (this.window != null && this.window != componentWindow) {
                this.window.addMouseListener(this);
            } else {
                this.window = null;
            }
            this.tipShowing = true;
        }
    }

    void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.window != null) {
                this.window.removeMouseListener(this);
                this.window = null;
            }
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
        }
    }

    public static YCompToolTipManager sharedInstance() {
        return sharedInstance;
    }

    public void registerComponent(JComponent component) {
        component.removeMouseListener(this);
        component.addMouseListener(this);
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        component.addMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(component)) {
            InputMap inputMap = component.getInputMap(0);
            ActionMap actionMap = component.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.put(this.postTip, "postTip");
                inputMap.put(this.hideTip, "hideTip");
                actionMap.put("postTip", this.postTipAction);
                actionMap.put("hideTip", this.hideTipAction);
            }
        }
    }

    public void unregisterComponent(JComponent component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(component)) {
            InputMap inputMap = component.getInputMap(0);
            ActionMap actionMap = component.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.remove(this.postTip);
                inputMap.remove(this.hideTip);
                actionMap.remove("postTip");
                actionMap.remove("hideTip");
            }
        }
    }

    private boolean shouldRegisterBindings(JComponent component) {
        InputMap inputMap;
        for (inputMap = component.getInputMap(0); inputMap != null && inputMap.size() == 0; inputMap = inputMap.getParent()) {
        }
        return inputMap != null;
    }

    public void mouseEntered(MouseEvent event) {
        this.initiateToolTip(event);
    }

    private void initiateToolTip(MouseEvent event) {
        if (event.getSource() == this.window) {
            return;
        }
        JComponent component = (JComponent)event.getSource();
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        this.exitTimer.stop();
        Point location = event.getPoint();
        if (location.x < 0 || location.x >= component.getWidth() || location.y < 0 || location.y >= component.getHeight()) {
            return;
        }
        if (this.insideComponent != null) {
            this.enterTimer.stop();
        }
        component.removeMouseMotionListener(this);
        component.addMouseMotionListener(this);
        boolean sameComponent = this.insideComponent == component;
        this.insideComponent = component;
        if (this.tipWindow != null) {
            this.mouseEvent = event;
            if (this.showImmediately) {
                boolean sameLoc;
                String newToolTipText = component.getToolTipText(event);
                Point newPreferredLocation = component.getToolTipLocation(event);
                boolean bl = this.preferredLocation != null ? this.preferredLocation.equals(newPreferredLocation) : (sameLoc = newPreferredLocation == null);
                if (!(sameComponent && this.toolTipText.equals(newToolTipText) && sameLoc)) {
                    this.toolTipText = newToolTipText;
                    this.preferredLocation = newPreferredLocation;
                    this.showTipWindow();
                }
            } else {
                this.enterTimer.start();
            }
        }
    }

    public void mouseExited(MouseEvent event) {
        Window win;
        boolean shouldHide = true;
        if (this.insideComponent == null) {
            // empty if block
        }
        if (this.window != null && event.getSource() == this.window) {
            Container insideComponentWindow = this.insideComponent.getTopLevelAncestor();
            Point location = event.getPoint();
            SwingUtilities.convertPointToScreen(location, this.window);
            location.x -= insideComponentWindow.getX();
            location.y -= insideComponentWindow.getY();
            location = SwingUtilities.convertPoint(null, location, this.insideComponent);
            shouldHide = location.x < 0 || location.x >= this.insideComponent.getWidth() || location.y < 0 || location.y >= this.insideComponent.getHeight();
        } else if (event.getSource() == this.insideComponent && this.tipWindow != null && (win = SwingUtilities.getWindowAncestor(this.insideComponent)) != null) {
            Point location = SwingUtilities.convertPoint(this.insideComponent, event.getPoint(), win);
            Rectangle bounds = this.insideComponent.getTopLevelAncestor().getBounds();
            location.x += bounds.x;
            location.y += bounds.y;
            Point loc = new Point(0, 0);
            SwingUtilities.convertPointToScreen(loc, this.tip);
            bounds.x = loc.x;
            bounds.y = loc.y;
            bounds.width = this.tip.getWidth();
            bounds.height = this.tip.getHeight();
            shouldHide = location.x < bounds.x || location.x >= bounds.x + bounds.width || location.y < bounds.y || location.y >= bounds.y + bounds.height;
        }
        if (shouldHide) {
            this.enterTimer.stop();
            if (this.insideComponent != null) {
                this.insideComponent.removeMouseMotionListener(this);
            }
            this.insideComponent = null;
            this.toolTipText = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.exitTimer.restart();
        }
    }

    public void mousePressed(MouseEvent event) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
        this.insideComponent = null;
        this.mouseEvent = null;
    }

    public void mouseDragged(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
        if (this.tipShowing) {
            this.checkForTipChange(event);
        } else if (this.showImmediately) {
            JComponent component = (JComponent)event.getSource();
            this.toolTipText = component.getToolTipText(event);
            if (this.toolTipText != null) {
                this.preferredLocation = component.getToolTipLocation(event);
                this.mouseEvent = event;
                this.insideComponent = component;
                this.exitTimer.stop();
                this.showTipWindow();
            }
        } else {
            this.insideComponent = (JComponent)event.getSource();
            this.mouseEvent = event;
            this.toolTipText = null;
            this.enterTimer.restart();
        }
    }

    private void checkForTipChange(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        String newText = component.getToolTipText(event);
        Point newPreferredLocation = component.getToolTipLocation(event);
        if (newText != null || newPreferredLocation != null) {
            this.mouseEvent = event;
            if ((newText != null && newText.equals(this.toolTipText) || newText == null) && (newPreferredLocation != null && newPreferredLocation.equals(this.preferredLocation) || newPreferredLocation == null)) {
                if (this.tipWindow == null) {
                    this.enterTimer.restart();
                }
            } else {
                this.preferredLocation = null;
                this.hideTipWindow();
                this.insideComponent = (JComponent)event.getSource();
                this.mouseEvent = event;
                this.toolTipText = null;
                this.enterTimer.restart();
                this.showImmediately = false;
            }
        } else {
            this.toolTipText = null;
            this.preferredLocation = null;
            this.mouseEvent = null;
            this.insideComponent = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.restart();
        }
    }

    static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    private FocusListener createFocusChangeListener() {
        return new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                YCompToolTipManager.this.hideTipWindow();
                YCompToolTipManager.this.insideComponent = null;
                JComponent c2 = (JComponent)evt.getSource();
                c2.removeFocusListener(YCompToolTipManager.this.focusChangeListener);
            }
        };
    }

    private void show(JComponent source) {
        if (this.tipWindow != null) {
            this.hideTipWindow();
            this.insideComponent = null;
        } else {
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.stop();
            this.insideComponent = source;
            if (this.insideComponent != null) {
                this.toolTipText = this.insideComponent.getToolTipText();
                this.preferredLocation = new Point(10, this.insideComponent.getHeight() + 10);
                this.showTipWindow();
                if (this.focusChangeListener == null) {
                    this.focusChangeListener = this.createFocusChangeListener();
                }
                this.insideComponent.addFocusListener(this.focusChangeListener);
            }
        }
    }

    private void hide(JComponent source) {
        this.hideTipWindow();
        source.removeFocusListener(this.focusChangeListener);
        this.preferredLocation = null;
        this.insideComponent = null;
    }

    private static class Actions
    extends UIAction {
        private static String SHOW = "SHOW";
        private static String HIDE = "HIDE";

        Actions(String key) {
            super(key);
        }

        public void actionPerformed(ActionEvent e2) {
            String key = this.getName();
            JComponent source = (JComponent)e2.getSource();
            if (key == SHOW) {
                YCompToolTipManager.sharedInstance().show(source);
            } else if (key == HIDE) {
                YCompToolTipManager.sharedInstance().hide(source);
            }
        }

        public boolean isEnabled(Object sender) {
            if (this.getName() == SHOW) {
                return true;
            }
            return YCompToolTipManager.sharedInstance().tipShowing;
        }
    }

    private class MoveBeforeEnterListener
    extends MouseMotionAdapter {
        private MoveBeforeEnterListener() {
        }

        public void mouseMoved(MouseEvent e2) {
            YCompToolTipManager.this.initiateToolTip(e2);
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        public void actionPerformed(ActionEvent e2) {
            YCompToolTipManager.this.showImmediately = false;
        }
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent e2) {
            if (YCompToolTipManager.this.insideComponent != null && YCompToolTipManager.this.insideComponent.isShowing()) {
                if (YCompToolTipManager.this.toolTipText == null && YCompToolTipManager.this.mouseEvent != null) {
                    YCompToolTipManager.this.toolTipText = YCompToolTipManager.this.insideComponent.getToolTipText(YCompToolTipManager.this.mouseEvent);
                    YCompToolTipManager.this.preferredLocation = YCompToolTipManager.this.insideComponent.getToolTipLocation(YCompToolTipManager.this.mouseEvent);
                }
                if (YCompToolTipManager.this.toolTipText != null) {
                    YCompToolTipManager.this.showImmediately = true;
                    YCompToolTipManager.this.showTipWindow();
                } else {
                    YCompToolTipManager.this.insideComponent = null;
                    YCompToolTipManager.this.toolTipText = null;
                    YCompToolTipManager.this.preferredLocation = null;
                    YCompToolTipManager.this.mouseEvent = null;
                    YCompToolTipManager.this.hideTipWindow();
                }
            }
        }
    }
}

