/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.view;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MessageBoxOutputStream
extends OutputStream {
    public Component frame;
    public String title;
    public int type;

    MessageBoxOutputStream(Component frame, String title, int type) {
        this.frame = frame;
        this.title = title;
        this.type = type;
    }

    public void write(byte[] b2, int off, int len) {
        String s2 = new String(b2, off, len);
        if (!(s2 == null || s2.equals("\n") || s2.equals("\r") || s2.equals("\r\n"))) {
            JOptionPane.showMessageDialog(this.frame, s2, this.title, this.type);
        }
    }

    public void write(int b2) throws IOException {
        JOptionPane.showMessageDialog(this.frame, String.valueOf(b2), this.title, this.type);
    }

    public static void setDefaultOut(Component comp) {
        MessageBoxOutputStream out = new MessageBoxOutputStream(comp, "Message", 1);
        System.setOut(new PrintStream(out));
    }

    public static void setDefaultErr(Component comp) {
        MessageBoxOutputStream err = new MessageBoxOutputStream(comp, "Error", 0);
        System.setErr(new PrintStream(err));
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel();
        MessageBoxOutputStream.setDefaultOut(panel);
        MessageBoxOutputStream.setDefaultErr(panel);
        System.out.println("My output message");
        System.err.println("My error message");
    }
}

