/*
 * Decompiled with CFR 0.152.
 */
package joana.sdg;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import joana.sdg.SDGEdge;
import joana.sdg.SDGLexer;
import joana.sdg.SDGNode;
import joana.sdg.SDGParser;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.jgrapht.Graph;
import org.jgrapht.graph.DirectedPseudograph;
import org.jgrapht.traverse.BreadthFirstIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDG
extends DirectedPseudograph<SDGNode, SDGEdge> {
    private static final long serialVersionUID = 1L;
    private String name;

    public SDG() {
        super(SDGEdge.class);
    }

    public SDG(String name) {
        super(SDGEdge.class);
        this.name = name;
    }

    public SDGNode getNode(int id) {
        for (SDGNode node : this.vertexSet()) {
            if (node.getId() != id) continue;
            return node;
        }
        return null;
    }

    public static SDG readFrom(String sdgFile) throws IOException, RecognitionException {
        File f2 = new File(sdgFile);
        return SDG.readFrom(new FileInputStream(f2));
    }

    public static SDG readFrom(InputStream input) throws IOException, RecognitionException {
        SDGLexer lexer = new SDGLexer(new ANTLRInputStream(input));
        SDGParser parser = new SDGParser(new CommonTokenStream(lexer));
        return parser.parse();
    }

    public String getName() {
        return this.name;
    }

    public void addEdge(SDGEdge edge) {
        this.addEdge(edge.getSource(), edge.getTarget(), edge);
    }

    private static Stack<SDGNode> initWorklist(SDG g2, Stack<SDGNode> worklist) {
        BreadthFirstIterator i2 = new BreadthFirstIterator((Graph)g2);
        while (i2.hasNext()) {
            SDGNode currNode = (SDGNode)i2.next();
            if (currNode.getKind() != SDGNode.Kind.FORMAL_IN && currNode.getKind() != SDGNode.Kind.ACTUAL_OUT) continue;
            worklist.push(currNode);
        }
        return worklist;
    }

    private static boolean hasParamEdge(Set<SDGEdge> edgeList) {
        Iterator<SDGEdge> i2 = edgeList.iterator();
        while (i2.hasNext()) {
            if (!i2.next().isParameter()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDDEdge(Set<SDGEdge> edgeList) {
        Iterator<SDGEdge> i2 = edgeList.iterator();
        while (i2.hasNext()) {
            if (!i2.next().isDataDependence()) continue;
            return true;
        }
        return false;
    }

    private Stack<SDGNode> addParamEdges(Set<SDGEdge> edgeSet, Stack<SDGNode> worklist) {
        for (SDGEdge currEdge : edgeSet) {
            if (!currEdge.isParameter()) continue;
            worklist.push((SDGNode)this.getEdgeSource(currEdge));
        }
        return worklist;
    }

    private Stack<SDGNode> addParamNodes(Set<SDGEdge> edgeSet, Stack<SDGNode> worklist) {
        for (SDGEdge currEdge : edgeSet) {
            SDGNode source = (SDGNode)this.getEdgeSource(currEdge);
            if (!currEdge.isDataDependence() || !source.isParameter()) continue;
            worklist.push(source);
        }
        return worklist;
    }

    private static Stack<SDGNode> formIn_ActOut(SDG g2, SDGNode n2, Stack<SDGNode> worklist, Set<SDGEdge> incomingEdges, Set<SDGEdge> outgoingEdges) {
        boolean ddExists = false;
        ddExists = SDG.hasDDEdge(outgoingEdges);
        if (!ddExists) {
            worklist = g2.addParamEdges(incomingEdges, worklist);
            System.out.println("remove Node : " + n2.toString());
            g2.removeVertex(n2);
        }
        return worklist;
    }

    private static Stack<SDGNode> formOut_ActIn(SDG g2, SDGNode n2, Stack<SDGNode> worklist, Set<SDGEdge> incomingEdges, Set<SDGEdge> outgoingEdges) {
        boolean paramExists = false;
        paramExists = SDG.hasParamEdge(incomingEdges);
        if (!paramExists) {
            paramExists = SDG.hasParamEdge(outgoingEdges);
        }
        if (!paramExists) {
            worklist = g2.addParamNodes(incomingEdges, worklist);
            System.out.println("remove Node : " + n2.toString());
            g2.removeVertex(n2);
        }
        return worklist;
    }

    public static SDG slicealg(SDG g2) {
        Stack<SDGNode> worklist = SDG.initWorklist(g2, new Stack<SDGNode>());
        System.out.println("initSize of worklist : " + worklist.size());
        while (!worklist.isEmpty()) {
            SDGNode currNode = worklist.pop();
            Set incomingEdges = g2.incomingEdgesOf(currNode);
            Set outgoingEdges = g2.outgoingEdgesOf(currNode);
            if (currNode.getKind() == SDGNode.Kind.FORMAL_IN || currNode.getKind() == SDGNode.Kind.ACTUAL_OUT) {
                worklist = SDG.formIn_ActOut(g2, currNode, worklist, incomingEdges, outgoingEdges);
                continue;
            }
            if (currNode.getKind() != SDGNode.Kind.FORMAL_OUT && currNode.getKind() != SDGNode.Kind.ACTUAL_IN) continue;
            worklist = SDG.formOut_ActIn(g2, currNode, worklist, incomingEdges, outgoingEdges);
        }
        return g2;
    }
}

